/*
 * Decompiled with CFR 0.152.
 */
package org.cnice.rad.common;

import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.cnice.rad.common.SqlMetadata;
import org.cnice.rad.common.SqlResult;
import org.cnice.rad.common.SqlValue;
import org.cnice.rad.common.SqlValueArray;

public class SqlQueryTableModel
extends AbstractTableModel {
    JTable jtbl;
    JComponent parent;
    SqlResult values;
    String[] columns;
    String[] columnNames;
    int[] columnWidths;

    public SqlQueryTableModel() {
        this(null, null, null, null);
    }

    public SqlQueryTableModel(JComponent jComponent, String[] stringArray, String[] stringArray2, int[] nArray) {
        this.parent = jComponent;
        this.columns = stringArray;
        this.columnNames = stringArray2;
        this.columnWidths = nArray;
        this.values = new SqlResult();
    }

    public void setTable(JTable jTable) {
        this.jtbl = jTable;
    }

    public JTable getTable() {
        return this.jtbl;
    }

    public String getColumnName(int n) {
        if (this.columnNames == null) {
            SqlValueArray sqlValueArray;
            SqlMetadata sqlMetadata;
            if (this.values != null && this.values.size() > 0 && (sqlMetadata = (sqlValueArray = this.values.valueAt(0)).getMetadata(n)) != null) {
                return sqlMetadata.getName();
            }
        } else if (n < this.columnNames.length) {
            return this.columnNames[n];
        }
        return "";
    }

    public int getColumnCount() {
        if (this.columns == null) {
            if (this.values != null && this.values.size() > 0) {
                SqlValueArray sqlValueArray = this.values.valueAt(0);
                return sqlValueArray.getMetadata().length;
            }
        } else {
            return this.columns.length;
        }
        return 0;
    }

    public int getRowCount() {
        if (this.values != null) {
            return this.values.size();
        }
        return 0;
    }

    public Object getValueAt(int n, int n2) {
        if (this.values != null && n < this.values.size()) {
            Serializable serializable;
            SqlValueArray sqlValueArray = this.values.valueAt(n);
            int n3 = n2;
            if (this.columns != null) {
                if (n2 >= this.columns.length) {
                    return null;
                }
                for (n3 = 0; !(n3 >= sqlValueArray.getMetadata().length || (serializable = sqlValueArray.getMetadata(n3)) != null && this.columns[n2].equals(((SqlMetadata)serializable).getName())); ++n3) {
                }
            }
            if (n3 < sqlValueArray.getMetadata().length) {
                serializable = sqlValueArray.getValue(n3);
                switch (((SqlValue)serializable).getType()) {
                    case 4: {
                        return new Integer(((SqlValue)serializable).getInt());
                    }
                    case 12: 
                    case 91: 
                    case 92: 
                    case 93: {
                        return ((SqlValue)serializable).getString();
                    }
                    case -4: {
                        return ((SqlValue)serializable).getBytes();
                    }
                }
                return ((SqlValue)serializable).getString();
            }
        }
        return "";
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void fire() {
        this.fireTableChanged(null);
        if (this.jtbl != null && this.parent != null && this.columnWidths != null) {
            int n = this.parent.getSize().width;
            int n2 = 0;
            int n3 = this.getColumnCount();
            for (int i = 0; i < n3; ++i) {
                TableColumn tableColumn = this.jtbl.getColumnModel().getColumn(i);
                int n4 = (int)((double)n * (double)this.columnWidths[i] / 100.0);
                if (i + 1 == n3) {
                    n4 = n - n2;
                }
                if (n4 < 0) {
                    n4 = 0;
                }
                tableColumn.setPreferredWidth(n4);
                n2 += n4;
            }
        }
    }

    public void updateValues(SqlResult sqlResult) {
        this.values = sqlResult;
    }
}

