/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.math;

public class R2 {
    public double x;
    public double y;

    public R2() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public R2(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public R2 copy() {
        return new R2(this.x, this.y);
    }

    public int ix() {
        return (int)Math.round(Math.max(Math.min(this.x, 32000.0), -32000.0));
    }

    public int iy() {
        return (int)Math.round(Math.max(Math.min(this.y, 32000.0), -32000.0));
    }

    public boolean equals(R2 r2) {
        return this.x == r2.x && this.y == r2.y;
    }

    public double norm2() {
        return this.x * this.x + this.y * this.y;
    }

    public double norm() {
        return Math.sqrt(this.norm2());
    }

    public double distance(R2 r2) {
        R2 r22 = this.copy();
        r22.sub(r2);
        return r22.norm();
    }

    public double dot(R2 r2) {
        return this.x * r2.x + this.y * r2.y;
    }

    public double det(R2 r2) {
        return this.x * r2.y - this.y * r2.x;
    }

    public void mul(double d) {
        this.x *= d;
        this.y *= d;
    }

    public void div(double d) {
        this.x /= d;
        this.y /= d;
    }

    public void add(R2 r2) {
        this.x += r2.x;
        this.y += r2.y;
    }

    public void sub(R2 r2) {
        this.x -= r2.x;
        this.y -= r2.y;
    }

    public void normalize() {
        double d = this.norm();
        if (d != 0.0) {
            this.div(d);
        }
    }

    public void rotR90() {
        double d = this.x;
        this.x = this.y;
        this.y = -d;
    }

    public void rotL90() {
        double d = this.x;
        this.x = -this.y;
        this.y = d;
    }

    public void rot(double d) {
        R2 r2 = this.copy();
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        this.x = r2.x * d2 - r2.y * d3;
        this.y = r2.x * d3 + r2.y * d2;
    }

    public void rot(int n) {
        this.rot((double)n * Math.PI / 180.0);
    }
}

