/*
 * Decompiled with CFR 0.152.
 */
package com.jla.desc2.editdesc;

import com.jla.desc2.descartes.data;
import com.jla.desc2.gui.editDialog;
import com.jla.desc2.gui.mjaGui;
import com.jla.desc2.util.mjaStr;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class editColorDialog
extends editDialog
implements AdjustmentListener,
ItemListener,
KeyListener,
ActionListener {
    public Color color;
    private Canvas c;
    private Scrollbar sb_r;
    private Scrollbar sb_g;
    private Scrollbar sb_b;
    private TextField tf_r;
    private TextField tf_g;
    private TextField tf_b;
    private Choice ch_c;
    private String[] colorName = data.colorName[1];
    private Button bc;
    private Button bp;
    private static Color lastCopied;
    private boolean updating = false;
    private long ta = 0L;
    private long ti = 0L;

    public editColorDialog(Frame frame, String string, boolean bl, String string2, String string3) {
        super(frame, string, bl, string2, string3);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        this.add("North", panel);
        this.ch_c = new Choice();
        panel.add(this.ch_c);
        this.bc = new Button("copy");
        this.addExtraButton(this.bc);
        this.bp = new Button("paste");
        this.addExtraButton(this.bp);
        this.bc.addActionListener(this);
        this.bp.addActionListener(this);
        this.ch_c.addItem("");
        for (int i = 0; i < this.colorName.length; ++i) {
            this.ch_c.addItem(this.colorName[i]);
        }
        this.ch_c.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setBackground(Color.black);
        panel2.setLayout(new GridLayout(3, 0));
        this.add("Center", panel2);
        this.sb_r = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_g = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_b = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_r.setForeground(Color.red);
        this.sb_g.setForeground(Color.green);
        this.sb_b.setForeground(Color.blue);
        panel2.add(this.sb_r);
        panel2.add(this.sb_g);
        panel2.add(this.sb_b);
        Panel panel3 = new Panel();
        this.add("West", panel3);
        panel3.setFont(mjaGui.Courier);
        panel3.setLayout(new GridLayout(3, 2));
        Label label = new Label(" ");
        label.setBackground(Color.red);
        panel3.add(label);
        this.tf_r = new TextField(2);
        panel3.add(this.tf_r);
        label = new Label(" ");
        label.setBackground(Color.green);
        panel3.add(label);
        this.tf_g = new TextField(2);
        panel3.add(this.tf_g);
        label = new Label(" ");
        label.setBackground(Color.blue);
        panel3.add(label);
        this.tf_b = new TextField(2);
        panel3.add(this.tf_b);
        this.c = new Canvas();
        this.add("East", this.c);
        this.c.setSize(80, 64);
        this.sb_r.addAdjustmentListener(this);
        this.sb_g.addAdjustmentListener(this);
        this.sb_b.addAdjustmentListener(this);
        this.tf_r.addKeyListener(this);
        this.tf_g.addKeyListener(this);
        this.tf_b.addKeyListener(this);
        this.setColor(Color.black);
    }

    public void setColorNames(String[] stringArray) {
        this.colorName = stringArray;
        this.ch_c.removeAll();
        this.ch_c.addItem("");
        for (int i = 0; i < this.colorName.length; ++i) {
            this.ch_c.addItem(this.colorName[i]);
        }
    }

    public void setCopyLabels(String string, String string2) {
        this.bc.setLabel(string);
        this.bp.setLabel(string2);
    }

    static String rgbHex(int n) {
        String string = Integer.toString(n, 16);
        while (string.length() < 2) {
            string = "0" + string;
        }
        return string;
    }

    public static String colorToHexString(Color color) {
        return editColorDialog.rgbHex(color.getRed() + color.getGreen() + color.getBlue());
    }

    public String getColorHexString() {
        return editColorDialog.colorToHexString(this.color);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.updateAll();
    }

    private void updateAll() {
        if (!this.isUpdating()) {
            this.updating = true;
            this.ch_c.select(0);
            this.ch_c.select(mjaStr.getColorName(this.colorName, this.color));
            this.sb_r.setValue(this.color.getRed());
            this.sb_g.setValue(this.color.getGreen());
            this.sb_b.setValue(this.color.getBlue());
            this.tf_r.setText(editColorDialog.rgbHex(this.color.getRed()));
            this.tf_g.setText(editColorDialog.rgbHex(this.color.getGreen()));
            this.tf_b.setText(editColorDialog.rgbHex(this.color.getBlue()));
            this.c.setBackground(this.color);
            this.c.repaint();
            this.updating = false;
        }
    }

    private boolean isUpdating() {
        return this.updating;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        long l = System.currentTimeMillis();
        if (l - this.ta > 100L) {
            this.ta = l;
            if (!(this.isUpdating() || adjustmentEvent.getSource() != this.sb_r && adjustmentEvent.getSource() != this.sb_g && adjustmentEvent.getSource() != this.sb_b)) {
                int n;
                int n2;
                int n3 = this.sb_r.getValue();
                if (n3 > 255) {
                    n3 = 255;
                }
                if ((n2 = this.sb_g.getValue()) > 255) {
                    n2 = 255;
                }
                if ((n = this.sb_b.getValue()) > 255) {
                    n = 255;
                }
                this.color = new Color(n3, n2, n);
                this.updateAll();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        long l = System.currentTimeMillis();
        if (l - this.ti > 100L) {
            this.ti = l;
            if (!this.isUpdating() && itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.ch_c) {
                this.color = mjaStr.parseColor(this.colorName, this.ch_c.getSelectedItem(), this.color);
                this.updateAll();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isUpdating()) {
            if (actionEvent.getSource() == this.bc) {
                lastCopied = this.getColor();
            } else if (actionEvent.getSource() == this.bp && lastCopied != null) {
                this.setColor(lastCopied);
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isUpdating() && keyEvent.getSource() instanceof TextField && keyEvent.getKeyCode() == 10) {
            try {
                int n = Integer.parseInt(this.tf_r.getText(), 16);
                int n2 = Integer.parseInt(this.tf_g.getText(), 16);
                int n3 = Integer.parseInt(this.tf_b.getText(), 16);
                this.color = new Color(n, n2, n3);
            }
            catch (NumberFormatException numberFormatException) {
                Toolkit.getDefaultToolkit().beep();
            }
            this.updateAll();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }
}

