/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.algebra.DescartesA;
import com.mja.algebra.ExerciseConfig;
import com.mja.algebra.RandomNumber;
import com.mja.file.mjaFile;
import com.mja.file.mjaHtml;
import com.mja.gui.mjaText;
import com.mja.lang.translator;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import java.applet.Applet;
import java.io.File;
import java.util.StringTokenizer;
import java.util.Vector;
import org.unam.matem.Attribute;

public class SeriesConfig {
    public static final int auto = 1;
    public static final int mouse = 2;
    public static final int mousenkbd = 3;
    public static final int kbd = 4;
    private static translator Tr;
    private Applet A;
    Parser parser;
    int decimales = 2;
    private boolean inWeb = true;
    private boolean guided = false;
    private int[] mode = new int[]{2};
    private int bienConsecutivosParaAvance = 3;
    private int notaDeAvance = 75;
    private int notaDeRetroceso = 50;
    private String instructions;
    ExerciseConfig[] exercise;
    private RandomNumber[] randomvar;
    private Vector randomVector;
    public static final int ix_guided = 0;
    public static final int ix_mode = 1;
    public static final int ix_equation = 2;
    public static final int ix_okconsec = 3;
    public static final int ix_perNext = 4;
    public static final int ix_perPrev = 5;
    public static final int ix_filename = 6;
    public static final String[] attrName;
    public static final String[][] attrOptions;
    public static final int[] modeix;
    public static final String[] attrDefault;
    public String[] attrValue;

    void updateAttribute(int n, String string) {
        this.attrValue[n] = string;
    }

    public int notaDeAvance() {
        return this.notaDeAvance;
    }

    public int notaDeRetroceso() {
        return this.notaDeRetroceso;
    }

    public int bienConsecutivosParaAvance() {
        return this.bienConsecutivosParaAvance;
    }

    public int bienParaAvance() {
        return Math.round(this.notaDeAvance * this.countExercises() / 100);
    }

    public int countExercisesOk() {
        int n = 0;
        for (int i = 0; i < this.countExercises(); ++i) {
            if (!this.exercise[i].isDone() || this.exercise[i].getErrors() != 0) continue;
            ++n;
        }
        return n;
    }

    public int countConsecutiveOks(int n) {
        if (this.exercise[n].getErrors() != 0) {
            return 0;
        }
        int n2 = 0;
        for (int i = n; i >= 0; --i) {
            if (!this.exercise[i].isDone()) continue;
            if (this.exercise[i].getErrors() != 0) break;
            ++n2;
        }
        return n2;
    }

    public double getAverage() {
        int n = 0;
        double d = 0.0;
        for (int i = 0; i < this.exercise.length; ++i) {
            if (!this.exercise[i].isDone()) continue;
            ++n;
            d += this.exercise[i].getAverage();
        }
        if (n == 0) {
            n = 1;
        }
        return d / (double)n;
    }

    public void reset() {
        for (int i = 0; i < this.exercise.length; ++i) {
            this.exercise[i].reset();
        }
    }

    public String getIndicator() {
        return this.getFileName() + " " + this.getModos() + " " + this.getGuiado();
    }

    public String getFileName() {
        return this.attrValue[6];
    }

    public void setFileName(String string) {
        this.attrValue[6] = string;
    }

    public void setInstructions(String string) {
        this.instructions = new String(string);
    }

    public String getInstructions() {
        return this.instructions;
    }

    void resetContent() {
        this.applyContents(this.getContents());
        this.saveContents();
    }

    boolean saveContents() {
        if (!this.inWeb) {
            String string = BasicStr.DocPath((Applet)this.A);
            string = string + "ejercicios/" + this.attrValue[6];
            string = BasicStr.replace((String)string, (String)"/", (String)File.separator);
            boolean bl = false;
            File file = new File(string);
            if (file.exists()) {
                bl = true;
            } else if (mjaText.ask((String)("Crear" + this.getFileName()), (int)4, (int)40, (String)("\u00bfDesea crear el archivo\n" + this.attrValue[6] + "?"), (String)"S\u00ed", (String)"No")) {
                bl = true;
            }
            if (bl) {
                mjaFile.save((String)string, (String)this.getContents());
                return true;
            }
        }
        return false;
    }

    public SeriesConfig(DescartesA descartesA, Parser parser, int n, boolean bl) {
        this.A = descartesA;
        Tr = descartesA.Tr;
        this.parser = parser;
        this.decimales = n;
        this.inWeb = bl;
        this.attrValue = new String[attrName.length];
        for (int i = 0; i < attrName.length; ++i) {
            this.attrValue[i] = attrDefault[i];
        }
        this.applyConfig(true);
    }

    public SeriesConfig cloneSeriesConfig(DescartesA descartesA, Parser parser, int n) {
        int n2;
        Tr = descartesA.Tr;
        SeriesConfig seriesConfig = new SeriesConfig(descartesA, parser, n, this.inWeb);
        seriesConfig.parser = this.parser;
        seriesConfig.decimales = n;
        seriesConfig.attrValue[6] = new String(this.attrValue[6]);
        seriesConfig.mode = new int[this.mode.length];
        for (n2 = 0; n2 < this.mode.length; ++n2) {
            seriesConfig.mode[n2] = this.mode[n2];
        }
        seriesConfig.guided = this.guided;
        seriesConfig.bienConsecutivosParaAvance = this.bienConsecutivosParaAvance;
        seriesConfig.notaDeAvance = this.notaDeAvance;
        seriesConfig.notaDeRetroceso = this.notaDeRetroceso;
        seriesConfig.attrValue = new String[attrName.length];
        for (n2 = 0; n2 < attrName.length; ++n2) {
            seriesConfig.attrValue[n2] = new String(this.attrValue[n2]);
        }
        seriesConfig.applyContents(this.getContents());
        return seriesConfig;
    }

    public static String getModeName(int n) {
        if (1 <= n && n <= attrOptions[1].length) {
            return attrOptions[1][n - 1];
        }
        return "";
    }

    public SeriesConfig(Applet applet, translator translator2, String string, String string2, Parser parser, int n, boolean bl) {
        this.A = applet;
        Tr = translator2;
        this.parser = parser;
        this.decimales = n;
        this.inWeb = bl;
        this.attrValue = new String[attrName.length];
        for (int i = 0; i < attrName.length; ++i) {
            this.attrValue[i] = attrDefault[i];
        }
        Attribute[] attributeArray = Attribute.parse((String)string2);
        this.attrValue = new String[attrName.length];
        for (int i = 0; i < attrName.length; ++i) {
            this.attrValue[i] = Attribute.getValue((Attribute[])attributeArray, (String)attrName[i]);
        }
        this.applyConfig(false);
        this.applyContents(string);
    }

    public SeriesConfig(Applet applet, translator translator2, Parser parser, String string, int n, boolean bl) {
        this.A = applet;
        Tr = translator2;
        this.decimales = n;
        this.parser = parser;
        this.inWeb = bl;
        Attribute[] attributeArray = Attribute.parse((String)string);
        this.attrValue = new String[attrName.length];
        for (int i = 0; i < attrName.length; ++i) {
            this.attrValue[i] = Attribute.getValue((Attribute[])attributeArray, (String)attrName[i]);
        }
        this.applyConfig(true);
    }

    void applyConfig(boolean bl) {
        if (bl) {
            String string = "";
            if (BasicStr.hasContent((String)this.attrValue[6])) {
                string = mjaFile.readFile((Applet)this.A, (boolean)this.inWeb, (String)("ejercicios" + File.separator + this.getFileName()), (boolean)true);
                string = mjaHtml.decodeHTMLEncoding((String)string);
            } else if (BasicStr.hasContent((String)this.attrValue[2])) {
                string = "Ejercicio\n\n" + this.attrValue[2] + "  |";
            }
            this.applyContents(string);
        }
        this.parseModesString(this.attrValue[1]);
        this.guided = this.attrValue[0].toLowerCase().startsWith("s") || this.attrValue[0].toLowerCase().startsWith("y") || this.attrValue[0].toLowerCase().startsWith("t");
        this.bienConsecutivosParaAvance = BasicStr.parseInteger((String)this.attrValue[3], (int)3, (int)3);
        this.attrValue[3] = Integer.toString(this.bienConsecutivosParaAvance);
        this.notaDeAvance = BasicStr.parseInteger((String)this.attrValue[4], (int)75, (int)75);
        this.attrValue[4] = Integer.toString(this.notaDeAvance);
        this.notaDeRetroceso = BasicStr.parseInteger((String)this.attrValue[5], (int)50, (int)50);
        this.attrValue[5] = Integer.toString(this.notaDeRetroceso);
    }

    private void applyContents(String string) {
        this.readInstructionsAndAttr(string);
        this.setRandomVariables(string, string);
    }

    private void setRandomVariables(String string, String string2) {
        this.randomvar = RandomNumber.parseRandomVariables(string);
        this.randomVector = new Vector();
        for (int i = 0; i < this.randomvar.length; ++i) {
            this.randomVector.addElement(this.randomvar[i]);
        }
        this.randomizeExercises(string2);
    }

    public String getRandomVariablesStr() {
        String string = "";
        if (this.randomvar.length > 0) {
            for (int i = 0; i < this.randomvar.length; ++i) {
                string = string + this.randomvar[i].toString(true) + "\n";
            }
            string = string + "\n";
        }
        return string;
    }

    void resetRandomVar(String string, double d, double d2, int n, boolean bl) {
        RandomNumber randomNumber = new RandomNumber(string, d, d2, n, bl);
        if (this.isRandomVar(string)) {
            for (int i = 0; i < this.randomvar.length; ++i) {
                if (!this.randomvar[i].getName().equals(string)) continue;
                this.randomvar[i] = randomNumber;
                break;
            }
        } else {
            this.setRandomVariables(this.getRandomVariablesStr() + randomNumber.toString(true), this.getContents());
        }
        this.saveContents();
    }

    public void deleteRandomVar(String string) {
        if (this.isRandomVar(string)) {
            RandomNumber[] randomNumberArray = this.randomvar;
            this.randomvar = new RandomNumber[randomNumberArray.length - 1];
            int n = 0;
            for (int i = 0; i < randomNumberArray.length; ++i) {
                if (randomNumberArray[i].getName().equals(string)) continue;
                this.randomvar[n++] = randomNumberArray[i];
            }
        }
        this.saveContents();
    }

    public boolean isRandomVar(String string) {
        RandomNumber randomNumber = this.getRandomVar(string);
        return randomNumber != null;
    }

    public RandomNumber getRandomVar(String string) {
        for (int i = 0; i < this.randomvar.length; ++i) {
            if (!this.randomvar[i].getName().equals(string)) continue;
            return this.randomvar[i];
        }
        return null;
    }

    public RandomNumber[] getRandomVariables() {
        return this.randomvar;
    }

    public void randomizeExercises(String string) {
        for (int i = 0; i < this.randomvar.length; ++i) {
            this.randomvar[i].recalculate();
        }
        this.exercise = ExerciseConfig.readExercises(this.randomVector, this.parser, string, this.decimales);
    }

    public Vector getRandomVector() {
        return this.randomVector;
    }

    public void randomize() {
        this.randomizeExercises(this.getContents());
    }

    public static SeriesConfig[] readAllSeries(DescartesA descartesA, Parser parser, int n, boolean bl) {
        Vector<SeriesConfig> vector = new Vector<SeriesConfig>();
        for (int i = 0; i < 100; ++i) {
            String string = descartesA.getParameter("SERIE_" + BasicStr.IntegerToString((int)i, (int)2));
            if (!BasicStr.hasContent((String)string)) continue;
            try {
                vector.addElement(new SeriesConfig((Applet)((Object)descartesA), descartesA.Tr, parser, string, n, bl));
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        SeriesConfig[] seriesConfigArray = new SeriesConfig[vector.size()];
        for (int i = 0; i < seriesConfigArray.length; ++i) {
            seriesConfigArray[i] = (SeriesConfig)vector.elementAt(i);
        }
        return seriesConfigArray;
    }

    public static SeriesConfig[] readAllSeries(Applet applet, translator translator2, String string, String string2, Parser parser, int n, boolean bl) {
        Vector<SeriesConfig> vector = new Vector<SeriesConfig>();
        try {
            vector.addElement(new SeriesConfig(applet, translator2, string2, string, parser, n, bl));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        SeriesConfig[] seriesConfigArray = new SeriesConfig[vector.size()];
        for (int i = 0; i < seriesConfigArray.length; ++i) {
            seriesConfigArray[i] = (SeriesConfig)vector.elementAt(i);
        }
        return seriesConfigArray;
    }

    public int countModes() {
        return this.mode.length;
    }

    public int getMode(int n) {
        if (n >= 0 && n < this.mode.length) {
            return this.mode[n];
        }
        return 1;
    }

    public int countExercises() {
        return this.exercise.length;
    }

    public ExerciseConfig getExercise(int n) {
        if (0 <= n && n < this.countExercises()) {
            return this.exercise[n];
        }
        return null;
    }

    public String[] getSExpressions(int n) {
        if (0 <= n && n < this.countExercises()) {
            return this.exercise[n].getSExpressions();
        }
        return new String[0];
    }

    public String getSExpression(int n, int n2) {
        return this.getSExpressions(n)[n2];
    }

    public String[] getExplanations(int n) {
        if (0 <= n && n < this.countExercises()) {
            return this.exercise[n].getExplanations();
        }
        return new String[0];
    }

    private void parseModesString(String string) {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        if (BasicStr.hasContent((String)string)) {
            for (n = 0; n < attrOptions[1].length; ++n) {
                if (!attrOptions[1][n].equals(string)) {
                    if (!translator.equals((String)string, (int)modeix[n])) continue;
                }
                vector.addElement(new Integer(n + 1));
                break;
            }
            if (vector.size() == 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    try {
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n2 < 1 || n2 > 4) continue;
                        vector.addElement(new Integer(n2));
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            }
        }
        if (vector.size() == 0) {
            vector.addElement(new Integer(2));
        }
        this.mode = new int[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            this.mode[n] = (Integer)vector.elementAt(n);
        }
    }

    private void readInstructionsAndAttr(String string) {
        this.instructions = "";
        String[] stringArray = BasicStr.toStrArr((String)string);
        int n = 0;
        while (n < stringArray.length && stringArray[n].length() != 0 && !stringArray[n].startsWith("variable ")) {
            this.instructions = this.instructions + stringArray[n++];
        }
        while (n < stringArray.length && stringArray[n].length() == 0) {
            ++n;
        }
        if (n < stringArray.length && !stringArray[n].startsWith("variable ")) {
            while (n < stringArray.length) {
                boolean bl = false;
                for (int i = 0; i < attrName.length; ++i) {
                    String string2 = Attribute.getValue((String)stringArray[n], (String)attrName[i]);
                    if (!BasicStr.hasContent((String)string2)) continue;
                    this.attrValue[i] = string2;
                    bl = true;
                }
                if (!bl) break;
                ++n;
            }
        }
    }

    public boolean isGuided() {
        return this.guided;
    }

    public String getGuidedStr() {
        if (this.guided) {
            return "guiado";
        }
        return "libre";
    }

    public String getModeAndGuidedStr() {
        return SeriesConfig.getModeName(this.mode[0]) + "," + this.getGuidedStr();
    }

    public String getModos() {
        String string = "";
        for (int i = 0; i < this.mode.length; ++i) {
            if (i > 0) {
                string = string + ",";
            }
            string = string + this.mode[i];
        }
        return string;
    }

    public String getGuiado() {
        if (this.guided) {
            return "s";
        }
        return "n";
    }

    public String getHeader() {
        String string = "";
        for (int i = 0; i < attrName.length; ++i) {
            string = string + attrName[i] + "='" + this.attrValue[i] + "' ";
        }
        return string;
    }

    public String getContents() {
        String string = this.instructions + "\n\n";
        string = string + this.getRandomVariablesStr();
        for (int i = 0; i < this.exercise.length; ++i) {
            string = string + this.exercise[i].toString() + "\n";
        }
        return string;
    }

    static {
        attrName = new String[]{"guiado", "modos", "ecuaci\u00f3n", "bien_consecutivos", "nota_para_avanzar", "nota_para_retroceder", "ejercicios"};
        attrOptions = new String[][]{{"no", "s\u00ed"}, {"autom\u00e1tico", "clic o arrastre", "clic y escribir", "escribir"}, {""}, {"", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"}, {"", "100", "95", "90", "85", "80", "75", "70", "65", "60", "55", "50"}, {"", "60", "50", "40", "30", "20", "10"}, {""}};
        modeix = new int[]{302, 303, 304, 305};
        attrDefault = new String[]{"n", "clic o arrastre", "", "3", "75", "50", "_nuevo.txt"};
    }
}

