/*
 * Decompiled with CFR 0.152.
 */
package com.mja.textedit;

import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.Formula;
import com.mja.text.Text;
import com.mja.util.BasicStr;
import java.util.StringTokenizer;
import java.util.Vector;

public class TextParser {
    public static Text parseString(Parser parser, String string) {
        String string2 = BasicStr.replace(string, "\\n", "\n");
        String[] stringArray = TextParser.getLines(string2);
        Text text = new Text(parser);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                text.insertString("\n");
            }
            String[] stringArray2 = TextParser.getWords(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                Formula formula;
                if (j > 0) {
                    text.insertString(" ");
                }
                if ((formula = TextParser.getFormula(parser, stringArray2[j])) != null) {
                    text.insertFormula(formula);
                    continue;
                }
                text.insertString(stringArray2[j]);
            }
        }
        return text;
    }

    public static Formula getFormula(Parser parser, String string) {
        if (TextParser.hasOperator(string)) {
            try {
                Node node = parser.Analyse("TextParser", string, true, false);
                return node.toFormula(parser, false, "\u00d7", true, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static Node getNode(Parser parser, String string) {
        if (TextParser.hasOperator(string)) {
            try {
                Node node = parser.Analyse("TextParser", string, true, false);
                return node;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean hasOperator(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!Node.isOperator(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static String[] getLines(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\r");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] getWords(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String toString(Parser parser, Text text, boolean bl) {
        String[] stringArray = TextParser.getLines(text.toExpression(bl));
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                string = string + "\\n";
            }
            String[] stringArray2 = TextParser.getWords(stringArray[i]);
            for (int j = 0; j < stringArray2.length; ++j) {
                Node node;
                if (j > 0) {
                    string = string + " ";
                }
                string = (node = TextParser.getNode(parser, stringArray2[j])) != null ? string + node.toExpression(bl) : string + stringArray2[j];
            }
        }
        return string;
    }

    public static String canonize(Parser parser, String string, boolean bl) {
        Text text = TextParser.parseString(parser, string);
        return TextParser.toString(parser, text, bl);
    }
}

