/*
 * Decompiled with CFR 0.152.
 */
package org.cnice.rad.client;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import org.cnice.rad.common.ExceptionResponse;
import org.cnice.rad.common.HelloRequest;
import org.cnice.rad.common.Message;
import org.cnice.rad.common.QueryRequest;
import org.cnice.rad.common.QueryResponse;
import org.cnice.rad.common.SqlResult;
import org.cnice.rad.common.UserDataRequest;
import org.cnice.rad.common.UserDataResponse;
import org.cnice.rad.learner.CreateSesionEquipoRequest;
import org.cnice.rad.learner.CreateSesionEquipoResponse;

public class Client {
    public static final int admin = 0;
    public static final int teacher = 1;
    public static final int learner = 2;
    public static final String[] userTypeNames = new String[]{"Administrador", "Profesor", "Alumno"};
    public static final int usr_id = 0;
    public static final int usr_tipo = 1;
    public static final int usr_grupo = 2;
    public static final int usr_codigo_a = 3;
    public static final int usr_contrasenya = 4;
    public static final int usr_apellido_p = 5;
    public static final int usr_apellido_m = 6;
    public static final int usr_nombres = 7;
    public static final int usr_alias = 8;
    public static final int usr_correo_e = 9;
    private String host = null;
    private String host_name = "";
    protected String user_login = null;
    protected String user_password = null;
    private static boolean TRACE = false;
    private boolean dbon = false;
    private int initial_port;
    private int final_port;
    private int PORT;
    private String[] userData;
    Vector Queue = new Vector();

    public Client(String string, String string2, int n, int n2) {
        this.host = string2;
        this.initial_port = n;
        this.final_port = n2;
    }

    public boolean connect() {
        TRACE = false;
        Client.tracePrint("Hello...");
        try {
            this.executeHello();
            this.dbon = true;
            Client.tracePrint("Hello accepted");
        }
        catch (Exception exception) {
            Client.tracePrint("Hello rejected");
            this.dbon = false;
        }
        return this.dbon;
    }

    public boolean isConnected() {
        return this.dbon;
    }

    public void setUser(String string, String string2) {
        this.user_login = string;
        this.user_password = string2;
    }

    String getUserLogin() {
        return this.user_login;
    }

    String getUserPassword() {
        return this.user_password;
    }

    public String getNombreEquipo() {
        return this.host_name;
    }

    public String getUserID() {
        return this.userData[0];
    }

    public String getUserName() {
        return this.userData[7] + " " + this.userData[5] + " " + this.userData[6];
    }

    public String getUserType() {
        return this.userData[1];
    }

    public String getUserGroupID() {
        return this.userData[2];
    }

    public static String getUserTypeName(String string) {
        for (int i = 0; i < userTypeNames.length; ++i) {
            if (!userTypeNames[i].equals(string)) continue;
            return userTypeNames[i];
        }
        return "";
    }

    public static String getUserType(String string) {
        for (int i = 0; i < userTypeNames.length; ++i) {
            if (!userTypeNames[i].equals(string)) continue;
            return userTypeNames[i];
        }
        return "";
    }

    public String getUserEMail() {
        return this.userData[9];
    }

    protected static void tracePrint(Object object) {
        if (TRACE) {
            System.out.println(object);
        }
    }

    public boolean userAllowed(String string, String string2) throws Exception {
        this.userData = this.executeUserData(string, string2);
        return this.userData.length > 0;
    }

    public boolean grupoCorrecto(String string, String string2, String string3) throws Exception {
        return this.executeGrupoCorrecto(string, string2, string3);
    }

    public String[] executeUserData(String string, String string2) throws Exception {
        UserDataRequest userDataRequest = new UserDataRequest(string, string2);
        Message message = this.sendRequest(userDataRequest);
        if (message == null) {
            throw new Exception("Unreachable destination");
        }
        if (message.getType() == 4) {
            return ((UserDataResponse)message).getUserData();
        }
        if (message.getType() == 0) {
            throw new Exception(((ExceptionResponse)message).getExceptionMessage());
        }
        Client.tracePrint("Unexpected Response Type");
        return new String[0];
    }

    public boolean executeGrupoCorrecto(String string, String string2, String string3) throws Exception {
        String string4 = "SELECT * FROM usuario,grupo WHERE usuario.codigo_a='" + string + "' AND usuario.contrasenya='" + string2 + "'" + "      AND grupo.nombre='" + string3 + "'" + "      AND usuario.grupo=grupo.id";
        QueryRequest queryRequest = new QueryRequest(string, string2, string4);
        Message message = this.sendRequest(queryRequest);
        if (message == null) {
            throw new Exception("Unreachable destination");
        }
        if (message.getType() == 6) {
            SqlResult sqlResult = ((QueryResponse)message).getValues();
            return sqlResult != null && sqlResult.size() > 0;
        }
        if (message.getType() == 0) {
            throw new Exception(((ExceptionResponse)message).getExceptionMessage());
        }
        Client.tracePrint("Unexpected Response Type");
        return false;
    }

    protected void queueRequest(Serializable serializable) {
        this.Queue.add(serializable);
    }

    protected void sendQueue() {
        try {
            this.sendRequest(this.Queue);
            this.Queue.clear();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Message sendRequest(Serializable serializable) throws Exception {
        InetAddress inetAddress = null;
        Socket socket = null;
        try {
            inetAddress = this.host == null || this.host.equals("") ? InetAddress.getByName(null) : InetAddress.getByName(this.host);
        }
        catch (Exception exception) {
            System.err.println("Imposible obtener direcci\u00f3n del servidor " + this.host);
            return null;
        }
        try {
            socket = new Socket(inetAddress, this.PORT);
        }
        catch (Exception exception) {
            Client.tracePrint("Fallo de socket");
        }
        if (socket == null) {
            throw new Exception("Imposible establecer la conecci\u00f3n");
        }
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.flush();
            objectInputStream = new ObjectInputStream(socket.getInputStream());
            objectOutputStream.writeObject(serializable);
            objectOutputStream.flush();
            Message message = null;
            try {
                message = (Message)objectInputStream.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Se recibi\u00f3 un objeto desconocido");
                classNotFoundException.printStackTrace();
                socket.close();
                return null;
            }
            socket.close();
            return message;
        }
        catch (Exception exception) {
            try {
                socket.close();
            }
            catch (Exception exception2) {
                System.err.println("No se cerr\u00f3 el socket");
            }
            return null;
        }
    }

    private void executeHello() throws Exception {
        InetAddress inetAddress = null;
        Socket socket = null;
        ObjectInputStream objectInputStream = null;
        ObjectOutputStream objectOutputStream = null;
        HelloRequest helloRequest = new HelloRequest();
        try {
            inetAddress = this.host == null || this.host.equals("") ? InetAddress.getByName(null) : InetAddress.getByName(this.host);
            Client.tracePrint("InetAddress=" + inetAddress);
        }
        catch (Exception exception) {
            Client.tracePrint("Imposible obtener direcci\u00f3n del servidor " + this.host);
            throw exception;
        }
        this.PORT = this.initial_port;
        boolean bl = false;
        while (!bl) {
            Serializable serializable;
            while (true) {
                try {
                    Client.tracePrint("new socket addr:" + inetAddress + " port:" + this.PORT);
                    socket = new Socket(inetAddress, this.PORT);
                    serializable = socket.getLocalAddress();
                    this.host_name = ((InetAddress)serializable).getHostName();
                }
                catch (Exception exception) {
                    Client.tracePrint("port " + this.PORT + " at host " + inetAddress + " is not available");
                    if (this.PORT == this.final_port) {
                        throw exception;
                    }
                    ++this.PORT;
                    continue;
                }
                break;
            }
            if (socket == null) {
                throw new Exception("Imposible esablecer la conexi\u00f3n");
            }
            try {
                objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                objectOutputStream.flush();
                objectInputStream = new ObjectInputStream(socket.getInputStream());
                objectOutputStream.writeObject(helloRequest);
                objectOutputStream.flush();
                serializable = null;
                try {
                    serializable = (Message)objectInputStream.readObject();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Client.tracePrint("Se recibi\u00f3 un objeto desconocido");
                    socket.close();
                    throw classNotFoundException;
                }
                socket.close();
                if (((Message)serializable).getType() == 2) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    Client.tracePrint("El socket no se cerr\u00f3");
                    throw exception2;
                }
            }
            if (bl) continue;
            if (this.PORT == this.final_port) {
                Client.tracePrint("No port available");
                throw new Exception("El puerto no est\u00e1 disponible");
            }
            ++this.PORT;
        }
    }

    public SqlResult executeSesionGrupo(String string, String string2, String string3) throws Exception {
        String string4 = "SELECT grupo.nombre as nombre_grupo,grupo.id as id_grupo,        sesion_grupo.* FROM grupo,sesion_grupo WHERE grupo.id='" + string3 + "'" + "      AND sesion_grupo.grupo=grupo.id";
        QueryRequest queryRequest = new QueryRequest(string, string2, string4);
        Message message = this.sendRequest(queryRequest);
        if (message == null) {
            throw new Exception("Destino inalcanzable");
        }
        if (message.getType() == 6) {
            return ((QueryResponse)message).getValues();
        }
        if (message.getType() == 0) {
            throw new Exception(((ExceptionResponse)message).getExceptionMessage());
        }
        Client.tracePrint("Respuesta inesperada");
        return null;
    }

    public String[] executeCrearSesionEquipo(String string, String string2, String string3, String string4, String[] stringArray) throws Exception {
        CreateSesionEquipoRequest createSesionEquipoRequest = new CreateSesionEquipoRequest(string, string2, string3, string4, stringArray);
        Message message = this.sendRequest(createSesionEquipoRequest);
        if (message == null) {
            throw new Exception("Destino inalcanzable");
        }
        if (message.getType() == 24) {
            return ((CreateSesionEquipoResponse)message).getInfo();
        }
        if (message.getType() == 0) {
            throw new Exception(((ExceptionResponse)message).getExceptionMessage());
        }
        Client.tracePrint("Respuesta inesperada");
        return null;
    }
}

