/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.algebra.SeriesConfig;
import com.mja.algebra.StepConfig;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import java.util.Vector;

public class ExerciseConfig {
    private Vector Vstep = new Vector();
    private Vector rnv;
    private String instruction = "";
    private Parser parser;
    private int decimales;
    private int errors = 0;
    private int steps = 0;
    private boolean done = false;

    public int getErrors() {
        return this.errors;
    }

    public void addError() {
        ++this.errors;
    }

    public void addStep() {
        ++this.steps;
    }

    public boolean isDone() {
        return this.done;
    }

    public void setDone() {
        this.done = true;
    }

    public void reset() {
        this.errors = 0;
        this.steps = 0;
        this.done = false;
    }

    public double getAverage() {
        if (this.done) {
            return (double)Math.max(0, this.countSteps() - this.errors) * 100.0 / (double)Math.max(1, this.countSteps());
        }
        return 0.0;
    }

    public String getIndicator() {
        String string = this.instruction;
        return string;
    }

    public String toString() {
        String string = this.instruction + "\n\n";
        for (int i = 0; i < this.countSteps(); ++i) {
            string = string + this.getStep(i).toString() + "\n";
        }
        return string;
    }

    public String getOExpressions() {
        String string = "";
        for (int i = 0; i < this.countSteps(); ++i) {
            string = string + this.getStep(i).getOExpression(true) + "\n";
        }
        return string;
    }

    public String getAllExplanations() {
        String string = "";
        for (int i = 0; i < this.countSteps(); ++i) {
            string = string + this.getStep(i).getExplanation() + "\n";
        }
        return string;
    }

    public String getInstruction() {
        return this.instruction;
    }

    public ExerciseConfig(Vector vector, Parser parser, int n) {
        this.parser = parser;
        this.rnv = vector;
        this.decimales = n;
    }

    public ExerciseConfig cloneExercise() {
        ExerciseConfig exerciseConfig = new ExerciseConfig(this.rnv, this.parser, this.decimales);
        exerciseConfig.setValues(this.instruction, this.getOExpressions(), this.getAllExplanations());
        return exerciseConfig;
    }

    public void setValues(String string, String string2, String string3) {
        this.instruction = string;
        String[] stringArray = BasicStr.toStrArr((String)string2);
        String[] stringArray2 = BasicStr.toStrArr((String)string3);
        int n = stringArray.length;
        this.Vstep = new Vector();
        for (int i = 0; i < n; ++i) {
            if (stringArray[i].length() <= 0) continue;
            String string4 = "";
            if (i < stringArray2.length) {
                string4 = stringArray2[i];
            }
            this.Vstep.add(new StepConfig(this.rnv, this.parser, stringArray[i], string4, this.decimales));
        }
    }

    public int countSteps() {
        return this.Vstep.size();
    }

    public String[] getSExpressions() {
        String[] stringArray = new String[this.countSteps()];
        for (int i = 0; i < this.countSteps(); ++i) {
            stringArray[i] = this.getStep(i).getSExpression();
        }
        return stringArray;
    }

    public String[] getExplanations() {
        String[] stringArray = new String[this.countSteps()];
        int n = this.countSteps();
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((StepConfig)this.Vstep.elementAt(i)).getExplanation();
        }
        return stringArray;
    }

    public StepConfig getStep(int n) {
        if (n >= 0 && n < this.Vstep.size()) {
            return (StepConfig)this.Vstep.elementAt(n);
        }
        return null;
    }

    private void addStep(Parser parser, String string, String string2, int n) {
        this.Vstep.addElement(new StepConfig(this.rnv, parser, string, string2, n));
    }

    public static ExerciseConfig[] readExercises(Vector vector, Parser parser, String string, int n) {
        int n2;
        String[] stringArray = BasicStr.toStrArr((String)string);
        Vector<ExerciseConfig> vector2 = new Vector<ExerciseConfig>();
        boolean bl = false;
        ExerciseConfig exerciseConfig = null;
        String string2 = "";
        for (n2 = 1; n2 < stringArray.length; ++n2) {
            int n3 = 0;
            n3 = stringArray[n2].indexOf("|");
            if (n3 > 0) {
                if (!bl || exerciseConfig == null) {
                    exerciseConfig = new ExerciseConfig(vector, parser, n);
                    bl = true;
                }
                String string3 = stringArray[n2].substring(0, n3);
                string3 = BasicStr.trim((String)string3, (char)'\t');
                string3 = BasicStr.trim((String)string3, (char)' ');
                String string4 = stringArray[n2].substring(n3 + 1);
                string4 = BasicStr.trim((String)string4, (char)' ');
                exerciseConfig.addStep(parser, string3, string4, n);
                continue;
            }
            if (BasicStr.hasContent((String)stringArray[n2]) && !stringArray[n2].toLowerCase().startsWith("variable")) {
                string2 = stringArray[n2];
            }
            bl = false;
            if (exerciseConfig != null) {
                for (int i = 0; i < SeriesConfig.attrName.length; ++i) {
                    if (!string2.startsWith(SeriesConfig.attrName[i])) continue;
                    string2 = "";
                }
                exerciseConfig.instruction = string2;
                vector2.addElement(exerciseConfig);
                string2 = "";
            }
            exerciseConfig = null;
        }
        if (exerciseConfig != null) {
            vector2.addElement(exerciseConfig);
        }
        ExerciseConfig[] exerciseConfigArray = new ExerciseConfig[vector2.size()];
        for (n2 = 0; n2 < exerciseConfigArray.length; ++n2) {
            exerciseConfigArray[n2] = (ExerciseConfig)vector2.elementAt(n2);
        }
        return exerciseConfigArray;
    }
}

