/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.file.mjaFont;
import com.mja.gui.mjaText;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.FormulaItem;
import com.mja.text.TColors;
import com.mja.util.BasicStr;
import com.mja.util.LiveOrDie;
import com.mja.util.TFont;
import java.awt.Component;
import java.util.StringTokenizer;

public class TNode {
    public static boolean hideExprs = true;
    static final int CHAR = 0;
    static final int TFONT = 1;
    static final int COLOR = 2;
    static final int EXPR = 3;
    static final int FRACT = 4;
    static final int RADICAL = 5;
    static final int SUBIX = 6;
    static final int SUPIX = 7;
    static final int SUM = 8;
    static final int INTEGRAL = 9;
    static final int LIMIT = 10;
    static final int MATRIX = 11;
    static final int DEFPARTS = 12;
    static final int FORMULA = 13;
    static final int MULT = 14;
    static final int HYPERLINK = 15;
    static final int COMPONENT = 16;
    private int type = 0;
    private TFont tfont;
    private TColors tc;
    private String s;
    private String expr;
    private String eval;
    private String dec_expr;
    private Node n_dec;
    private FormulaItem FI;
    private Component Cmp;
    private String ctype;
    private String cid = "";
    private String url = "";
    private Parser p;
    private int x;
    private int y;
    private int A;
    private int D;
    private int W;
    private int x1;
    private int dx2;
    private int dx1;
    private int he;
    private int extra;
    private boolean fixed = false;
    private int cols = 1;
    private int rows = 1;
    private int parts = 2;
    private BasicText parent;

    public void setLocation(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getX1() {
        return this.x1;
    }

    public int getdX2() {
        return this.dx2;
    }

    public int getdX1() {
        return this.dx1;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getA() {
        return this.A;
    }

    public int getD() {
        return this.D;
    }

    public int getW() {
        return this.W;
    }

    public int gethe() {
        return this.he;
    }

    public int getdx2() {
        return this.extra / 2;
    }

    public FormulaItem getFI() {
        return this.FI;
    }

    private TNode(BasicText basicText) {
        this.parent = basicText;
    }

    public TNode(BasicText basicText, String string) {
        this.parent = basicText;
        this.build(0, string);
    }

    public TNode(BasicText basicText, String string, int n) {
        this.parent = basicText;
        if (n == 6 || n == 7 || n == 13) {
            Formula formula = new Formula(basicText.getParser());
            formula.setColors(basicText.getColors());
            formula.insertString(string);
            this.build(n, formula);
        } else if (n == 0) {
            this.build(n, string);
        } else if (n == 15) {
            this.build(n, string);
        } else {
            new Exception("BAD TNode TYPE").printStackTrace();
        }
    }

    public TNode(BasicText basicText, Formula formula, int n) {
        this.parent = basicText;
        this.build(n, formula);
    }

    public TNode(BasicText basicText, Formula formula) {
        this.parent = basicText;
        this.build(13, formula);
    }

    public TNode(BasicText basicText, Component component, String string, String string2) {
        this.parent = basicText;
        this.build(16, component);
        this.ctype = string;
        this.cid = string2;
    }

    public TNode(BasicText basicText, TFont tFont) {
        this.parent = basicText;
        this.build(1, tFont);
    }

    public TNode(BasicText basicText, TColors tColors) {
        this.parent = basicText;
        this.build(2, tColors);
    }

    public TNode(BasicText basicText, int n, int n2, FormulaItem formulaItem) {
        this.cols = n;
        this.rows = n2;
        this.parent = basicText;
        this.build(11, formulaItem);
        formulaItem.setColors(this.parent.getColors());
    }

    public TNode(BasicText basicText, int n, FormulaItem formulaItem) {
        this.parts = n;
        this.parent = basicText;
        this.build(12, formulaItem);
        formulaItem.setColors(this.parent.getColors());
    }

    public TNode(BasicText basicText, FormulaItem formulaItem, int n) {
        this.parent = basicText;
        this.build(n, formulaItem);
    }

    public TNode(BasicText basicText, Parser parser, String string) {
        this.parent = basicText;
        this.p = parser;
        this.expr = string;
        this.build(3, string);
    }

    public void setParser(Parser parser) {
        this.p = parser;
    }

    public BasicText getParent() {
        return this.parent;
    }

    public void setExpr(String string) {
        this.expr = string;
        this.build(3, string);
    }

    private void build(int n, Object object) {
        this.type = n;
        if (n == 0) {
            this.s = (String)object;
            if (!(this.s.equals("\u00b7") || this.s.equals("\u00d7") || this.s.equals("*") || this.s.equals("\u2022") || !this.s.equals("\u2219"))) {
                // empty if block
            }
        } else if (n == 1) {
            this.tfont = (TFont)object;
        } else if (n == 2) {
            this.tc = (TColors)object;
        } else if (n == 3) {
            this.eval = this.s = " " + this.expr + " ";
        } else if (n == 4 || n == 5 || n == 9 || n == 10 || n == 8 || n == 11 || n == 12 || n == 14) {
            this.FI = (FormulaItem)object;
            this.FI.setParent(this);
        } else if (n == 13 || n == 6 || n == 7) {
            this.FI = new FormulaItem((Formula)object);
            this.FI.setParent(this);
            this.s = this.FI.getFormula(0).toString();
        } else if (n == 15) {
            String string = (String)object;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            this.s = stringTokenizer.countTokens() < 2 ? "hv" : stringTokenizer.nextToken();
            this.url = stringTokenizer.nextToken();
        } else if (n == 16) {
            this.Cmp = (Component)object;
        } else {
            this.type = -1;
        }
    }

    public int getAscent(TFont tFont) {
        int n = tFont.getAscent();
        int n2 = tFont.getDescent();
        this.he = (n - n2) / 2;
        switch (this.type) {
            case 0: 
            case 3: 
            case 15: {
                this.A = n;
                break;
            }
            case 7: {
                this.A = this.FI.getFormula(0).getAscent() + this.he + this.FI.getFormula(0).getDescent();
                break;
            }
            case 6: {
                this.A = this.he;
                break;
            }
            case 13: {
                this.A = this.FI.getFormula(0).getAscent();
                break;
            }
            case 4: {
                this.A = this.FI.getFormula(0).getHeight() + this.he;
                break;
            }
            case 5: {
                this.A = Math.max(this.FI.getFormula(1).getAscent(), this.FI.getFormula(0).getHeight() + this.he) + 3;
                break;
            }
            case 8: 
            case 9: {
                this.A = Math.max(n + this.FI.getFormula(1).getHeight() - 1, this.FI.getFormula(2).getAscent());
                break;
            }
            case 10: {
                this.A = Math.max(n, this.FI.getFormula(2).getAscent());
                break;
            }
            case 11: {
                this.A = this.he + (this.getMatrixHeight() + 1) / 2;
                break;
            }
            case 12: {
                this.A = this.he + (this.getDefPartsHeight() + 1) / 2;
                break;
            }
            case 14: {
                this.A = Math.max(this.FI.getFormula(0).getAscent(), this.FI.getFormula(0).getAscent());
                break;
            }
            case 16: {
                this.A = n + 3;
                break;
            }
            default: {
                this.A = 0;
            }
        }
        return this.A;
    }

    public int getDescent(TFont tFont) {
        int n = tFont.getAscent();
        int n2 = tFont.getDescent();
        this.he = (n - n2) / 2;
        switch (this.type) {
            case 0: 
            case 3: 
            case 15: {
                this.D = n2;
                break;
            }
            case 4: {
                this.D = this.FI.getFormula(1).getHeight() - this.he;
                break;
            }
            case 6: {
                this.D = this.FI.getFormula(0).getDescent() - this.he + this.FI.getFormula(0).getAscent();
                break;
            }
            case 7: {
                this.D = -this.he;
                break;
            }
            case 13: {
                this.D = this.FI.getFormula(0).getDescent();
                break;
            }
            case 5: {
                this.D = this.FI.getFormula(1).getDescent();
                break;
            }
            case 8: 
            case 9: {
                this.D = Math.max(n2 + this.FI.getFormula(0).getHeight() - 1, this.FI.getFormula(2).getDescent());
                break;
            }
            case 10: {
                this.D = n2 + Math.max(this.FI.getFormula(0).getHeight() - 1, this.FI.getFormula(1).getHeight());
                this.D = Math.max(this.D, this.FI.getFormula(2).getDescent());
                break;
            }
            case 11: {
                this.D = -this.he + (this.getMatrixHeight() + 1) / 2;
                break;
            }
            case 12: {
                this.D = -this.he + (this.getDefPartsHeight() + 1) / 2;
                break;
            }
            case 14: {
                this.D = Math.max(this.FI.getFormula(0).getDescent(), this.FI.getFormula(0).getDescent());
                break;
            }
            case 16: {
                this.D = n2 + 3;
                break;
            }
            default: {
                this.D = 0;
            }
        }
        return this.D;
    }

    public int getExtraDescent(TFont tFont) {
        int n = tFont.getDescent();
        int n2 = 0;
        if (this.type == 16 && this.Cmp != null) {
            n2 = this.Cmp.getSize().height;
        }
        return Math.max(0, n2 - n);
    }

    int getRows() {
        return this.rows;
    }

    int getColumns() {
        return this.cols;
    }

    int getParts() {
        return this.parts;
    }

    int getMaxA() {
        int n = 0;
        if (this.type == 12) {
            for (int i = 0; i < this.parts; ++i) {
                n = Math.max(n, this.FI.getFormula(i).getAscent());
            }
        } else {
            for (int i = 0; i < this.cols; ++i) {
                int n2 = 0;
                for (int j = 0; j < this.rows; ++j) {
                    n2 = Math.max(n2, this.FI.getFormula(j + i * this.rows).getAscent());
                }
                n = Math.max(n, n2);
            }
        }
        return n;
    }

    int getMatrixHeight() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.cols; ++i) {
            int n3 = 0;
            int n4 = 0;
            for (int j = 0; j < this.rows; ++j) {
                n3 = Math.max(n3, this.FI.getFormula(j + i * this.rows).getAscent());
                n4 = Math.max(n4, this.FI.getFormula(j + i * this.rows).getDescent());
            }
            n = Math.max(n, n3);
            n2 = Math.max(n2, n4);
        }
        return this.rows * (n + n2);
    }

    int getDefPartsHeight() {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.parts; ++i) {
            int n3 = 0;
            int n4 = 0;
            n3 = Math.max(n3, this.FI.getFormula(i).getAscent());
            n4 = Math.max(n4, this.FI.getFormula(i).getDescent());
            n = Math.max(n, n3);
            n2 = Math.max(n2, n4);
        }
        return this.parts * (n + n2 + 6) + 10;
    }

    public int getCharWidth(TFont tFont, Component component, boolean bl) {
        mjaFont mjaFont2 = tFont.getMjaFont();
        this.extra = mjaFont2.stringWidth(component, " ");
        switch (this.type) {
            case 0: {
                if (!this.isOpSymbol()) {
                    this.extra = 0;
                }
                this.W = mjaFont2.stringWidth(component, this.getChar());
                if (!bl || !"(".equals(this.getChar()) && !")".equals(this.getChar())) break;
                this.W = mjaFont2.stringWidth(component, " (");
                break;
            }
            case 3: 
            case 15: {
                this.W = mjaFont2.stringWidth(component, this.getChar());
                break;
            }
            case 6: 
            case 7: {
                this.extra = 0;
            }
            case 13: {
                this.W = this.FI.getFormula(0).getFormulaWidth(component);
                if (!this.FI.getFormula(0).getParent().isFormula()) break;
                this.dx1 = mjaFont2.stringWidth(component, " ");
                this.W += this.dx1 + this.dx1;
                break;
            }
            case 16: {
                this.W = this.Cmp.getSize().width;
                break;
            }
            case 4: {
                this.W = Math.max(this.FI.getFormula(0).getFormulaWidth(component), this.FI.getFormula(1).getFormulaWidth(component)) + 8;
                break;
            }
            case 5: {
                this.dx2 = mjaFont2.stringWidth(component, "\u221a");
                this.x1 = this.dx2 + this.FI.getFormula(0).getFormulaWidth(component);
                this.W = this.x1 + this.FI.getFormula(1).getFormulaWidth(component);
                break;
            }
            case 8: {
                this.dx2 = mjaFont2.stringWidth(component, "\u2211");
                this.x1 = Math.max(this.dx2, Math.max(this.FI.getFormula(0).getFormulaWidth(component), this.FI.getFormula(1).getFormulaWidth(component)));
                this.W = this.x1 + this.FI.getFormula(2).getFormulaWidth(component);
                break;
            }
            case 9: {
                this.dx2 = mjaFont2.stringWidth(component, "\u222b");
                this.x1 = this.dx2 + Math.max(this.FI.getFormula(0).getFormulaWidth(component), this.FI.getFormula(1).getFormulaWidth(component));
                this.W = this.x1 + 3 + this.FI.getFormula(2).getFormulaWidth(component);
                break;
            }
            case 10: {
                this.dx2 = this.FI.getFormula(0).getFormulaWidth(component) + mjaFont2.stringWidth(component, " \u2192");
                int n = this.FI.getFormula(1).getFormulaWidth(component);
                this.x1 = Math.max(n + this.dx2, mjaFont2.stringWidth(component, "l\u00edm"));
                this.W = this.x1 + 3 + this.FI.getFormula(2).getFormulaWidth(component);
                break;
            }
            case 11: {
                int n = 0;
                for (int i = 0; i < this.rows; ++i) {
                    int n2 = this.extra;
                    for (int j = 0; j < this.cols; ++j) {
                        n2 = Math.max(n2, this.FI.getFormula(i + j * this.rows).getFormulaWidth(component));
                    }
                    n = Math.max(n, n2 + this.extra);
                }
                this.W = 2 * this.extra + this.cols * n;
                break;
            }
            case 12: {
                this.extra = 6;
                int n = 0;
                int n3 = this.extra;
                for (int i = 0; i < this.parts; ++i) {
                    n3 = Math.max(n3, this.FI.getFormula(i).getFormulaWidth(component));
                }
                n = Math.max(n, n3 + this.extra);
                this.W = 2 * this.extra + n;
                break;
            }
            case 14: {
                this.dx1 = this.FI.getFormula(0).getFormulaWidth(component);
                this.dx2 = mjaFont2.stringWidth(component, " \u00b7 ");
                this.W = this.dx1 + this.dx2 + this.FI.getFormula(1).getFormulaWidth(component);
                break;
            }
            default: {
                this.W = 0;
                this.extra = 0;
            }
        }
        if (bl) {
            this.W += this.extra;
        }
        return this.W;
    }

    void removeFI() {
        if (this.FI != null) {
            for (int i = 0; i < this.FI.size(); ++i) {
                Formula formula = this.FI.getFormula(i);
                formula.remove(0, formula.info.size());
            }
        }
    }

    void clearColors() {
        if (this.FI != null) {
            for (int i = 0; i < this.FI.size(); ++i) {
                this.FI.getFormula(i).clearColors();
            }
        }
    }

    void clearFonts() {
        if (this.FI != null) {
            for (int i = 0; i < this.FI.size(); ++i) {
                this.FI.getFormula(i).clearFonts();
            }
        }
    }

    void setColors(TColors tColors) {
        if (this.FI != null) {
            for (int i = 0; i < this.FI.size(); ++i) {
                this.FI.getFormula(i).setColors(tColors);
            }
        }
    }

    void clean() {
        if (this.FI != null) {
            for (int i = 0; i < this.FI.size(); ++i) {
                this.FI.getFormula(i).clean();
            }
        }
    }

    public String toString() {
        String string = "";
        switch (this.type) {
            case 0: {
                string = string + " CHAR " + this.s;
                break;
            }
            case 1: {
                string = string + " TFONT " + this.tfont.toString();
                break;
            }
            case 2: {
                string = string + " COLOR " + this.tc.toString();
                break;
            }
            case 15: {
                string = string + " HYPERLINK " + this.expr;
                break;
            }
            case 3: {
                string = string + " EXPR " + this.expr;
                break;
            }
            case 5: {
                string = string + " RADICAL " + this.FI.toString();
                break;
            }
            case 6: {
                string = string + " SUBIX " + this.s;
                break;
            }
            case 7: {
                string = string + " SUPIX " + this.s;
                break;
            }
            case 4: {
                string = string + " FRACT " + this.FI.toString();
                break;
            }
            case 8: {
                string = string + " SUM " + this.FI.toString();
                break;
            }
            case 9: {
                string = string + " INTEGRAL " + this.FI.toString();
                break;
            }
            case 10: {
                string = string + " LIMIT " + this.FI.toString();
                break;
            }
            case 11: {
                string = string + " MATRIX " + this.FI.toString();
                break;
            }
            case 12: {
                string = string + " DEFPARTS " + this.FI.toString();
                break;
            }
            case 13: {
                string = string + " FORMULA " + this.s;
                break;
            }
            case 16: {
                string = string + " COMPONENT " + this.s;
                break;
            }
            case 14: {
                string = string + " MULT " + this.FI.toString();
                break;
            }
            default: {
                string = string + " INVALID TNode";
            }
        }
        return string;
    }

    public static String getComparisonSymbol(String string) {
        if (string.equals("<=")) {
            return "\u2264";
        }
        if (string.equals(">=")) {
            return "\u2265";
        }
        if (string.equals("!=")) {
            return "\u2260";
        }
        if (string.equals("#")) {
            return "\u2260";
        }
        if (string.equals("==")) {
            return "<=>";
        }
        if (string.equals("=?")) {
            return "\u225f";
        }
        return string;
    }

    public String toExpresion(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.s;
        switch (this.type) {
            case 0: {
                string = string.replace('\u00b7', '*');
                string = string.replace('\u00d7', '*');
                string = string.replace('\u2022', '*');
                string = string.replace('\u2219', '*');
                string = BasicStr.replace(string, "\u225f", "=?");
                string = BasicStr.replace(string, "\u2260", "#");
                string = BasicStr.replace(string, "<=>", "==");
                string = BasicStr.replace(string, "\u2264", "<=");
                string = BasicStr.replace(string, "\u2265", ">=");
                if (Node.inAlgebraTutor) {
                    string = BasicStr.replace(string, "#", "eqn");
                    string = BasicStr.replace(string, "@", "eqa");
                    string = BasicStr.replace(string, "~", "eqx");
                    string = BasicStr.replace(string, "[", "num(");
                    string = BasicStr.replace(string, "]", ")");
                }
                stringBuffer.append(string);
                break;
            }
            case 1: {
                stringBuffer.append("<FONT:" + this.tfont.getName() + this.tfont.getSize() + ">");
                break;
            }
            case 2: {
                stringBuffer.append("<COLOR:" + this.tc.getTextColor() + ">");
                break;
            }
            case 5: {
                String string2 = this.FI.getFormula(0).toExpresion(bl);
                if (BasicStr.hasContent(string2)) {
                    stringBuffer.append("(");
                    stringBuffer.append(this.FI.getFormula(1).toExpresion(bl));
                    stringBuffer.append(")^(1/(");
                    stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                    stringBuffer.append("))");
                    break;
                }
                stringBuffer.append("sqrt(" + this.FI.getFormula(1).toExpresion(bl) + ")");
                break;
            }
            case 15: {
                if (bl) {
                    stringBuffer.append(this.url);
                    break;
                }
                stringBuffer.append("hyperlink(" + this.url + ")");
                break;
            }
            case 3: {
                if (bl) {
                    stringBuffer.append(this.expr);
                    break;
                }
                stringBuffer.append("expr(" + this.expr + "," + this.dec_expr + "," + this.fixed + ")");
                break;
            }
            case 6: {
                stringBuffer.append("_" + this.FI.getFormula(0).toExpresion(bl));
                break;
            }
            case 7: {
                stringBuffer.append("^(" + this.FI.getFormula(0).toExpresion(bl) + ")");
                break;
            }
            case 13: {
                stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                break;
            }
            case 16: {
                stringBuffer.append(this.Cmp.toString());
                break;
            }
            case 4: {
                stringBuffer.append("((");
                stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                stringBuffer.append(")/(");
                stringBuffer.append(this.FI.getFormula(1).toExpresion(bl));
                stringBuffer.append("))");
                break;
            }
            case 8: {
                stringBuffer.append("Sum from (" + this.FI.getFormula(0).toExpresion(bl) + ") " + "to (" + this.FI.getFormula(1).toExpresion(bl) + ") " + " (" + this.FI.getFormula(2).toExpresion(bl) + ") ");
                break;
            }
            case 9: {
                stringBuffer.append("Integral from (" + this.FI.getFormula(0).toExpresion(bl) + ") " + "to (" + this.FI.getFormula(1).toExpresion(bl) + ") " + " (" + this.FI.getFormula(2).toExpresion(bl) + ") ");
                break;
            }
            case 10: {
                stringBuffer.append("Limit from (" + this.FI.getFormula(0).toExpresion(bl) + ") " + "to (" + this.FI.getFormula(1).toExpresion(bl) + ") ");
                break;
            }
            case 11: {
                stringBuffer.append(this.rows + "x" + this.cols + "Matrix ");
                for (int i = 0; i < this.cols; ++i) {
                    for (int j = 0; j < this.rows; ++j) {
                        stringBuffer.append(this.FI.getFormula(j + this.rows * i).toExpresion(bl));
                    }
                }
                break;
            }
            case 12: {
                stringBuffer.append(this.parts + " parts Definition ");
                for (int i = 0; i < this.parts; ++i) {
                    stringBuffer.append(this.FI.getFormula(i).toExpresion(bl));
                }
                break;
            }
            case 14: {
                stringBuffer.append("((");
                stringBuffer.append(this.FI.getFormula(0).toExpresion(bl));
                stringBuffer.append(")\u00b7(");
                stringBuffer.append(this.FI.getFormula(1).toExpresion(bl));
                stringBuffer.append("))");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isOpSymbol() {
        return this.s != null && (this.s.equals("+") || this.s.equals("-") || this.s.equals("*") || this.s.equals("\u00b7") || this.s.equals("\u00d7") || this.s.equals("\u2022") || this.s.equals("\u2219") || this.s.equals("/") || this.s.equals("\u00f7") || this.s.equals("\u00b1") || this.s.equals("=") || this.s.equals("<") || this.s.equals(">") || this.s.equals("\u225f") || this.s.equals("\u2260") || this.s.equals("\u2261") || this.s.equals("\u2264") || this.s.equals("\u2265") || this.s.equals("?"));
    }

    public boolean isEquivalenceDirective() {
        return this.s != null && (this.s.equals("#") || this.s.equals("@") || this.s.equals("~") || this.s.equals("["));
    }

    public boolean isRightSqrBracket() {
        return this.s != null && this.s.equals("]");
    }

    public boolean isNumSymbol() {
        return this.s != null && (this.s.equals("0") || this.s.equals("1") || this.s.equals("2") || this.s.equals("3") || this.s.equals("4") || this.s.equals("5") || this.s.equals("6") || this.s.equals("7") || this.s.equals("8") || this.s.equals("9") || this.s.equals("."));
    }

    public boolean isPureChar() {
        return this.type == 0;
    }

    public boolean isChar() {
        switch (this.type) {
            case 0: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public boolean isAlgebraicToken() {
        return this.type == 0 && !this.isOpSymbol() && !this.isEquivalenceDirective() || this.type == 4 || this.type == 5 || this.type == 13 || this.type == 6 || this.type == 14;
    }

    public boolean isTFont() {
        return this.type == 1;
    }

    public boolean isColors() {
        return this.type == 2;
    }

    public boolean isMath() {
        return this.isExpr() || this.isFraction() || this.isProduct() || this.isRadical() || this.isSum() || this.isIntegral() || this.isLimit() || this.isMatrix() || this.isDefParts() || this.isSubIndex() || this.isSuperIndex() || this.isFormula();
    }

    public boolean isLineSeparator() {
        return this.isChar() && (this.isEndOfFile() || "\n".equals(this.s));
    }

    public boolean isWordSeparator() {
        return this.isChar() && (this.isWhiteSpace() || ".".equals(this.s) || ",".equals(this.s) || ";".equals(this.s) || ":".equals(this.s));
    }

    public boolean isWhiteSpace() {
        return this.isChar() && (this.isEndOfFile() || "\n".equals(this.s) || " ".equals(this.s));
    }

    public boolean isExpr() {
        return this.type == 3;
    }

    public boolean isHyperlink() {
        return this.type == 15;
    }

    public boolean isFraction() {
        return this.type == 4;
    }

    public boolean isProduct() {
        return this.type == 14;
    }

    public boolean isRadical() {
        return this.type == 5;
    }

    public boolean isSum() {
        return this.type == 8;
    }

    public boolean isIntegral() {
        return this.type == 9;
    }

    public boolean isLimit() {
        return this.type == 10;
    }

    public boolean isMatrix() {
        return this.type == 11;
    }

    public boolean isDefParts() {
        return this.type == 12;
    }

    public boolean isSubIndex() {
        return this.type == 6;
    }

    public boolean isSuperIndex() {
        return this.type == 7;
    }

    public boolean isFormula() {
        return this.type == 13;
    }

    public boolean isComponent() {
        return this.type == 16;
    }

    public boolean isEndOfLine() {
        return this.isChar() && ("\n".equals(this.s) || this.isEndOfFile());
    }

    public boolean isEndOfFile() {
        return this.isChar() && "\u001a".equals(this.s);
    }

    public int getType() {
        return this.type;
    }

    public void setChar(String string) {
        this.s = string;
    }

    public String getChar() {
        String string = "";
        string = this.isExpr() ? this.eval : this.s;
        return string;
    }

    public String getUri() {
        return this.url;
    }

    public TFont getTFont() {
        return this.tfont;
    }

    public TColors getColors() {
        return this.tc;
    }

    public String getExpr() {
        return this.expr;
    }

    public Component getComponent() {
        return this.Cmp;
    }

    public void setNewComponent(Component component, String string) {
        this.Cmp = component;
        this.cid = string;
    }

    public boolean updateComponent(Component component, String string) {
        if (this.type == 16 && this.cid.equals(string)) {
            this.Cmp = component;
            ((LiveOrDie)((Object)this.Cmp)).setIsUsed(true);
            return true;
        }
        return this.type == 13 && this.getFI().updateNodes(component, string);
    }

    public String getComponentType() {
        return this.ctype;
    }

    public String getComponentId() {
        return this.cid;
    }

    public String getEval() {
        return this.eval;
    }

    public void setFixed(boolean bl) {
        this.fixed = bl;
    }

    public void setDecExpr(String string) {
        this.dec_expr = string;
        this.n_dec = null;
        if (string != null) {
            try {
                this.n_dec = this.p.Analyse(this.dec_expr, 2.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean getFixed() {
        return this.fixed;
    }

    public String getDecExpr() {
        return this.dec_expr;
    }

    /*
     * Unable to fully structure code
     */
    void calcValues(int var1_1, boolean var2_2, int var3_3, boolean var4_4, boolean var5_5) {
        switch (this.type) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                var6_6 = true;
                this.eval = "[ERROR]";
                if (TNode.hideExprs && var4_4 && !var5_5) {
                    this.eval = "[expr]";
                    break;
                }
                var7_7 = null;
                var7_7 = this.p.isVar(this.expr) != false ? this.p.Var(this.expr) : this.p.Analyse(this.expr);
                if (var7_7 == null) ** GOTO lbl41
                try {
                    var8_9 = var7_7.Evaluate();
                    if (var7_7.getStr() == null) ** GOTO lbl22
                    this.eval = var7_7.getStr();
                    ** GOTO lbl43
lbl22:
                    // 1 sources

                    try {
                        if (this.n_dec != null) {
                            var10_12 = (int)Math.round(this.n_dec.Evaluate(2.0));
                            this.eval = var7_7.toString(var10_12, this.fixed, var3_3);
                        } else {
                            this.eval = var7_7.toString(var1_1, var2_2, var3_3);
                        }
                        ** GOTO lbl43
                    }
                    catch (Exception var10_13) {
                        System.out.println("\n" + var10_13.getMessage() + "\nText expression");
                        var11_15 = new StringTokenizer(var10_13.getMessage(), ";");
                        this.eval = var11_15.nextToken();
                        var6_6 = false;
                    }
                }
                catch (Exception var8_10) {
                    System.out.println("\n" + var8_10.getMessage() + "\nText expression");
                    var9_16 = new StringTokenizer(var8_10.getMessage(), ";");
                    this.eval = var9_16.nextToken();
                    var6_6 = false;
                }
                ** GOTO lbl43
lbl41:
                // 1 sources

                this.eval = "[error]";
                var6_6 = false;
lbl43:
                // 6 sources

                if (!var6_6) break;
                while (this.eval.indexOf("\\u") >= 0) {
                    var8_11 = this.eval.indexOf("\\u") + 2;
                    var9_16 = "";
                    while (var8_11 < this.eval.length() && Node.isHexDigit(this.eval.charAt(var8_11))) {
                        var9_16 = (String)var9_16 + this.eval.charAt(var8_11++);
                    }
                    var10_14 = "";
                    if (var9_16.length() > 0) {
                        var10_14 = var10_14 + (char)Integer.parseInt((String)var9_16, 16);
                    }
                    if (var8_11 < this.eval.length()) {
                        var9_16 = (String)var9_16 + this.eval.charAt(var8_11++);
                    }
                    this.eval = BasicStr.replace(this.eval, "\\u" + (String)var9_16, var10_14);
                }
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                this.FI.getFormula(0).calcValues(var1_1, var2_2, var3_3, var4_4, var5_5);
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                for (var7_8 = 0; var7_8 < this.FI.size(); ++var7_8) {
                    this.FI.getFormula(var7_8).calcValues(var1_1, var2_2, var3_3, var4_4, var5_5);
                }
                break;
            }
            case 15: {
                break;
            }
        }
    }

    public TNode cloneTNode(BasicText basicText) {
        TNode tNode = new TNode(basicText);
        switch (this.type) {
            case 0: {
                tNode.build(this.type, this.s);
                break;
            }
            case 1: {
                tNode.build(this.type, this.getTFont());
                break;
            }
            case 2: {
                tNode.build(this.type, this.getColors());
                break;
            }
            case 3: {
                tNode = new TNode(basicText, this.p, this.expr);
                tNode.eval = this.eval;
                tNode.setDecExpr(this.dec_expr);
                tNode.setFixed(this.fixed);
                break;
            }
            case 6: 
            case 7: 
            case 13: {
                tNode.build(this.type, this.FI.getFormula(0).cloneFormula());
                break;
            }
            case 16: {
                tNode.build(16, this.Cmp);
                tNode.ctype = this.ctype;
                tNode.cid = this.cid;
                break;
            }
            case 15: {
                tNode.build(15, this.url);
                tNode.s = this.s;
                break;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: {
                tNode.build(this.type, this.getFI().cloneItem());
            }
        }
        return tNode;
    }

    public void editHyperlink() {
        if (this.isHyperlink()) {
            String[] stringArray = new String[]{"etiqueta", "URL"};
            String[] stringArray2 = new String[]{this.s, this.url};
            boolean[] blArray = new boolean[]{true, true};
            boolean[] blArray2 = new boolean[]{false, false};
            if ((stringArray2 = mjaText.getInfo("Hiperv\u00ednculo", stringArray, "aceptar", "cancelar", blArray, blArray2, stringArray2)) != null) {
                this.s = stringArray2[0];
                this.url = stringArray2[1];
            }
        }
    }
}

