$(document).ready(function() {

	var trivia = [
		question01=	{
			question: "¿Cuál de las siguientes ha recibido dos premios Nobel?",
			answers: ["A: Sophie Germain", "B: Lise Meitner", "C: Maryam Mirzakhani", "D: Marie Curie"],
			correctAnswer: 3,
		},
		question02= {
			question: "¿Cuál de las siguientes, además de científica fue filósofa?",
			answers: ["A: Emmy Noether", "B: Hipatia de Alejandría", "C: Ada Lovelace", "D: Lucy Weston Pickett"],
			correctAnswer: 1,
		},
		question03= {
			question: "Destacó en el campo de las matemáticas.",
			answers: ["A: Maryam Mirzakhani", "B: Margarita Salas", "C: Irène Joliot-Curie", "D: Mileva Maric"],
			correctAnswer: 0
		},
		question04= {
			question: "Estuvo casada con Albert Einstein.",
			answers: ["A: María Winkelmann", "B: Rosalind Franklin", "C: Mileva Maric", "D: Lise Meitner"],
			correctAnswer: 2,
		},
		question05= {
			question: "Murió en el siglo XIX.",
			answers: ["A: Sophie Germain", "B: María la Judía", "C: Laura Bassi", "D: Hipatia de Alejandría"],
			correctAnswer: 0,
		},
		question06= {
			question: "Contribuyó al descubrimiento de la estructura del ADN.",
			answers: ["A: Marie Curie", "B: Lise Meitner", "C: Emmy Noether", "D: Rosalind Franklin"],
			correctAnswer: 3,
		},
		question07=	{
			question: "No destacó como matemática.",
			answers: ["A: Emmy Noether", "B: Sophie Germain", "C: Sofia Kovalevskaya", "D: Lise Meitner"],
			correctAnswer: 3,
		},
		question08= {
			question: "Estuvo casada con Lavoisier.",
			answers: ["A: Ada Lovelace", "B: Jocelyn Bell", "C: Marie-Anne Pierrette Paulze", "D: Rita Levi Montalcini"],
			correctAnswer: 2
		},
		question09= {
			question: "Año de nacimiento de Marie Curie.",
			answers: ["A: 1789", "B: 1867", "C: 1905", "D: 1940"],
			correctAnswer: 1
		},
		question10= {
			question: "Se ha dedicado al estudio de los primates.",
			answers: ["A: Sophie Germain", "B: Barbara McClintock", "C: Emmy Noether", "D: Jane Goodall"],
			correctAnswer: 3
		},
		question11= {
			question: "Se le ha dedicado un elemento químico.",
			answers: ["A: Hipatia de Alejandría", "B: Jocelyn Bell", "C: Lise Meitner", "D: Sophie Germain"],
			correctAnswer: 2
		},
		question12= {
			question: "Consiguió que se erradicara el uso del DDT.",
			answers: ["A: Rachel Carson", "B: Mae Jemison", "C: Inge Lehmann", "D: Katherine Johnson"],
			correctAnswer: 0
		},
		question13= {
			question: "Fue la primera persona en desarrollar un código de computación.",
			answers: ["A: Ada Lovelace", "B: Mary Anning", "C: Mary Cartwright", "D: Katherine Johnson"],
			correctAnswer: 0
		},
		question14= {
			question: "Fue la primera sismóloga en afirmar que el núcleo terrestre se divide en una parte sólida y otra líquida.",
			answers: ["A: Rosalind Franklin", "B: Lynn Margulis", "C: Inge Lehmann", "D: Esther Lederberg"],
			correctAnswer: 2
		},
		question15= {
			question: "Descubrió la primera radioseñal de un púlsar. Su descubrimiento fue parte de su propia tesis doctoral.",
			answers: ["A: Grace Hopper", "B: Jocelyn Bell", "C: Mary Anning", "D: Esther Lederberg"],
			correctAnswer: 1
		
		//question16= {
		//	question: "Contrajo matrimonio de conveniencia a los 18 años para poder salir de su país a estudiar.",
		//	answers: ["A: Sophie Germain", "B: Ada Lovelace", "C: Sofia Kovalévskaya", "D: Mary Cartwright"],
		//	correctAnswer: 2
		//},
		//question17= {
		//	question: "Realizó importantes contribuciones a la teoría de números primos en su época, descubriendo un tipo de primos que llevan su nombre.",
		//	answers: ["A: Mary Cartwright", "B: Évariste Galois", "C: Sophie Germain", "D: Ada Lovelace"],
		//	correctAnswer: 2
		//},
		//question18= {
		//	question: "Trabajó casi todos los ámbitos de las matemáticas: geometría, cálculo, trigonometría, álgebra, teoría de números...",
		//	answers: ["A: Mary Somerville", "B: Évariste Galois", "C: Leonhard Euler", "D: Sofia Kovalévskaya"],
		//	correctAnswer: 2
		//},
		//question19= {
		//	question: "Su primer marido fue el mayor obstáculo para poder estudiar.",
		//	answers: ["A: Ada Lovelace", "B: Mary Somerville", "C: Sofia Kovalévskaya", "D: Mary Cartwright"],
		//	correctAnswer: 1
		//},
		//question20= {
		//	question: "Primera obra conocida que recopila todos los conocimientos matemáticos anteriores a nuestra era.",
		//	answers: ["A: Liber abaci", "B: Teoría de grupos", "C: Elementos", "D: Elasticidad"],
		//	correctAnswer: 2
		//},
		//question21= {
		//	question: "Impedimentos que encuentran las mujeres para ascender en el mundo laboral y de los negocios.",
		//	answers: ["A: Techo de cristal", "B: Efecto Matilda", "C: Brecha de género", "D: Discriminación femenina"],
		//	correctAnswer: 0
		//},
		//question22= {
		// 	question: "Sus investigaciones sobre ecuaciones diferenciales se aplicaron para mejorar la radio y el radar.",
		// 	answers: ["A: Leonhard Euler", "B: Mary Somerville", "C: Mary Cartwright", "D: Sofia Kovalévskaya"],
		//	correctAnswer: 2
	        //},
		//question23= {
		//	question: "¿A qué teoría dieron lugar los descubrimientos de Évariste Galois?",
		//	answers: ["A: Teoría analítica", "B: Teoría algebraica", "C: Teoría de grupos", "D: Teoría del caos"],
		//	correctAnswer: 2
		//},
		//question24= {
		// 	question: "Obtuvo el Premio Bordin de la Academia de Ciencias de París.",
		//	answers: ["A: Sophie Germain", "B: Évariste Galois", "C: Sofia Kovalévskaya", "D: Leonhard Euler"],
		//	correctAnswer: 2
		//},
		//question25= {
		// 	question: "Estudió con los matemáticos árabes más destacados de su tiempo.",
		// 	answers: ["A: Évariste Galois", "B: Leonhard Euler", "C: Euclides de Alejandría", "D: Leonardo de Pisa"],
		// 	correctAnswer: 3
		//},
		//question26= {
		// 	question: "Realizó grandes aportaciones al teorema de Fermat para grados o exponentes primos.",
		// 	answers: ["A: Sophie Germain", "B: Évariste Galois", "C: Sofia Kovalévskaya", "D: Mary Somerville"],
		// 	correctAnswer: 0
		//},
		//question27= {
		//	question: "Popularizó el símbolo \u03c0 para representar el cociente entre la longitud de una circunferencia y su diámetro.",
		// 	answers: ["A: Évariste Galois", "B: Leonhard Euler", "C: Sofia Kovalévskaya", "D: Mary Cartwright"],
		// 	correctAnswer: 1
		//},
		//question28= {
		// 	question: "Consiguió ser profesora en la Universidad de Estocolmo, aunque no admitían mujeres.",
		// 	answers: ["A: Mary Cartwright", "B: Sophie Germain", "C: Sofia Kovalévskaya", "D: Ada Lovelace"],
		// 	correctAnswer: 2
		//},
		//question29= {
		// 	question: "Fue la primera mujer en acceder a la Academia de Ciencias de París.",
		// 	answers: ["A: Mary Cartwright", "B: Sophie Germain", "C: Sofia Kovalévskaya", "D: Mary Somerville"],
		// 	correctAnswer: 1
		//},
		//question30= {
		// 	question: "Un teorema con nombre compuesto lleva su apellido junto al del matemático francés Augustin Louis Cauchy.",
		// 	answers: ["A: Sophie Germain", "B: Leonhard Euler", "C: Sofia Kovalévskaya", "D: Évariste Galois"],
		// 	correctAnswer: 2
                //question22= {
		// 	question: "Sus investigaciones sobre ecuaciones diferenciales se aplicaron para mejorar la radio y el radar.",
		// 	answers: ["A: Leonhard Euler", "B: Mary Somerville", "C: Mary Cartwright", "D: Sofia Kovalévskaya"],
		//	correctAnswer: 2
	        // },
		// question23= {
		// 	question: "¿A qué teoría dieron lugar los descubrimientos de Évariste Galois?",
		// 	answers: ["A: Teoría analítica", "B: Teoría algebraica", "C: Teoría de grupos", "D: Teoría del caos"],
		// 	correctAnswer: 2
		// },
		// question24= {
		// 	question: "Obtuvo el Premio Bordin de la Academia de Ciencias de París",
		// 	answers: ["A: Sophie Germain", "B: Évariste Galois", "C: Sofia Kovalévskaya", "D: Leonhard Euler"],
		// 	correctAnswer: 2
		// },
		// question25= {
		// 	question: "Estudió con los matemáticos árabes más destacados de su tiempo.",
		// 	answers: ["A: Évariste Galois", "B: Leonhard Euler", "C: Euclides de Alejandría", "D: Leonardo de Pisa"],
		// 	correctAnswer: 3
		// },
		// question26= {
		// 	question: "Realizó grandes aportaciones al teorema de Fermat para grados o exponentes primos.",
		// 	answers: ["A: Sophie Germain", "B: Évariste Galois", "C: Sofia Kovalévskaya", "D: Mary Somerville"],
		// 	correctAnswer: 0
		// },
		// question27= {
		// 	question: "Popularizó el símbolo &Pi; para la longitud de la circunferencia",
		// 	answers: ["A: Évariste Galois", "B: Leonhard Euler", "C: Sofia Kovalévskaya", "D: Mary Cartwright"],
		// 	correctAnswer: 1
		// },
		// question28= {
		// 	question: "Consiguió ser profesora en la Universidad de Estocolmo, aunque no admitían mujeres.",
		// 	answers: ["A: Mary Cartwright", "B: Sophie Germain", "C: Sofia Kovalévskaya", "D: Ada Lovelace"],
		// 	correctAnswer: 2
		// },
		// question29= {
		// 	question: "Fue la primera mujer en acceder a la Academia de Ciencias de París.",
		// 	answers: ["A: Mary Cartwright", "B: Sophie Germain", "C: Sofia Kovalévskaya", "D: Mary Somerville"],
		// 	correctAnswer: 1
		// },
		// question30= {
		// 	question: "Un teorema con nombre compuesto lleva su apellido junto al del matemático francés Augustin Louis Cauchy.",
		// 	answers: ["A: Sophie Germain", "B: Leonhard Euler", "C: Sofia Kovalévskaya", "D: Évariste Galois"],
		// 	correctAnswer: 2
		}];
	var audienceAnswers = ['A: 64%  B:  17%  C: 9%  D: 10%', 'A: 24%  B:  26%  C: 27%  D: 23%', 'A: 14%  B:  2%  C: 49%  D: 12%', 'A: 17%  B: 16%  C: 34%  D: 43%']
	var phoneAnswers = ['Estoy seguro. La respuesta es ', "No entiendo bien la pregunta. Pero creo que es ", "¿Cuánto tiempo tengo para decirte una respuesta? Es ... ", 'Ésta la se. Es ',  "Solo estoy suponiendo, pero creo que es "]
	var questionValue = [100, 1000, 5000, 10000, 32000, 64000, 125000, 250000, 500000, 1000000]
	var lettersKey = ['A','B','C','D'];
	var timer = 20;
	var gameStart = false;
	var difficulty = 1;
	var nextQuestion = true;
	var questionNumber = 0;
	var currentAnswer;
	var money = 0;
	var clockIsRunning = false;
	var buttonAIsOn = false;
	var buttonBIsOn = false;
	var buttonCIsOn = false;
	var buttonDIsOn = false;
	var mainTheme = new Audio ("assets/audio/main_theme.mp3");
	var selectButton = new Audio ("assets/audio/select_button.mp3");
	var wrongButton = new Audio ("assets/audio/wrong_button.mp3");
	var wonMillion = new Audio ("assets/audio/won_million.mp3");
	var musicOne = new Audio ("assets/audio/music_01.mp3");
	var musicTwo= new Audio ("assets/audio/music_02.mp3");
	var musicThree = new Audio ("assets/audio/music_03.mp3");
	var phoneRing = new Audio ("assets/audio/phone_ring.mp3");
	var letsPlay = new Audio ("assets/audio/lets_play.mp3");
	var fiftyFiftyOn = false;
	var phoneFriend = false;
	var audienceHelp = false;
	

	mainTheme.play();


	function startTrivia(){
		if  (gameStart === false){
			mainTheme.pause();
			musicOne.currentTime = 0;
			musicTwo.currentTime = 0;
			musicThree.currentTime = 0;
			buttonIsOn();
			fiftyFiftyOn = true;
			phoneFriend = true;
			audienceHelp = true;
			gameStart = true;
			questionNumber = 0;
			shuffle(trivia);
			$('.money-bar').removeClass('current-money');
			$('#money01').addClass('current-money');
			reset();
			lifelineSwitch();
			run();
			startClock();
		generateQuestion();
			console.log("game start is " + gameStart);
			console.log("question number is " + questionNumber);
		}else{
			console.log('start button didnt work')
		}
	}

	$('#start-button').on("click", function(){
		startTrivia();
	});
	
	function run() {
	      intervalId = setInterval(startClock, 1000);
 	}

 	//starts the timer
	function startClock(){
		timer--;
		if (timer > 9){
			$('#game-timer').html(":" + timer);
		}
			else {
				$('#game-timer').html(":0" + timer);
			}
		// console.log(timer);
		clockIsRunning = true;
		if (timer===0){	
			stop();
			gameLose();

		}
	}


	function stop(){
		clearInterval(intervalId);
		clockIsRunning = false;
	}

	 function reset() {
	    timer = 31;
	    $("#display").text(":00");
	  }

	function changeMusic() {
		if (gameStart === true){
			if(questionNumber <5){
				musicOne.play();
			}else if (questionNumber >=5 && questionNumber <8){
				musicTwo.play();
				musicOne.pause();
			}else if (questionNumber > 7){
				musicThree.play();
				musicTwo.pause();
			}
		}else {
			musicOne.pause();		
			musicTwo.pause();
			musicThree.pause();
		}
	};

	function calculateMoney(){
		money = questionValue[questionNumber] ;
		console.log("total money is " + money);
		if (questionNumber === 1){
			$('#money01').removeClass('current-money');
			$('#money02').addClass('current-money');
		}
		else if (questionNumber === 2){
			$('#money02').removeClass('current-money');
			$('#money03').addClass('current-money');
		}
		else if (questionNumber === 3){
			$('#money03').removeClass('current-money');
			$('#money04').addClass('current-money');
		}
		else if (questionNumber === 4){
			$('#money04').removeClass('current-money');
			$('#money05').addClass('current-money');
		}
		else if (questionNumber === 5){
			$('#money05').removeClass('current-money');
			$('#money06').addClass('current-money');
		}
		else if (questionNumber === 6){
			$('#money06').removeClass('current-money');
			$('#money07').addClass('current-money');
		}
		else if (questionNumber === 7){
			$('#money07').removeClass('current-money');
			$('#money08').addClass('current-money');
		}
		else if (questionNumber === 8){
			$('#money08').removeClass('current-money');
			$('#money09').addClass('current-money');
		}
		else if (questionNumber === 9){
			$('#money09').removeClass('current-money');
			$('#money10').addClass('current-money');
			gameWin();
		}
		else {
		}
	}

	function gameLose(){
		//display you lose
		stop();
		musicOne.pause();		
		musicTwo.pause();
		musicThree.pause();
		letsPlay.play();
		fiftyFiftyOn = false;
		phoneFriend = false;
		audienceHelp = false;
		gameStart = false;
		$('.message').text("Fin del juego");
		console.log("Perdiste");
	}

	function gameWin(){
		musicOne.pause();		
		musicTwo.pause();
		musicThree.pause();
		wonMillion.play();
		fiftyFiftyOn = false;
		phoneFriend = false;
		audienceHelp = false;
		stop();
		gameStart = false;
		$('.message').text("¡Eres millonario!");
		console.log("Ganaste");
	}
	
	function buttonIsOn(){
		buttonAIsOn = true;
		buttonBIsOn = true;
		buttonCIsOn = true;
		buttonDIsOn = true;
		console.log('button a is ' + buttonAIsOn);
		console.log('button b is ' + buttonBIsOn);
		console.log('button c is ' + buttonCIsOn);
		console.log('button d is ' + buttonDIsOn);
		$('#answerA').removeClass('disabled');
		$('#answerB').removeClass('disabled');
		$('#answerC').removeClass('disabled');
		$('#answerD').removeClass('disabled');
	}

	function shuffle(array) {
		var currentIndex = trivia.length, temporaryValue, randomIndex;

		// While there remain elements to shuffle...
		while (0 !== currentIndex) {

		// Pick a remaining element...
		randomIndex = Math.floor(Math.random() * currentIndex);
		currentIndex -= 1;

		// And swap it with the current element.
		temporaryValue = array[currentIndex];
		array[currentIndex] = array[randomIndex];
		array[randomIndex] = temporaryValue;
		}

		return array;
		}
	// generateQuestion();
	function generateQuestion () {	
		if (gameStart === true){
			$('.message').empty();
			changeMusic();		
			$('#question').text(trivia[questionNumber].question);
			$('#answerA').text(trivia[questionNumber].answers[0]);
			$('#answerB').text(trivia[questionNumber].answers[1]);
			$('#answerC').text(trivia[questionNumber].answers[2]);
			$('#answerD').text(trivia[questionNumber].answers[3]);
			currentAnswer = trivia[questionNumber].correctAnswer;
			console.log("current answer is " + currentAnswer);
		}else {
			console.log("game is over");
		}
	}


	$("#answerA").on("click", function() {
		if (gameStart === false){
		console.log("nothing")
		}
		else if (gameStart === true && currentAnswer === 0 && buttonAIsOn === true){
			selectButton.play();
			buttonIsOn();
			questionNumber++;
			console.log('q # is ' + questionNumber);
			reset();
			calculateMoney();
			generateQuestion();
		} 	else {
				wrongButton.play();
				gameLose();
				console.log("game loss from answerA");
				console.log("gameStart is " + gameStart);
				console.log("current answer is " + currentAnswer);
				console.log("button a is on is " + buttonAIsOn);
			}
	});

	$("#answerB").on("click", function() {
		if (gameStart === false){
		console.log("nothing")
		}
		else if (gameStart === true && currentAnswer === 1 && buttonBIsOn === true){
			questionNumber++;
			console.log('q # is ' + questionNumber);
			buttonIsOn();
			selectButton.play();
			reset();
			calculateMoney();
			generateQuestion();
		}else {
				wrongButton.play();
				gameLose();
				console.log("game loss from answerB");
		}		
	});

	$("#answerC").on("click", function() {
		if (gameStart === false){
		console.log("nothing")
		}
		else if (gameStart === true && currentAnswer === 2 && buttonCIsOn === true){
			questionNumber++;
			console.log('q # is ' + questionNumber);
			buttonIsOn();
			selectButton.play();
			calculateMoney();
			generateQuestion();
			reset();
		} 	else {
				wrongButton.play();
				gameLose();
				console.log("game loss from answerC");
			}
	});

	$("#answerD").on("click", function() {
		if (gameStart === false){
			console.log("nothing")
		}
		else if (gameStart === true && currentAnswer === 3 && buttonDIsOn === true){
			questionNumber++;
			console.log('q # is ' + questionNumber);
			buttonIsOn();
			selectButton.play();
			calculateMoney();
			generateQuestion();
			reset();
		} 	else {
				wrongButton.play();
				gameLose();
				console.log("game loss from answerD");
			}
	});

	//These are the three lifeline buttons
	//5050, call a friend, and audience

	$("#5050").on("click", function() {
		if (fiftyFiftyOn === true){
			console.log('button 5050 was pressed');
			selectButton.play();
			fiftyFiftyOn = false;
			lifelineSwitch();
			//play sound
			//display 5050 screen
			if (currentAnswer === 0) {
				buttonDIsOn = false;
				$('#answerD').addClass('disabled');
				$('#answerB').addClass('disabled');
				buttonBIsOn = false;
				// disable button b and d
			}else if (currentAnswer === 1){
				buttonAIsOn = false;
				$('#answerA').addClass('disabled');
				$('#answerC').addClass('disabled');
				buttonCIsOn = false;
				//disable button a and c
			}else if (currentAnswer === 2){
				//disable a and b
				buttonAIsOn = false;
				$('#answerA').addClass('disabled');
				buttonBIsOn = false;
				$('#answerB').addClass('disabled');
			}else{
				//disable b & c
				buttonBIsOn = false;
				$('#answerB').addClass('disabled');
				buttonCIsOn = false;
				$('#answerC').addClass('disabled');
			}
		}else{
			console.log("5050 button doesn't work");
		}	
	});

	function randomPhoneAnswerGenerator(){
		var randomphoneAnswer = phoneAnswers[Math.floor(Math.random() * phoneAnswers.length)];
		$('.message').text(randomphoneAnswer + lettersKey[currentAnswer]);
		}
	
	function phoneAFriend(){
		phoneRing.play();
		setTimeout(randomPhoneAnswerGenerator, 2000);
	}

	function audienceForHelp(){
		// var randomAudienceAnswer = audienceAnswers[Math.floor(Math.random() * audienceAnswers.length)];
		$('.message').text(audienceAnswers[currentAnswer]);

	}

	$("#friend").on("click", function() {
		if (phoneFriend === true){
			console.log('button friend was pressed');
			reset();
			phoneFriend = false;
			lifelineSwitch();
			selectButton.play();
			phoneAFriend();
		}else{
			console.log("friend button doesn't work");
		}	
	});


	$("#audience").on("click", function() {
		if (audienceHelp === true){
			console.log('button audience was pressed');
			selectButton.play();
			audienceHelp = false;
			lifelineSwitch();
			audienceForHelp();
		}else{
			console.log("audience button doesn't work");
		}	

	});

	function lifelineSwitch(){
		if (fiftyFiftyOn === false){
			$('#5050').addClass('disabled');
		}else{
			$('#5050').removeClass('disabled');
		}
			if (phoneFriend === false){
			$('#friend').addClass('disabled');
		}else{
			$('#friend').removeClass('disabled');
		}
			if (audienceHelp === false){
			$('#audience').addClass('disabled');
		}else{
			$('#audience').removeClass('disabled');
		}
	}

// Get the modal
var modal = document.getElementById('myModal');

// Get the button that opens the modal
var btn = document.getElementById("myBtn");

// Get the <span> element that closes the modal
var span = document.getElementsByClassName("close")[0];

// When the user clicks on the button, open the modal 
btn.onclick = function() {
    modal.style.display = "block";
}

// When the user clicks on <span> (x), close the modal
span.onclick = function() {
    modal.style.display = "none";
}

// When the user clicks anywhere outside of the modal, close it
window.onclick = function(event) {
    if (event.target == modal) {
        modal.style.display = "none";
    }
}




});