/*
 * Decompiled with CFR 0.152.
 */
package com.mja.guiedit;

import com.mja.file.mjaFont;
import com.mja.gui.Explainer;
import com.mja.gui.MouseCursorHandler;
import com.mja.gui.editDialog;
import com.mja.gui.mjaColor;
import com.mja.lang.Expl;
import com.mja.lang.translator;
import com.mja.util.BasicStr;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;

public class editColorDialog
extends editDialog
implements AdjustmentListener,
ItemListener,
KeyListener,
ActionListener,
Explainer {
    private MouseCursorHandler mch = new MouseCursorHandler(this, this);
    public mjaColor color;
    private Canvas can;
    private Scrollbar sb_r;
    private Scrollbar sb_g;
    private Scrollbar sb_b;
    private Scrollbar sb_t;
    private TextField tf_r;
    private TextField tf_g;
    private TextField tf_b;
    private TextField tf_t;
    private Choice ch_c;
    private translator Tr;
    private Button bc;
    private Button bp;
    private Button bhelp;
    private static mjaColor lastCopied = new mjaColor(0, 0, 0, 0);
    private Label lr;
    private Label lg;
    private Label lb;
    private Label lt;
    private Panel NP = new Panel();
    private boolean updating = false;
    private long ta = 0L;
    private long ti = 0L;

    public editColorDialog(Frame frame, String string, boolean bl, String string2, String string3) {
        super(frame, string, bl, string2, string3);
        this.NP.setBackground(Color.lightGray);
        this.add("North", this.NP);
        this.bc = new Button("copy");
        this.NP.add(this.bc);
        this.ch_c = new Choice();
        this.NP.add(this.ch_c);
        this.bp = new Button("paste");
        this.NP.add(this.bp);
        this.bhelp = new Button("?");
        this.NP.add(this.bhelp);
        this.bc.addActionListener(this);
        this.bp.addActionListener(this);
        this.bhelp.addActionListener(this);
        this.ch_c.addItem("");
        this.ch_c.addItemListener(this);
        Panel panel = new Panel();
        panel.setBackground(Color.white);
        panel.setFont(mjaFont.AWTMono);
        panel.setLayout(new GridLayout(4, 2));
        this.add("Center", panel);
        this.sb_t = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_r = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_g = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_b = new Scrollbar(0, 255, 1, 0, 256);
        this.sb_t.setForeground(Color.lightGray);
        this.sb_r.setForeground(Color.red);
        this.sb_g.setForeground(Color.green);
        this.sb_b.setForeground(Color.blue);
        this.tf_t = new TextField(16);
        panel.add(this.tf_t);
        panel.add(this.sb_t);
        this.tf_r = new TextField(16);
        panel.add(this.tf_r);
        panel.add(this.sb_r);
        this.tf_g = new TextField(16);
        panel.add(this.tf_g);
        panel.add(this.sb_g);
        this.tf_b = new TextField(16);
        panel.add(this.tf_b);
        panel.add(this.sb_b);
        this.tf_t.addMouseListener(this.mch);
        this.tf_r.addMouseListener(this.mch);
        this.tf_g.addMouseListener(this.mch);
        this.tf_b.addMouseListener(this.mch);
        this.sb_t.addMouseListener(this.mch);
        this.sb_r.addMouseListener(this.mch);
        this.sb_g.addMouseListener(this.mch);
        this.sb_b.addMouseListener(this.mch);
        this.ch_c.addMouseListener(this.mch);
        this.bc.addMouseListener(this.mch);
        this.bp.addMouseListener(this.mch);
        this.bhelp.addMouseListener(this.mch);
        Panel panel2 = new Panel();
        this.add("West", panel2);
        panel2.setFont(mjaFont.AWTMono);
        panel2.setLayout(new GridLayout(4, 1));
        this.lt = new Label("transp");
        this.lt.setBackground(Color.lightGray);
        panel2.add(this.lt);
        this.lt.addMouseListener(this.mch);
        this.lr = new Label("     ");
        this.lr.setBackground(Color.red);
        panel2.add(this.lr);
        this.lr.addMouseListener(this.mch);
        this.lg = new Label("     ");
        this.lg.setBackground(Color.green);
        panel2.add(this.lg);
        this.lg.addMouseListener(this.mch);
        this.lb = new Label("     ");
        this.lb.setBackground(Color.blue);
        panel2.add(this.lb);
        this.lb.addMouseListener(this.mch);
        this.can = new Canvas();
        this.add("East", this.can);
        this.can.addMouseListener(this.mch);
        this.can.setSize(80, 92);
        this.enableListener(true);
        this.tf_t.addKeyListener(this);
        this.tf_r.addKeyListener(this);
        this.tf_g.addKeyListener(this);
        this.tf_b.addKeyListener(this);
        this.color = new mjaColor(0, 0, 0, 0);
    }

    private void enableListener(boolean bl) {
        if (bl) {
            this.ch_c.addItemListener(this);
            this.sb_t.addAdjustmentListener(this);
            this.sb_r.addAdjustmentListener(this);
            this.sb_g.addAdjustmentListener(this);
            this.sb_b.addAdjustmentListener(this);
        } else {
            this.ch_c.removeItemListener(this);
            this.sb_t.removeAdjustmentListener(this);
            this.sb_r.removeAdjustmentListener(this);
            this.sb_g.removeAdjustmentListener(this);
            this.sb_b.removeAdjustmentListener(this);
        }
    }

    public void setColorNames(translator translator2) {
        this.Tr = translator2;
        this.NP.remove(this.bhelp);
        this.NP.remove(this.bp);
        this.NP.remove(this.ch_c);
        this.ch_c = new Choice();
        this.ch_c.addItem("");
        for (int i = 0; i < 13; ++i) {
            this.ch_c.addItem(translator2.getColorName(i));
        }
        this.ch_c.addItemListener(this);
        this.ch_c.addMouseListener(this.mch);
        this.NP.add(this.ch_c);
        this.NP.add(this.bp);
        this.NP.add(this.bhelp);
        this.NP.repaint();
    }

    public void setCopyLabels(String string, String string2) {
        this.bc.setLabel(string);
        this.bp.setLabel(string2);
    }

    public mjaColor getMjaColor() {
        this.color = mjaColor.make(this.tf_r.getText(), this.tf_g.getText(), this.tf_b.getText(), this.tf_t.getText());
        return this.color;
    }

    public void setMjaColor(mjaColor mjaColor3) {
        this.color = mjaColor3;
        this.updateAll();
    }

    private boolean isUpdating() {
        return this.updating;
    }

    private void updateAll() {
        if (!this.isUpdating()) {
            this.updating = true;
            this.enableListener(false);
            if (this.color.variable()) {
                this.tf_t.setText(this.color.s_t);
                this.tf_r.setText(this.color.s_r);
                this.tf_g.setText(this.color.s_g);
                this.tf_b.setText(this.color.s_b);
                try {
                    this.sb_t.setValue(Integer.parseInt(this.color.s_t, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sb_t.setValue(0);
                }
                try {
                    this.sb_r.setValue(Integer.parseInt(this.color.s_r, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sb_r.setValue(0);
                }
                try {
                    this.sb_g.setValue(Integer.parseInt(this.color.s_g, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sb_g.setValue(0);
                }
                try {
                    this.sb_b.setValue(Integer.parseInt(this.color.s_b, 16));
                }
                catch (NumberFormatException numberFormatException) {
                    this.sb_b.setValue(0);
                }
            } else {
                String string = mjaColor.getOnlyNamedColor(this.Tr, this.color);
                if (BasicStr.hasContent(string)) {
                    this.ch_c.select(string);
                } else {
                    this.ch_c.select(0);
                }
                Color color = this.color.getFullColor();
                int n = this.color.getTransp();
                if (color == null) {
                    color = Color.gray;
                    n = 0;
                }
                this.sb_t.setValue(n);
                this.sb_r.setValue(color.getRed());
                this.sb_g.setValue(color.getGreen());
                this.sb_b.setValue(color.getBlue());
                this.tf_r.setText(mjaColor.rgbHex(color.getRed()));
                this.tf_g.setText(mjaColor.rgbHex(color.getGreen()));
                this.tf_b.setText(mjaColor.rgbHex(color.getBlue()));
                this.tf_t.setText(mjaColor.rgbHex(n));
                this.can.setBackground(color);
                this.can.repaint();
            }
            this.enableListener(true);
            this.updating = false;
        }
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        long l = System.currentTimeMillis();
        if (l - this.ta > 100L) {
            this.ta = l;
            if (!(this.isUpdating() || adjustmentEvent.getSource() != this.sb_r && adjustmentEvent.getSource() != this.sb_g && adjustmentEvent.getSource() != this.sb_b && adjustmentEvent.getSource() != this.sb_t)) {
                if (adjustmentEvent.getSource() == this.sb_r) {
                    int n = this.sb_r.getValue();
                    if (n > 255) {
                        n = 255;
                    }
                    this.tf_r.setText(mjaColor.rgbHex(n));
                } else if (adjustmentEvent.getSource() == this.sb_g) {
                    int n = this.sb_g.getValue();
                    if (n > 255) {
                        n = 255;
                    }
                    this.tf_g.setText(mjaColor.rgbHex(n));
                } else if (adjustmentEvent.getSource() == this.sb_b) {
                    int n = this.sb_b.getValue();
                    if (n > 255) {
                        n = 255;
                    }
                    this.tf_b.setText(mjaColor.rgbHex(n));
                } else if (adjustmentEvent.getSource() == this.sb_t) {
                    int n = this.sb_t.getValue();
                    if (n > 255) {
                        n = 255;
                    }
                    this.tf_t.setText(mjaColor.rgbHex(n));
                }
                this.color = mjaColor.make(this.tf_r.getText(), this.tf_g.getText(), this.tf_b.getText(), this.tf_t.getText());
                this.updateAll();
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        long l = System.currentTimeMillis();
        if (l - this.ti > 100L) {
            this.ti = l;
            if (!this.isUpdating() && itemEvent.getStateChange() == 1 && itemEvent.getSource() == this.ch_c) {
                this.color = this.Tr.parseColor(this.ch_c.getSelectedItem(), this.color, this.color);
                this.updateAll();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.isUpdating() && !this.mch.isHand()) {
            if (actionEvent.getSource() == this.bc) {
                lastCopied = this.getMjaColor();
            } else if (actionEvent.getSource() == this.bp) {
                this.color = lastCopied;
                this.updateAll();
            } else if (actionEvent.getSource() == this.bhelp) {
                this.mch.setHand();
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isUpdating() && keyEvent.getSource() instanceof TextField && keyEvent.getKeyCode() == 10) {
            this.color = mjaColor.make(this.tf_r.getText(), this.tf_g.getText(), this.tf_b.getText(), this.tf_t.getText());
            this.updateAll();
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public String getExplLabel(MouseEvent mouseEvent) {
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof Label) {
            Label label = (Label)component;
            return "Componente del color";
        }
        if (component instanceof TextField) {
            TextField textField = (TextField)component;
            return "Componente del color";
        }
        if (component instanceof Scrollbar) {
            Scrollbar scrollbar = (Scrollbar)component;
            return "Componente del color";
        }
        if (component instanceof Button) {
            Button button = (Button)component;
            return button.getLabel();
        }
        if (component instanceof Choice) {
            return "Selector de color por nombre";
        }
        if (component instanceof Canvas) {
            return "Color actual";
        }
        return "";
    }

    @Override
    public String getExplanation(MouseEvent mouseEvent) {
        Canvas canvas;
        String[] stringArray = null;
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof Label) {
            Label label = (Label)component;
            if (label == this.lt) {
                stringArray = Expl.EditColor[0];
            } else if (label == this.lr) {
                stringArray = Expl.EditColor[1];
            } else if (label == this.lg) {
                stringArray = Expl.EditColor[2];
            } else if (label == this.lb) {
                stringArray = Expl.EditColor[3];
            }
        } else if (component instanceof TextField) {
            TextField textField = (TextField)component;
            if (textField == this.tf_t) {
                stringArray = Expl.EditColor[0];
            } else if (textField == this.tf_r) {
                stringArray = Expl.EditColor[1];
            } else if (textField == this.tf_g) {
                stringArray = Expl.EditColor[2];
            } else if (textField == this.tf_b) {
                stringArray = Expl.EditColor[3];
            }
        } else if (component instanceof Scrollbar) {
            Scrollbar scrollbar = (Scrollbar)component;
            if (scrollbar == this.sb_t) {
                stringArray = Expl.EditColor[0];
            } else if (scrollbar == this.sb_r) {
                stringArray = Expl.EditColor[1];
            } else if (scrollbar == this.sb_g) {
                stringArray = Expl.EditColor[2];
            } else if (scrollbar == this.sb_b) {
                stringArray = Expl.EditColor[3];
            }
        } else if (component instanceof Button) {
            Button button = (Button)component;
            if (button == this.bc) {
                stringArray = Expl.EditColor[4];
            } else if (button == this.bp) {
                stringArray = Expl.EditColor[5];
            } else if (button == this.bhelp) {
                stringArray = Expl.EditColor[6];
            }
        } else if (component instanceof Choice) {
            Choice choice = (Choice)component;
            if (choice == this.ch_c) {
                stringArray = Expl.EditColor[7];
            }
        } else if (component instanceof Canvas && (canvas = (Canvas)component) == this.can) {
            stringArray = Expl.EditColor[8];
        }
        return Expl.get(stringArray, this.Tr.getActiveLanguage());
    }
}

