
/**
 * Function to specify the Dynamic Feed Mappings
 */
function bindMap(feed, localize, condition, feedErrorCheck) {
  /**
   *
   * Campaign creator:
   * Update FEED NAMES in the lines below.
   *
   */
  var COPY_FEED = 'Universal_feed_copy_CTA';
  var TRACKING_FEED = 'Universal_feed_tracking';
  var DESTINATION_FEED = 'universal_feed_properties_2017_q2_v3';
  var CAMPAIGN_FEED = 'Tripadvisor_USP_Sheet1';


  // We can have two types of destinations for an ad:
  // cities or properties
  var DESTINATION_TYPES = [ 'destination', 'property' ];

  // Add comprehensible error notifications through wrapper on fw.
  feedErrorCheck([COPY_FEED, TRACKING_FEED, DESTINATION_FEED, CAMPAIGN_FEED])

  var destinationFeed = feed[DESTINATION_FEED][0];
  var trackingFeed = feed[TRACKING_FEED][0];
  var campaignFeed = feed[CAMPAIGN_FEED][0];
  var copyFeed = feed[COPY_FEED][0];

  window.clickTag = destinationFeed.click_url.Url;

  var language = trackingFeed.language_code;
  var destination_type = destinationFeed.dest_type_id
  destination_type = condition(
      (DESTINATION_TYPES.indexOf(destination_type) !== -1),
      destination_type, 'unknown'
  );

  /**
   *
   * Map the creative supported fields with
   * the corresponding values from each feed.
   *
   */
  return {
    destination_type: destination_type,

    // Required for building the exit URL
    aid: trackingFeed.aid,
    label: trackingFeed.label + language + '_ufi-P' + destinationFeed.booking_ufi,
    utm_source: trackingFeed.utm_source,
    utm_medium: condition(
      (DESTINATION_TYPES.indexOf(destination_type) !== -1),
      destination_type, 'default'
    ),

    // Creative Values
    // cta: copyFeed.cta,
    // hotel_name: localize('hotel_name', destinationFeed, language),
    // city_name: localize('city_name', destinationFeed, language),
    // hotel_image: destinationFeed.photo_url.Url,

    // frame_1: campaignFeed.text_message_one,
    // frame_2: campaignFeed.text_message_two,
    // copy_1: copyFeed.copy_1,
    // copy_2: copyFeed.copy_2,
    // copy_3: copyFeed.copy_3,
    // property_count: destinationFeed.property_count,
    // stars: destinationFeed.stars,

    // Exits
    default_exit: destinationFeed.click_url.Url
  }
}

/**
 * When the ad is completely loaded, we show it and
 * trigger animations.
 */
function onAdLoaded() {
  document.querySelector("#main-container").style.opacity=1;
  document.querySelector("#loader-container").style.opacity=0;
  document.querySelector("#loader-container").style.display = "none";
  document.querySelector("#main-container").style.display = "block";
  animate();
}

AdTech(bindMap).onLoad(onAdLoaded);
