/*
 * Decompiled with CFR 0.152.
 */
package com.mja.poly;

import com.mja.gui.mjaColor;
import com.mja.parser.Parser;
import com.mja.poly.mjaSurface;
import com.mja.util.BasicStr;
import java.util.StringTokenizer;

public class SurfaceFactory {
    public static final int point = 0;
    public static final int segment = 1;
    public static final int polygon = 2;
    public static final int arrow = 3;
    public static final int curve = 4;
    public static final int triangle = 5;
    public static final int face = 6;
    public static final int regpoly = 7;
    public static final int box = 8;
    public static final int cone = 9;
    public static final int cylinder = 10;
    public static final int tetrahedron = 11;
    public static final int cube = 12;
    public static final int octahedron = 13;
    public static final int dodecahedron = 14;
    public static final int icosahedron = 15;
    public static final int sphere = 16;
    public static final int ellipsoid = 17;
    public static final int parametric = 18;
    public static final int text = 19;
    public static final String[] surfaceName = new String[]{"punto", "segmento", "pol\u00edgono", "flecha", "curva", "tri\u00e1ngulo", "cara", "polireg", "paralelep\u00edpedo", "cono", "cilindro", "tetraedro", "cubo", "octaedro", "dodecaedro", "icosaedro", "esfera", "elipsoide", "superficie", "texto"};

    public static final int getType(String string) {
        for (int i = 0; i < surfaceName.length; ++i) {
            if (!surfaceName[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static final String getEquation(int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return "";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "";
            }
            case 4: {
                return "x=_AnChO_*cos(pi*u) y=_LaRgO_*sen(pi*u) z=_AlTo_*(u-0.5)";
            }
            case 5: {
                return "";
            }
            case 6: {
                return "Cara poligonal plana";
            }
            case 7: {
                return "U=2*pi*u x=(_AnChO_/2)*v*cos(U) y=-(_LaRgO_/2)*v*sin(U) z=0";
            }
            case 8: {
                return "Paralelep\u00edpedo de lados _AnChO_, _LaRgO_ y _AlTo_";
            }
            case 9: {
                return "U=2*pi*u V=v x=(_AnChO_/2)*V*cos(U) y=(_LaRgO_/2)*V*sin(U) z=-(_AlTo_/2)+_AlTo_*V";
            }
            case 10: {
                return "U=2*pi*u V=v x=(_AnChO_/2)*cos(U) y=(_LaRgO_/2)*sin(U) z=-(_AlTo_/2)+_AlTo_*V";
            }
            case 11: {
                return "Tetraedro inscrito en la esfera de radio=_AnChO_/2";
            }
            case 12: {
                return "Cubo inscrito en la esfera de radio=_AnChO_/2";
            }
            case 13: {
                return "Octaedro inscrito en la esfera de radio=_AnChO_/2";
            }
            case 14: {
                return "Dodecaedro inscrito en la esfera de radio=_AnChO_/2";
            }
            case 15: {
                return "Icosaedro inscrito en la esfera de radio=_AnChO_/2";
            }
            case 16: {
                return "U=pi*u V=2*pi*v x=(_AnChO_/2)*sen(U)*cos(V) y=(_AnChO_/2)*sen(U)*sin(V) z=(_AnChO_/2)*cos(U)";
            }
            case 17: {
                return "U=pi*u V=2*pi*v x=(_AnChO_/2)*sen(U)*cos(V) y=(_LaRgO_/2)*sen(U)*sin(V) z=(_AlTo_/2)*cos(U)";
            }
            case 18: {
                return "x=_AnChO_*u-_AnChO_/2 y=_LaRgO_*v-_LaRgO_/2 z=_AlTo_*exp(-2*(x^2+y^2))";
            }
            case 19: {
                return "";
            }
        }
        return "";
    }

    public static mjaSurface getMjaSurface(Parser parser, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, mjaColor mjaColor3, mjaColor mjaColor4, boolean bl, String string9, String string10, String string11, String string12, String string13, String string14, int n, String string15, boolean bl2) {
        int n2 = SurfaceFactory.getType(string);
        mjaSurface mjaSurface2 = new mjaSurface(parser, n2, string3, string4, string5, string6, string7, string8, mjaColor3, mjaColor4, bl, string9, string10, string11, string12, string13, string14, n, bl2);
        mjaSurface2.cond = parser.Analyse(string15, "1");
        switch (n2) {
            case 7: {
                mjaSurface2.setEquation(SurfaceFactory.getEquation(7));
                mjaSurface2.setNv("1");
                break;
            }
            case 9: {
                mjaSurface2.setEquation(SurfaceFactory.getEquation(9));
                break;
            }
            case 10: {
                mjaSurface2.setEquation(SurfaceFactory.getEquation(10));
                break;
            }
            case 16: {
                mjaSurface2.setEquation(SurfaceFactory.getEquation(16));
                break;
            }
            case 17: {
                mjaSurface2.setEquation(SurfaceFactory.getEquation(17));
                break;
            }
            case 0: 
            case 19: {
                mjaSurface2.setEquation(SurfaceFactory.getPointEquation(string2));
                mjaSurface2.setNu("0");
                mjaSurface2.setNv("0");
                break;
            }
            case 1: {
                mjaSurface2.setEquation(SurfaceFactory.getSegmentEquation(string2));
                mjaSurface2.setNv("0");
                break;
            }
            case 2: {
                mjaSurface2.setEquation(SurfaceFactory.getPolygonEquation(string2));
                mjaSurface2.setNv("0");
                mjaSurface2.setNu(Integer.toString(SurfaceFactory.countPoints(string2) - 1) + "*(" + string3 + ")");
                break;
            }
            case 5: {
                mjaSurface2.set3DVertices(string2);
                break;
            }
            case 6: {
                mjaSurface2.setVertices(string2);
                break;
            }
            case 3: {
                mjaSurface2.setEquation(SurfaceFactory.getSegmentEquation(string2));
                mjaSurface2.setNv("0");
                break;
            }
            case 4: {
                mjaSurface2.setNv("0");
            }
            case 18: {
                mjaSurface2.setEquation(string2);
            }
        }
        return mjaSurface2;
    }

    private static final String getPointEquation(String string) {
        String string2 = "x=0 y=0 z=0";
        try {
            String[] stringArray = BasicStr.getTokens(string);
            if (stringArray.length == 3) {
                string2 = "";
                string2 = string2 + "x=" + stringArray[0];
                string2 = string2 + " y=" + stringArray[1];
                string2 = string2 + " z=" + stringArray[2];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static final String getSegmentEquation(String string) {
        String string2 = "x=u y=u z=u";
        try {
            String[] stringArray = BasicStr.getTokens(string);
            if (stringArray.length == 6) {
                String string3 = stringArray[0];
                String string4 = stringArray[1];
                String string5 = stringArray[2];
                String string6 = stringArray[3];
                String string7 = stringArray[4];
                String string8 = stringArray[5];
                string2 = "x=" + string3 + "+u*((" + string6 + ")-(" + string3 + "))" + " y=" + string4 + "+u*((" + string7 + ")-(" + string4 + "))" + " z=" + string5 + "+u*((" + string8 + ")-(" + string5 + "))";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private static int countPoints(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "(,)");
        return stringTokenizer.countTokens() / 3;
    }

    private static final String getPolygonEquation(String string) {
        String[] stringArray = new String[]{};
        try {
            stringArray = BasicStr.getTokens(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int n = stringArray.length / 3;
        String string2 = Integer.toString(n - 1);
        String string3 = "x=";
        String string4 = "y=";
        String string5 = "z=";
        String string6 = "";
        String string7 = "";
        String string8 = "";
        String string9 = "0";
        for (int i = 0; i < n; ++i) {
            String string10 = "0";
            String string11 = "0";
            String string12 = "0";
            try {
                string10 = stringArray[i * 3];
                string11 = stringArray[i * 3 + 1];
                string12 = stringArray[i * 3 + 2];
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (i > 0) {
                if (i > 1) {
                    string3 = string3 + "+";
                    string4 = string4 + "+";
                    string5 = string5 + "+";
                }
                String string13 = Integer.toString(i - 1);
                String string14 = Double.toString(1.0E-8 + (double)i / (double)(n - 1));
                String string15 = "ind((u>=" + string9 + ")&(u<" + string14 + "))";
                String string16 = string2 + "*u-" + string13;
                string3 = string3 + string15 + "*(" + string6 + "+(" + string16 + ")*((" + string10 + ")-(" + string6 + ")))";
                string4 = string4 + string15 + "*(" + string7 + "+(" + string16 + ")*((" + string11 + ")-(" + string7 + ")))";
                string5 = string5 + string15 + "*(" + string8 + "+(" + string16 + ")*((" + string12 + ")-(" + string8 + ")))";
                string9 = string14;
            }
            string6 = string10;
            string7 = string11;
            string8 = string12;
        }
        return string3 + " " + string4 + " " + string5;
    }
}

