  <script>
    const translateBtn = document.getElementById('translate-btn');
    const popup = document.getElementById('popup');
    const popupContent = document.getElementById('popup-content');
    const copyBtn = document.getElementById('copy-btn');
    const closeBtn = document.getElementById('close-btn');

    let currentTranslation = "";

    document.addEventListener('mouseup', function (e) {
      const selection = window.getSelection();
      const selectedText = selection.toString().trim();

      if (selectedText.length > 0) {
        const rect = selection.getRangeAt(0).getBoundingClientRect();
        translateBtn.style.top = (rect.bottom + window.scrollY + 5) + "px";
        translateBtn.style.left = (rect.left + window.scrollX) + "px";
        translateBtn.style.display = 'block';
        translateBtn.dataset.text = selectedText;
      } else {
        translateBtn.style.display = 'none';
        popup.style.display = 'none';
      }
    });

    translateBtn.addEventListener('click', function (e) {
      const textToTranslate = translateBtn.dataset.text;
      translateText(textToTranslate, e.pageX, e.pageY);
      translateBtn.style.display = 'none';
    });

    async function translateText(text, x, y) {
      try {
        const response = await fetch("https://translate.astian.org/translate", {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: JSON.stringify({
            q: text,
            source: "en",
            target: "es",
            format: "text"
          })
        });

        const data = await response.json();

        currentTranslation = data.translatedText || "No se pudo traducir.";
        popupContent.innerText = currentTranslation;
        popup.style.top = (y + 10) + "px";
        popup.style.left = (x) + "px";
        popup.style.display = 'block';
      } catch (error) {
        currentTranslation = "Error al traducir.";
        popupContent.innerText = currentTranslation;
        popup.style.top = (y + 10) + "px";
        popup.style.left = (x) + "px";
        popup.style.display = 'block';
        console.error(error);
      }
    }

    copyBtn.addEventListener('click', async function () {
      try {
        await navigator.clipboard.writeText(currentTranslation);
        copyBtn.innerText = "¡Copiado!";
        setTimeout(() => {
          copyBtn.innerText = "Copiar 📋";
        }, 2000);
      } catch (err) {
        console.error("Error al copiar: ", err);
      }
    });

    closeBtn.addEventListener('click', function () {
      popup.style.display = 'none';
    });
  </script>