var images = [
  {Url: "imagenes/1.png", Text: "Sapo de arroyo del norte de Borneo <(gggpellas)"},
  {Url: "imagenes/2.png", Text: "Sapo de corriente Matang (roylesafaris)"},
  {Url: "imagenes/3.png", Text: "Pequeño sapo corriente (Bob Zakaria)"},
  {Url: "imagenes/4.jpg", Text: "Falso sapo pigmeo (Albert Kang)"},
  {Url: "imagenes/5.jpg", Text: "Sapo de arroyo Kadamaian (Pylon Dale Imbun)"},
  {Url: "imagenes/6.jpg", Text: "Sapo corriente de dedos largos (Palumie Eliss Imbun)"},
  {Url: "imagenes/7.jpg", Text: "Sapo de corriente Matang (birdtan)"},
  {Url: "imagenes/8.jpg", Text: "Sapo de arroyo siamés (binturong27)"},
  {Url: "imagenes/9.jpg", Text: "Sapo de corriente Kra (blackdogto)"},
  {Url: "imagenes/10.jpg", Text: "Sapo corriente de dedos largos (Albert Kang)"},
  {Url: "imagenes/11.jpg", Text: "Sapo de arroyo de Muller (Nielbert Raner)"},
  {Url: "imagenes/12.jpg", Text: "Sapo de corriente de Penang (Alexius L.Z.L)"},

  
];

var imagesContainer = document.getElementById("images-container");
var footer = document.getElementById("footer");

var size = 6;
var start = 0;
var end = size;


$( document ).ready(function() {

    // Load content first time
    loadContent(start, end, size);
    var loadMoreBtn = document.createElement('button');
    loadMoreBtn.setAttribute("id", "loadMoreBtn");
    loadMoreBtn.textContent = "Mostrar más";
    loadMoreBtn.setAttribute("OnClick","loadMoreButtonClick()");
    footer.appendChild(loadMoreBtn);
    
// Click event for Modal
/*$('a.thumbnailElem').click(function(e) {
    e.preventDefault();

    createImageModal('image-modal', $(this).prop('innerText'), $(this).attr('src'), 'hideModal()', 'Stäng');
});  */
  
$(document).on('click', 'a.thumbnailElem', function(e){
    e.preventDefault();

    createImageModal('image-modal', $(this).prop('innerText'), $(this).attr('src'), 'hideModal()', 'Stäng');
});
  

});



// Scroll Listener
var lastScrollTop = 0, delta = 5;
$(window).scroll(function() {
//console.log('loadContent:' + end + ' ' + images.length);
   if($(window).scrollTop() + $(window).height() > $(document).height() - 60) {
     
     // Load content if there is some
     if (end < images.length) {
       
            ShowHideFooter(false, false);
            start += size;
            end += size;
            loadContent(start, end, size);
     }
     else if (end == images.length) {
         if($(window).scrollTop() + $(window).height() > $(document).height()) {
           var noMoreContent = document.createElement('span')
           noMoreContent.setAttribute('id','noContentText');
           noMoreContent.innerText = "No more content";
           footer.appendChild(noMoreContent);
           ShowHideFooter(true,false);
        }
     }
   }
 
  // Detect scroll direction
  var st = $(this).scrollTop();

  if(Math.abs(lastScrollTop - st) <= delta)
    return;

  if (st > lastScrollTop){
    // downscroll code
    
  } else {
    // upscroll code
    var elem = document.getElementById('noContentText');
    if (elem != null){
      elem.parentNode.removeChild(elem);
      ShowHideFooter(false, false);
    }
  }
  lastScrollTop = st;
});

function loadContent(start, end, size){
        var rowSize = end - start;
        for (var i = start; i < end; i++) {
          var thumbnailWrapper = document.createElement("div");
          thumbnailWrapper.className = "thumbnail-wrapper row" + start;

          var thumbnail = document.createElement("a");
          thumbnail.className = "thumbnailElem";
          thumbnail.setAttribute('style', 'background-image:url(\"' +   images[i].Url + '\");');
          thumbnail.setAttribute('src', images[i].Url);

          var textContainer = document.createElement("div");
          textContainer.className = "text-wrapper";

          var imageText = document.createElement("span");
          imageText.className = "image-text";
          imageText.innerHTML = images[i].Text;

          thumbnailWrapper.appendChild(thumbnail);
          thumbnail.appendChild(textContainer);
          textContainer.appendChild(imageText);
          imagesContainer.appendChild(thumbnailWrapper);
            
  }
}

function createImageModal(placementId, heading, imagesSrc)
{
    var html =  '<div id="modalWindow" class="modal fade" tabindex="-1" role="dialog">';
    html += '<div class="modal-dialog modal-lg">';
    html += '<div class="modal-content">';
    html += '<div class="modal-header">';
    html += '<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">x</span></button>';
    if (heading === undefined){
      html += '<div id="modalTitle" class="modal-title">No title</div>'
    }
    else {
      html += '<div id="modalTitle" class="modal-title">'+heading+'</div>'
    }
    html += '</div>'; // header
    html += '<div class="modal-body">';
    html += '<img class="img-responsive center-block" src="'+imagesSrc+'" alt="">'
    html += '</div>';
    html += '<div class="modal-footer">';
    html += '<a class="imageLink" href="'+imagesSrc+'"target="_blank">'+imagesSrc+'</a>'
    html += '<button type="button" class="btn btn-default" data-dismiss="modal">Cerrar</button>';
    html += '</div>';  // footer
    html += '</div>';  // content
    html += '</div>';  // dialog
    html += '</div>';  // modalWindow
    $("#"+placementId).html(html);
    $("#modalWindow").modal();
}


function hideModal()
{
    // Using a very general selector - this is because $('#modalDiv').hide
    // will remove the modal window but not the mask
    $('.modal.in').modal('hide');
}

function loadMoreButtonClick(){
    start += size;
    end += size;
    loadContent(start, end, size);
    ShowHideFooter(false,false);
}

function ShowHideFooter(fo ,btn){
  if (fo == true){
    $('#footer').fadeIn();
  }
  else{
    $('#footer').fadeOut(100);
  }
  if(btn == true){
        $('#loadMoreBtn').fadeIn();
     }
  else{
        $('#loadMoreBtn').fadeOut(200);
     }
}