/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.TColors;
import com.mja.text.TNode;
import com.mja.text.Text;
import com.mja.util.BasicStr;
import com.mja.util.LivingCanvas;
import com.mja.util.TFont;
import java.awt.Color;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import org.unam.matem.Attribute;

public class RTF {
    public static final String RTF_header = "{\\rtf1";
    public static final String RTF_mjaformula = "{\\*\\mjaformula";
    public static final String RTF_component = "{\\*\\component";
    public static final String RTF_hyperlink = "{\\*\\hyperlink";
    public static final String RTF_expr = "{\\expr";
    public static final String RTF_decimals = "\\decimals";
    public static final String RTF_fixed = "\\fixed";
    public static final String RTF_fraction = "{\\fraction";
    public static final String RTF_product = "{\\product";
    public static final String RTF_num = "{\\num";
    public static final String RTF_den = "{\\den";
    public static final String RTF_radical = "{\\radical";
    public static final String RTF_index = "{\\index";
    public static final String RTF_radicand = "{\\radicand";
    public static final String RTF_sum = "{\\sum";
    public static final String RTF_integral = "{\\integral";
    public static final String RTF_limit = "{\\limit";
    public static final String RTF_from = "{\\from";
    public static final String RTF_to = "{\\to";
    public static final String RTF_what = "{\\what";
    public static final String RTF_matrix = "{\\matrix";
    public static final String RTF_rows = "\\rows";
    public static final String RTF_columns = "\\columns";
    public static final String RTF_element = "{\\element";
    public static final String RTF_defparts = "{\\defparts";
    public static final String RTF_parts = "\\parts";
    public static final String RTF_subix = "{\\subix";
    public static final String RTF_supix = "{\\supix";
    public static final int Monospaced = 0;
    public static final int Serif = 1;
    public static final int SansSerif = 2;
    public static final String[] Java2FontNames = new String[]{"Monospaced", "Serif", "SansSerif"};
    public static final String[] Java1FontNames = new String[]{"Courier", "TimesRoman", "Helvetica"};
    public static final String[] WindowsFontNames = new String[]{"Courier New", "Times New Roman", "Arial"};
    public static float defaultFontSize = 12.0f;
    public static float fontScale = 2.0f;
    private static final char[] hexdigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private StringBuffer RTFsb;
    private boolean RTFafterKeyword;
    private Dictionary RTFcolorTable;
    private Dictionary RTFfontTable;
    private Dictionary RTFstyleTable;
    private int RTFcolorCount;
    private int RTFfontCount;
    private int RTFstyleCount;
    private int RTFusedFontCount;
    private static int RTFunicodeCount;
    private int[] outputConversion;
    private BasicText T;
    protected static CharacterKeywordPair[] textKeywords;
    private boolean endFont;
    private StringBuffer TEXsb;
    public static final int normalsize = 0;
    public static final int small = -1;
    public static final int large = 1;
    public static final int Large = 2;
    public static final int LARGE = 3;
    public static final int huge = 4;
    public static final int Huge = 5;
    private boolean sizeDefined = false;

    public RTF(BasicText basicText) {
        this.T = basicText;
        if (basicText instanceof Text) {
            ((Text)this.T).clean();
        }
        textKeywords = new CharacterKeywordPair[0];
    }

    static String WfontName(String string) {
        for (int i = 0; i < Java1FontNames.length; ++i) {
            if (WindowsFontNames[i].equals(string)) {
                return WindowsFontNames[i];
            }
            if (Java1FontNames[i].equals(string)) {
                return WindowsFontNames[i];
            }
            if (!Java2FontNames[i].equals(string)) continue;
            return WindowsFontNames[i];
        }
        return WindowsFontNames[0];
    }

    static String JfontName(String string) {
        for (int i = 0; i < WindowsFontNames.length; ++i) {
            if (!WindowsFontNames[i].equals(string)) continue;
            return Java2FontNames[i];
        }
        return Java2FontNames[0];
    }

    private void writeRTFBegingroup() {
        this.RTFsb.append('{');
        this.RTFafterKeyword = false;
    }

    private void writeRTFEndgroup() {
        this.RTFsb.append('}');
        this.RTFafterKeyword = false;
    }

    private void writeRTFRawString(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.RTFsb.append(string.charAt(i));
        }
    }

    private void writeRTFControlWord(String string) {
        this.RTFsb.append('\\');
        this.writeRTFRawString(string);
        this.RTFafterKeyword = true;
    }

    private void writeRTFControlWord(String string, int n) {
        this.RTFsb.append('\\');
        this.writeRTFRawString(string);
        this.writeRTFRawString(String.valueOf(n));
        this.RTFafterKeyword = true;
    }

    private void writeRTFLineBreak() {
        this.RTFafterKeyword = false;
    }

    private void writeRTFText(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeRTFCharacter(string.charAt(i));
        }
    }

    private void writeRTFCharacter(char c) {
        if (c == '\u00a0') {
            this.RTFsb.append('\\');
            this.RTFsb.append('~');
            this.RTFafterKeyword = false;
            return;
        }
        if (c == '\t') {
            this.writeRTFControlWord("tab");
            return;
        }
        if (c == '\n' || c == '\r') {
            return;
        }
        int n = RTF.convertCharacter(this.outputConversion, c);
        if (n == 0 || n > 127) {
            String string = this.approximationForUnicode(c);
            if (string.length() != RTFunicodeCount) {
                RTFunicodeCount = string.length();
                this.writeRTFControlWord("uc", RTFunicodeCount);
            }
            this.writeRTFControlWord("u", c);
            this.writeRTFRawString(" ");
            this.writeRTFRawString(string);
            this.RTFafterKeyword = false;
            return;
        }
        switch (n) {
            case 92: 
            case 123: 
            case 125: {
                this.RTFsb.append('\\');
                this.RTFafterKeyword = false;
            }
        }
        if (this.RTFafterKeyword) {
            this.RTFsb.append(' ');
            this.RTFafterKeyword = false;
        }
        this.RTFsb.append((char)n);
    }

    private String approximationForUnicode(char c) {
        return "";
    }

    private static int[] outputConversionFromTranslationTable(char[] cArray) {
        int[] nArray = new int[2 * cArray.length];
        for (int i = 0; i < cArray.length; ++i) {
            nArray[i * 2] = cArray[i];
            nArray[i * 2 + 1] = i;
        }
        return nArray;
    }

    private static int[] outputConversionForName(String string) {
        char[] cArray = new char[256];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = (char)i;
        }
        return RTF.outputConversionFromTranslationTable(cArray);
    }

    private static int convertCharacter(int[] nArray, char c) {
        for (int i = 0; i < nArray.length; i += 2) {
            if (nArray[i] != c) continue;
            return nArray[i + 1];
        }
        return 0;
    }

    private void putColorInTable(Color color) {
        if (color != null && this.RTFcolorTable.get(color) == null) {
            this.RTFcolorTable.put(color, new Integer(this.RTFcolorCount));
            ++this.RTFcolorCount;
        }
    }

    private void prepareRTFHeader() {
        this.RTFcolorTable = new Hashtable();
        this.RTFcolorCount = 0;
        this.RTFfontTable = new Hashtable();
        this.RTFfontCount = 0;
        this.RTFfontTable.put(this.T.getTFont().toString(), new Integer(0));
        ++this.RTFfontCount;
        ++this.RTFusedFontCount;
        this.RTFstyleTable = new Hashtable();
        this.RTFstyleCount = 0;
        RTFunicodeCount = 0;
        this.endFont = false;
        this.prepareColors(this.T);
        if (this.endFont) {
            --this.RTFusedFontCount;
        }
        this.RTFsb = new StringBuffer();
        this.TEXsb = new StringBuffer();
    }

    private void prepareColors(BasicText basicText) {
        for (int i = 0; i < basicText.end(); ++i) {
            this.endFont = false;
            TNode tNode = basicText.TNode(i);
            if (tNode.isColors()) {
                this.putColorInTable(tNode.getColors().getTextColor());
                this.putColorInTable(tNode.getColors().getBackColor());
                continue;
            }
            if (tNode.isTFont()) {
                TFont tFont = tNode.getTFont();
                if (this.RTFfontTable.get(tFont.toString()) == null) {
                    this.RTFfontTable.put(tFont.toString(), new Integer(this.RTFfontCount));
                    ++this.RTFfontCount;
                    ++this.RTFusedFontCount;
                    this.endFont = true;
                    continue;
                }
                this.endFont = false;
                continue;
            }
            if (!tNode.isMath() || tNode.isExpr() || tNode.getFI() == null) continue;
            for (int j = 0; j < tNode.getFI().size(); ++j) {
                this.prepareColors(tNode.getFI().getFormula(j));
            }
        }
    }

    private void writeRTFHeader() {
        this.writeRTFBegingroup();
        this.writeRTFControlWord("rtf", 1);
        this.writeRTFControlWord("uc", 0);
        this.outputConversion = RTF.outputConversionForName("ansi");
        this.writeRTFLineBreak();
        String[] stringArray = new String[this.RTFfontCount];
        Enumeration enumeration = this.RTFfontTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Integer n = (Integer)this.RTFfontTable.get(string);
            stringArray[n.intValue()] = TFont.getNameFromString(string);
        }
        this.writeRTFBegingroup();
        this.writeRTFControlWord("fonttbl");
        for (int i = 0; i < this.RTFfontCount; ++i) {
            this.writeRTFControlWord("f", i);
            this.writeRTFControlWord("fcharset", 0);
            this.writeRTFText(RTF.WfontName(stringArray[i]));
            this.writeRTFText(";");
        }
        this.writeRTFEndgroup();
        this.writeRTFLineBreak();
        if (this.RTFcolorCount > 0) {
            Color color;
            Color[] colorArray = new Color[this.RTFcolorCount];
            Enumeration enumeration2 = this.RTFcolorTable.keys();
            while (enumeration2.hasMoreElements()) {
                color = (Color)enumeration2.nextElement();
                Integer n = (Integer)this.RTFcolorTable.get(color);
                colorArray[n.intValue()] = color;
            }
            this.writeRTFBegingroup();
            this.writeRTFControlWord("colortbl");
            for (int i = 0; i < this.RTFcolorCount; ++i) {
                color = colorArray[i];
                if (color != null) {
                    this.writeRTFControlWord("red", color.getRed());
                    this.writeRTFControlWord("green", color.getGreen());
                    this.writeRTFControlWord("blue", color.getBlue());
                }
                this.writeRTFRawString(";");
            }
            this.writeRTFEndgroup();
            this.writeRTFLineBreak();
        }
    }

    private void writeRTFColor(String string, Color color) {
        Object v;
        if (color != null && (v = this.RTFcolorTable.get(color)) != null) {
            this.writeRTFControlWord(string, ((Number)v).intValue());
        }
    }

    private void writeRTFDocument(BasicText basicText) {
        Object object = null;
        int n = 0;
        float f = 0.0f;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        for (int i = 0; i < basicText.end(); ++i) {
            Object object2;
            TNode tNode = basicText.TNode(i);
            if (tNode.isColors()) {
                this.writeRTFColor("cf", tNode.getColors().getTextColor());
                this.writeRTFColor("cb", tNode.getColors().getBackColor());
                continue;
            }
            if (tNode.isTFont()) {
                object2 = tNode.getTFont();
                Object v = this.RTFfontTable.get(((TFont)object2).toString());
                if (v == null) continue;
                n = ((Number)v).intValue();
                if (object == null) {
                    f = ((TFont)object2).getSize();
                    bl = ((TFont)object2).isBold();
                    bl2 = ((TFont)object2).isItalic();
                    bl3 = ((TFont)object2).isUnderline();
                    bl4 = ((TFont)object2).isOverline();
                    this.writeRTFControlWord("f", n);
                    this.writeRTFControlWord("fs", Math.round(f * fontScale));
                    if (bl) {
                        this.writeRTFControlWord("b");
                    }
                    if (bl2) {
                        this.writeRTFControlWord("i");
                    }
                    if (bl3) {
                        this.writeRTFControlWord("ul");
                    }
                    if (bl4) {
                        this.writeRTFControlWord("ol");
                    }
                } else {
                    if (!((TFont)object2).getName().equals(((TFont)object).getName())) {
                        this.writeRTFControlWord("f", n);
                        f = -1.0f;
                    }
                    if ((float)((TFont)object2).getSize() != f) {
                        f = ((TFont)object2).getSize();
                        this.writeRTFControlWord("fs", Math.round(f * fontScale));
                    }
                    if (((TFont)object2).isBold() != bl) {
                        if (bl) {
                            this.writeRTFControlWord("b0");
                        } else {
                            this.writeRTFControlWord("b");
                        }
                        bl = ((TFont)object2).isBold();
                    }
                    if (((TFont)object2).isItalic() != bl2) {
                        if (bl2) {
                            this.writeRTFControlWord("i0");
                        } else {
                            this.writeRTFControlWord("i");
                        }
                        bl2 = ((TFont)object2).isItalic();
                    }
                    if (((TFont)object2).isUnderline() != bl3) {
                        if (bl3) {
                            this.writeRTFControlWord("ulnone");
                        } else {
                            this.writeRTFControlWord("ul");
                        }
                        bl3 = ((TFont)object2).isUnderline();
                    }
                    if (((TFont)object2).isOverline() != bl4) {
                        if (bl4) {
                            this.writeRTFControlWord("olnone");
                        } else {
                            this.writeRTFControlWord("ol");
                        }
                        bl4 = ((TFont)object2).isOverline();
                    }
                }
                object = object2;
                continue;
            }
            if (tNode.isComponent()) {
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_component.substring(2));
                this.writeControl(tNode);
                this.writeRTFEndgroup();
                continue;
            }
            if (tNode.isHyperlink()) {
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_hyperlink.substring(2));
                this.RTFafterKeyword = false;
                this.writeRTFRawString(" " + tNode.getChar() + "|" + tNode.getUri());
                this.writeRTFEndgroup();
                continue;
            }
            if (tNode.isMath()) {
                if (tNode.isFormula()) {
                    this.writeRTFBegingroup();
                    this.writeRTFControlWord(RTF_mjaformula.substring(2));
                }
                this.writeMath(tNode);
                if (!tNode.isFormula()) continue;
                this.writeRTFEndgroup();
                continue;
            }
            if (!tNode.isChar()) continue;
            object2 = tNode.getChar();
            if (((String)object2).equals("\n")) {
                this.writeRTFControlWord("par ");
                this.writeRTFLineBreak();
                continue;
            }
            this.writeRTFText((String)object2);
        }
    }

    private void writeControl(TNode tNode) {
        if (tNode.isComponent()) {
            this.writeRTFControlWord(tNode.getComponentType() + " " + tNode.getComponentId());
        }
    }

    private void writeMath(TNode tNode) {
        if (tNode.isExpr()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_expr.substring(2));
            this.writeRTFText(tNode.getExpr());
            if (tNode.getDecExpr() != null) {
                this.writeRTFControlWord(RTF_decimals.substring(1));
                this.writeRTFText(tNode.getDecExpr());
                if (tNode.getFixed()) {
                    this.writeRTFControlWord(RTF_fixed.substring(1) + "1");
                } else {
                    this.writeRTFControlWord(RTF_fixed.substring(1) + "0");
                }
            }
            this.writeRTFEndgroup();
        } else if (tNode.isFraction()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_fraction.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_num.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_den.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isProduct()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_product.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_num.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_den.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isRadical()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_radical.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_index.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_radicand.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isSum()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_sum.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_from.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_to.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_what.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(2));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isIntegral()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_integral.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_from.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_to.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_what.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(2));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isLimit()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_limit.substring(2));
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_from.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_to.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(1));
            this.writeRTFEndgroup();
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_what.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(2));
            this.writeRTFEndgroup();
            this.writeRTFEndgroup();
        } else if (tNode.isSubIndex()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_subix.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
        } else if (tNode.isSuperIndex()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_supix.substring(2));
            this.writeRTFDocument(tNode.getFI().getFormula(0));
            this.writeRTFEndgroup();
        } else if (tNode.isMatrix()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_matrix.substring(2));
            this.writeRTFControlWord(RTF_rows.substring(1));
            this.writeRTFText(String.valueOf(tNode.getRows()));
            this.writeRTFControlWord(RTF_columns.substring(1));
            this.writeRTFText(String.valueOf(tNode.getColumns()));
            for (int i = 0; i < tNode.getFI().size(); ++i) {
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_element.substring(2));
                this.writeRTFDocument(tNode.getFI().getFormula(i));
                this.writeRTFEndgroup();
            }
            this.writeRTFEndgroup();
        } else if (tNode.isDefParts()) {
            this.writeRTFBegingroup();
            this.writeRTFControlWord(RTF_defparts.substring(2));
            this.writeRTFControlWord(RTF_parts.substring(1));
            this.writeRTFText(String.valueOf(tNode.getParts()));
            for (int i = 0; i < tNode.getFI().size(); ++i) {
                this.writeRTFBegingroup();
                this.writeRTFControlWord(RTF_element.substring(2));
                this.writeRTFDocument(tNode.getFI().getFormula(i));
                this.writeRTFEndgroup();
            }
            this.writeRTFEndgroup();
        } else {
            this.writeRTFDocument(tNode.getFI().getFormula(0));
        }
    }

    private void writeRTFTrailer() {
        this.writeRTFEndgroup();
        this.writeRTFLineBreak();
    }

    public String toRTF(boolean bl) {
        if (this.T instanceof Text) {
            ((Text)this.T).clean();
        }
        this.prepareRTFHeader();
        boolean bl2 = false;
        if (bl) {
            boolean bl3 = bl2 = this.RTFcolorCount == 0 && this.RTFusedFontCount == 0;
            if (bl2) {
                System.out.println("isPlain");
                for (int i = 0; i < this.T.end(); ++i) {
                    Object object;
                    TNode tNode = this.T.TNode(i);
                    if (tNode.isColors() || tNode.isTFont()) continue;
                    if (tNode.isFormula()) {
                        object = tNode.getFI().getFormula(0);
                        if (((BasicText)object).end() == ((BasicText)object).begin() + 1) {
                            tNode = ((BasicText)object).TNode(((BasicText)object).begin());
                            if (tNode.isExpr()) {
                                if (tNode.getDecExpr() == null) {
                                    this.RTFsb.append("[");
                                    this.RTFsb.append(tNode.getExpr());
                                    this.RTFsb.append("]");
                                    continue;
                                }
                                bl2 = false;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    if (tNode.isChar()) {
                        object = tNode.getChar();
                        if (((String)object).equals("\n")) {
                            this.RTFsb.append("\\n");
                            continue;
                        }
                        this.RTFsb.append((String)object);
                        continue;
                    }
                    bl2 = false;
                    break;
                }
            }
        }
        if (!bl2) {
            this.RTFsb = new StringBuffer();
            this.writeRTFHeader();
            this.writeRTFDocument(this.T);
            this.writeRTFTrailer();
        }
        String string = this.RTFsb.toString();
        string = BasicStr.replace(string, "\"", "&quote;");
        string = BasicStr.replace(string, "<", "&lt;");
        string = BasicStr.replace(string, ">", "&gt;");
        return string;
    }

    public static void parseRTF(String string, BasicText basicText) {
        String string2 = new String(string);
        string2 = BasicStr.replace(string2, "&gt;", ">");
        string2 = BasicStr.replace(string2, "&lt;", "<");
        string2 = BasicStr.replace(string2, "&quote;", "\"");
        RTFunicodeCount = 1;
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        if (BasicStr.hasContent(string2)) {
            if (string2.startsWith(RTF_header)) {
                RTF.addText(string2.substring(RTF_header.length()), basicText, hashtable, hashtable2);
                int n = RTF_header.length();
            } else {
                basicText.insertString(BasicStr.replace(string2, "\\n", "\n"));
            }
        }
        if (basicText instanceof Text) {
            ((Text)basicText).clean();
        }
        basicText.setCursorPos(basicText.firstChar(basicText.begin()));
    }

    private static void addText(String string, BasicText basicText, Hashtable hashtable, Hashtable hashtable2) {
        Attribute attribute;
        TFont tFont = basicText.getTFont();
        Color color = basicText.getColors().getTextColor();
        Color color2 = basicText.getColors().getBackColor();
        for (int i = 0; i < string.length(); i += attribute.name.length() + attribute.value.length()) {
            Object object;
            attribute = RTF.getNextToken(string, i);
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (attribute.name.equals("\\")) {
                basicText.insertString(attribute.value);
                continue;
            }
            if (attribute.name.startsWith("{")) {
                String string2;
                String string3;
                if (attribute.name.startsWith("{\\fonttbl")) {
                    boolean bl = hashtable.get("\\f0") != null;
                    RTF.addFonts(hashtable, attribute.name.substring("{\\fonttbl".length()).trim());
                    if (bl || hashtable.get("\\f0") == null) continue;
                    tFont.setName(RTF.JfontName((String)hashtable.get("\\f0")));
                    if (!(basicText instanceof Text) || basicText instanceof Formula) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("{\\colortbl")) {
                    RTF.addColors(hashtable2, attribute.name.substring("{\\colortbl".length()).trim());
                    continue;
                }
                if (attribute.name.startsWith(RTF_component)) {
                    if (!(basicText instanceof Text)) continue;
                    String string4 = attribute.name.substring(RTF_component.length() + 1).trim();
                    object = new StringTokenizer(string4, " }");
                    string3 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    LivingCanvas livingCanvas = new LivingCanvas();
                    ((Text)basicText).insertComponent(livingCanvas, string3, string2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_hyperlink)) {
                    if (!(basicText instanceof Text)) continue;
                    String string5 = attribute.name.substring(RTF_hyperlink.length() + 1).trim();
                    object = new StringTokenizer(string5, "|}");
                    string3 = ((StringTokenizer)object).nextToken();
                    string2 = ((StringTokenizer)object).nextToken();
                    ((Text)basicText).insertHyperlink(string3, string2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_mjaformula)) {
                    Formula formula = null;
                    if (basicText instanceof Formula) {
                        formula = (Formula)basicText;
                    } else if (basicText instanceof Text) {
                        formula = new Formula(basicText.getParser(), basicText.getTFont(), color2, color);
                        ((Text)basicText).insertFormula(formula);
                    }
                    RTF.addText(attribute.name.substring(RTF_mjaformula.length()).trim(), formula, hashtable, hashtable2);
                    if (!(basicText instanceof Text)) continue;
                    formula.setFonts(tFont.cloneTFont());
                    continue;
                }
                if (attribute.name.startsWith(RTF_expr)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_expr.length()).trim(), 3, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_fraction)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_fraction.length()).trim(), 4, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_product)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_product.length()).trim(), 14, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_radical)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_radical.length()).trim(), 5, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_sum)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_sum.length()).trim(), 8, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_integral)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_integral.length()).trim(), 9, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_limit)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_limit.length()).trim(), 10, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_matrix)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_matrix.length()).trim(), 11, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_defparts)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_parts.length()).trim(), 12, hashtable2);
                    continue;
                }
                if (attribute.name.startsWith(RTF_subix)) {
                    RTF.addMath((Formula)basicText, attribute.name.substring(RTF_subix.length()).trim(), 6, hashtable2);
                    continue;
                }
                if (!attribute.name.startsWith(RTF_supix)) continue;
                RTF.addMath((Formula)basicText, attribute.name.substring(RTF_supix.length()).trim(), 7, hashtable2);
                continue;
            }
            if (attribute.name.startsWith("\\")) {
                if (attribute.name.equals("\\f")) {
                    Object v = hashtable.get(attribute.name + attribute.value.trim());
                    if (v == null) continue;
                    tFont.setName(RTF.JfontName((String)v));
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.equals("\\fs")) {
                    try {
                        tFont.setSize(Integer.parseInt(attribute.value.trim()) / 2);
                        if (!(basicText instanceof Text)) continue;
                        ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (attribute.name.equals("\\cf") || attribute.name.equals("\\cb")) {
                    Object v = hashtable2.get("\\cf" + attribute.value.trim());
                    if (v == null) continue;
                    if (attribute.name.equals("\\cf")) {
                        color = (Color)v;
                        color2 = null;
                    } else {
                        color2 = (Color)v;
                    }
                    if (!(basicText instanceof Text)) continue;
                    object = new TColors(color2, color);
                    ((Text)basicText).insertColors((TColors)object, false);
                    continue;
                }
                if (attribute.name.equals("\\u")) {
                    try {
                        char c = (char)Integer.parseInt(attribute.value.trim());
                        basicText.insertChar(c);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (attribute.name.startsWith("\\b")) {
                    tFont.setBold(attribute.value.trim().length() == 0);
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("\\i")) {
                    tFont.setItalic(attribute.value.trim().length() == 0);
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("\\ulnone")) {
                    tFont.setUnderline(false);
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("\\ul")) {
                    tFont.setUnderline(true);
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("\\olnone")) {
                    tFont.setOverline(false);
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("\\ol")) {
                    tFont.setOverline(true);
                    if (!(basicText instanceof Text)) continue;
                    ((Text)basicText).insertTFont(tFont.cloneTFont(), false);
                    continue;
                }
                if (attribute.name.startsWith("\\uc")) {
                    try {
                        RTFunicodeCount = Integer.parseInt(attribute.value.trim());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!attribute.name.startsWith("\\par")) continue;
                basicText.insertChar('\n');
                continue;
            }
            if (RTF.isWhiteSpace(attribute.name.charAt(0))) continue;
            basicText.insertString(attribute.name);
        }
        basicText.setCursorPos(basicText.firstChar(basicText.begin()));
    }

    private static void addMath(Formula formula, String string, int n, Hashtable hashtable) {
        Attribute attribute;
        Color color = formula.getColors().getTextColor();
        Color color2 = formula.getColors().getBackColor();
        Formula formula2 = null;
        Formula formula3 = null;
        Formula formula4 = null;
        Formula formula5 = null;
        Formula formula6 = null;
        Formula formula7 = null;
        Formula formula8 = null;
        Formula formula9 = null;
        Formula[][] formulaArray = null;
        Formula[] formulaArray2 = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        formula2 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        if (n == 4) {
            formula3 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula4 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        } else if (n == 5) {
            formula5 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula6 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        } else if (n == 8 || n == 9 || n == 10) {
            formula7 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula8 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
            formula9 = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        } else if (n == -1) {
            formula2 = formula;
        }
        String string2 = "";
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl = false;
        block22: for (int i = 0; i < string.length(); i += attribute.name.length() + attribute.value.length()) {
            String string7;
            attribute = RTF.getNextToken(string, i);
            if (n == 5 && i == 0 && !attribute.name.startsWith(RTF_index)) {
                formula2 = formula6;
            }
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (attribute.name.startsWith("{")) {
                if (attribute.name.startsWith(RTF_component)) {
                    string7 = attribute.name.substring(RTF_component.length() + 1).trim();
                    StringTokenizer stringTokenizer = new StringTokenizer(string7, " }");
                    String string8 = stringTokenizer.nextToken();
                    String string9 = stringTokenizer.nextToken();
                    LivingCanvas livingCanvas = new LivingCanvas();
                    formula.insertComponent(livingCanvas, string8, string9);
                    continue;
                }
                if (attribute.name.startsWith(RTF_expr)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_expr.length()).trim(), 3, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_fraction)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_fraction.length()).trim(), 4, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_product)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_product.length()).trim(), 14, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_radical)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_radical.length()).trim(), 5, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_sum)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_sum.length()).trim(), 8, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_integral)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_integral.length()).trim(), 9, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_limit)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_limit.length()).trim(), 10, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_matrix)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_matrix.length()).trim(), 11, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_defparts)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_defparts.length()).trim(), 12, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_subix)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_subix.length()).trim(), 6, hashtable);
                    continue;
                }
                if (attribute.name.startsWith(RTF_supix)) {
                    RTF.addMath(formula2, attribute.name.substring(RTF_supix.length()).trim(), 7, hashtable);
                    continue;
                }
                if (n == 4) {
                    if (attribute.name.startsWith(RTF_num)) {
                        RTF.addMath(formula3, attribute.name.substring(RTF_num.length()).trim(), -1, hashtable);
                        continue;
                    }
                    if (!attribute.name.startsWith(RTF_den)) continue;
                    RTF.addMath(formula4, attribute.name.substring(RTF_den.length()).trim(), -1, hashtable);
                    continue;
                }
                if (n == 5) {
                    if (attribute.name.startsWith(RTF_index)) {
                        RTF.addMath(formula5, attribute.name.substring(RTF_index.length()).trim(), -1, hashtable);
                        continue;
                    }
                    if (!attribute.name.startsWith(RTF_radicand)) continue;
                    RTF.addMath(formula6, attribute.name.substring(RTF_radicand.length()).trim(), -1, hashtable);
                    continue;
                }
                if (n == 8 || n == 9 || n == 10) {
                    if (attribute.name.startsWith(RTF_from)) {
                        RTF.addMath(formula7, attribute.name.substring(RTF_from.length()).trim(), -1, hashtable);
                        continue;
                    }
                    if (attribute.name.startsWith(RTF_to)) {
                        RTF.addMath(formula8, attribute.name.substring(RTF_to.length()).trim(), -1, hashtable);
                        continue;
                    }
                    if (!attribute.name.startsWith(RTF_what)) continue;
                    RTF.addMath(formula9, attribute.name.substring(RTF_what.length()).trim(), -1, hashtable);
                    continue;
                }
                if (n == 11) {
                    if (!attribute.name.startsWith(RTF_element)) continue;
                    if (formulaArray == null) {
                        n2 = Integer.parseInt(string4);
                        n3 = Integer.parseInt(string5);
                        formulaArray = new Formula[n3][n2];
                        n4 = 0;
                        n5 = 0;
                    }
                    formulaArray[n5][n4] = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
                    RTF.addMath(formulaArray[n5][n4], attribute.name.substring(RTF_element.length()).trim(), -1, hashtable);
                    if (n4 + 1 < n2) {
                        ++n4;
                        continue;
                    }
                    if (n5 + 1 >= n3) continue;
                    n4 = 0;
                    ++n5;
                    continue;
                }
                if (n != 12 || !attribute.name.startsWith(RTF_element)) continue;
                if (formulaArray2 == null) {
                    n6 = Integer.parseInt(string6);
                    formulaArray2 = new Formula[n6];
                    n7 = 0;
                }
                formulaArray2[n7] = new Formula(formula.getParser(), formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
                RTF.addMath(formulaArray2[n7], attribute.name.substring(RTF_element.length()).trim(), -1, hashtable);
                if (n7 + 1 >= n6) continue;
                ++n7;
                continue;
            }
            if (attribute.name.startsWith("\\")) {
                if (attribute.name.equals("\\cf") || attribute.name.equals("\\cb")) {
                    string7 = hashtable.get("\\cf" + attribute.value.trim());
                    if (string7 == null) continue;
                    if (attribute.name.equals("\\cf")) {
                        color = (Color)((Object)string7);
                        color2 = null;
                    } else {
                        color2 = (Color)((Object)string7);
                    }
                    TColors tColors = new TColors(color2, color);
                    formula2.insertColors(tColors, false);
                    continue;
                }
                if (attribute.name.equals("\\u")) {
                    try {
                        string7 = attribute.value;
                        if (string7.endsWith("}")) {
                            string7 = string7.substring(0, string7.length() - 1);
                        }
                        char c = (char)Integer.parseInt(string7.trim());
                        if (n == 3) {
                            string2 = string2 + c;
                            continue;
                        }
                        formula2.insertChar(c);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (n == 3) {
                    if (attribute.name.startsWith(RTF_decimals)) {
                        string3 = "";
                        continue;
                    }
                    if (!attribute.name.startsWith(RTF_fixed)) continue;
                    bl = "1".equals(attribute.value.trim());
                    continue;
                }
                if (n == 11) {
                    if (attribute.name.startsWith(RTF_rows)) {
                        string4 = "";
                        continue;
                    }
                    if (!attribute.name.startsWith(RTF_columns)) continue;
                    string5 = "";
                    continue;
                }
                if (n != 12 || !attribute.name.startsWith(RTF_parts)) continue;
                string6 = "";
                continue;
            }
            if (RTF.isWhiteSpace(attribute.name.charAt(0))) continue;
            switch (n) {
                case -1: {
                    formula2.insertString(attribute.name);
                    continue block22;
                }
                case 3: {
                    if (string3 == null) {
                        string2 = string2 + attribute.name.trim();
                        continue block22;
                    }
                    string3 = string3 + attribute.name.trim();
                    continue block22;
                }
                case 11: {
                    if (string5 != null) {
                        string5 = string5 + attribute.name.trim();
                        continue block22;
                    }
                    if (string4 != null) {
                        string4 = string4 + attribute.name.trim();
                        continue block22;
                    }
                    string2 = string2 + attribute.name.trim();
                    continue block22;
                }
                case 12: {
                    if (string6 != null) {
                        string6 = string6 + attribute.name.trim();
                        continue block22;
                    }
                    string2 = string2 + attribute.name.trim();
                    continue block22;
                }
                default: {
                    formula2.insertString(attribute.name);
                }
            }
        }
        switch (n) {
            case -1: {
                break;
            }
            case 3: {
                formula.insertExpr(string2, string3, bl);
                break;
            }
            case 4: {
                formula.insertFraction(formula3, formula4);
                break;
            }
            case 14: {
                formula.insertProduct(formula3, formula4);
                break;
            }
            case 5: {
                formula.insertRadical(formula5, formula6);
                break;
            }
            case 8: {
                formula.insertSum(formula7, formula8, formula9);
                break;
            }
            case 9: {
                formula.insertIntegral(formula7, formula8, formula9);
                break;
            }
            case 10: {
                formula.insertLimit(formula7, formula8, formula9);
                break;
            }
            case 11: {
                formula.insertMatrix(formulaArray);
                break;
            }
            case 12: {
                formula.insertDefParts(formulaArray2);
                break;
            }
            case 6: {
                formula.insertSubIndex(formula2);
                break;
            }
            case 7: {
                formula.insertSuperIndex(formula2);
            }
        }
    }

    private static void addFonts(Hashtable hashtable, String string) {
        Attribute attribute;
        String string2 = "";
        for (int i = 0; i < string.length(); i += attribute.name.length() + attribute.value.length()) {
            attribute = RTF.getNextToken(string, i);
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (attribute.name.equals("\\") || attribute.name.startsWith("{")) continue;
            if (attribute.name.startsWith("\\")) {
                if (!attribute.name.equals("\\f")) continue;
                string2 = attribute.name + attribute.value.trim();
                continue;
            }
            if (RTF.isWhiteSpace(attribute.name.charAt(0))) continue;
            String string3 = attribute.name;
            if (string3.endsWith(";")) {
                string3 = string3.substring(0, string3.length() - 1);
            }
            if (string2.length() > 0) {
                hashtable.put(string2, string3);
            }
            string2 = "";
        }
    }

    private static void addColors(Hashtable hashtable, String string) {
        Attribute attribute;
        String string2 = "0";
        String string3 = "0";
        String string4 = "0";
        for (int i = 0; i < string.length(); i += attribute.name.length() + attribute.value.length()) {
            attribute = RTF.getNextToken(string, i);
            if (attribute.name.length() == 0 || attribute.name.equals("}")) break;
            if (attribute.name.equals("\\") || attribute.name.startsWith("{")) continue;
            if (attribute.name.startsWith("\\")) {
                if (attribute.name.startsWith("\\red")) {
                    string2 = attribute.value.trim();
                    continue;
                }
                if (attribute.name.startsWith("\\green")) {
                    string3 = attribute.value.trim();
                    continue;
                }
                if (!attribute.name.startsWith("\\blue")) continue;
                string4 = attribute.value.trim();
                continue;
            }
            if (RTF.isWhiteSpace(attribute.name.charAt(0)) || !attribute.name.startsWith(";")) continue;
            try {
                int n = Integer.parseInt(string2);
                int n2 = Integer.parseInt(string3);
                int n3 = Integer.parseInt(string4);
                Color color = new Color(n, n2, n3);
                String string5 = "\\cf" + String.valueOf(hashtable.size());
                hashtable.put(string5, color);
            }
            catch (Exception exception) {
                // empty catch block
            }
            string2 = "0";
            string3 = "0";
            string4 = "0";
        }
    }

    private static Attribute getNextToken(String string, int n) {
        int n2;
        if (string.charAt(n) == '}') {
            return new Attribute("}", "");
        }
        if (string.charAt(n) == '{') {
            int n3;
            int n4 = 1;
            for (n3 = n + 1; n3 < string.length() && n4 > 0; ++n3) {
                if (string.charAt(n3) == '}') {
                    --n4;
                    continue;
                }
                if (string.charAt(n3) != '{') continue;
                ++n4;
            }
            return new Attribute(string.substring(n, n3), "");
        }
        if (RTF.isWhiteSpace(string.charAt(n))) {
            return new Attribute(new Character(string.charAt(n)).toString(), "");
        }
        if (string.charAt(n) == '\\') {
            int n5;
            int n6;
            if (n + 1 < string.length() && RTF.isCtrlChar(string.charAt(n + 1))) {
                return new Attribute("\\", new Character(string.charAt(n + 1)).toString());
            }
            for (n6 = n + 1; n6 < string.length() && !RTF.isCtrlSep(string.charAt(n6)); ++n6) {
            }
            if (n6 < string.length() && string.charAt(n6) == ' ') {
                ++n6;
            }
            String string2 = string.substring(n, n6);
            for (n5 = 1; n5 < string2.length() && !RTF.isNumChar(string2.charAt(n5)); ++n5) {
            }
            String string3 = string2.substring(0, n5);
            String string4 = string2.substring(n5);
            if (string3.equals("\\u")) {
                string4 = string4 + string.substring(n6, n6 + RTFunicodeCount);
            }
            return new Attribute(string3, string4);
        }
        for (n2 = n + 1; n2 < string.length() && !RTF.isCtrlChar(string.charAt(n2)) && !RTF.isWhiteSpace(string.charAt(n2)); ++n2) {
        }
        return new Attribute(string.substring(n, n2), "");
    }

    private static boolean isCtrlSep(char c) {
        return c == ' ' || c == ';' || RTF.isWhiteSpace(c) || RTF.isCtrlChar(c);
    }

    private static boolean isWhiteSpace(char c) {
        return c == '\r' || c == '\n';
    }

    private static boolean isCtrlChar(char c) {
        return c == '\\' || c == '{' || c == '}';
    }

    private static boolean isNumChar(char c) {
        return c == '-' || c >= '0' && c <= '9';
    }

    static void appendAsChar(StringBuffer stringBuffer, char c) {
        if (c == '{' || c == '}' || c == '\\') {
            stringBuffer.append('\\');
        }
        stringBuffer.append(c);
    }

    public String toTeX() {
        this.TEXsb = new StringBuffer();
        this.writeTEXDocument(this.T);
        return this.TEXsb.toString();
    }

    private void writeTEXText(String string) {
        for (int i = 0; i < string.length(); ++i) {
            this.TEXsb.append(string.charAt(i));
        }
    }

    private void writeTEXMath(TNode tNode) {
        if (!tNode.isExpr()) {
            if (tNode.isFraction()) {
                this.writeTEXText("\\frac{");
                this.writeTEXDocument(tNode.getFI().getFormula(0));
                this.writeTEXText("}{");
                this.writeTEXDocument(tNode.getFI().getFormula(1));
                this.writeTEXText("}");
            } else if (!tNode.isProduct()) {
                if (tNode.isRadical()) {
                    if (BasicStr.hasContent(tNode.getFI().getFormula(0).toExpresion(false))) {
                        this.writeTEXText("\\root {");
                        this.writeTEXDocument(tNode.getFI().getFormula(0));
                        this.writeTEXText("} \\of {");
                        this.writeTEXDocument(tNode.getFI().getFormula(1));
                        this.writeTEXText("}");
                    } else {
                        this.writeTEXText("\\sqrt{");
                        this.writeTEXDocument(tNode.getFI().getFormula(1));
                        this.writeTEXText("}");
                    }
                } else if (tNode.isSum()) {
                    this.writeTEXText("\\sum\\sb {");
                    this.writeTEXDocument(tNode.getFI().getFormula(0));
                    this.writeTEXText("} \\sp {");
                    this.writeTEXDocument(tNode.getFI().getFormula(1));
                    this.writeTEXText("}");
                    this.writeTEXDocument(tNode.getFI().getFormula(2));
                } else if (tNode.isIntegral()) {
                    this.writeTEXText("\\int\\sb {");
                    this.writeTEXDocument(tNode.getFI().getFormula(0));
                    this.writeTEXText("} \\sp {");
                    this.writeTEXDocument(tNode.getFI().getFormula(1));
                    this.writeTEXText("}");
                    this.writeTEXDocument(tNode.getFI().getFormula(2));
                } else if (tNode.isLimit()) {
                    this.writeTEXText("\\lim\\sb {");
                    this.writeTEXDocument(tNode.getFI().getFormula(0));
                    this.writeTEXText(" \\rightarrow ");
                    this.writeTEXDocument(tNode.getFI().getFormula(1));
                    this.writeTEXText("}");
                    this.writeTEXDocument(tNode.getFI().getFormula(2));
                } else if (tNode.isSubIndex()) {
                    this.writeTEXText("\\sb{");
                    this.writeTEXDocument(tNode.getFI().getFormula(0));
                    this.writeTEXText("}");
                } else if (tNode.isSuperIndex()) {
                    this.writeTEXText("\\sp{");
                    this.writeTEXDocument(tNode.getFI().getFormula(0));
                    this.writeTEXText("}");
                } else if (!tNode.isMatrix() && !tNode.isDefParts()) {
                    this.writeTEXDocument(tNode.getFI().getFormula(0));
                }
            }
        }
    }

    private void writeTEXDocument(BasicText basicText) {
        for (int i = 0; i < basicText.end(); ++i) {
            Object object;
            TNode tNode = basicText.TNode(i);
            if (tNode.isColors()) continue;
            if (tNode.isTFont()) {
                if (this.sizeDefined) continue;
                object = tNode.getTFont();
                int n = (((TFont)object).getSize() - 17) / 3;
                if (n < 0) {
                    n = -1;
                } else if (n > 5) {
                    n = 5;
                }
                switch (n) {
                    case -1: {
                        this.writeTEXText("\\small ");
                        break;
                    }
                    case 1: {
                        this.writeTEXText("\\large ");
                        break;
                    }
                    case 2: {
                        this.writeTEXText("\\Large ");
                        break;
                    }
                    case 3: {
                        this.writeTEXText("\\LARGE ");
                        break;
                    }
                    case 4: {
                        this.writeTEXText("\\huge ");
                        break;
                    }
                    case 5: {
                        this.writeTEXText("\\Huge ");
                        break;
                    }
                }
                this.sizeDefined = true;
                continue;
            }
            if (tNode.isComponent() || tNode.isHyperlink()) continue;
            if (tNode.isMath()) {
                this.writeTEXMath(tNode);
                continue;
            }
            if (!tNode.isChar()) continue;
            object = tNode.getChar();
            if (((String)object).equals("\n")) {
                this.writeTEXText("\\break");
                continue;
            }
            if (((String)object).charAt(0) == ' ') {
                this.writeTEXText("\\ ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2212') {
                this.writeTEXText("-");
                continue;
            }
            if (((String)object).charAt(0) == '\u00b7') {
                this.writeTEXText("\\cdot");
                continue;
            }
            if (((String)object).charAt(0) == '\u00d7') {
                this.writeTEXText("\\times ");
                continue;
            }
            if (((String)object).charAt(0) == '\u00f7') {
                this.writeTEXText("\\div ");
                continue;
            }
            if (((String)object).charAt(0) == '\u00b1') {
                this.writeTEXText("\\pm ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2260') {
                this.writeTEXText("\\ne ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2264') {
                this.writeTEXText("\\le ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2265') {
                this.writeTEXText("\\ge ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2248') {
                this.writeTEXText("\\aprox ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2261') {
                this.writeTEXText("\\equiv ");
                continue;
            }
            if (((String)object).charAt(0) == '\u0192') {
                this.writeTEXText("\\f ");
                continue;
            }
            if (((String)object).charAt(0) == '\u221e') {
                this.writeTEXText("\\infty ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2200') {
                this.writeTEXText("\\forall ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2203') {
                this.writeTEXText("\\exists ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2204') {
                this.writeTEXText("\\not\\exists ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2208') {
                this.writeTEXText("\\in ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2209') {
                this.writeTEXText("\\notin ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2234') {
                this.writeTEXText("\\ ");
                continue;
            }
            if (((String)object).charAt(0) == '\u21d2') {
                this.writeTEXText("\\Rightarrow ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2205') {
                this.writeTEXText("\\emptyset ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2229') {
                this.writeTEXText("\\cup ");
                continue;
            }
            if (((String)object).charAt(0) == '\u222a') {
                this.writeTEXText("\\cap ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2202') {
                this.writeTEXText("\\partial ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2206') {
                this.writeTEXText("\\Delta ");
                continue;
            }
            if (((String)object).charAt(0) == '\u2207') {
                this.writeTEXText("\\nabla ");
                continue;
            }
            if (((String)object).charAt(0) == '(' || ((String)object).charAt(0) == '[' || ((String)object).charAt(0) == '{') {
                this.writeTEXText("\\left " + ((String)object).charAt(0));
                continue;
            }
            if (((String)object).charAt(0) == ')' || ((String)object).charAt(0) == ']' || ((String)object).charAt(0) == '}') {
                this.writeTEXText("\\right " + ((String)object).charAt(0));
                continue;
            }
            if (((String)object).charAt(0) >= '\u0391' && ((String)object).charAt(0) <= '\u03c9') {
                switch (((String)object).charAt(0)) {
                    case '\u0391': {
                        this.writeTEXText("A");
                        break;
                    }
                    case '\u0392': {
                        this.writeTEXText("B");
                        break;
                    }
                    case '\u0393': {
                        this.writeTEXText("\\Gamma ");
                        break;
                    }
                    case '\u0394': {
                        this.writeTEXText("\\Delta ");
                        break;
                    }
                    case '\u0395': {
                        this.writeTEXText("E");
                        break;
                    }
                    case '\u0396': {
                        this.writeTEXText("Z");
                        break;
                    }
                    case '\u0397': {
                        this.writeTEXText("H");
                        break;
                    }
                    case '\u0398': {
                        this.writeTEXText("\\Theta ");
                        break;
                    }
                    case '\u0399': {
                        this.writeTEXText("I");
                        break;
                    }
                    case '\u039a': {
                        this.writeTEXText("K");
                        break;
                    }
                    case '\u039b': {
                        this.writeTEXText("\\Lambda ");
                        break;
                    }
                    case '\u039c': {
                        this.writeTEXText("M");
                        break;
                    }
                    case '\u039d': {
                        this.writeTEXText("N");
                        break;
                    }
                    case '\u039e': {
                        this.writeTEXText("\\Xi ");
                        break;
                    }
                    case '\u039f': {
                        this.writeTEXText("O");
                        break;
                    }
                    case '\u03a0': {
                        this.writeTEXText("\\Pi ");
                        break;
                    }
                    case '\u03a1': {
                        this.writeTEXText("P");
                        break;
                    }
                    case '\u03a3': {
                        this.writeTEXText("\\Sigma ");
                        break;
                    }
                    case '\u03a4': {
                        this.writeTEXText("T");
                        break;
                    }
                    case '\u03a5': {
                        this.writeTEXText("\\Upsilon ");
                        break;
                    }
                    case '\u03a6': {
                        this.writeTEXText("\\Phi ");
                        break;
                    }
                    case '\u03a7': {
                        this.writeTEXText("X");
                        break;
                    }
                    case '\u03a8': {
                        this.writeTEXText("\\Psi ");
                        break;
                    }
                    case '\u03a9': {
                        this.writeTEXText("\\Omega ");
                        break;
                    }
                    case '\u03b1': {
                        this.writeTEXText("\\alpha ");
                        break;
                    }
                    case '\u03b2': {
                        this.writeTEXText("\\beta ");
                        break;
                    }
                    case '\u03b3': {
                        this.writeTEXText("\\gamma ");
                        break;
                    }
                    case '\u03b4': {
                        this.writeTEXText("\\delta ");
                        break;
                    }
                    case '\u03b5': {
                        this.writeTEXText("\\epsilon ");
                        break;
                    }
                    case '\u03b6': {
                        this.writeTEXText("\\zeta ");
                        break;
                    }
                    case '\u03b7': {
                        this.writeTEXText("\\eta ");
                        break;
                    }
                    case '\u03b8': {
                        this.writeTEXText("\\theta ");
                        break;
                    }
                    case '\u03b9': {
                        this.writeTEXText("\\iota ");
                        break;
                    }
                    case '\u03ba': {
                        this.writeTEXText("\\kappa ");
                        break;
                    }
                    case '\u03bb': {
                        this.writeTEXText("\\lambda ");
                        break;
                    }
                    case '\u03bc': {
                        this.writeTEXText("\\mu ");
                        break;
                    }
                    case '\u03bd': {
                        this.writeTEXText("\\nu ");
                        break;
                    }
                    case '\u03be': {
                        this.writeTEXText("\\xi ");
                        break;
                    }
                    case '\u03bf': {
                        this.writeTEXText("o");
                        break;
                    }
                    case '\u03c0': {
                        this.writeTEXText("\\pi ");
                        break;
                    }
                    case '\u03c1': {
                        this.writeTEXText("\\rho ");
                        break;
                    }
                    case '\u03c2': {
                        this.writeTEXText("\\varsigma ");
                        break;
                    }
                    case '\u03c3': {
                        this.writeTEXText("\\sigma ");
                        break;
                    }
                    case '\u03c4': {
                        this.writeTEXText("\\tau ");
                        break;
                    }
                    case '\u03c5': {
                        this.writeTEXText("\\upsilon ");
                        break;
                    }
                    case '\u03c6': {
                        this.writeTEXText("\\phi ");
                        break;
                    }
                    case '\u03c7': {
                        this.writeTEXText("\\chi ");
                        break;
                    }
                    case '\u03c8': {
                        this.writeTEXText("\\psi ");
                        break;
                    }
                    case '\u03c9': {
                        this.writeTEXText("\\omega ");
                        break;
                    }
                    default: {
                        this.writeTEXText((String)object);
                        break;
                    }
                }
                continue;
            }
            this.writeTEXText((String)object);
        }
    }

    static class CharacterKeywordPair {
        public char character;
        public String keyword;

        CharacterKeywordPair() {
        }
    }
}

