/*
 * Decompiled with CFR 0.152.
 */
package com.jla.calc;

import com.mja.util.BasicStr;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class calculadora {
    private static final String[] operadores = new String[]{"+", "-", "*", "/", "=", "-x", "1/x"};
    private double acumulado;
    private double entrada;
    private String operador;

    public calculadora() {
        this.limpiar();
    }

    public void limpiar() {
        this.entrada = 0.0;
        this.acumulado = 0.0;
        this.operador = "=";
    }

    public static boolean esOperador(String string) {
        for (int i = 0; i < operadores.length; ++i) {
            if (!operadores[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    public static boolean esOperadorBinario(String string) {
        return "+".equals(string) || "-".equals(string) || "*".equals(string) || "/".equals(string);
    }

    public void entrarValor(String string) throws NumberFormatException {
        this.entrada = Double.valueOf(string);
    }

    public void definirOperador(String string) throws Exception {
        for (int i = 0; i < operadores.length; ++i) {
            if (!operadores[i].equals(string)) continue;
            this.operador = string;
            return;
        }
        throw new Exception("operador desconocido");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void realizarOperaci\u00f3n() throws Exception {
        if (this.operador.equals("=")) {
            this.acumulado = this.entrada;
            return;
        } else if (this.operador.equals("-x")) {
            this.acumulado = -this.entrada;
            return;
        } else if (this.operador.equals("1/x")) {
            if (this.entrada == 0.0) throw new Exception("intento de dividir entre cero.");
            this.acumulado = 1.0 / this.entrada;
            return;
        } else if (this.operador.equals("+")) {
            this.acumulado += this.entrada;
            return;
        } else if (this.operador.equals("*")) {
            this.acumulado *= this.entrada;
            return;
        } else if (this.operador.equals("-")) {
            this.acumulado -= this.entrada;
            return;
        } else {
            if (!this.operador.equals("/")) return;
            if (this.entrada == 0.0) throw new Exception("intento de dividir entre cero.");
            this.acumulado /= this.entrada;
        }
    }

    public String entrada() {
        return BasicStr.DoubleToString(this.entrada, 20, false, ".");
    }

    public String resultado() {
        return BasicStr.DoubleToString(this.acumulado, 20, false, ".");
    }

    public String operador() {
        return this.operador;
    }

    private static double redondear(double d) {
        double d2 = 1.0E8;
        return (double)Math.round(d * d2) / d2;
    }

    public static void main(String[] stringArray) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        calculadora calculadora2 = new calculadora();
        try {
            System.out.print("operando : ");
            calculadora2.entrarValor(bufferedReader.readLine());
            calculadora2.realizarOperaci\u00f3n();
            while (true) {
                calculadora2.entrarValor(calculadora2.resultado());
                System.out.print("operador : ");
                calculadora2.definirOperador(bufferedReader.readLine());
                if (calculadora.esOperadorBinario(calculadora2.operador())) {
                    System.out.print("operando : ");
                    calculadora2.entrarValor(bufferedReader.readLine());
                }
                calculadora2.realizarOperaci\u00f3n();
                System.out.println("resultado= " + calculadora2.resultado());
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
    }
}

