/*global require, dat*/

// copy paste from paul irish http://paulirish.com/2011/requestanimationframe-for-smart-animating/
var requestAnimFrame = (function(){
  return  window.requestAnimationFrame       ||
    window.webkitRequestAnimationFrame ||
    window.mozRequestAnimationFrame    ||
    window.oRequestAnimationFrame      ||
    window.msRequestAnimationFrame     ||
    function( callback ){
      window.setTimeout(callback, 1000 / 60);
    };
})();

document.addEventListener('DOMContentLoaded',function(){
  "use strict";

  var canvas = document.getElementById('canvas');
  var ctx = canvas.getContext('2d');
  window.addEventListener('resize', resize); resize();

  var options = {
    radioCentro : 15,
    circulos : 4,
    angulo : 100,
    distancia : 56,
    width : 16,
    alternaRotacion : true
  };

  function getUrlValues() {
    var hashKeyVals = [],
        i = 0,
        key = null,
        val = null;
    if(window.location.hash) {
      hashKeyVals = window.location.hash.substr(1).split('&');
      for(i in hashKeyVals) {
        key = hashKeyVals[i].split('=')[0];
        if(key === 'alternaRotacion') {
          val = (hashKeyVals[i].split('=')[1] === 'true');
        } else {
          val = parseInt(hashKeyVals[i].split('=')[1], 10);
        }
        if(typeof(options[key]) !== 'undefined') {
          options[key] = val;
        }
      }
    }
  }
  getUrlValues();

  var gui = new dat.GUI();
  gui.add(options, 'radioCentro', 0,100).step(1);
  gui.add(options, 'circulos', 1,10).step(1);
  gui.add(options, 'angulo', 0, 360).step(1);
  gui.add(options, 'distancia', 0, 200);
  gui.add(options, 'alternaRotacion');
  var folder = gui.addFolder('Cuadrado');
  folder.add(options, 'width', 0, 32).step(1);
  folder.open();

  function updateUrl() {
    var hashVals = [],
        hashVal = '',
        option = null;
    for(option in options) {
        hashVals.push(option + '=' + options[option]);
    }
    hashVal = hashVals.join('&');
    if(window.location.hash !== '#' + hashVal) {
        window.location.hash = hashVal;
    }
  }

  function render() {
    var center = {
      x : parseInt(canvas.width / 2, 10),
      y : parseInt(canvas.height / 2, 10)
    };
    var sprite = {
      width  : options.width,
      height : options.width
    };
    var spriteWidth = Math.sqrt(sprite.width * sprite.width + sprite.height * sprite.height);
    ctx.clearRect(0,0,canvas.width,canvas.height);
    ctx.lineWidth = 2;
    for (var i = 0; i < options.circulos; i++) {
      var radius = (i+1) * options.distancia;
      var circumference = 2 * Math.PI * (radius + options.radioCentro);
      var numSprites = parseInt(circumference / spriteWidth,10);
      if (numSprites % 2) numSprites--; // keep even for color purposes
      var ratio = (Math.PI * 2) / numSprites;
      for (var j = 0; j < numSprites ; j++) {
        ctx.save();
        ctx.translate(center.x, center.y);
        ctx.rotate((ratio * j));
        ctx.translate(radius + options.radioCentro,0);
        var rotation = options.angulo * (Math.PI / 180);
        ctx.rotate(options.alternaRotacion && i % 2 ? -rotation : rotation);
        ctx.strokeStyle = (j % 2) ? '#222222' : '#dddddd';
        ctx.strokeRect(-(sprite.width / 2),-(sprite.height / 2), sprite.width,sprite.height);
        ctx.stroke();
        ctx.restore();
      }

    }
    updateUrl();
  }

  (function animloop(){
    requestAnimFrame(animloop);
    render();
  })();

  function resize() {
    canvas.width = window.innerWidth;
    canvas.height = window.innerHeight;
  }
});
