class GouraudMaterial extends Material {
  constructor(gl, color=[1,1,1,1]) {
    let vertexShaderSource =
    `#version 300 es
    in vec4 a_position;
    in vec3 a_normal;

    uniform mat4 u_M_matrix;
    uniform mat4 u_VM_matrix;
    uniform mat4 u_PVM_matrix;
    uniform vec3 u_light_position;
    uniform vec4 u_color;

    out vec4 v_color;

    void main() {
      vec3 w_position = vec3( u_M_matrix * a_position );
      vec3 w_normal = vec3(u_M_matrix * vec4(a_normal, 0) );

      vec3 to_light = normalize( u_light_position - w_position );
      vec3 fragment_normal = normalize(w_normal);
      float cos_angle = max(dot(fragment_normal, to_light), 0.0);
      v_color = vec4(vec3(u_color) * cos_angle, u_color.a);

      gl_Position = u_PVM_matrix * a_position;
    }`;

    let fragmentShaderSource =
    `#version 300 es
    precision mediump float;

    in vec4 v_color;
    out vec4 pixelColor;

    void main() {
      pixelColor = v_color;
    }`;

    // Se llama al constructor de la clase Material
    super(gl, color, vertexShaderSource, fragmentShaderSource);
  }
}