/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descgui;

import com.mja.gui.mjaColor;
import com.mja.util.BasicStr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

class Tooltip
extends Window
implements MouseListener,
MouseMotionListener,
Runnable,
KeyListener {
    private Thread thr;
    private Component parentC;
    private Component C;
    private Point p;
    private String msg;
    private String moremsg;
    private TextField tf;
    private TextArea TA;
    private Font font;
    private volatile boolean pleaseStop;
    private volatile boolean moved;
    private volatile boolean mousexit;
    private boolean inC = false;
    private boolean inParent = false;

    Tooltip(Frame frame) {
        super(frame);
        this.setBackground(Color.black);
        this.setForeground(Color.gray);
        this.setLayout(new BorderLayout());
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    void reset(Component component, Component component2, Point point, String string, String string2, Font font) {
        this.close();
        this.removeAll();
        if (this.C != null) {
            this.C.removeMouseListener(this);
            this.C.removeMouseMotionListener(this);
        }
        if (this.parentC != null) {
            this.parentC.removeMouseListener(this);
            this.parentC.removeMouseMotionListener(this);
        }
        this.C = component2;
        this.parentC = component;
        this.p = point;
        this.msg = string;
        this.moremsg = string2;
        this.font = font;
        component2.addMouseListener(this);
        component2.addMouseMotionListener(this);
        component.addMouseListener(this);
        component.addMouseMotionListener(this);
        this.thr = new Thread(this);
        this.thr.start();
    }

    private void close() {
        this.pleaseStop = true;
        while (this.thr != null) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }

    void setEditor(TextField textField) {
        this.tf = textField;
    }

    private boolean pleaseStop() {
        return this.pleaseStop;
    }

    private boolean moved() {
        return this.moved;
    }

    private boolean mousexit() {
        return this.mousexit;
    }

    public void run() {
        int n;
        this.pleaseStop = false;
        for (n = 0; n < 25 && !this.pleaseStop(); ++n) {
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (!this.pleaseStop()) {
            this.moved = false;
            for (n = 0; n < 25 && !this.pleaseStop() && !this.moved(); ++n) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
        }
        if (!this.pleaseStop() && !this.moved()) {
            this.mousexit = false;
            Dimension dimension = new Dimension();
            String string = BasicStr.adjust(this.msg, 30, dimension, true, this.getFontMetrics(this.font));
            String[] stringArray = BasicStr.toStringArray(string, true);
            string = "";
            dimension.height = 0;
            boolean bl = false;
            for (n = 0; n < stringArray.length; ++n) {
                string = string + stringArray[n];
                if (stringArray[n].equals("\n")) {
                    ++dimension.height;
                    if (n + 1 < stringArray.length && (dimension.height > 6 || bl)) {
                        if (!bl) {
                            string = string + "\n";
                            ++dimension.height;
                        }
                        string = string + " ... " + this.moremsg + " ...";
                        break;
                    }
                    bl = true;
                    continue;
                }
                bl = false;
            }
            this.TA = new TextArea(string, dimension.height + 1, 31, 3);
            this.TA.addMouseListener(this);
            this.TA.addMouseMotionListener(this);
            this.TA.setFont(this.font);
            this.TA.setEditable(false);
            this.TA.setForeground(mjaColor.DeepBlue);
            this.TA.setBackground(Color.white);
            this.removeAll();
            this.add("Center", this.TA);
            this.pack();
            this.p.x = Math.min(this.p.x, this.parentC.getLocationOnScreen().x + this.parentC.getSize().width - this.getSize().width);
            this.p.y = Math.min(this.p.y + 16, this.parentC.getLocationOnScreen().y + this.parentC.getSize().height - this.getSize().height);
            this.setLocation(this.p.x, this.p.y);
            this.setVisible(true);
            if (this.mousexit()) {
                this.pleaseStop = false;
                this.moved = false;
                this.mousexit = false;
            }
            for (n = 0; n < 200 && !this.pleaseStop() && !this.moved(); ++n) {
                try {
                    Thread.sleep(20L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            }
            this.setVisible(false);
        }
        this.thr = null;
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.pleaseStop = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.pleaseStop = true;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.mousexit = true;
        this.pleaseStop = true;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.moved = true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.pleaseStop = true;
        if (this.tf != null) {
            int n = this.tf.getCaretPosition();
            String string = this.tf.getText();
            this.tf.setText(string.substring(0, n) + keyEvent.getKeyChar() + string.substring(n));
            this.tf.setCaretPosition(n + 1);
            this.tf.requestFocus();
        }
    }
}

