/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Curve;
import com.mja.descartes.Descartes;
import com.mja.descartes.Space;
import com.mja.descartes.mjaGraph;
import com.mja.descartes.spaceConfig;
import com.mja.file.mjaFont;
import com.mja.gui.mjaColor;
import com.mja.math.R2;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.Vector;

public class SpaceR2
extends Space {
    private Graphics2D[] tga;
    private Graphics2D[] fga;
    private boolean fillInFront;
    private R2 v = new R2();
    Vector GV;

    public SpaceR2(Descartes descartes, spaceConfig spaceConfig2) {
        super(descartes, spaceConfig2);
        descartes.p.Var(this.spcfg.prefix() + "_refresh_back_").setDouble(1.0);
    }

    public String toTeX(boolean bl) {
        int n;
        int n2;
        this.GV = new Vector();
        for (n2 = 0; n2 < this.D.scene.graph.length; ++n2) {
            if (this.D.scene.graph[n2] == null || this.D.scene.graph[n2].cs != this || !this.D.scene.graph[n2].gc.isInBack) continue;
            this.GV.addElement(this.D.scene.graph[n2]);
        }
        for (n2 = 0; n2 < this.D.scene.graph.length; ++n2) {
            if (this.D.scene.graph[n2] == null || this.D.scene.graph[n2].cs != this || this.D.scene.graph[n2].gc.isInBack) continue;
            this.GV.addElement(this.D.scene.graph[n2]);
        }
        Vector<Curve> vector = new Vector<Curve>();
        for (int i = 0; i < this.GV.size(); ++i) {
            mjaGraph mjaGraph2 = (mjaGraph)this.GV.elementAt(i);
            for (n = 0; n < mjaGraph2.lasCurvas.length; ++n) {
                vector.addElement(mjaGraph2.lasCurvas[n]);
            }
        }
        double d = this.Nesc.Evaluate(48.0);
        n = this.getWidth() / 2;
        int n3 = this.getHeight() / 2;
        double d2 = ((double)n + this.NOx.Evaluate(0.0)) / d;
        double d3 = ((double)n3 - this.NOy.Evaluate(0.0)) / d;
        String string = BasicStr.getTeX_Header(n, n3);
        string = string + BasicStr.getTeX_BeginDoc(d, n, n3, d2, d3);
        for (int i = 0; i < vector.size(); ++i) {
            string = string + ((Curve)vector.elementAt(i)).toTeX(this, this.getHeight(), bl);
        }
        string = string + "\r\n}\r\n\r\n\\end{pspicture}\r\n\r\n}\r\n\r\n\\end{document}\r\n";
        return string;
    }

    protected R2 injection(double d, double d2) {
        return this.injection(d, d2, false);
    }

    protected R2 injection(double d, double d2, boolean bl) {
        if (bl) {
            return new R2(d, d2);
        }
        return new R2((d - (double)this.Ox) / this.Nesc.getDouble(), ((double)this.Oy - d2) / this.Nesc.getDouble());
    }

    protected R2 projection(R2 r2, boolean bl) {
        double d = r2.x;
        double d2 = r2.y;
        if (!bl) {
            d = (double)this.Ox + this.Nesc.getDouble() * r2.x;
            d2 = (double)this.Oy - this.Nesc.getDouble() * r2.y;
        }
        return new R2(d, d2);
    }

    protected R2 projection(R2 r2) {
        return this.projection(r2, false);
    }

    protected void stopMoving() {
        this.v.x = 0.0;
        this.v.y = 0.0;
    }

    protected boolean isMoving() {
        return this.v.x != 0.0 || this.v.y != 0.0;
    }

    void doBack(boolean bl) {
        this.setVisible(this.visibilityN.Evaluate(1.0) > 0.0);
        if (this.isVisible()) {
            if (!this.started) {
                this.start();
            }
            boolean bl2 = this.backColor.variable() || this.backColor.getAdaptedColor().getAlpha() < 255;
            boolean bl3 = this.initializeGraphicStuff();
            if (bl3 || bl || this.main == null || bl2) {
                super.doBack(bl3 || bl);
                double d = this.Nesc.getDouble();
                int n = 0;
                while (d >= 10.0 && d > (double)(this.w + this.h)) {
                    d /= 10.0;
                    ++n;
                }
                while (d < (double)((this.w + this.h) / 10)) {
                    d *= 10.0;
                }
                if (this.spcfg.isOn[1]) {
                    this.gback.setColor(this.spcfg.DC[1].getAdaptedColor());
                    this.drawMarks(d / 10.0, -1);
                }
                if (this.spcfg.isOn[2]) {
                    this.gback.setColor(this.spcfg.DC[2].getAdaptedColor());
                    this.drawMarks(d, -1);
                }
                if (this.spcfg.isOn[3]) {
                    this.gback.setFont(mjaFont.AWTSansSerif);
                    this.gback.setColor(this.spcfg.DC[3].getAdaptedColor());
                    if (this.spcfg.x_On) {
                        this.gback.drawLine(0, this.Oy, this.w, this.Oy);
                    }
                    if (this.spcfg.y_On) {
                        this.gback.drawLine(this.Ox, 0, this.Ox, this.h);
                    }
                    if (this.spcfg.numbers) {
                        if (d > (double)((this.w + this.h) / 2)) {
                            this.drawNumbers(d / 5.0, d <= this.Nesc.getDouble() ? n + 1 : n);
                        } else if (d > (double)((this.w + this.h) / 4)) {
                            this.drawNumbers(d / 2.0, d <= this.Nesc.getDouble() ? n + 1 : n);
                        } else {
                            this.drawNumbers(d, n);
                        }
                    }
                    this.drawMarks(d, 3);
                    this.drawMarks(d /= 2.0, 2);
                    this.drawMarks(d /= 5.0, 1);
                    this.gback.setColor(this.spcfg.DC[3].getAdaptedColor());
                    int n2 = this.Ox - 2 - this.gback.getFontMetrics(this.gback.getFont()).stringWidth(this.spcfg.y_axis);
                    int n3 = this.gback.getFontMetrics(this.gback.getFont()).getAscent();
                    if (this.spcfg.y_On) {
                        this.gback.drawString(this.spcfg.y_axis, n2, n3);
                    }
                    n2 = this.w - 3 - this.gback.getFontMetrics(this.gback.getFont()).stringWidth(this.spcfg.x_axis);
                    n3 = this.Oy + n3;
                    if (this.spcfg.x_On) {
                        this.gback.drawString(this.spcfg.x_axis, n2, n3);
                    }
                }
                this.drawGraphsInBack();
            }
            if (this.fillInFront) {
                this.gmain.setColor(this.backColor.getAdaptedColor());
                this.gmain.fillRect(0, 0, this.w, this.h);
            }
        }
    }

    protected void doCalc() {
    }

    protected void doFront(boolean bl) {
        if (this.isVisible()) {
            this.prepareMainImage();
            this.fga[0] = this.gmain;
            this.adjustControls();
            this.drawGraphsInFront();
            this.drawBackControls();
            super.doFront(bl);
            this.gmain.setColor(new Color(0xCCBBAA));
        }
    }

    protected void writeCoordinates(Graphics graphics, int n, int n2) {
        if (this.isVisible() && this.spcfg.isOn[4]) {
            int n3;
            int n4;
            int n5;
            graphics.setFont(mjaFont.AWTMono);
            graphics.setColor(this.spcfg.DC[4].getAdaptedColor());
            graphics.drawOval(n - 2, n2 - 2, 4, 4);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            TFont tFont = new TFont(mjaFont.AWTMono);
            int n6 = 0;
            while (this.Nesc.getDouble() > Math.pow(10.0, n6)) {
                ++n6;
            }
            if (n6 > 0) {
                ++n6;
            }
            double d = (double)(n - this.Ox) / this.Nesc.getDouble();
            double d2 = (double)(this.Oy - n2) / this.Nesc.getDouble();
            String string = BasicStr.DoubleToString(d, n6, true, ".");
            String string2 = BasicStr.DoubleToString(d2, n6, true, ".");
            String string3 = "(" + string + "," + string2 + ")";
            int n7 = fontMetrics.stringWidth(string3);
            int n8 = n - n7 / 2;
            int n9 = n2 - 12;
            if (n8 < 0) {
                n8 = 0;
            }
            if (n8 > (n5 = this.w - n7)) {
                n8 = n5;
            }
            if (n9 < (n4 = tFont.getAscent())) {
                n9 = n4;
            }
            if (n9 > (n3 = this.h - tFont.getDescent())) {
                n9 = n3;
            }
            graphics.drawString(string3, n8, n9);
        }
    }

    protected boolean onDrag(boolean bl, int n, int n2) {
        this.D.updateNodesFromControls();
        if (bl) {
            double d = this.Nesc.getDouble();
            double d2 = ((double)this.h - (double)n2) / (double)this.h;
            this.Nesc.setDouble(this.Nesc.getDouble() * d2);
            this.correctScale();
            this.NOx.setDouble(this.NOx.getDouble() * (this.Nesc.getDouble() / d));
            this.NOy.setDouble(this.NOy.getDouble() * (this.Nesc.getDouble() / d));
            this.Ox = (int)Math.round(this.NOx.getDouble()) + this.w / 2;
            this.Oy = (int)Math.round(this.NOy.getDouble()) + this.h / 2;
        } else {
            this.v.x = n;
            this.v.y = n2;
            this.Ox = (int)((double)this.Ox + this.v.x);
            this.Oy = (int)((double)this.Oy + this.v.y);
            this.NOx.setDouble((double)this.Ox - (double)this.w / 2.0);
            this.NOy.setDouble((double)this.Oy - (double)this.h / 2.0);
            this.v.x = 0.0;
            this.v.y = 0.0;
        }
        this.D.updateTextFieldsFromNodes();
        return this.backColor.variable();
    }

    private double _X_(int n, double d, boolean bl) {
        double d2 = d;
        if (!bl) {
            d2 = (double)this.Ox + this.Nesc.getDouble() * d;
        }
        if (d2 < (double)(-n)) {
            d2 = -n;
        }
        if (d2 > (double)(this.w + n)) {
            d2 = this.w + n;
        }
        return d2;
    }

    int XX(int n, double d, boolean bl) {
        return (int)Math.round(this._X_(n, d, bl));
    }

    private double _Y_(int n, double d, boolean bl) {
        double d2 = d;
        if (!bl) {
            d2 = (double)this.Oy - this.Nesc.getDouble() * d;
        }
        if (d2 < (double)(-n)) {
            d2 = -n;
        }
        if (d2 > (double)(this.h + n)) {
            d2 = this.h + n;
        }
        return d2;
    }

    int YY(int n, double d, boolean bl) {
        return (int)Math.round(this._Y_(n, d, bl));
    }

    private boolean initializeGraphicStuff() {
        boolean bl = false;
        this.fillInFront = false;
        if (this.D.scene.graph != null) {
            for (int i = 0; i < this.D.scene.graph.length; ++i) {
                if (this.D.scene.graph[i] == null || this.D.scene.graph[i].gc.isInBack || this.D.scene.graph[i].gc.type != 43) continue;
                this.fillInFront = true;
                break;
            }
        }
        this.fga = new Graphics2D[1];
        this.fga[0] = this.gmain;
        this.tga = new Graphics2D[2];
        this.tga[0] = this.gback;
        this.tga[1] = this.gmain;
        bl = this.spaceChanged() | bl;
        return bl;
    }

    private void drawGraphsInBack() {
        for (int i = 0; i < this.D.scene.graph.length; ++i) {
            if (this.D.scene.graph[i] == null || this.D.scene.graph[i].cs != this || !this.D.scene.graph[i].gc.isInBack) continue;
            this.drawGraph(this.D.p, this.D.scene.graph[i]);
        }
    }

    private void drawGraphsInFront() {
        for (int i = 0; i < this.D.scene.graph.length; ++i) {
            if (this.D.scene.graph[i] == null || this.D.scene.graph[i].cs != this || this.D.scene.graph[i].gc.isInBack) continue;
            this.drawGraph(this.D.p, this.D.scene.graph[i]);
        }
    }

    protected void flushImages() {
        int n;
        for (n = 0; n < this.D.scene.graph.length; ++n) {
            if (this.D.scene.graph[n].ith == null) continue;
            this.D.scene.graph[n].ith.pleaseStop();
        }
        for (n = 0; n < this.D.scene.graph.length; ++n) {
            if (this.D.scene.graph[n].image == null) continue;
            this.D.scene.graph[n].flush();
        }
    }

    private void drawMarks(double d, int n) {
        int n2;
        int n3 = 0;
        int n4 = this.w;
        int n5 = 0;
        int n6 = this.h;
        if (n >= 0) {
            n3 = this.Ox - n;
            n4 = this.Ox + n;
            n5 = this.Oy - n;
            n6 = this.Oy + n;
        }
        if (this.spcfg.x_On && n > 0 || n < 0) {
            int n7;
            n2 = -((int)Math.round((double)this.Ox / d));
            while ((n7 = this.Ox + (int)Math.round((double)n2 * d)) < this.w) {
                this.gback.drawLine(n7, n5, n7, n6);
                ++n2;
            }
        }
        if (this.spcfg.y_On && n > 0 || n < 0) {
            int n8;
            n2 = -((int)Math.round((double)this.Oy / d));
            while ((n8 = this.Oy + (int)Math.round((double)n2 * d)) < this.h) {
                this.gback.drawLine(n3, n8, n4, n8);
                ++n2;
            }
        }
    }

    private void drawNumbers(double d, int n) {
        String string;
        double d2;
        int n2;
        if (this.spcfg.x_On) {
            int n3;
            n2 = -((int)Math.round((double)this.Ox / d));
            while ((n3 = this.Ox + (int)Math.round((double)n2 * d)) < this.w) {
                d2 = (double)n2 * d / this.Nesc.getDouble();
                string = BasicStr.DoubleToString(d2, 4, false);
                this.gback.drawString(string, n3 - (d2 < 0.0 ? 4 : 0), this.Oy - 5);
                ++n2;
            }
        }
        if (this.spcfg.y_On) {
            int n4;
            n2 = -((int)Math.round((double)this.Oy / d));
            while ((n4 = this.Oy + (int)Math.round((double)n2 * d)) < this.h) {
                d2 = -((double)n2) * d / this.Nesc.getDouble();
                string = BasicStr.DoubleToString(d2, 4, false);
                if (!"0".equals(string)) {
                    this.gback.drawString(string, this.Ox + 5, n4 + 2);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawGraph(Parser parser, mjaGraph mjaGraph2) {
        if (mjaGraph2.cs == this) {
            Node node = parser.Var("x");
            Node node2 = parser.Var("y");
            Node node3 = node;
            synchronized (node3) {
                Node node4 = node2;
                synchronized (node4) {
                    double d = node.getDouble();
                    double d2 = node2.getDouble();
                    if (mjaGraph2.sparz != null) {
                        Node node5;
                        int n = (int)Math.round(mjaGraph2.sparz.NN.Evaluate(32.0));
                        double d3 = mjaGraph2.sparz.Ni.Evaluate(0.0);
                        double d4 = mjaGraph2.sparz.Nf.Evaluate(1.0);
                        Node node6 = node5 = parser.Var(mjaGraph2.sparz.name);
                        synchronized (node6) {
                            double d5 = node5.getDouble();
                            if (n == 0) {
                                node5.setDouble(d3);
                                mjaGraph2.createLasCurvas(1);
                                this.drawGraph(mjaGraph2, 0);
                            } else if (n > 0) {
                                mjaGraph2.createLasCurvas(n + 1);
                                for (int i = 0; i <= n; ++i) {
                                    node5.setDouble(d3 + (d4 - d3) * (double)i / (double)n);
                                    this.drawGraph(mjaGraph2, i);
                                }
                            }
                            node5.setDouble(d5);
                        }
                    } else {
                        mjaGraph2.createLasCurvas(1);
                        this.drawGraph(mjaGraph2, 0);
                    }
                    node.setDouble(d);
                    node2.setDouble(d2);
                }
            }
        }
    }

    private void drawGraph(mjaGraph mjaGraph2, int n) {
        if (mjaGraph2.cs == this) {
            if (mjaGraph2.gc.isInBack) {
                mjaColor[] mjaColorArray = new mjaColor[1];
                for (int i = 0; i < 1; ++i) {
                    mjaColorArray[i] = mjaGraph2.gc.gcolor;
                }
                if (this.back != null) {
                    Graphics[] graphicsArray = new Graphics[]{this.back.getGraphics()};
                    mjaGraph2.draw(this.back, graphicsArray, mjaColorArray, n);
                }
            } else if (mjaGraph2.gc.hasTrace) {
                mjaColor[] mjaColorArray = new mjaColor[this.tga.length];
                for (int i = 0; i < this.tga.length; ++i) {
                    mjaColorArray[i] = i == 0 ? mjaGraph2.gc.traceColor : mjaGraph2.gc.gcolor;
                }
                mjaGraph2.draw(this.main, this.tga, mjaColorArray, n);
            } else {
                mjaColor[] mjaColorArray = new mjaColor[this.fga.length];
                for (int i = 0; i < this.fga.length; ++i) {
                    mjaColorArray[i] = mjaGraph2.gc.gcolor;
                }
                mjaGraph2.draw(this.main, this.fga, mjaColorArray, n);
            }
        }
    }
}

