/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.file.mjaFont;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.Formula;
import com.mja.text.TColors;
import com.mja.text.TNode;
import com.mja.util.BasicStr;
import com.mja.util.LiveOrDie;
import com.mja.util.TFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.Vector;

public class BasicText
implements ClipboardOwner {
    protected Vector info;
    private TFont font;
    private TColors colors = new TColors(Color.white, Color.black);
    public Parser parser;
    private int initialTNodes;
    private int finalTNodes;
    private int segBegin;
    private int segEnd;
    private boolean segMarked = false;
    public static Vector textBuffer;
    private int cursorPos;
    private static boolean localcopy;

    public BasicText(Parser parser) {
        this(parser, null, null, null);
    }

    public BasicText(Parser parser, TFont tFont) {
        this(parser, tFont, null, null);
    }

    public BasicText(Parser parser, TFont tFont, Color color, Color color2) {
        this.parser = parser;
        this.colors = new TColors(color, color2);
        this.font = tFont != null ? tFont : new TFont(mjaFont.makeFont("Serif", 0, 24));
        this.info = new Vector();
        this.cursorPos = this.initialTNodes = 0;
        this.info.addElement(new TNode(this, "\u001a"));
        this.finalTNodes = 1;
    }

    public void println() {
        for (int i = 0; i < this.info.size(); ++i) {
            System.out.print(i + " " + this.TNode(i).toExpresion(true) + ";");
        }
        System.out.println("");
    }

    public void setParser(Parser parser) {
        this.parser = parser;
        for (int i = 0; i < this.info.size(); ++i) {
            TNode tNode = (TNode)this.info.elementAt(i);
            tNode.setParser(parser);
        }
    }

    Parser getParser() {
        return this.parser;
    }

    public String toString() {
        String string = super.toString() + "\n";
        for (int i = 0; i < this.info.size(); ++i) {
            TNode tNode = (TNode)this.info.elementAt(i);
            string = string + tNode.toString();
        }
        return string;
    }

    void setInfo(Vector vector) {
        this.info = vector;
    }

    Vector getInfo() {
        return this.info;
    }

    Font getFont() {
        return this.font.getMjaFont().getAwtFont();
    }

    public TFont getTFont() {
        return this.font;
    }

    public void setTFont(TFont tFont) {
        this.font = tFont;
    }

    public TColors getColors() {
        return this.colors;
    }

    public void setColors(Color color, Color color2) {
        this.colors = new TColors(color, color2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TNode TNode(int n) {
        Vector vector = this.info;
        synchronized (vector) {
            if (n < this.info.size()) {
                return (TNode)this.info.elementAt(n);
            }
            new Exception("info.size()=" + this.info.size() + " <= " + n).printStackTrace();
            return null;
        }
    }

    public String getTeXColors(boolean bl) {
        String string = "";
        int n = 0;
        for (int i = 0; i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isColors()) continue;
            TColors tColors = tNode.getColors();
            Color color = tColors.getTextColor();
            String string2 = "tcolor" + BasicStr.justify("" + n, -3, '0');
            ++n;
            string = string + BasicStr.DefineColor(bl, string2, color);
        }
        return string;
    }

    public int getCursorPos() {
        return this.cursorPos;
    }

    public void setCursorPos(int n) {
        this.cursorPos = Math.min(n, this.info.size() - 1);
    }

    public int indexOf(TNode tNode) {
        for (int i = this.begin(); i < this.end(); ++i) {
            if (tNode != (TNode)this.info.elementAt(i)) continue;
            return i;
        }
        return this.begin();
    }

    public void setCursorPos(TNode tNode) {
        this.setCursorPos(this.indexOf(tNode));
    }

    public int begin() {
        return this.initialTNodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int end() {
        Vector vector = this.info;
        synchronized (vector) {
            return this.info.size() - this.finalTNodes;
        }
    }

    public int infoSize() {
        return this.info.size();
    }

    public int segBegin() {
        return this.segBegin;
    }

    public int segEnd() {
        return this.segEnd;
    }

    private void setSegment(int n, int n2) {
        int n3 = Math.min(n, n2);
        int n4 = Math.max(n, n2);
        while (n4 - 1 >= this.begin() && !this.TNode(n4 - 1).isChar()) {
            --n4;
        }
        if (n == n3) {
            this.segBegin = n;
            this.segEnd = n4;
        } else {
            this.segBegin = n4;
            this.segEnd = n2;
        }
    }

    public boolean segMarked() {
        return this.segMarked;
    }

    public void markSegment(int n, int n2) {
        this.setSegment(n, n2);
        this.segMarked = n != n2;
    }

    public void updateMarkedSegment() {
        this.setSegment(this.segBegin, this.cursorPos);
    }

    public void unmarkSegment() {
        this.segMarked = false;
    }

    public int segMin() {
        return Math.min(this.segBegin, this.segEnd);
    }

    public int segMax() {
        return Math.max(this.segBegin, this.segEnd);
    }

    public int firstLine() {
        return this.firstChar(this.initialTNodes);
    }

    public int firstChar(int n) {
        int n2;
        for (n2 = n; n2 < this.end() && !this.TNode(n2).isChar(); ++n2) {
        }
        if (n2 == this.end()) {
            return n;
        }
        return n2;
    }

    public int firstFormula(int n) {
        int n2;
        for (n2 = n; n2 < this.end() && !this.TNode(n2).isFormula(); ++n2) {
        }
        if (n2 == this.end()) {
            return -1;
        }
        return n2;
    }

    public boolean afterLastChar(int n) {
        if (this.TNode(n).isChar()) {
            return n == this.end();
        }
        for (int i = n + 1; i < this.end(); ++i) {
            if (!this.TNode(i).isChar()) continue;
            return false;
        }
        return true;
    }

    public int startOfLine(int n) {
        int n2;
        for (n2 = n; n2 > this.initialTNodes && this.TNode(n2 - 1) != null && !this.TNode(n2 - 1).isEndOfLine(); --n2) {
        }
        return this.firstChar(n2);
    }

    public int endOfLine(int n) {
        int n2;
        for (n2 = n; n2 < this.end() && !this.TNode(n2).isEndOfLine(); ++n2) {
        }
        return n2;
    }

    public int nextChar(int n) {
        int n2 = this.firstChar(n);
        if (n2 < this.end()) {
            ++n2;
        }
        return this.firstChar(n2);
    }

    public int prevChar(int n) {
        int n2 = n;
        if (n2 > this.initialTNodes) {
            --n2;
        }
        while (n2 > this.initialTNodes && !this.TNode(n2).isChar()) {
            --n2;
        }
        return this.firstChar(n2);
    }

    public int nextLine(int n) {
        return this.firstChar(this.startOfLine(this.endOfLine(Math.min(this.end(), this.endOfLine(n) + 1))));
    }

    public int previousLine(int n) {
        return this.firstChar(this.startOfLine(Math.max(this.begin(), this.prevChar(this.startOfLine(n)))));
    }

    public void insertString(String string) {
        String string2 = new String(string);
        if (BasicStr.classExists("com.mja.parser.Node") && Node.inAlgebraTutor) {
            string2 = BasicStr.replace(string2, "eqn", "#");
            string2 = BasicStr.replace(string2, "eqa", "@");
            string2 = BasicStr.replace(string2, "eqx", "~");
        }
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            if (c == '\r') continue;
            this.insertChar(c);
        }
    }

    void insertChar(char c) {
        this.insertText(new Character(c).toString());
    }

    void insertText(String string) {
        this.insert(new TNode(this, string), this.cursorPos);
    }

    boolean delete() {
        int n = this.firstChar(this.cursorPos);
        if (n < this.end()) {
            return this.removeNode(n);
        }
        return false;
    }

    boolean backSpace() {
        int n = this.prevChar(this.firstChar(this.cursorPos));
        if (n != this.cursorPos && n < this.end()) {
            return this.removeNode(n);
        }
        return false;
    }

    void removeMarkedSegment() {
        if (this.segMarked) {
            this.remove(this.segMin(), this.segMax());
            this.segMarked = false;
        }
    }

    public void clean() {
        int n;
        Object object = this.getTFont();
        Object object2 = this.getColors();
        int n2 = n = this.begin();
        while (n < this.end()) {
            Object object3;
            TNode tNode = this.TNode(n);
            if (tNode.isColors()) {
                object3 = tNode.getColors();
                if (((TColors)object3).equals((TColors)object2)) {
                    this.removeNode(n);
                } else {
                    object2 = object3;
                }
            } else if (tNode.isTFont()) {
                object3 = tNode.getTFont();
                if (object3.equals(object)) {
                    this.removeNode(n);
                } else {
                    object = object3;
                }
            } else {
                tNode.clean();
            }
            if (this.TNode(n) != tNode) continue;
            ++n;
        }
        boolean bl = true;
        boolean bl2 = true;
        for (n = this.end(); n >= this.begin(); --n) {
            TNode tNode = this.TNode(n);
            if (tNode.isColors()) {
                if (!bl2) {
                    this.removeNode(n);
                }
                bl2 = false;
                continue;
            }
            if (tNode.isTFont()) {
                if (!bl) {
                    this.removeNode(n);
                }
                bl = false;
                continue;
            }
            if (!tNode.isChar()) continue;
            bl = true;
            bl2 = true;
        }
    }

    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        localcopy = false;
    }

    public void copy(Component component) {
        textBuffer = new Vector();
        int n = this.segMin();
        int n2 = this.segMax();
        textBuffer.addElement(new TNode(this, this.getColorsAtTNode(n)));
        textBuffer.addElement(new TNode(this, this.getTFontAtTNode(n)));
        localcopy = false;
        String string = "";
        for (int i = n; i < n2; ++i) {
            localcopy = true;
            textBuffer.addElement(this.TNode(i).cloneTNode(this));
            if (this.TNode(i).isPureChar()) {
                string = string + this.TNode(i).getChar();
            } else if (this.TNode(i).isFormula()) {
                string = string + this.TNode(i).toExpresion(true);
            }
            try {
                Clipboard clipboard = component.getToolkit().getSystemClipboard();
                StringSelection stringSelection = new StringSelection(string);
                clipboard.setContents(stringSelection, this);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paste(Component component) {
        if (localcopy) {
            if (textBuffer != null) {
                int n = this.getCursorPos();
                TColors tColors = this.getColorsAtTNode(this.getCursorPos());
                TFont tFont = this.getTFontAtTNode(this.getCursorPos());
                for (int i = 0; i < textBuffer.size(); ++i) {
                    this.insert(((TNode)textBuffer.elementAt(i)).cloneTNode(this), this.getCursorPos());
                }
                this.insert(new TNode(this, tColors), this.getCursorPos());
                this.insert(new TNode(this, tFont), this.getCursorPos());
            }
        } else {
            String string = "";
            try {
                Clipboard clipboard = component.getToolkit().getSystemClipboard();
                Transferable transferable = clipboard.getContents(this);
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                if (BasicStr.hasContent(string)) {
                    textBuffer = new Vector();
                    this.insertString(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BasicText getTextBuffer() {
        BasicText basicText = new BasicText(this.parser, this.font, this.colors.getBackColor(), this.colors.getTextColor());
        for (int i = 0; i < textBuffer.size(); ++i) {
            basicText.insert(((TNode)textBuffer.elementAt(i)).cloneTNode(this), basicText.cursorPos);
        }
        return basicText;
    }

    private boolean charInSeg(int n) {
        return this.segMarked && this.segMin() <= n && n < this.segMax();
    }

    protected Vector cloneInfo() {
        Vector<TNode> vector = new Vector<TNode>();
        for (int i = 0; i < this.info.size(); ++i) {
            vector.addElement(((TNode)this.info.elementAt(i)).cloneTNode(this));
        }
        return vector;
    }

    protected void insert(TNode tNode, int n) {
        if (tNode != null) {
            this.info.insertElementAt(tNode, n);
            if (tNode.isComponent()) {
                if (((LiveOrDie)((Object)tNode.getComponent())).isUsed()) {
                    String string = Long.toString(System.currentTimeMillis(), 16);
                    tNode.setNewComponent(((LiveOrDie)((Object)tNode.getComponent())).cloneComponent(string), string);
                } else {
                    ((LiveOrDie)((Object)tNode.getComponent())).setIsUsed(true);
                }
            }
            tNode.setParser(this.parser);
            if (n <= this.cursorPos) {
                ++this.cursorPos;
            }
            if (n <= this.segBegin) {
                ++this.segBegin;
            }
            if (n <= this.segEnd) {
                ++this.segEnd;
            }
        } else {
            new Exception("null TNode").printStackTrace();
        }
    }

    protected boolean removeNode(int n) {
        if (n >= this.begin() && n <= this.end()) {
            TNode tNode = (TNode)this.info.elementAt(n);
            tNode.removeFI();
            if (tNode.isComponent()) {
                ((LiveOrDie)((Object)tNode.getComponent())).setIsUsed(false);
            }
            this.info.removeElementAt(n);
            if (n < this.cursorPos) {
                --this.cursorPos;
            }
            if (n < this.segBegin) {
                --this.segBegin;
            }
            if (n < this.segEnd) {
                --this.segEnd;
            }
            return true;
        }
        return false;
    }

    public void remove(int n, int n2) {
        int n3;
        boolean bl = false;
        int n4 = Math.min(n, n2);
        if (n4 < (n3 = Math.max(n, n2))) {
            for (int i = n3 - 1; i >= n4; --i) {
                bl |= this.removeNode(i);
            }
        }
    }

    public TColors getColorsAtTNode(int n) {
        return this.getColorsAtTNode(n, true);
    }

    public TColors getColorsAtTNode(int n, boolean bl) {
        for (int i = n - 1; i >= 0; --i) {
            if (!this.TNode(i).isColors()) continue;
            return this.TNode(i).getColors();
        }
        if (bl) {
            return this.getColors();
        }
        return null;
    }

    public TFont getTFontAtTNode(int n) {
        if (this instanceof Formula) {
            return this.font;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (!this.TNode(i).isTFont()) continue;
            return this.TNode(i).getTFont();
        }
        return this.getTFont();
    }

    public void calcValues(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        for (int i = this.begin(); i < this.end(); ++i) {
            if (!this.TNode(i).isFormula()) continue;
            this.TNode(i).getFI().getFormula(0).calcValues(n, bl, n2, bl2, bl3);
        }
    }

    public int getLineAscentAtTNode(Component component, int n) {
        int n2 = this.startOfLine(n);
        TFont tFont = this.getTFontAtTNode(n2);
        int n3 = tFont.getAscent();
        while (this.TNode(n2) != null && !this.TNode(n2).isEndOfLine()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                int n4 = n3;
                n3 = Math.max(n3, tNode.getAscent(tFont));
            } else if (tNode.isTFont()) {
                tFont = tNode.getTFont();
            }
            ++n2;
        }
        return n3;
    }

    public int getLineDescentAtTNode(Component component, int n) {
        int n2 = this.startOfLine(n);
        TFont tFont = this.getTFontAtTNode(n2);
        int n3 = tFont.getDescent();
        while (!this.TNode(n2).isEndOfLine()) {
            TNode tNode = this.TNode(n2);
            if (tNode.isChar()) {
                n3 = Math.max(n3, tNode.getDescent(tFont));
            } else if (tNode.isTFont()) {
                tFont = tNode.getTFont();
            }
            ++n2;
        }
        return n3;
    }

    public int getLineHeightAtTNode(Component component, int n) {
        int n2 = this.getLineAscentAtTNode(component, n);
        int n3 = this.getLineDescentAtTNode(component, n);
        return n2 + n3 + 1;
    }

    public int getCharWidthAtTNode(Component component, int n, boolean bl) {
        TNode tNode = this.TNode(n);
        if (tNode.isChar()) {
            return tNode.getCharWidth(this.getTFontAtTNode(n), component, bl);
        }
        return 0;
    }

    public int getCharVisualLimitAtTNode(Component component, int n, boolean bl) {
        return this.getCharVisualLimitAtTNode(component, n, bl, false);
    }

    public int getCharVisualLimitAtTNode(Component component, int n, boolean bl, boolean bl2) {
        TNode tNode = this.TNode(n);
        if (tNode.isChar()) {
            TFont tFont = this.getTFontAtTNode(n);
            int n2 = tNode.getCharWidth(tFont, component, bl);
            if (tNode.isFormula()) {
                return n2 - (int)Math.round(1.0 * (double)tFont.getMjaFont().stringWidth(component, "a") / 3.0);
            }
            if (bl2) {
                return Math.round(n2);
            }
            return (int)Math.round(2.0 * (double)n2 / 3.0);
        }
        return 0;
    }

    public static Color bestBG(Color color) {
        if (color.getRed() + color.getGreen() + color.getBlue() < 382) {
            return Color.white;
        }
        return Color.black;
    }

    public static Color bestFG(Color color) {
        if (color.getRed() + color.getGreen() + color.getBlue() < 382) {
            return Color.black;
        }
        return Color.white;
    }

    static {
        localcopy = false;
    }
}

