/*
 * Decompiled with CFR 0.152.
 */
package com.mja.descartes;

import com.mja.descartes.Arquimedes;
import com.mja.descartes.Descartes;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;

class DescartesWindow
extends Window
implements WindowListener {
    private static Frame father = new Frame();
    private Descartes D;
    private Dimension dim;
    private Dimension ScrSz;
    private Point p;

    DescartesWindow(Descartes descartes, Dimension dimension) {
        super(father);
        this.D = descartes;
        this.dim = dimension;
        this.setBackground(Descartes.basicBlue);
        this.addWindowListener(this);
        this.setLayout(new GridLayout(1, 1));
        this.add(descartes.mainP);
        this.pack();
        this.ScrSz = Toolkit.getDefaultToolkit().getScreenSize();
        this.p = new Point((this.ScrSz.width - dimension.width) / 2, (this.ScrSz.height - dimension.height) / 2);
        this.p.x = this.p.x < 0 ? 0 : this.p.x;
        this.p.y = this.p.y < 0 ? 0 : this.p.y;
        this.setBounds(this.p.x, this.p.y, dimension.width, dimension.height);
        descartes.setSize(dimension);
        descartes.mainP.setSize(dimension);
        if (descartes instanceof Arquimedes) {
            this.setLocation((this.ScrSz.width - dimension.width) / 2, (this.ScrSz.height - Math.min(565, dimension.height)) / 2);
        }
        this.show();
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
        this.D.closeScene();
        this.D.destroy();
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        this.paintAll(this.getGraphics());
        int n = this.D.mainP.getSize().width - this.dim.width;
        int n2 = this.D.mainP.getSize().height - this.dim.height;
        if (n != 0 || n2 != 0) {
            this.setSize(this.getSize().width - n, this.getSize().height - n2);
        }
        this.D.setSize(this.dim);
        this.D.mainP.setSize(this.dim);
        this.D.start();
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }
}

