/*
 * Decompiled with CFR 0.152.
 */
package com.mja.textedit;

import com.mja.cmp.mjaButton;
import com.mja.file.mjaFont;
import com.mja.gui.Explainer;
import com.mja.gui.MouseCursorHandler;
import com.mja.gui.editDialog;
import com.mja.lang.Expl;
import com.mja.lang.translator;
import com.mja.textedit.UnicodePair;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JScrollBar;

public class UnicodeSelector
extends editDialog
implements ActionListener,
ItemListener,
AdjustmentListener,
ComponentListener,
Runnable,
Explainer {
    private static UnicodeSelector us;
    private List l_base1;
    private Choice ch_base2;
    private Label lb;
    private mjaButton[] b;
    private int base;
    private JScrollBar sb;
    private Vector listeners;
    private translator Tr;
    private MouseCursorHandler mch;
    private static final int limsup = 9728;
    private String charSelected = "";
    static UnicodePair[] up;
    private mjaFont mf;
    private boolean firsttime = true;

    public static String getUnicodeChar(Frame frame, translator translator2) {
        if (us == null) {
            us = new UnicodeSelector(frame, translator2);
            us.pack();
            us.setSize(640, 360);
        }
        us.display(false, true);
        String string = UnicodeSelector.us.charSelected;
        return string;
    }

    public UnicodeSelector(Frame frame, translator translator2) {
        super(frame, translator2.getTr(256), false, translator2.getTr(83), null);
        mjaFont.finishLoadingMathFont();
        this.setModal(true);
        this.Tr = translator2;
        if (up == null) {
            up = new UnicodePair[16];
            UnicodeSelector.up[0] = new UnicodePair(translator2.getTr(240), 32, 126);
            UnicodeSelector.up[1] = new UnicodePair(translator2.getTr(241), 160, 255);
            UnicodeSelector.up[2] = new UnicodePair(translator2.getTr(242), 256, 383);
            UnicodeSelector.up[3] = new UnicodePair(translator2.getTr(243), 384, 591);
            UnicodeSelector.up[4] = new UnicodePair(translator2.getTr(244), 880, 975);
            UnicodeSelector.up[5] = new UnicodePair(translator2.getTr(245), 1024, 1279);
            UnicodeSelector.up[6] = new UnicodePair(translator2.getTr(246), 1488, 1514);
            UnicodeSelector.up[7] = new UnicodePair(translator2.getTr(247), 1536, 1791);
            UnicodeSelector.up[8] = new UnicodePair(translator2.getTr(248), 8192, 8303);
            UnicodeSelector.up[9] = new UnicodePair(translator2.getTr(249), 8352, 8399);
            UnicodeSelector.up[10] = new UnicodePair(translator2.getTr(250), 8448, 8527);
            UnicodeSelector.up[11] = new UnicodePair(translator2.getTr(251), 8528, 8591);
            UnicodeSelector.up[12] = new UnicodePair(translator2.getTr(252), 8704, 8959);
            UnicodeSelector.up[13] = new UnicodePair(translator2.getTr(253), 9472, 9599);
            UnicodeSelector.up[14] = new UnicodePair(translator2.getTr(254), 9600, 9727);
            UnicodeSelector.up[15] = new UnicodePair(translator2.getTr(255), 9728, 9983);
        }
        this.mch = new MouseCursorHandler(this, this);
        this.mch.handEnabled = false;
        this.listeners = new Vector();
        Panel panel = new Panel();
        this.add("Center", panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new BorderLayout(5, 1));
        this.lb = new Label("UNICODE");
        this.lb.setAlignment(1);
        this.lb.addMouseListener(this.mch);
        panel2.add("North", this.lb);
        this.l_base1 = new List();
        panel2.add("Center", this.l_base1);
        for (int i = 0; i < up.length; ++i) {
            this.l_base1.add(UnicodeSelector.up[i].description);
        }
        this.l_base1.addMouseListener(this.mch);
        Panel panel3 = new Panel();
        panel3.setLayout(new GridLayout(2, 1));
        panel2.add("South", panel3);
        this.ch_base2 = new Choice();
        panel3.add(this.ch_base2);
        for (int i = 0; i <= 9728; i += 16) {
            this.ch_base2.addItem(Integer.toString(i, 16));
        }
        this.ch_base2.addMouseListener(this.mch);
        this.l_base1.select(0);
        this.ch_base2.select(Integer.toString(UnicodeSelector.up[this.l_base1.getSelectedIndex()].start, 16));
        Panel panel4 = new Panel();
        panel4.setLayout(new GridLayout(8, 16));
        this.b = new mjaButton[128];
        this.mf = new mjaFont("SansSerif", 0, 16);
        this.setFont(this.mf.getAwtFont());
        for (int i = 0; i < this.b.length; ++i) {
            this.b[i] = new mjaButton();
            panel4.add(this.b[i]);
            this.b[i].setFont(this.mf.getAwtFont());
            this.b[i].setBackground(new Color(0xEEF8FF));
            this.b[i].addActionListener(this);
            this.b[i].addMouseListener(this.mch);
        }
        panel.setLayout(new BorderLayout());
        panel.add("West", panel2);
        panel.add("Center", panel4);
        this.sb = new JScrollBar(1, 2, 16, 0, 624);
        panel.add("East", this.sb);
        this.addComponentListener(this);
    }

    int indexOf(int n) {
        for (int i = 0; i < up.length - 1; ++i) {
            if (n * 16 >= UnicodeSelector.up[i + 1].start) continue;
            return i;
        }
        return up.length - 1;
    }

    void updateButtons() {
        try {
            this.base = Integer.parseInt(this.ch_base2.getSelectedItem(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            this.base = 0;
        }
        for (int i = 0; i < this.b.length; ++i) {
            int n = this.base + i;
            if (8501 <= n && n < 8847) {
                this.b[i].setFont(this.mf.getMathFont());
            } else {
                this.b[i].setFont(this.mf.getAwtFont());
            }
            String string = new Character((char)n).toString();
            this.b[i].setLabel(string, false);
            this.b[i].invalidate();
            this.b[i].repaint();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.b.length; ++i) {
            if (actionEvent.getSource() != this.b[i]) continue;
            this.charSelected = this.b[i].getLabel();
            this.setVisible(false);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.mch.isHand()) {
            if (itemEvent.getSource() == this.l_base1) {
                this.ch_base2.select(Integer.toString(UnicodeSelector.up[this.l_base1.getSelectedIndex()].start, 16));
                this.sb.setValue(this.ch_base2.getSelectedIndex());
                this.updateButtons();
            } else if (itemEvent.getSource() == this.ch_base2) {
                this.sb.setValue(this.ch_base2.getSelectedIndex());
                this.l_base1.select(this.indexOf(this.ch_base2.getSelectedIndex()));
                this.updateButtons();
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.mch.isHand() && adjustmentEvent.getSource() == this.sb) {
            this.ch_base2.select(this.sb.getValue());
            this.l_base1.select(this.indexOf(this.ch_base2.getSelectedIndex()));
            this.updateButtons();
        }
    }

    public String getExplLabel(MouseEvent mouseEvent) {
        Choice choice;
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof Label) {
            Label label = (Label)component;
            return label.getText();
        }
        if (component instanceof Button) {
            Button button = (Button)component;
            return button.getLabel();
        }
        if (component instanceof List) {
            List list = (List)component;
            if (list == this.l_base1) {
                return this.Tr.getTr(256);
            }
        } else if (component instanceof Choice && (choice = (Choice)component) == this.ch_base2) {
            return this.Tr.getTr(257);
        }
        return "";
    }

    public String getExplanation(MouseEvent mouseEvent) {
        Choice choice;
        String[] stringArray = null;
        Component component = (Component)mouseEvent.getSource();
        if (component instanceof Label) {
            Label label = (Label)component;
            if (label == this.lb) {
                stringArray = Expl.SymbolsTable[0];
            }
        } else if (component instanceof Button) {
            Button button = (Button)component;
            stringArray = Expl.SymbolsTable[2];
        } else if (component instanceof List) {
            List list = (List)component;
            if (list == this.l_base1) {
                stringArray = Expl.SymbolsTable[3];
            }
        } else if (component instanceof Choice && (choice = (Choice)component) == this.ch_base2) {
            stringArray = Expl.SymbolsTable[4];
        }
        return Expl.get(stringArray, this.Tr.getActiveLanguage());
    }

    public void run() {
        try {
            Thread.sleep(500L);
            this.updateButtons();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        Thread thread = new Thread(this);
        thread.start();
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
        if (this.firsttime) {
            this.sb.addAdjustmentListener(this);
            this.l_base1.addItemListener(this);
            this.ch_base2.addItemListener(this);
            this.firsttime = false;
        }
        Thread thread = new Thread(this);
        thread.start();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    static {
        up = null;
    }
}

