/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.algebra.ANode;
import com.mja.algebra.TreeNodeConfig;
import com.mja.parser.Node;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;

class TreeNode {
    static Color nodeColor = new Color(255, 255, 34, 192);
    static Color lineColor = new Color(192, 192, 192, 128);
    Node N;
    String symbol;
    TreeNodeConfig tn_cfg;
    TreeNode L;
    TreeNode R;
    TreeNode parent;
    int x0;
    int y0;
    int lx;
    int ly;
    int sw;
    int A;
    int D;
    int a;
    int b;
    int sign;
    boolean isArtificialEndNode = false;
    int max_y = 0;

    TreeNode(FontMetrics fontMetrics, TreeNodeConfig treeNodeConfig, Node node, int n, int n2, int n3, int n4) {
        this.tn_cfg = treeNodeConfig;
        this.N = node;
        this.symbol = ANode.getPrettySymbol(node.getSymbol());
        this.x0 = n;
        this.y0 = n2;
        this.lx = n3;
        this.ly = n4;
        treeNodeConfig.negativeNumbersAsNumbers = true;
        treeNodeConfig.fractionsAsNumbers = false;
        if (treeNodeConfig.fractionsAsNumbers && this.isIntegerFraction(node)) {
            this.isArtificialEndNode = true;
            this.symbol = node.getLeft().getSymbol() + "/" + node.getRight()[0].getSymbol();
        }
        if (treeNodeConfig.negativeNumbersAsNumbers && this.isNegativeNumber(node)) {
            this.isArtificialEndNode = true;
            this.symbol = "-" + node.getRight()[0].getSymbol();
        }
        this.sw = fontMetrics.stringWidth(this.symbol);
        this.D = fontMetrics.getDescent();
        this.A = fontMetrics.getAscent();
        this.b = (this.A + this.D) / 2 + this.sw / 16;
        this.a = Math.max(this.sw / 2 + this.sw / 16 + 8, this.b);
        this.max_y = Math.max(this.max_y, n2 + this.b + 1);
        if (this.isArtificialEndNode) {
            return;
        }
        if (node.getLeft() != null) {
            this.L = new TreeNode(fontMetrics, treeNodeConfig, node.getLeft(), n - n3, n2 + n4, n3 / 2, n4);
            this.max_y = Math.max(this.max_y, this.L.max_y);
            this.L.sign = -1;
            this.L.parent = this;
        }
        if (node.getRight() != null && node.getRight().length > 0 && node.getRight()[0] != null) {
            this.R = new TreeNode(fontMetrics, treeNodeConfig, node.getRight()[0], n + n3, n2 + n4, n3 / 2, n4);
            this.max_y = Math.max(this.max_y, this.R.max_y);
            this.R.sign = 1;
            this.R.parent = this;
        }
    }

    boolean isIntegerFraction(Node node) {
        return node.getSymb() == 21 && node.getLeft().isInteger() && node.getLeft().isInteger();
    }

    boolean isNegativeNumber(Node node) {
        return node.getSymb() == 18 && node.getType() == 13 && node.getRight()[0].isPositiveNumber();
    }

    Node getNodeAt(int n, int n2) {
        Node node;
        if ((n - this.x0) * (n - this.x0) / (this.a * this.a) + (n2 - this.y0) * (n2 - this.y0) / (this.b * this.b) <= 1) {
            return this.N;
        }
        if (this.L != null && (node = this.L.getNodeAt(n, n2)) != null) {
            return node;
        }
        if (this.R != null && (node = this.R.getNodeAt(n, n2)) != null) {
            return node;
        }
        return null;
    }

    void draw(Graphics graphics, Node node, double d) {
        Color color = nodeColor;
        Color color2 = Color.black;
        double d2 = 1.0;
        int n = this.x0;
        int n2 = this.y0;
        if (this.N == node || node != null && node.contains(this.N)) {
            color = new Color(255, 102, 51, 192);
            color2 = Color.black;
            d2 = d;
        }
        if (this.parent != null && this.N != node) {
            n = this.parent.x0 + (int)Math.round((double)this.sign * d2 * (double)this.parent.lx);
            n2 = this.parent.y0 + (int)Math.round(d2 * (double)this.parent.ly);
        }
        if (!this.isArtificialEndNode) {
            if (this.R != null) {
                graphics.setColor(lineColor);
                graphics.drawLine(this.x0, this.y0, this.x0 + (int)((double)this.lx * d2), this.y0 + (int)((double)this.ly * d2));
            }
            if (this.L != null) {
                graphics.setColor(lineColor);
                graphics.drawLine(this.x0, this.y0, this.x0 - (int)((double)this.lx * d2), this.y0 + (int)((double)this.ly * d2));
            }
            if (this.R != null) {
                graphics.setColor(color);
                this.R.draw(graphics, node, d * 1.0);
            }
            if (this.L != null) {
                graphics.setColor(color);
                this.L.draw(graphics, node, d * 1.0);
            }
        }
        graphics.setColor(color);
        graphics.fillOval(n - this.a, n2 - this.b, 2 * this.a + 1, 2 * this.b + 1);
        graphics.setColor(color2);
        graphics.drawString(this.symbol, n - this.sw / 2 + 1, n2 + (this.A - this.D) / 2);
    }
}

