/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.algebra.ANodeConfig;
import com.mja.algebra.ANode_AA;
import com.mja.algebra.ANode_AB;
import com.mja.algebra.ANode_AU;
import com.mja.algebra.ANode_BA;
import com.mja.algebra.ANode_BB;
import com.mja.algebra.ANode_N;
import com.mja.algebra.ANode_U;
import com.mja.algebra.ANode_UA;
import com.mja.algebra.ANode_UU;
import com.mja.algebra.Resultado;
import com.mja.algebra.U;
import com.mja.algebra.UU;
import com.mja.algebra.UserSelection;
import com.mja.gui.mjaText;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.util.BasicStr;
import java.awt.Toolkit;
import java.util.Vector;

public class ANode {
    protected Node N;
    protected String symbol;
    protected double value;
    protected ANode L;
    protected ANode R;
    protected ANodeConfig an_cfg;
    private boolean animate = true;
    private static Parser parser = new Parser(null);
    public static boolean notablesAntes = true;
    Vector V = new Vector();
    public int countResults;
    static ANode finalOpANode;

    protected ANode() {
    }

    public ANode(Node node, ANodeConfig aNodeConfig) {
        this.N = node.cloneNode();
        this.N.setDecimals(aNodeConfig.getDecimals());
        this.an_cfg = aNodeConfig;
        this.symbol = ANode.getPrettySymbol(node.getSymbol());
        this.value = node.Evaluate(node.getDouble());
        if (node.getLeft() != null) {
            this.L = new ANode(node.getLeft(), aNodeConfig);
        }
        if (node.getRight() != null && node.getRight().length == 1 && node.getRight()[0] != null) {
            this.R = new ANode(node.getRight()[0], aNodeConfig);
        }
    }

    public ANode(String string, ANodeConfig aNodeConfig) {
        this.an_cfg = aNodeConfig;
        this.N = new Node(parser, 16, 75, string);
        this.symbol = string;
        this.value = 0.0;
        this.N.setDecimals(aNodeConfig.getDecimals());
    }

    public ANode(double d, ANodeConfig aNodeConfig) {
        this(new Node(parser, d, aNodeConfig.getDecimals()), aNodeConfig);
    }

    public Node getNode() {
        return this.N;
    }

    public boolean animate() {
        return this.animate;
    }

    public String toExpression(boolean bl) {
        return this.N.toExpression(bl);
    }

    boolean equals(ANode aNode) {
        return this.toExpression(true).equals(aNode.toExpression(true));
    }

    public static String getPrettySymbol(String string) {
        if ("+/-".equals(string)) {
            return "\u00b1";
        }
        if ("*".equals(string)) {
            return "\u00d7";
        }
        if ("/".equals(string)) {
            return "\u00f7";
        }
        if ("-".equals(string)) {
            return "\u2012";
        }
        if ("-/+".equals(string)) {
            return "\u2213";
        }
        if ("sqrt".equals(string)) {
            return "\u221a";
        }
        if ("\\".equals(string)) {
            return "\u221a";
        }
        if ("=?".equals(string)) {
            return "\u225f";
        }
        if ("#".equals(string) || "!=".equals(string)) {
            return "\u2260";
        }
        if ("==".equals(string)) {
            return "<=>";
        }
        if ("!==".equals(string)) {
            return "\u2262";
        }
        if ("<=".equals(string)) {
            return "\u2264";
        }
        if (">=".equals(string)) {
            return "\u2265";
        }
        return string;
    }

    public static String getPrettyExpression(String string) {
        String string2 = BasicStr.replace((String)string, (String)"+/-", (String)"\u00b1");
        string2 = BasicStr.replace((String)string2, (String)"*", (String)"\u00b7");
        string2 = BasicStr.replace((String)string2, (String)"/", (String)"\u00f7");
        string2 = BasicStr.replace((String)string2, (String)"-", (String)"\u2012");
        string2 = BasicStr.replace((String)string2, (String)"-/+", (String)"\u2213");
        string2 = BasicStr.replace((String)string2, (String)"sqrt", (String)"\u221a");
        string2 = BasicStr.replace((String)string2, (String)"\\", (String)"\u221a");
        string2 = BasicStr.replace((String)string2, (String)"=?", (String)"\u225f");
        string2 = BasicStr.replace((String)string2, (String)"#", (String)"\u2260");
        string2 = BasicStr.replace((String)string2, (String)"==", (String)"<=>");
        string2 = BasicStr.replace((String)string2, (String)"!==", (String)"\u2262");
        string2 = BasicStr.replace((String)string2, (String)"<=", (String)"\u2264");
        string2 = BasicStr.replace((String)string2, (String)">=", (String)"\u2265");
        return string2;
    }

    public ANode Copy(ANode aNode) {
        return new ANode(aNode.N.cloneNode(), this.an_cfg);
    }

    public ANode Num(double d) {
        if (d >= 0.0) {
            return new ANode(new Node(parser, d, this.an_cfg.getDecimals()), this.an_cfg);
        }
        return this.Minus(new ANode(new Node(parser, -d, this.an_cfg.getDecimals()), this.an_cfg));
    }

    public ANode Abs(ANode aNode) {
        return new ANode(Node.Abs((Node)aNode.N), this.an_cfg);
    }

    public ANode Minus(ANode aNode) {
        if (this.an_cfg.simplify_minuses && aNode.isUnaryMinus()) {
            return new ANode(aNode.R.N, this.an_cfg);
        }
        return new ANode(Node.Minus((Node)aNode.N), this.an_cfg);
    }

    public ANode Inv(ANode aNode) {
        return this.Div(this.Num(1.0), aNode);
    }

    public ANode Sum(ANode aNode, ANode aNode2) {
        if (this.an_cfg.simplify_zero_one) {
            if (aNode.isZero()) {
                return new ANode(aNode2.N, this.an_cfg);
            }
            if (aNode2.isZero()) {
                return new ANode(aNode.N, this.an_cfg);
            }
        }
        if (this.an_cfg.simplify_minuses && aNode2.isUnaryMinus()) {
            return new ANode(Node.Subtract((Node)aNode.N, (Node)aNode2.R.N), this.an_cfg);
        }
        return new ANode(Node.Sum((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public ANode Sub(ANode aNode, ANode aNode2) {
        if (this.an_cfg.simplify_zero_one) {
            if (aNode2.isZero()) {
                return new ANode(aNode.N, this.an_cfg);
            }
            if (aNode.isZero()) {
                return this.Minus(aNode2);
            }
        }
        if (this.an_cfg.simplify_minuses && aNode2.isUnaryMinus()) {
            return new ANode(Node.Sum((Node)aNode.N, (Node)aNode2.R.N), this.an_cfg);
        }
        return new ANode(Node.Subtract((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public ANode Mul(ANode aNode, ANode aNode2) {
        return this.Mul(aNode, aNode2, this.an_cfg.simplify_zero_one);
    }

    public ANode Mul(ANode aNode, ANode aNode2, boolean bl) {
        if (aNode.isOne() && bl) {
            return new ANode(aNode2.N, this.an_cfg);
        }
        if (aNode2.isOne() && bl) {
            return new ANode(aNode.N, this.an_cfg);
        }
        if ((aNode.isZero() || aNode2.isZero()) && bl) {
            return this.Num(0.0);
        }
        return new ANode(Node.Multiply((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public ANode Div(ANode aNode, ANode aNode2) {
        return new ANode(Node.Divide((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public ANode Exp(ANode aNode, ANode aNode2) {
        return new ANode(Node.Exponentiate((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public ANode Root(ANode aNode, ANode aNode2) {
        return new ANode(Node.Root((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public ANode Sqrt(ANode aNode) {
        return new ANode(Node.Sqrt((Node)aNode.N), this.an_cfg);
    }

    public ANode Equal(ANode aNode, ANode aNode2) {
        return new ANode(Node.Equal((Node)aNode.N, (Node)aNode2.N), this.an_cfg);
    }

    public boolean isVar() {
        return this.N.getType() == 16;
    }

    public boolean isUnaryOperator() {
        boolean bl = !this.isPositiveNumber() && this.R != null && (this.L == null || this.opIs("\\") && (this.L.symbol.equals("2") || this.L.symbol.equals("")) || this.opIs("^") && this.R.symbol.equals("2"));
        return bl;
    }

    public boolean isBinaryOperator() {
        return !this.isPositiveNumber() && this.L != null && this.R != null;
    }

    boolean opIs(String string) {
        return ANode.getPrettySymbol(string).equals(this.symbol);
    }

    public static boolean isNumber(String string) {
        if (BasicStr.hasContent((String)string)) {
            for (int i = 0; i < string.length(); ++i) {
                if (Node.isDecimal((char)string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isNumber() {
        return this.isPositiveNumber() || this.isUnaryMinus() && this.R.isPositiveNumber() || this.isUnaryPlus() && this.R.isPositiveNumber();
    }

    boolean isIntegerFraction() {
        return this.isDiv() && this.L.isInteger() && this.R.isInteger();
    }

    boolean isSignedVar() {
        return this.isVar() || this.isUnaryMinus() && this.R.isVar();
    }

    boolean isInvariant() {
        return this.equals(this.performOperation());
    }

    boolean isCyclic() {
        ANode aNode = this.performOperation();
        return this.equals(aNode.performOperation());
    }

    public boolean isSimple() {
        if (this.isVar()) {
            return true;
        }
        if (this.isUnaryOperator()) {
            return this.isInvariant() && this.R.isSimple();
        }
        if (this.isBinaryOperator()) {
            if (this.isInvariant()) {
                return this.L.isSimple() && this.R.isSimple();
            }
            if (this.isCyclic() && this.L.isSimple() && this.R.isSimple()) {
                if (this.isSum()) {
                    if (!this.L.isPositiveNumber()) {
                        return true;
                    }
                    if (this.R.symbol.equals("x")) {
                        return true;
                    }
                } else if (this.isMul() && this.L.isVar()) {
                    if (this.R.symbol.equals("x")) {
                        return true;
                    }
                    if (this.L.isPositiveNumber()) {
                        return true;
                    }
                    if (this.R.isExp() && this.R.L.symbol.equals("x")) {
                        return true;
                    }
                }
            }
            if (this.isExp() && this.L.isVar() && this.R.isSimple()) {
                return true;
            }
        }
        return false;
    }

    public boolean isAbstractNumber() {
        return !ANode.isNumber(this.symbol);
    }

    public boolean isPositiveNumber() {
        return ANode.isNumber(this.symbol);
    }

    public boolean isInteger() {
        return this.symbol != null && this.isPositiveNumber() && this.symbol.indexOf(".") < 0;
    }

    public boolean isEven() {
        return this.isPositiveNumber() && this.isInteger() && (int)this.value % 2 == 0;
    }

    public boolean isOdd() {
        return this.isPositiveNumber() && this.isInteger() && (int)this.value % 1 == 0;
    }

    public boolean isOne() {
        return this.isInteger() && this.symbol.equals("1") && (int)this.value == 1;
    }

    public boolean isZero() {
        return this.isInteger() && this.symbol.equals("0") && (int)this.value == 0;
    }

    boolean isUnaryMinus() {
        return this.isUnaryOperator() && this.opIs("-");
    }

    boolean isUnaryPlus() {
        return this.isUnaryOperator() && this.opIs("+");
    }

    boolean isSqr() {
        return this.isUnaryOperator() && (this.opIs("sqr") || this.opIs("^") && this.R.symbol.equals("2"));
    }

    boolean isSqrt() {
        return this.isUnaryOperator() && (this.opIs("sqrt") || this.opIs("\\") && (this.L.symbol.equals("2") || this.L.symbol.equals("")));
    }

    boolean isAbs() {
        return this.isUnaryOperator() && this.opIs("abs");
    }

    boolean isSum() {
        return this.isBinaryOperator() && this.opIs("+");
    }

    boolean isSub() {
        return this.isBinaryOperator() && this.opIs("-");
    }

    boolean isMul() {
        return this.isBinaryOperator() && this.opIs("*");
    }

    boolean isDiv() {
        return this.isBinaryOperator() && this.opIs("/");
    }

    boolean isExp() {
        return this.isBinaryOperator() && this.opIs("^");
    }

    boolean isRoot() {
        return this.isBinaryOperator() && this.opIs("\\");
    }

    boolean isEqual() {
        return this.isBinaryOperator() && this.opIs("=");
    }

    boolean isComp() {
        return this.isBinaryOperator() && (this.opIs("=") || this.opIs("<") || this.opIs(">"));
    }

    void addResultado(Vector vector, ANode aNode, String string) {
        this.addResultado(vector, aNode, string, "");
    }

    void addResultado(Vector vector, ANode aNode, String string, String string2) {
        this.addResultado(vector, new Resultado(aNode, string, string2));
    }

    void addResultado(Vector vector, Resultado resultado) {
        if (resultado != null) {
            ANode aNode = resultado.getANode();
            String string = aNode.toExpression(true);
            for (int i = 0; i < vector.size(); ++i) {
                Resultado resultado2 = (Resultado)vector.elementAt(i);
                ANode aNode2 = resultado2.getANode();
                if (!string.equals(aNode2.toExpression(true))) continue;
                return;
            }
            vector.addElement(resultado);
        }
    }

    Vector getResultados() {
        this.performOperation();
        return this.V;
    }

    protected ANode performOperation() {
        return this.performOperation(0, false, false, false, false, false, 0, 0, "Operaciones posibles");
    }

    public ANode performOperation(int n, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n2, int n3, String string) {
        Resultado resultado;
        this.V = new Vector();
        if (bl) {
            Resultado resultado2 = this.doAssociation(bl);
            if (resultado2 != null) {
                return resultado2.getANode();
            }
            return this;
        }
        ANode aNode = this;
        if (bl2 && !(resultado = this.doAssociation(true)).getANode().equals(this)) {
            aNode = resultado.getANode();
            this.V.addElement(resultado);
            return aNode;
        }
        if (this.isVar()) {
            return aNode;
        }
        if (this.isUnaryOperator()) {
            new U(aNode).perform(this.V);
            if (this.R.isUnaryOperator()) {
                new UU(aNode).perform(this.V);
            } else if (this.L != null && this.L.isUnaryOperator()) {
                new UU(aNode).perform(this.V);
            }
            resultado = new ANode_U(aNode).perform_U();
            if (resultado != null) {
                this.V.addElement(resultado);
            }
        }
        if (this.isBinaryOperator()) {
            aNode.doBinaryOperation(this.V);
        }
        this.countResults = this.V.size();
        if (this.countResults > 0) {
            int n4 = n;
            if (this.countResults > 1 && bl3) {
                n4 = UserSelection.selectOption(parser, aNode, this.V, n2, n3, bl4, bl5, string);
            }
            if (n4 >= 0 && n4 < this.V.size()) {
                Resultado resultado3 = (Resultado)this.V.elementAt(n4);
                return resultado3.getANode();
            }
            return null;
        }
        return aNode;
    }

    void doBinaryOperation(Vector vector) {
        this.addResultado(vector, new ANode_BB(this).perform_BN(vector));
        this.addResultado(vector, new ANode_BB(this).perform_NB(vector));
        if (this.L.isPositiveNumber() || this.R.isPositiveNumber()) {
            ANode_N aNode_N = new ANode_N(this);
            if (this.L.isPositiveNumber() && this.R.isPositiveNumber()) {
                aNode_N.perform_NN(vector);
            }
            if (this.L.isPositiveNumber()) {
                aNode_N.perform_NA_0(vector);
                if (this.R.isUnaryOperator()) {
                    aNode_N.perform_NU(vector);
                }
                aNode_N.perform_NA_1(vector);
            }
            if (this.R.isPositiveNumber()) {
                aNode_N.perform_AN_0(vector);
                if (this.L.isUnaryOperator()) {
                    aNode_N.perform_UN(vector);
                }
                aNode_N.perform_AN_1(vector);
            }
        }
        new ANode_AA(this).perform_AA_0(vector);
        if (this.L.isUnaryOperator() && this.R.isUnaryOperator()) {
            this.addResultado(vector, new ANode_UU(this).perform_UU());
        }
        if (this.R.isUnaryOperator()) {
            this.addResultado(vector, new ANode_AU(this).perform_AU());
        }
        if (this.L.isUnaryOperator()) {
            this.addResultado(vector, new ANode_UA(this).perform_UA());
        }
        if (this.L.isBinaryOperator() && this.R.isBinaryOperator()) {
            if (notablesAntes) {
                this.addResultado(vector, new ANode_BB(this).perform_BB_notables(vector));
            }
            this.addResultado(vector, new ANode_BB(this).perform_BB(vector));
        }
        if (this.L.isBinaryOperator()) {
            this.addResultado(vector, new ANode_BA(this).perform_BA(vector));
        }
        if (this.R.isBinaryOperator()) {
            this.addResultado(vector, new ANode_AB(this).perform_AB(vector));
        }
        new ANode_AA(this).perform_AA_1(vector);
        if (this.L.isBinaryOperator() && this.R.isBinaryOperator()) {
            this.addResultado(vector, new ANode_BB(this).perform_BB_notables(vector));
        }
    }

    int maxCommonDivisor(int n, int n2) {
        if (n == 0) {
            return n2;
        }
        int n3 = 2;
        int n4 = n >= n2 ? n : n2;
        int n5 = n >= n2 ? n2 : n;
        int n6 = n4 - (int)Math.floor(n4 / n5) * n5;
        while (n5 > 1 & n6 > 0) {
            n4 = n6 == 0 ? n4 : n5;
            n5 = n6 == 0 ? n5 : n6;
            n6 = n4 - (int)Math.floor(n4 / n5) * n5;
        }
        return n5;
    }

    int minCommonMultiple(int n, int n2) {
        return n * n2 / this.maxCommonDivisor(n, n2);
    }

    void divideIntegers(Vector vector) {
        if (this.isIntegerFraction()) {
            ANode aNode = this;
            int n = (int)Math.round(this.L.value);
            int n2 = (int)Math.round(this.R.value);
            if (n2 != 0) {
                int n3 = this.maxCommonDivisor(n, n2);
                if (n3 == n2) {
                    aNode = this.Num((double)n / (double)n2);
                    this.addResultado(vector, new Resultado(aNode, "(n*d)/d = n", ""));
                } else if (n3 > 1) {
                    aNode = this.Div(this.Num(n / n3), this.Num(n2 / n3));
                    this.addResultado(vector, new Resultado(aNode, "(m*c)/(n*c)=m/n", ""));
                } else {
                    this.addResultado(vector, new Resultado(new ANode(aNode.N.Evaluate(0.0), this.an_cfg), "m/n=r", "si n#0"));
                }
            }
        }
    }

    public ANode userModified(Parser parser) {
        String string = this.toExpression(true);
        String string2 = mjaText.getInfo((String)"Modificar", (String)(string + " = "), (String)"aceptar", (String)"cancelar", (boolean)false, (String)string);
        if (BasicStr.hasContent((String)string2)) {
            try {
                Node node = parser.Analyse(string2);
                if (node.Evaluate() == this.N.Evaluate()) {
                    return new ANode(node, this.an_cfg);
                }
            }
            catch (Exception exception) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        return this;
    }

    void error(String string) {
        System.out.println("Error: " + string + " in " + this.toExpression(true));
    }

    public static Node getFinalOpNode() {
        if (finalOpANode != null) {
            return ANode.finalOpANode.N;
        }
        return null;
    }

    public Resultado doAssociation(boolean bl) {
        ANode aNode = this;
        String string = "";
        finalOpANode = this;
        if (this.isSum() && this.L.isSum()) {
            aNode = bl ? this.Sum(this.L.L, this.Sum(this.L.R, this.R).doAssociation(bl).getANode()) : this.Sum(this.L.L, this.Sum(this.L.R, this.R));
            string = "(A + B) + C = A + (B + C)";
        } else if (this.isSum() && this.L.isSub()) {
            if (aNode.an_cfg.simplify_minuses) {
                aNode = bl ? this.Sub(this.L.L, this.Sub(this.L.R, this.R).doAssociation(bl).getANode()) : this.Sub(this.L.L, this.Sub(this.L.R, this.R));
                string = "(A - B) + C = A - (B - C)";
            } else {
                aNode = bl ? this.Sum(this.L.L, this.Sum(this.Minus(this.L.R), this.R).doAssociation(bl).getANode()) : this.Sum(this.L.L, this.Sum(this.Minus(this.L.R), this.R));
                string = "(A - B) + C = A + (-B + C)";
            }
        } else if (this.isSub() && this.L.isSum()) {
            aNode = bl ? this.Sum(this.L.L, this.Sub(this.L.R, this.R).doAssociation(bl).getANode()) : this.Sum(this.L.L, this.Sub(this.L.R, this.R));
            string = "(A + B) - C = A + (B - C)";
        } else if (this.isSub() && this.L.isSub()) {
            if (aNode.an_cfg.simplify_minuses) {
                aNode = bl ? this.Sub(this.L.L, this.Sum(this.L.R, this.R).doAssociation(bl).getANode()) : this.Sub(this.L.L, this.Sum(this.L.R, this.R));
                string = "(A - B) - C = A - (B + C)";
            } else {
                aNode = bl ? this.Sum(this.L.L, this.Sum(this.Minus(this.L.R), this.Minus(this.R)).doAssociation(bl).getANode()) : this.Sum(this.L.L, this.Sum(this.Minus(this.L.R), this.Minus(this.R)));
                string = "(A - B) - C = A + (-B + (-C))";
            }
        } else if (this.isMul() && this.L.isMul()) {
            aNode = bl ? this.Mul(this.L.L, this.Mul(this.L.R, this.R, false).doAssociation(bl).getANode(), false) : this.Sum(this.L.L, this.Sum(this.L.R, this.R));
            string = "(A * B) * C = A * (B * C)";
        } else if (this.isSum() && this.R.isSum()) {
            aNode = bl ? this.Sum(this.Sum(this.L, this.R.L).doAssociation(bl).getANode(), this.R.R) : this.Sum(this.Sum(this.L, this.R.L), this.R.R);
            string = "A + (B + C) = (A + B) + C";
        } else if (this.isSum() && this.R.isSub()) {
            aNode = bl ? this.Sub(this.Sum(this.L, this.R.L).doAssociation(bl).getANode(), this.R.R) : this.Sub(this.Sum(this.L, this.R.L), this.R.R);
            string = "A + (B - C) = (A + B) - C";
        } else if (this.isSub() && this.R.isSum()) {
            aNode = bl ? this.Sub(this.Sub(this.L, this.R.L).doAssociation(bl).getANode(), this.R.R) : this.Sub(this.Sub(this.L, this.R.L), this.R.R);
            string = "A - (B + C) = (A - B) - C";
        } else if (this.isSub() && this.R.isSub()) {
            aNode = bl ? this.Sum(this.Sub(this.L, this.R.L).doAssociation(bl).getANode(), this.R.R) : this.Sum(this.Sub(this.L, this.R.L), this.R.R);
            string = "A - (B - C) = (A - B) + C";
        } else if (this.isMul() && this.R.isMul()) {
            aNode = bl ? this.Mul(this.Mul(this.L, this.R.L, false).doAssociation(bl).getANode(), this.R.R, false) : this.Mul(this.Mul(this.L, this.R.L, false), this.R.R, false);
            string = "A * (B * C) = (A * B) * C";
        }
        aNode.animate = false;
        return new Resultado(aNode, string);
    }

    static boolean isPerfectSqr(int n) {
        double d = Math.sqrt(n);
        return (double)Math.round(d) == d;
    }

    Vector getVector() {
        return this.V;
    }

    public Node findModifiedNode(ANode aNode) {
        Node node;
        if (this.L != null && aNode.L != null && (node = this.L.findModifiedNode(aNode.L)) != null) {
            return node;
        }
        if (this.R != null && aNode.R != null && (node = this.R.findModifiedNode(aNode.R)) != null) {
            return node;
        }
        Vector vector = this.getResultados();
        for (int i = 0; i < vector.size(); ++i) {
            ANode aNode2;
            Resultado resultado = (Resultado)vector.elementAt(i);
            if (resultado == null || (aNode2 = resultado.getANode()) == null || !aNode2.equals(aNode)) continue;
            return this.N;
        }
        return null;
    }

    public ANode findModifiedANode(ANode aNode) {
        ANode aNode2;
        if (this.L != null && aNode.L != null && (aNode2 = this.L.findModifiedANode(aNode.L)) != null) {
            return aNode2;
        }
        if (this.R != null && aNode.R != null && (aNode2 = this.R.findModifiedANode(aNode.R)) != null) {
            return aNode2;
        }
        Vector vector = this.getResultados();
        for (int i = 0; i < vector.size(); ++i) {
            Resultado resultado = (Resultado)vector.elementAt(i);
            if (resultado == null || (aNode2 = resultado.getANode()) == null || !aNode2.equals(aNode)) continue;
            return this;
        }
        return null;
    }
}

