/*
 * Decompiled with CFR 0.152.
 */
package com.mja.algebra;

import com.mja.algebra.ANode;
import com.mja.algebra.DescartesA;
import com.mja.algebra.TreeNode;
import com.mja.parser.Node;
import com.mja.text.Formula;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

class TreeCanvas
extends Canvas
implements MouseListener,
Runnable {
    Thread thr;
    Node Ns;
    TreeNode DN;
    DescartesA DA;
    Image ima;
    int W;
    int H;
    Graphics G;
    double t = 1.0;
    private boolean paint_slowly = false;

    TreeCanvas(DescartesA descartesA, boolean bl) {
        this.setBackground(new Color(0x2244FF));
        this.DA = descartesA;
        if (bl) {
            this.addMouseListener(this);
        }
    }

    void start() {
        this.W = this.getSize().width;
        this.H = this.getSize().height;
        this.ima = this.createImage(this.W, this.H);
        this.G = this.ima.getGraphics();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this) {
            this.Ns = this.DN.getNodeAt(mouseEvent.getX(), mouseEvent.getY());
            this.DA.FEC.unmarkSegment();
            if (this.Ns != null) {
                Formula formula = this.Ns.F;
                if (formula != null) {
                    formula.markSegment(formula.begin(), formula.end());
                    this.DA.FEC.updateScreen();
                }
                this.DA.setEditableFormula();
            }
            this.paint(this.getGraphics());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && this.Ns != null) {
            ANode aNode;
            if (mouseEvent.getClickCount() == 2) {
                this.DA.performOperation(false, false, this.Ns);
            } else if (mouseEvent.getClickCount() == 1 && this.DA.an_cfg.associateOnClick && !(aNode = new ANode(this.Ns, this.DA.an_cfg)).isVar()) {
                this.DA.performOperation(true, false, this.Ns);
                this.DA.FEC.unmarkSegment();
                this.DA.FEC.updateScreen();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void update(Graphics graphics) {
    }

    public void paint(Graphics graphics) {
        try {
            if (this.G == null) {
                this.start();
            }
            this.G.setColor(this.getBackground());
            this.G.fillRect(0, 0, this.W, this.H);
            Dimension dimension = this.getSize();
            if (dimension != null && dimension.width != 0) {
                this.DN = new TreeNode(this.G.getFontMetrics(), this.DA.tn_cfg, this.DA.FEC.getMainFormula().getNode(), dimension.width / 2, 20, (dimension.width - 15) / 4, 35);
                this.DN.draw(this.G, this.Ns, this.t);
            }
            graphics.drawImage(this.ima, 0, 0, this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void animate() {
        this.thr = new Thread(this);
        this.thr.start();
    }

    void paintSlowly() {
        this.paint_slowly = true;
        this.animate();
    }

    public void run() {
        try {
            if (this.paint_slowly) {
                int n;
                if (this.G == null) {
                    this.start();
                }
                Graphics graphics = this.ima.getGraphics();
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.W, this.H);
                this.paint(graphics);
                Graphics graphics2 = this.getGraphics();
                for (n = 0; 0 <= n && n <= Math.max(this.DN.max_y, this.H / 2); ++n) {
                    graphics2.setColor(Color.white);
                    graphics2.drawLine(0, n, this.W, n);
                    Thread.sleep(5L);
                    graphics2.clipRect(0, n, this.W, 1);
                    graphics2.drawImage(this.ima, 0, 0, this);
                    graphics2 = this.getGraphics();
                }
                graphics2.setColor(this.getBackground());
                graphics2.fillRect(0, n, this.W, this.H - n);
                this.paint_slowly = false;
            } else {
                long l = 100L;
                this.t = 1.0;
                Thread.sleep(2L * l);
                while (this.t > 0.0) {
                    Thread.sleep(l);
                    this.t -= 0.125;
                    this.paint(this.getGraphics());
                }
                this.t = 1.0;
                Thread.sleep(l);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.thr = null;
    }
}

