/*
 * Decompiled with CFR 0.152.
 */
package com.mja.textedit;

import com.mja.descartes.Descartes;
import com.mja.descartes.controlConfig;
import com.mja.descgui.NumericControl;
import com.mja.gui.MouseCursorHandler;
import com.mja.lang.translator;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.Formula;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.text.TNode;
import com.mja.text.Text;
import com.mja.text.TextCanvas;
import com.mja.textedit.MathEditor;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class EditorCanvas
extends TextCanvas
implements Runnable,
KeyListener,
FocusListener,
ComponentListener {
    private int cursorX;
    private MouseCursorHandler mch;
    private Vector AL = new Vector();
    private String por_str = null;
    private Vector localBuffer;
    private Thread thr;
    private boolean pleaseStop;
    static final int pulsador = 0;
    static final int texto_corto = 1;
    static final int texto_medio = 2;
    static final int texto_largo = 3;
    static final int menu = 4;
    static final int barra = 5;
    static final int boton = 6;
    private static final int left = 1;
    private static final int right = 2;
    private static final int up = 3;
    private static final int down = 4;
    private static final int home = 5;
    private static final int end = 6;
    private char UC_base = '\u0000';
    int TBSZ = 25;
    String[] Sa = new String[this.TBSZ + 1];
    int[] cposa = new int[this.TBSZ + 1];
    private int mouseX;
    private int mouseY;
    private int activeImage = -1;
    private int activeImage2 = -1;
    private boolean mousePressedWhileEditing = false;
    private boolean dragged = false;
    private Point point;
    private boolean falseDrag;
    private int cX;
    private int cY;
    private int cW;
    private int cH;
    private boolean dblclkusd;
    private int dblclckpos = -1;
    private long dblclckmillis = -1L;

    public EditorCanvas(Applet applet, Frame frame, translator translator2, MouseCursorHandler mouseCursorHandler, Parser parser, TFont tFont, Color color, boolean bl, boolean bl2, boolean bl3) {
        this(applet, frame, translator2, mouseCursorHandler, parser, tFont, color, bl, false, bl2, bl3);
    }

    public EditorCanvas(Applet applet, Frame frame, translator translator2, MouseCursorHandler mouseCursorHandler, Parser parser, TFont tFont, Color color, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        super(applet, frame, translator2, parser, tFont, color, bl3, bl4);
        this.mch = mouseCursorHandler;
        this.addFocusListener(this);
    }

    protected void updateSelectors() {
        this.callActionListeners("UpdateSelectors", 1001);
    }

    @Override
    public boolean start() {
        this.removeComponentListener(this);
        boolean bl = super.start();
        if (bl) {
            this.updateCursorThread();
        }
        this.addComponentListener(this);
        return bl;
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.setFormulaColors(this.T.getColors());
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        this.setFormulaColors(this.T.getColors());
    }

    @Override
    public void setText(Text text) {
        if (this.isEditing()) {
            this.removeListeners();
        }
        super.setText(text);
        if (this.isEditing()) {
            this.addListeners();
        }
    }

    public void setMultStr(String string) {
        this.por_str = string;
    }

    @Override
    public void addActionListener(ActionListener actionListener) {
        if (actionListener != null) {
            this.AL.addElement(actionListener);
        }
    }

    protected void callActionListeners(String string) {
        this.callActionListeners(string, 0);
    }

    void callActionListeners(String string, int n) {
        for (int i = 0; i < this.AL.size(); ++i) {
            ActionListener actionListener = (ActionListener)this.AL.elementAt(i);
            actionListener.actionPerformed(new ActionEvent(this, n, string));
        }
    }

    public void setLearnerMode(boolean bl) {
        this.learnerMode = bl;
        this.updateSize();
        this.updateScreen();
        this.updateCursorThread();
    }

    public boolean segIsMarked() {
        if (this.F != null) {
            return this.F.segMarked();
        }
        return this.T.segMarked();
    }

    public void unmarkSegment() {
        if (this.F != null && this.F.segMarked()) {
            this.F.unmarkSegment();
            this.updateScreenSegment(this.mainFIndex, this.mainFIndex);
        }
        if (this.T.segMarked()) {
            int n = this.T.segMin();
            int n2 = this.T.segMax();
            this.T.unmarkSegment();
            this.updateScreenSegment(n, n2);
        }
    }

    public void updateComponents() {
        if (this.A instanceof Descartes) {
            Descartes descartes = (Descartes)this.A;
            NumericControl[] numericControlArray = descartes.getNumCtrls();
            for (int i = 0; i < numericControlArray.length; ++i) {
                if (numericControlArray[i] == null) continue;
                this.updateTextComponent(numericControlArray[i], numericControlArray[i].getControlID());
            }
        }
    }

    public void setEditing(boolean bl) {
        if (this.editing) {
            this.unmarkSegment();
            this.removeListeners();
        }
        this.editing = bl;
        if (this.editing) {
            this.addListeners();
        }
        this.updateSize();
        this.updateCursorThread();
        if (!this.editing) {
            this.setCursor(null);
        }
    }

    public void setActiveFormulaAtNode(Node node) {
        this.mainF.unmarkSegment();
        this.F = this.mainF.subFormulaWithNode(node);
        this.F.markSegment(this.F.begin(), this.F.end());
        this.updateScreen();
    }

    public void insertHyperlink() {
        int n;
        String string = "HV";
        String string2 = "http://recursostic.educacion.es/descartes/web/";
        if (this.T.segMarked()) {
            string = "";
            n = this.T.segBegin();
            while (n < this.T.segEnd()) {
                string = string + this.T.TNode(n++).getChar();
            }
            this.T.removeMarkedSegment();
        }
        n = this.T.getCursorPos();
        this.T.insertHyperlink(string, string2);
        TNode tNode = this.T.TNode(n);
        tNode.editHyperlink();
        this.updateScreen();
        this.requestFocus();
    }

    public void insertControl(int n, boolean bl) {
        controlConfig controlConfig2;
        Descartes descartes = (Descartes)this.A;
        TFont tFont = this.T.getTFontAtTNode(this.T.getCursorPos());
        int n2 = tFont.getAscent() + tFont.getDescent() + 6;
        String string = descartes.scene.getNewControlName();
        String string2 = Long.toString(System.currentTimeMillis(), 16);
        int n3 = n2;
        if (bl) {
            n3 = n2 - 2;
        }
        switch (n) {
            case 0: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='" + string + "' tipo='num\u00e9rico' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 120 + "," + n3 + ")' valor='0' decimales='2' visible='si' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            case 1: {
                if (bl) {
                    controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='' tipo='num\u00e9rico' interfaz='campo de texto' solo_texto='s\u00ed' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + n3 + "," + n3 + ")' valor='||' decimales='0' fijo='no' visible='si' dibujar-si='' cID='" + string2 + "' ");
                    break;
                }
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='' tipo='num\u00e9rico' interfaz='campo de texto' solo_texto='s\u00ed' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 40 + "," + n3 + ")' valor='||' decimales='0' fijo='no' visible='s\u00ed' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            case 2: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='' tipo='num\u00e9rico' interfaz='campo de texto' solo_texto='s\u00ed' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 100 + "," + n3 + ")' valor='||' decimales='0' fijo='no' visible='si' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            case 3: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='' tipo='num\u00e9rico' interfaz='campo de texto' solo_texto='s\u00ed' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 240 + "," + n3 + ")' valor='||' decimales='0' fijo='no' visible='si' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            case 4: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='' tipo='num\u00e9rico' interfaz='men\u00fa'  regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 120 + "," + n3 + ")' valor='0' decimales='0' opciones=' ,opci\u00f3n1,,opci\u00f3n2' visible='no' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            case 5: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='' tipo='num\u00e9rico'  interfaz='barra' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 120 + "," + n3 + ")' valor='0' decimales='2' fijo='no' min='0' max='100' incr='1' visible='no' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            case 6: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='" + string + "' tipo='num\u00e9rico' interfaz='bot\u00f3n'  regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 120 + "," + n3 + ")' valor='0' decimales='0' visible='no' dibujar-si='' cID='" + string2 + "' ");
                break;
            }
            default: {
                controlConfig2 = descartes.cfg.addNumCtrlCfg("id='" + string + "' nombre='" + string + "' tipo='num\u00e9rico' regi\u00f3n='escenario' expresi\u00f3n='(0,0," + 120 + "," + n2 + ")' valor='0' decimales='2' visible='si' dibujar-si='' cID='" + string2 + "' ");
            }
        }
        if (descartes.getEditor() != null) {
            descartes.getEditor().setInfo();
        }
        NumericControl numericControl = controlConfig2.makeNumericControl(descartes);
        numericControl.setVisible(false);
        int n4 = this.T.getLineHeightAtTNode(this, this.getCursorPos());
        if (this.F != null) {
            this.F.insertComponent(numericControl, "NumCtrl", string2);
        } else {
            this.T.insertComponent(numericControl, "NumCtrl", string2);
        }
        numericControl.addMouseListener(descartes);
        this.updateScreenLineAtTNode(this.getCursorPos());
        this.updateScreenLineAtTNode(this.getCursorPos());
        int n5 = this.T.getLineHeightAtTNode(this, this.getCursorPos());
        if (n5 > n4) {
            this.scrollFromTNode(this.getCursorPos(), n4 - n5);
            int n6 = this.T.nextLine(this.getCursorPos());
            this.updateScreenLineAtTNode(n6);
        }
        if (this.updateSize(false) || this.F != null) {
            this.updateScreen();
        }
        numericControl.paintAll(numericControl.getGraphics());
        this.paintCursor();
        this.requestFocus();
    }

    public void insertExpr(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            this.F.insertExpr(string, Integer.toString(this.dec), this.fixed);
            this.mainF.calcValues(this.dec, this.fixed, this.aL, this.editing, this.learnerMode);
            this.updateScreen();
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertFunction(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertText(string);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertRadical(String string, String string2) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertRadical(string, string2);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertSum(String string, String string2, String string3) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertSum(string, string2, string3);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertIntegral(String string, String string2, String string3) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertIntegral(string, string2, string3);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertLimit(String string, String string2, String string3) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertLimit(string, string2, string3);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertMatrix(String[][] stringArray) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertMatrix(stringArray);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertDefParts(String[] stringArray) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertDefParts(stringArray);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertFraction(String string, String string2) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertFraction(string, string2);
            if (string == null || string.length() == 0) {
                this.F.setCursorPos(n);
                n = this.F.getCursorPos();
                this.smallMoveRight();
            } else if (string2 == null || string2.length() == 0) {
                this.smallMoveLeft();
            }
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertNewFraction() {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                String string = this.F.toExpresion(this.F.segBegin(), this.F.segEnd(), true);
                try {
                    Node node = this.parser.Analyse("EditorCanvas", string, true, false);
                    Formula formula = node.toFormula();
                    Formula formula2 = new Formula(this.parser);
                    this.F.removeMarkedSegment();
                    try {
                        if (this.localBuffer != null) {
                            Formula formula3 = Formula.makeFormulaFromBuffer(this.F, this.localBuffer);
                            this.localBuffer = null;
                            String string2 = formula3.toExpresion(true);
                            Node node2 = this.parser.Analyse("EditorCanvas", string2, true, false);
                            formula2 = node2.toFormula();
                            this.F.insertFraction(formula, formula2);
                        } else {
                            this.F.insertFraction(formula, formula2);
                            this.smallMoveLeft();
                        }
                    }
                    catch (Exception exception) {
                        this.F.insertFraction(formula, formula2);
                        this.smallMoveLeft();
                    }
                    this.updateScreenFromTNode(this.mainFIndex);
                    this.paintCursor();
                    this.updateSize();
                }
                catch (Exception exception) {
                    this.insertFraction(string, "");
                }
            } else {
                this.insertFraction("", "");
            }
        }
    }

    public void insertSubIndex(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertSubIndex(string);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    public void insertSuperIndex(String string) {
        if (this.editing && this.F != null) {
            if (this.F.segMarked()) {
                this.removeMarkedSegment();
            }
            int n = this.F.getCursorPos();
            this.F.insertSuperIndex(string);
            this.F.setCursorPos(n);
            this.smallMoveRight();
            this.updateScreenFromTNode(this.mainFIndex);
            this.paintCursor();
            this.updateSize();
        }
    }

    void copyFormula() {
        if (this.F != null && this.F.segMarked()) {
            this.localBuffer = new Vector();
            int n = this.F.segMax();
            for (int i = this.F.segMin(); i < n; ++i) {
                TNode tNode = this.F.TNode(i).cloneTNode(this.F);
                this.localBuffer.addElement(tNode);
            }
        }
    }

    protected void setCursorPos(int n, int n2) {
        int n3 = this.T.getIndexOfLineAtPixel(this, n2);
        int n4 = this.T.getOffsetOfTNodeAtPixel(this, n3, n, false);
        int n5 = this.T.firstChar(n3 + n4);
        if (!this.onlyFormula) {
            this.T.setCursorPos(n5);
        }
        this.inVerticalMotion = false;
        boolean bl = false;
        if (this.T.TNode(n5).isFormula()) {
            this.mainF = this.T.TNode(n5).getFI().getFormula(0);
            Formula formula = this.mainF.getFormulaAt(n, n2);
            if (formula != null) {
                bl = true;
                this.setActiveFormulaAt(n5, formula, n, n2);
            }
        }
        if (!this.onlyFormula && !bl) {
            this.mainF = null;
            this.setEditingFormula(null);
            this.mainFIndex = -1;
        }
    }

    private void setCursorPosInText(int n, int n2) {
        int n3 = this.T.getIndexOfLineAtPixel(this, n2);
        int n4 = this.T.getOffsetOfTNodeAtPixel(this, n3, n, false);
        this.T.setCursorPos(this.T.firstChar(n3 + n4));
        this.inVerticalMotion = false;
    }

    private void setCursorPosInFormula(int n, int n2) {
        int n3 = this.F.getOffsetOfTNodeAtPixel(this, 0, n);
        this.F.setCursorPos(this.F.firstChar(n3));
        this.inVerticalMotion = false;
    }

    void smallMoveRight() {
        int n = this.F.firstChar(this.F.getCursorPos());
        TNode tNode = this.F.TNode(n);
        if (tNode.isSubIndex() || tNode.isSuperIndex() || tNode.isFraction() || tNode.isProduct() || tNode.isRadical() || tNode.isSum() || tNode.isIntegral() || tNode.isLimit() || tNode.isMatrix() || tNode.isDefParts()) {
            this.setEditingFormula(tNode.getFI().getFormula(0));
        } else {
            TNode tNode2;
            BasicText basicText = tNode.getParent();
            boolean bl = false;
            if (this.F.afterLastChar(n) && basicText instanceof Formula && (tNode2 = ((Formula)basicText).getParent()) != null && (tNode2.isFraction() || tNode.isProduct() || tNode2.isRadical() || tNode2.isSum() || tNode2.isIntegral() || tNode2.isLimit() || tNode2.isMatrix() || tNode2.isDefParts())) {
                for (int i = 0; i < tNode2.getFI().size() - 1; ++i) {
                    if (tNode2.getFI().getFormula(i) != this.F) continue;
                    this.setEditingFormula(tNode2.getFI().getFormula(i + 1));
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                if (this.F.afterLastChar(n)) {
                    this.doEscape();
                }
                if (this.F != null) {
                    this.moveRight();
                } else {
                    this.moveCursor(false, true, 2);
                }
            }
        }
    }

    void smallMoveLeft() {
        int n = this.F.getCursorPos();
        TNode tNode = this.F.TNode(n);
        if (n > this.F.firstChar(this.F.begin())) {
            this.moveLeft();
            n = this.F.getCursorPos();
            tNode = this.F.TNode(n);
            if (tNode.isSubIndex() || tNode.isSuperIndex() || tNode.isFraction() || tNode.isProduct() || tNode.isRadical() || tNode.isSum() || tNode.isIntegral() || tNode.isLimit() || tNode.isMatrix() || tNode.isDefParts()) {
                this.setEditingFormula(tNode.getFI().getFormula(tNode.getFI().size() - 1));
                this.F.setCursorPos(this.F.end());
            }
        } else {
            TNode tNode2;
            BasicText basicText = tNode.getParent();
            boolean bl = false;
            if (basicText instanceof Formula && (tNode2 = ((Formula)basicText).getParent()) != null && (tNode2.isFraction() || tNode.isProduct() || tNode2.isRadical() || tNode2.isSum() || tNode2.isIntegral() || tNode2.isLimit() || tNode2.isMatrix() || tNode2.isDefParts())) {
                for (int i = tNode2.getFI().size() - 1; i > 0; --i) {
                    if (tNode2.getFI().getFormula(i) != this.F) continue;
                    this.setEditingFormula(tNode2.getFI().getFormula(i - 1));
                    this.F.setCursorPos(this.F.end());
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                this.doEscape();
            }
        }
    }

    boolean doEscape() {
        BasicText basicText;
        TNode tNode = this.F.getParent();
        if (tNode != null && (basicText = tNode.getParent()) instanceof Formula) {
            this.setEditingFormula((Formula)basicText);
            this.F.setCursorPos(tNode);
            return true;
        }
        if (!this.onlyFormula) {
            this.mainF = null;
            this.setEditingFormula(null);
            this.mainFIndex = -1;
        }
        return false;
    }

    boolean moveRight() {
        int n = this.F.getCursorPos();
        this.F.setCursorPos(this.F.firstChar(n));
        if (this.F.getCursorPos() < this.F.end()) {
            this.F.setCursorPos(this.F.getCursorPos() + 1);
        }
        return this.F.getCursorPos() != n;
    }

    boolean moveLeft() {
        if (this.F != null) {
            int n = this.F.getCursorPos();
            this.F.setCursorPos(this.F.prevChar(n));
            if (this.F.getCursorPos() != n) {
                return true;
            }
        }
        return false;
    }

    boolean goToUpperFormula() {
        TNode tNode;
        int n = this.F.getCursorPos();
        TNode tNode2 = this.F.TNode(n);
        BasicText basicText = tNode2.getParent();
        if (basicText instanceof Formula && (tNode = ((Formula)basicText).getParent()) != null) {
            if (tNode.isFraction() || tNode.isProduct()) {
                if (tNode.getFI().getFormula(1) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(0));
                    return true;
                }
            } else if (tNode.isRadical()) {
                if (tNode.getFI().getFormula(1) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(0));
                    return true;
                }
            } else if ((tNode.isSum() || tNode.isIntegral() || tNode.isLimit()) && (tNode.getFI().getFormula(2) == this.F || tNode.getFI().getFormula(0) == this.F)) {
                this.setEditingFormula(tNode.getFI().getFormula(1));
                return true;
            }
        }
        return false;
    }

    boolean goToLowerFormula() {
        TNode tNode;
        int n = this.F.getCursorPos();
        TNode tNode2 = this.F.TNode(n);
        BasicText basicText = tNode2.getParent();
        if (basicText instanceof Formula && (tNode = ((Formula)basicText).getParent()) != null) {
            if (tNode.isFraction() || tNode.isProduct()) {
                if (tNode.getFI().getFormula(0) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(1));
                    return true;
                }
            } else if (tNode.isRadical()) {
                if (tNode.getFI().getFormula(0) == this.F) {
                    this.setEditingFormula(tNode.getFI().getFormula(1));
                    return true;
                }
            } else if ((tNode.isSum() || tNode.isIntegral() || tNode.isLimit()) && (tNode.getFI().getFormula(2) == this.F || tNode.getFI().getFormula(1) == this.F)) {
                this.setEditingFormula(tNode.getFI().getFormula(0));
                return true;
            }
        }
        return false;
    }

    public void setFormulaColors(TColors tColors) {
        if (this.mainF != null) {
            this.mainF.clearColors();
            this.mainF.setColors(tColors);
        }
    }

    private void moveCursor(boolean bl, boolean bl2, int n) {
        this.eraseCursor();
        if (this.F != null) {
            if ((n == 4 || n == 3) && bl2) {
                switch (n) {
                    case 4: {
                        this.insertSubIndex("");
                        break;
                    }
                    case 3: {
                        this.insertSuperIndex("");
                    }
                }
                if (this.F.segMarked()) {
                    this.F.unmarkSegment();
                    this.updateScreenFromTNode(this.mainFIndex);
                }
            } else if (bl) {
                int n2 = this.F.getCursorPos();
                switch (n) {
                    case 1: {
                        this.moveLeft();
                        break;
                    }
                    case 2: {
                        this.moveRight();
                    }
                }
                if (n2 != this.F.getCursorPos()) {
                    if (!this.F.segMarked()) {
                        this.F.markSegment(n2, this.F.getCursorPos());
                    } else {
                        this.F.updateMarkedSegment();
                    }
                    this.updateScreenFromTNode(this.mainFIndex);
                }
            } else if (bl2) {
                if (this.F.segMarked()) {
                    this.F.unmarkSegment();
                    this.updateScreenFromTNode(this.mainFIndex);
                }
                switch (n) {
                    case 1: {
                        if (this.doEscape()) break;
                        this.moveLeft();
                        break;
                    }
                    case 2: {
                        this.doEscape();
                        if (this.F != null) {
                            this.moveRight();
                            break;
                        }
                        this.moveCursor(false, false, 2);
                        break;
                    }
                    case 3: {
                        this.goToUpperFormula();
                        break;
                    }
                    case 4: {
                        this.goToLowerFormula();
                    }
                }
            } else {
                if (this.F.segMarked()) {
                    this.F.unmarkSegment();
                    this.updateScreenFromTNode(this.mainFIndex);
                }
                switch (n) {
                    case 1: {
                        this.smallMoveLeft();
                        break;
                    }
                    case 2: {
                        this.smallMoveRight();
                        break;
                    }
                    case 3: {
                        this.goToUpperFormula();
                        break;
                    }
                    case 4: {
                        this.goToLowerFormula();
                        break;
                    }
                    case 5: {
                        this.F.setCursorPos(this.F.startOfLine(this.F.getCursorPos()));
                        break;
                    }
                    case 6: {
                        this.F.setCursorPos(this.F.endOfLine(this.F.getCursorPos()));
                    }
                }
            }
        } else {
            int n3;
            int n4 = this.T.getCursorPos();
            int n5 = this.getCursorY();
            switch (n) {
                case 1: {
                    if (n4 <= this.T.firstChar(this.T.begin())) break;
                    this.T.setCursorPos(this.T.prevChar(this.T.getCursorPos()));
                    if (bl2 || !this.T.TNode(this.T.getCursorPos()).isFormula()) break;
                    n3 = this.T.getCursorPos();
                    this.mainF = this.T.TNode(n3).getFI().getFormula(0);
                    this.setActiveFormulaAt(n3, this.mainF, 0, 0);
                    this.moveCursor(false, false, 6);
                    break;
                }
                case 2: {
                    this.T.setCursorPos(this.T.firstChar(this.T.getCursorPos()));
                    if (this.T.getCursorPos() >= this.T.end()) break;
                    if (!bl2 && this.T.TNode(this.T.getCursorPos()).isFormula()) {
                        n3 = this.T.getCursorPos();
                        this.mainF = this.T.TNode(n3).getFI().getFormula(0);
                        this.setActiveFormulaAt(n3, this.mainF, 0, 0);
                        break;
                    }
                    this.T.setCursorPos(this.T.getCursorPos() + 1);
                    break;
                }
                case 3: {
                    if (!this.inVerticalMotion) {
                        this.cursorX = this.T.getX(this, this.T.getCursorPos());
                        this.inVerticalMotion = true;
                    }
                    int n6 = this.T.previousLine(this.T.getCursorPos());
                    this.T.setCursorPos(n6 + this.T.getOffsetOfTNodeAtPixel(this, n6, this.cursorX, false));
                    break;
                }
                case 4: {
                    if (!this.inVerticalMotion) {
                        this.cursorX = this.T.getX(this, this.T.getCursorPos());
                        this.inVerticalMotion = true;
                    }
                    int n7 = this.T.nextLine(this.T.getCursorPos());
                    this.T.setCursorPos(n7 + this.T.getOffsetOfTNodeAtPixel(this, n7, this.cursorX, false));
                    break;
                }
                case 5: {
                    this.T.setCursorPos(this.T.startOfLine(this.T.getCursorPos()));
                    break;
                }
                case 6: {
                    this.T.setCursorPos(this.T.endOfLine(this.T.getCursorPos()));
                }
            }
            if (n4 != this.T.getCursorPos()) {
                if (bl) {
                    if (!this.T.segMarked()) {
                        this.T.markSegment(n4, this.T.getCursorPos());
                    } else {
                        this.T.updateMarkedSegment();
                    }
                    this.updateScreenSegment(Math.min(n4, this.T.segMin()), Math.max(n4, this.T.segMax()));
                } else if (this.T.segMarked()) {
                    n3 = this.T.segMin();
                    int n8 = this.T.segMax();
                    this.T.unmarkSegment();
                    this.updateScreenSegment(n3, n8);
                }
            }
            if (this.mainF == null) {
                if (n5 < this.getCursorY()) {
                    this.callActionListeners("moved_down");
                } else if (n5 > this.getCursorY()) {
                    this.callActionListeners("moved_up");
                }
            }
        }
        this.paintCursor();
    }

    private boolean editNode(int n, int n2) {
        if (this.F != null) {
            TNode tNode;
            int n3 = this.F.getCursorPos();
            int n4 = n3;
            if (!this.F.TNode(n4).isExpr() && n4 > this.F.begin()) {
                --n4;
            }
            if ((tNode = this.F.TNode(n4)).isExpr()) {
                MathEditor mathEditor = new MathEditor(this.parent, this.Tr, tNode.getExpr(), tNode.getDecExpr(), tNode.getFixed());
                mathEditor.display(true, true);
                if (mathEditor.ok) {
                    tNode.setExpr(mathEditor.getExpr());
                    tNode.setDecExpr(mathEditor.getDecExpr());
                    tNode.setFixed(mathEditor.getFixed());
                    this.mainF.calcValues(this.dec, this.fixed, this.aL, this.editing, this.learnerMode);
                    this.updateScreen();
                }
                mathEditor.dispose();
                return true;
            }
        } else {
            TNode tNode = this.T.getTNodeAtPixel(this, n, n2);
            if (tNode != null && tNode.isHyperlink()) {
                tNode.editHyperlink();
                this.updateScreen();
                return true;
            }
        }
        return false;
    }

    private void removeListeners() {
        this.removeKeyListener(this);
    }

    private void addListeners() {
        this.addKeyListener(this);
    }

    public void setUnicodeBase(int n) {
        this.UC_base = (char)(n - 97);
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.updating = true;
        if (!(keyEvent.getKeyChar() < ' ' || keyEvent.getKeyChar() == '/' && this.F != null || keyEvent.getKeyChar() == '_' && this.F != null || keyEvent.getKeyChar() == '^' && this.F != null)) {
            if (keyEvent.getKeyChar() >= 'A' && keyEvent.getKeyChar() < '[' || keyEvent.getKeyChar() >= 'a' && keyEvent.getKeyChar() < '{') {
                this.saveText();
                this.insertChar((char)(keyEvent.getKeyChar() + this.UC_base));
            } else if (keyEvent.getKeyChar() != '\u007f') {
                char c = keyEvent.getKeyChar();
                if (c == '*' && this.por_str != null) {
                    c = this.por_str.charAt(0);
                }
                this.saveText();
                this.insertChar(c);
            }
            if (this.F != null && this.F.getCursorPos() == this.F.end() && keyEvent.getKeyChar() == '(') {
                this.saveText();
                this.insertChar(')');
                this.moveLeft();
            }
        }
        this.updating = false;
    }

    public void saveText() {
        for (int i = this.TBSZ - 1; i >= 0; --i) {
            this.Sa[i + 1] = this.Sa[i];
            this.cposa[i + 1] = this.cposa[i];
        }
        this.cposa[0] = this.T.getCursorPos();
        RTF rTF = new RTF(this.T);
        this.Sa[0] = rTF.toRTF(false);
    }

    public void popText() {
        if (this.Sa[0] != null) {
            this.T = new Text(this.parser);
            RTF.parseRTF(this.Sa[0], this.T);
            this.T.setCursorPos(this.cposa[0]);
            for (int i = 0; i < this.TBSZ - 1; ++i) {
                this.Sa[i] = this.Sa[i + 1];
                this.cposa[i] = this.cposa[i + 1];
            }
            this.Sa[this.TBSZ] = null;
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.updating = true;
        if (keyEvent.getKeyCode() != 38 && keyEvent.getKeyCode() != 40) {
            this.inVerticalMotion = false;
        }
        BasicStr.ShiftOn = keyEvent.isShiftDown();
        BasicStr.CtrlOn = keyEvent.isControlDown();
        boolean bl = keyEvent.isAltDown();
        boolean bl2 = false;
        block0 : switch (keyEvent.getKeyChar()) {
            case '/': 
            case '_': {
                if (this.F == null) break;
                this.saveText();
                bl2 = true;
                this.insertNewFraction();
                break;
            }
            case '^': {
                if (this.F == null) break;
                bl2 = true;
                this.saveText();
                this.insertSuperIndex("");
                break;
            }
            default: {
                switch (keyEvent.getKeyCode()) {
                    case 87: {
                        if (!BasicStr.CtrlOn || this.F == null) break block0;
                        System.out.println(this.F.toString());
                        break block0;
                    }
                    case 81: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                        }
                        bl2 = true;
                        this.insertNewFraction();
                        break block0;
                    }
                    case 70: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                            break block0;
                        }
                        bl2 = true;
                        this.insertNewFraction();
                        break block0;
                    }
                    case 69: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                        }
                        bl2 = true;
                        this.insertExpr("1");
                        break block0;
                    }
                    case 83: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                        }
                        bl2 = true;
                        this.insertSum("", "", "");
                        break block0;
                    }
                    case 82: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                        }
                        bl2 = true;
                        this.insertRadical("", "");
                        break block0;
                    }
                    case 73: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                        }
                        bl2 = true;
                        this.insertIntegral("", "", "");
                        break block0;
                    }
                    case 76: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F == null) {
                            this.insertFormula("");
                        }
                        bl2 = true;
                        this.insertLimit("", "", "");
                        break block0;
                    }
                    case 80: {
                        if (!BasicStr.CtrlOn || this.F == null) break block0;
                        break block0;
                    }
                    case 27: {
                        if (this.F == null) break block0;
                        this.eraseCursor();
                        this.doEscape();
                        this.paintCursor();
                        break block0;
                    }
                    case 10: {
                        if (this.F == null) {
                            this.insertText("\n");
                            this.saveText();
                            this.callActionListeners("moved_down");
                            break block0;
                        }
                        this.callActionListeners("Verify");
                        break block0;
                    }
                    case 37: {
                        this.moveCursor(BasicStr.ShiftOn, BasicStr.CtrlOn, 1);
                        break block0;
                    }
                    case 39: {
                        this.moveCursor(BasicStr.ShiftOn, BasicStr.CtrlOn, 2);
                        break block0;
                    }
                    case 40: {
                        if (BasicStr.CtrlOn) {
                            this.saveText();
                            if (this.F == null) {
                                this.insertFormula("");
                            }
                            bl2 = true;
                            this.insertSubIndex("");
                            break block0;
                        }
                        this.moveCursor(BasicStr.ShiftOn, BasicStr.CtrlOn, 4);
                        break block0;
                    }
                    case 38: {
                        if (BasicStr.CtrlOn) {
                            this.saveText();
                            if (this.F == null) {
                                this.insertFormula("");
                            }
                            bl2 = true;
                            this.insertSuperIndex("");
                            break block0;
                        }
                        this.moveCursor(BasicStr.ShiftOn, BasicStr.CtrlOn, 3);
                        break block0;
                    }
                    case 35: {
                        this.moveCursor(BasicStr.ShiftOn, BasicStr.CtrlOn, 6);
                        break block0;
                    }
                    case 36: {
                        this.moveCursor(BasicStr.ShiftOn, BasicStr.CtrlOn, 5);
                        break block0;
                    }
                    case 127: {
                        this.saveText();
                        if (this.F != null && this.F.segMarked() || this.F == null && this.T.segMarked()) {
                            this.removeMarkedSegment();
                        } else {
                            this.delete();
                        }
                        this.callActionListeners("moved");
                        break block0;
                    }
                    case 8: {
                        this.saveText();
                        if (this.F != null && this.F.segMarked() || this.F == null && this.T.segMarked()) {
                            this.removeMarkedSegment();
                        } else {
                            this.backSpace();
                        }
                        this.callActionListeners("moved_up");
                        break block0;
                    }
                    case 67: {
                        if (this.F != null) {
                            this.saveText();
                            if (BasicStr.CtrlOn) {
                                if (BasicStr.ShiftOn) {
                                    this.insertFraction("", "");
                                    if (this.F.segMarked()) {
                                        bl2 = true;
                                    }
                                } else {
                                    this.F.copy(this);
                                }
                            }
                        } else if (BasicStr.CtrlOn) {
                            this.T.copy(this);
                        }
                        this.callActionListeners("moved");
                        break block0;
                    }
                    case 88: {
                        if (this.F != null) {
                            this.saveText();
                            if (BasicStr.CtrlOn && this.F.segMarked()) {
                                this.copyFormula();
                                this.F.copy(this);
                                this.removeMarkedSegment();
                                this.updateSize();
                            }
                        } else if (BasicStr.CtrlOn && this.T.segMarked()) {
                            this.saveText();
                            this.T.copy(this);
                            this.removeMarkedSegment();
                            this.updateSize();
                        }
                        this.callActionListeners("moved");
                        break block0;
                    }
                    case 90: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.popText();
                        this.updateScreen();
                        break block0;
                    }
                    case 86: {
                        if (!BasicStr.CtrlOn) break block0;
                        this.saveText();
                        if (this.F != null) {
                            if (this.F.segMarked()) {
                                this.removeMarkedSegment();
                            }
                            int n = this.F.getCursorPos();
                            if (this.editing) {
                                int n2 = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                                this.F.paste(this);
                                this.updateComponents();
                                this.updateScreenLineAtTNode(this.mainFIndex);
                                if (this.updateSize(false)) {
                                    this.updateScreen();
                                } else {
                                    this.updateScreenLineAtTNode(this.mainFIndex);
                                    int n3 = this.T.getLineHeightAtTNode(this, this.mainFIndex);
                                    if (n3 > n2) {
                                        this.scrollFromTNode(this.mainFIndex, n2 - n3);
                                    }
                                    this.updateScreenLineAtTNode(this.T.nextLine(this.mainFIndex));
                                }
                            }
                        } else {
                            if (this.T.segMarked()) {
                                this.removeMarkedSegment();
                            }
                            int n = this.T.getCursorPos();
                            this.T.paste(this);
                            this.updateComponents();
                            this.updateScreenFromTNode(n);
                            if (this.updateSize()) {
                                this.updateScreen();
                            }
                        }
                        this.callActionListeners("moved");
                    }
                }
            }
        }
        if (bl2 && this.F.segMarked()) {
            this.F.unmarkSegment();
            this.updateScreenFromTNode(this.mainFIndex);
        }
        this.updating = false;
        this.updateSelectors();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        BasicStr.CtrlOn = false;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.falseDrag = false;
        this.dragged = false;
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.F != null) {
            int n = this.F.getIndexOfTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY());
            if (this.isEditing() && this.F.segMarked() && this.F.segMin() <= n && n <= this.F.segMax()) {
                this.mousePressedWhileEditing = true;
                this.point = mouseEvent.getComponent().getLocationOnScreen();
                this.F.copy(this);
            } else {
                this.doMousePressed(mouseEvent.getX(), mouseEvent.getY());
            }
        } else {
            int n = this.T.getIndexOfTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY());
            if (this.isEditing() && this.T.segMarked() && this.T.segMin() <= n && n <= this.T.segMax()) {
                this.mousePressedWhileEditing = true;
                this.point = mouseEvent.getComponent().getLocationOnScreen();
            } else {
                this.doMousePressed(mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    public void doMousePressed(int n, int n2) {
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (!this.hasFocus) {
            this.requestFocus();
        }
        if (this.isEditing()) {
            Formula formula;
            this.eraseCursor();
            this.unmarkSegment();
            this.setCursorPos(n, n2);
            this.T.markSegment(this.T.getCursorPos(), this.T.getCursorPos());
            if (this.F != null && (formula = this.F.getFormulaAt(n, n2)) != null) {
                this.setActiveFormulaAt(this.mainFIndex, formula, n, n2);
                formula.markSegment(formula.getCursorPos(), formula.getCursorPos());
            }
            this.paintCursor();
            this.updateSelectors();
            this.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.falseDrag = true;
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.F != null) {
            if (this.mousePressedWhileEditing) {
                this.mousePressedWhileEditing = false;
                if (this.dragged) {
                    boolean bl;
                    this.dragged = false;
                    Point point = this.getLocationOnScreen();
                    int n = this.point.x + mouseEvent.getX() - point.x;
                    int n2 = this.point.y + mouseEvent.getY() - point.y;
                    boolean bl2 = bl = 0 <= n && n < this.getSize().width && 0 <= n2 && n2 < this.getSize().height;
                    if (bl && this.F.segMarked()) {
                        Formula formula;
                        Formula formula2 = this.F;
                        int n3 = this.F.segMin();
                        int n4 = this.F.segMax();
                        this.doMousePressed(n, n2);
                        if (this.F != null && (formula = this.F.getFormulaAt(n, n2)) != null) {
                            if (!mouseEvent.isControlDown()) {
                                formula2.remove(n3, n4);
                            }
                            formula.paste(this);
                            this.updateComponents();
                            this.updateSize();
                            this.updateScreen();
                            this.updateScreen();
                        }
                    }
                    this.unmarkSegment();
                    this.point = null;
                    return;
                }
                this.point = null;
                this.eraseCursor();
                this.unmarkSegment();
                this.setCursorPos(mouseEvent.getX(), mouseEvent.getY());
                if (this.F != null) {
                    this.F.markSegment(this.F.getCursorPos(), this.F.getCursorPos());
                }
                this.paintCursor();
                this.updateSelectors();
                this.requestFocus();
                return;
            }
        } else if (this.mousePressedWhileEditing) {
            this.mousePressedWhileEditing = false;
            if (this.dragged) {
                boolean bl;
                this.dragged = false;
                Point point = this.getLocationOnScreen();
                int n = this.point.x + mouseEvent.getX() - point.x;
                int n5 = this.point.y + mouseEvent.getY() - point.y;
                boolean bl3 = bl = 0 <= n && n < this.getSize().width && 0 <= n5 && n5 < this.getSize().height;
                if (bl) {
                    this.T.copy(this);
                    int n6 = this.T.segMin();
                    int n7 = this.T.segMax();
                    this.doMousePressed(n, n5);
                    if (!mouseEvent.isControlDown()) {
                        this.T.remove(n6, n7);
                    }
                    n6 = Math.min(n6, this.T.getCursorPos());
                    this.T.paste(this);
                    this.updateScreenFromTNode(n6);
                    if (this.updateSize(false)) {
                        this.updateScreen();
                    }
                } else {
                    this.unmarkSegment();
                }
                this.point = null;
                return;
            }
            this.point = null;
            this.eraseCursor();
            this.unmarkSegment();
            this.setCursorPos(mouseEvent.getX(), mouseEvent.getY());
            this.T.markSegment(this.T.getCursorPos(), this.T.getCursorPos());
            this.paintCursor();
            this.updateSelectors();
            this.requestFocus();
            return;
        }
    }

    protected void activateButtons() {
        String string = "";
        string = this.F != null ? "ActivateFormulaButtons" : "ActivateTextButtons";
        this.callActionListeners(string, 1001);
    }

    protected void setActiveFormulaAt(int n, Formula formula, int n2, int n3) {
        if (this.F != null) {
            this.F.setActive(false);
        }
        this.F = formula;
        this.mainFIndex = n;
        if (this.F != null) {
            this.F.setActive(true);
            this.setCursorPosInFormula(n2, n3);
        }
        this.activateButtons();
    }

    protected void setEditingFormula(Formula formula) {
        this.setActiveFormulaAt(this.mainFIndex, formula, 0, 0);
    }

    protected void selectWordAt(int n) {
        if (this.F != null) {
            this.F.markSegment(this.F.begin(), this.F.end());
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            int n2 = n;
            if (!this.T.TNode(n).isWordSeparator()) {
                int n3;
                for (n3 = n; n3 > this.T.begin() && !this.T.TNode(n3 - 1).isWordSeparator(); --n3) {
                }
                while (n3 < n && !this.T.TNode(n3).isChar()) {
                    ++n3;
                }
                while (n2 < this.T.end() && !this.T.TNode(n2 + 1).isWordSeparator()) {
                    ++n2;
                }
                while (n2 > n && !this.T.TNode(n2).isChar()) {
                    --n2;
                }
                this.T.markSegment(n3, n2 + 1);
                this.updateScreen();
                for (int i = n3; i <= n2; ++i) {
                    if (!this.T.TNode(i).isFormula()) continue;
                    Parser.analyseEquation(new Parser(1), this.T.TNode(i).getFI().getFormula(0).toExpresion(true));
                }
            }
        }
    }

    protected void selectLineAt(int n) {
        if (this.F != null) {
            this.mainF.markSegment(this.mainF.begin(), this.mainF.end());
            this.updateScreenFromTNode(this.mainFIndex);
        } else {
            int n2 = n;
            if (!this.T.TNode(n).isLineSeparator()) {
                int n3;
                for (n3 = n; n3 > this.T.begin() && !this.T.TNode(n3 - 1).isLineSeparator(); --n3) {
                }
                while (n2 < this.T.end() && !this.T.TNode(n2 + 1).isLineSeparator()) {
                    ++n2;
                }
                this.T.markSegment(n3, n2 + 1);
                this.updateScreen();
            }
        }
    }

    protected void paintCursor() {
        try {
            if (this.isEditing() && this.hasTheFocus() && !this.T.segMarked()) {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                TFont.setAntialias(graphics2D, true);
                if (graphics2D != null) {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    TFont tFont;
                    int n6 = 2;
                    if (this.F != null) {
                        tFont = this.F.getTFont();
                        graphics2D.setColor(Formula.formulaCursorColor);
                        n5 = this.F.getX(this, this.F.getCursorPos());
                        n4 = this.F.getY(this, this.F.getCursorPos());
                        n4 = this.F.getLocation().y;
                        n3 = Math.min(tFont.getAscent(), this.F.getLineAscentAtTNode(this, this.F.getCursorPos()));
                        n2 = Math.min(tFont.getDescent(), this.F.getLineDescentAtTNode(this, this.F.getCursorPos()));
                        n = n4;
                    } else {
                        tFont = this.T.getTFontAtTNode(this.T.getCursorPos());
                        graphics2D.setColor(this.T.getColorsAtTNode(this.T.getCursorPos()).getTextColor());
                        n5 = this.T.getX(this, this.T.getCursorPos());
                        n4 = this.T.getY(this, this.T.getCursorPos());
                        n = this.T.getY(this, this.T.getCursorPos());
                        n3 = tFont.getAscent();
                        n2 = tFont.getDescent();
                    }
                    if (tFont.isBold()) {
                        n6 = 3;
                    }
                    --n5;
                    int n7 = n3 + n2;
                    int n8 = n - n3;
                    int n9 = n + n2;
                    if (tFont.isItalic()) {
                        int n10;
                        int n11 = (int)Math.round((double)n5 + (double)n3 / 4.5);
                        int n12 = n10 = (int)Math.round((double)n5 - (double)n2 / 4.5);
                        int n13 = n11 + n6;
                        Polygon polygon = new Polygon();
                        polygon.addPoint(n11, n8);
                        polygon.addPoint(n11 + n6, n8);
                        polygon.addPoint(n10 + n6, n9);
                        polygon.addPoint(n10, n9);
                        graphics2D.fillPolygon(polygon);
                        this.cX = n12;
                        this.cY = n8;
                        this.cW = 1 + n13 - n12;
                        this.cH = 1 + n9 - n8;
                    } else {
                        this.cX = n5;
                        this.cY = n4 - n3;
                        this.cW = 1 + n6;
                        this.cH = 1 + n7;
                        graphics2D.fillRect(n5, n4 - n3, n6, n7);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void eraseCursor() {
        Graphics graphics = this.getGraphics();
        if (graphics != null && this.isEditing()) {
            graphics.setClip(this.cX, this.cY, this.cW, this.cH);
            graphics.drawImage(this.buffer, 0, 0, this);
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    public void run() {
        this.pleaseStop = false;
        try {
            while (!this.pleaseStop()) {
                Thread.sleep(200L);
                if (!this.pleaseStop()) {
                    boolean bl = this.isUpdating();
                    if (!bl) {
                        this.paintCursor();
                    }
                    for (int i = 0; i < 10; ++i) {
                        Thread.sleep(50L);
                        if (this.pleaseStop()) break;
                    }
                    if (!this.pleaseStop()) {
                        if (bl) continue;
                        this.eraseCursor();
                        continue;
                    }
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.thr = null;
    }

    protected void updateCursorThread() {
        if (this.isEditing()) {
            if (this.thr == null) {
                this.thr = new Thread(this);
                this.thr.start();
            }
        } else {
            this.stop();
        }
    }

    private boolean isUpdating() {
        return this.updating;
    }

    private boolean pleaseStop() {
        return this.pleaseStop;
    }

    private boolean isRunning() {
        return this.thr != null;
    }

    @Override
    public void stop() {
        this.pleaseStop = true;
        super.stop();
        while (this.isRunning()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public boolean doubleClickUsed() {
        return this.dblclkusd;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.isEditing()) {
            if (mouseEvent.getClickCount() == 2 || mouseEvent.getClickCount() == 1 && BasicStr.CtrlOn) {
                this.dblclckmillis = System.currentTimeMillis();
                this.dblclkusd = false;
                if (this.editNode(mouseEvent.getX(), mouseEvent.getY())) {
                    this.dblclkusd = true;
                } else {
                    TNode tNode = this.T.getTNodeAtPixel(this, mouseEvent.getX(), mouseEvent.getY());
                    if (tNode != null) {
                        this.dblclckpos = this.getCursorPos();
                        this.selectWordAt(this.dblclckpos);
                        this.dblclkusd = this.T.segMarked();
                    }
                }
                BasicStr.CtrlOn = false;
            } else if (mouseEvent.getClickCount() == 1) {
                if (System.currentTimeMillis() < this.dblclckmillis + 500L && this.dblclckpos == this.getCursorPos()) {
                    this.selectLineAt(this.getCursorPos());
                }
                this.dblclckmillis = -1L;
                this.dblclckpos = -1;
            }
        } else if (this.F != null || this.A == null) {
            Node node;
            if (mouseEvent.getClickCount() == 1) {
                Formula formula;
                if (this.mainF != null && (formula = this.mainF.getFormulaAt(mouseEvent.getX(), mouseEvent.getY())) != null) {
                    this.mainF.unmarkSegment();
                    if (mouseEvent.getModifiers() == 4) {
                        this.F = formula;
                        this.F.markSegment(this.F.begin(), this.F.end());
                        this.updateScreen();
                        this.callActionListeners("right_click");
                    } else {
                        Node node2;
                        Node node3 = formula.getNode();
                        if (node3 != null && this.mainF.getNode() != null && (node3.isVar() || node3.isUnaryOp() && node3.getRight()[0].isVar()) && (node2 = this.mainF.getNode().getParent(node3)) != null && node2.F != null) {
                            if (node2.isUnaryOp() && node3.isVar() && this.mainF.getNode().getParent(node2) != null && this.mainF.getNode().getParent((Node)node2).F != null) {
                                node2 = this.mainF.getNode().getParent(node2);
                            }
                            formula = node2.F;
                        }
                        this.F = formula;
                        if (this.F != null) {
                            this.callActionListeners("single_click");
                            this.mainF.unmarkSegment();
                            formula = this.mainF.getFormulaAt(mouseEvent.getX(), mouseEvent.getY());
                            if (formula != null) {
                                node3 = formula.getNode();
                                if (node3 != null && this.mainF.getNode() != null && (node3.isVar() || node3.isUnaryOp() && node3.getRight()[0].isVar()) && (node2 = this.mainF.getNode().getParent(node3)) != null && node2.F != null) {
                                    if (node2.isUnaryOp() && node3.isVar() && this.mainF.getNode().getParent(node2) != null && this.mainF.getNode().getParent((Node)node2).F != null) {
                                        node2 = this.mainF.getNode().getParent(node2);
                                    }
                                    formula = node2.F;
                                }
                                this.F = formula;
                            }
                            this.F.markSegment(this.F.begin(), this.F.end());
                            this.updateScreen();
                        }
                    }
                }
            } else if ((mouseEvent.getClickCount() == 2 || BasicStr.CtrlOn && mouseEvent.getClickCount() == 1) && this.F != null && (node = this.F.getNode()) != null) {
                this.callActionListeners("double_click");
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        if (this.isEditing()) {
            this.setCursor(Cursor.getPredefinedCursor(2));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.setCursor(null);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.falseDrag) {
            return;
        }
        if (this.mch != null && this.mch.isHand()) {
            return;
        }
        this.dragged = true;
        if (this.mousePressedWhileEditing) {
            return;
        }
        if (this.isEditing()) {
            if (this.F != null) {
                this.setCursorPosInFormula(mouseEvent.getX(), mouseEvent.getY());
                if (this.F.segEnd() != this.F.getCursorPos()) {
                    this.F.markSegment(this.F.segBegin(), this.F.getCursorPos());
                    this.updateScreenLineAtTNode(this.mainFIndex);
                }
            } else {
                int n = Math.max(this.T.segBegin(), this.T.segEnd());
                this.setCursorPosInText(mouseEvent.getX(), mouseEvent.getY());
                if (this.T.segEnd() != this.T.getCursorPos()) {
                    this.T.markSegment(this.T.segBegin(), this.T.getCursorPos());
                    this.updateScreenSegment(this.T.segMin(), Math.max(this.T.segMax(), n));
                }
            }
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.isEnabled()) {
            this.callActionListeners("focus", 1001);
            this.hasFocus = true;
            if (this.F != null) {
                this.F.setActive(true);
                this.updateScreenFromTNode(this.mainFIndex);
            }
            this.updateCursorThread();
            this.paintCursor();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.isEnabled()) {
            this.eraseCursor();
            this.hasFocus = false;
            if (this.F != null) {
                this.F.setActive(false);
                this.updateScreenFromTNode(this.mainFIndex);
            }
        }
    }

    boolean hasTheFocus() {
        return this.hasFocus;
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        if (this.updateSize(false)) {
            this.updateScreen();
        }
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.updateSize(false)) {
            this.updateScreen();
        }
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }
}

