/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.lang.translator;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.RTF;
import com.mja.text.Text;
import com.mja.util.BasicStr;
import com.mja.util.TFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;

public class MathText {
    private Text T;
    private translator Tr;
    private Node decimals;
    private boolean fixed;

    public MathText(Parser parser, translator translator2, String string, Node node, boolean bl, Font font, Color color) {
        this.Tr = translator2;
        this.T = new Text(parser, new TFont(font.getName(), font.getStyle(), font.getSize()), null, color);
        RTF.parseRTF(MathText.DescartesToRTF(font, string), this.T);
        this.T.setLeftMargin(3);
        this.T.setTopAndBottomMargin(0);
        this.decimals = node;
        this.fixed = bl;
    }

    public void setColors(Color color, Color color2) {
        this.T.setColors(color, color2);
    }

    public int ancho(Component component) {
        return this.T.getWidth(component);
    }

    public int alto(Component component) {
        return this.T.getHeight(component);
    }

    public int getAscent(Component component) {
        return this.T.getY(component, 0);
    }

    public String toRTF(boolean bl) {
        RTF rTF = new RTF(this.T);
        String string = rTF.toRTF(bl);
        return string;
    }

    public String toTeX() {
        RTF rTF = new RTF(this.T);
        String string = rTF.toTeX();
        return string;
    }

    public static String DescartesToRTF(Font font, String string) {
        if (string.startsWith("{\\rtf1")) {
            return string;
        }
        String string2 = "{\\rtf1\\uc0 \n";
        string2 = string2 + "{\\fonttbl\\f0\\fcharset0 " + RTF.WfontName(font.getName()) + ";}\n";
        string2 = string2 + "\\f0\\fs" + font.getSize() * 2;
        if (font.isBold()) {
            string2 = string2 + "\\b";
        }
        if (font.isItalic()) {
            string2 = string2 + "\\i";
        }
        string2 = string2 + " " + MathText.parseSquareBrackets(BasicStr.replace(string, "\\n", "\n"));
        string2 = string2 + "\n}";
        return string2;
    }

    public static String parseSquareBrackets(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            char c;
            if ((c = string.charAt(n2++)) == '[') {
                if (n == 0) {
                    stringBuffer.append("{\\*\\mjaformula{\\expr ");
                } else {
                    stringBuffer.append('[');
                }
                ++n;
                continue;
            }
            if (c == ']') {
                if (n == 1) {
                    stringBuffer.append("}}");
                } else {
                    stringBuffer.append(']');
                }
                if (--n >= 0) continue;
                n = 0;
                new Exception(string + "\ntoo many ] ").printStackTrace();
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("\\par ");
                continue;
            }
            if (c == '\\' && n2 < string.length()) {
                c = string.charAt(n2++);
            }
            RTF.appendAsChar(stringBuffer, c);
        }
        return new String(stringBuffer);
    }

    public void draw(Component component, int n, int n2, Graphics[] graphicsArray) {
        if (component instanceof Container) {
            this.draw((Container)component, n, n2, graphicsArray);
        }
    }

    private void draw(Container container, int n, int n2, Graphics[] graphicsArray) {
        int n3 = 2;
        if (BasicStr.classExists("com.mja.parser.Node") && this.decimals != null) {
            n3 = (int)Math.round(this.decimals.Evaluate(2.0));
        }
        this.T.calcValues(n3, this.fixed, this.Tr.getActiveLanguage(), false, false);
        this.T.setLeftMargin(n);
        this.T.setTopAndBottomMargin(n2);
        for (int i = 0; i < graphicsArray.length; ++i) {
            this.T.drawSegment(graphicsArray[i], container, false, this.T.firstLine(), this.T.end(), false);
        }
    }
}

