/*
 * Decompiled with CFR 0.152.
 */
package com.mja.text;

import com.mja.file.mjaFont;
import com.mja.parser.Node;
import com.mja.parser.Parser;
import com.mja.text.BasicText;
import com.mja.text.FormulaItem;
import com.mja.text.RTF;
import com.mja.text.TColors;
import com.mja.text.TNode;
import com.mja.text.Text;
import com.mja.util.LiveOrDie;
import com.mja.util.TFont;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.Vector;

public class Formula
extends Text {
    public static boolean drawBox = true;
    TNode parent;
    private boolean active;
    private boolean assisted;
    private Node Fnode;
    private static final int min_font_size = 11;
    private int x0;
    private int x1;
    private int x2;
    private int x3;
    private int xe;
    private int y0;
    private int A;
    private int D;
    private int W;
    public static double sixp = 0.66;
    public static double ixp = 0.8;
    public static double frp = 0.9;
    public static boolean useMinFont = true;
    private int posX;
    private int posY;
    private FontMetrics fm;
    private static final Color exprBC = new Color(0xFFFFAA);
    public static final Color formulaCursorColor = new Color(-790816720, true);
    private static final Color lightLineColor = new Color(1893537840, true);

    public Formula(Parser parser) {
        super(parser);
    }

    public Formula(Parser parser, TFont tFont) {
        super(parser, tFont);
    }

    public Formula(Parser parser, TFont tFont, Color color, Color color2) {
        super(parser, tFont, color, color2);
    }

    public void setAssisted(boolean bl) {
        this.assisted = bl;
        int n = this.begin();
        int n2 = this.end();
        for (int i = n; i < n2; ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar() || tNode.getFI() == null) continue;
            FormulaItem formulaItem = tNode.getFI();
            formulaItem.setAssisted(this.assisted);
        }
    }

    public boolean isAssisted() {
        return this.assisted;
    }

    public TNode getParent() {
        return this.parent;
    }

    public void setNode(Node node) {
        this.Fnode = node;
    }

    public Node getNode() {
        return this.Fnode;
    }

    public Formula subFormulaWithNode(Node node) {
        if (this.getNode() != null) {
            Formula formula;
            if (this.getNode() == node) {
                return this;
            }
            if (this.getNode().getLeft() != null && this.getNode().getLeft().F != null && (formula = this.getNode().getLeft().F.subFormulaWithNode(node)) != null) {
                return formula;
            }
            if (this.getNode().getRight() != null && this.getNode().getRight()[0] != null && this.getNode().getRight()[0].F != null && (formula = this.getNode().getRight()[0].F.subFormulaWithNode(node)) != null) {
                return formula;
            }
        }
        return null;
    }

    public static Formula makeFormulaFromBuffer(Formula formula, Vector vector) {
        Formula formula2 = new Formula(formula.parser, formula.getTFont(), formula.getColors().getBackColor(), formula.getColors().getTextColor());
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                formula2.insert(((TNode)vector.elementAt(i)).cloneTNode(formula), formula2.getCursorPos());
            }
        }
        return formula2;
    }

    public void insertSuperIndex(String string) {
        this.insert(new TNode((BasicText)this, string, 7), this.getCursorPos());
    }

    public void insertSuperIndex(Formula formula) {
        this.insert(new TNode((BasicText)this, formula, 7), this.getCursorPos());
    }

    public void insertSubIndex(String string) {
        this.insert(new TNode((BasicText)this, string, 6), this.getCursorPos());
    }

    void insertSubIndex(Formula formula) {
        this.insert(new TNode((BasicText)this, formula, 6), this.getCursorPos());
    }

    public void insertSum(String string, String string2, String string3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2, string3), 8), this.getCursorPos());
    }

    public void insertSum(Formula formula, Formula formula2, Formula formula3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2, formula3), 8), this.getCursorPos());
    }

    public void insertIntegral(String string, String string2, String string3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2, string3), 9), this.getCursorPos());
    }

    public void insertIntegral(Formula formula, Formula formula2, Formula formula3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2, formula3), 9), this.getCursorPos());
    }

    public void insertLimit(String string, String string2, String string3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2, string3), 10), this.getCursorPos());
    }

    public void insertLimit(Formula formula, Formula formula2, Formula formula3) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2, formula3), 10), this.getCursorPos());
    }

    public void insertMatrix(String[][] stringArray) {
        this.insert(new TNode((BasicText)this, stringArray.length, stringArray[0].length, new FormulaItem(this.getParser(), stringArray)), this.getCursorPos());
    }

    public void insertMatrix(Formula[][] formulaArray) {
        this.insert(new TNode((BasicText)this, formulaArray.length, formulaArray[0].length, new FormulaItem(formulaArray)), this.getCursorPos());
    }

    public void insertDefParts(String[] stringArray) {
        this.insert(new TNode((BasicText)this, stringArray.length, new FormulaItem(this.getParser(), stringArray)), this.getCursorPos());
    }

    public void insertDefParts(Formula[] formulaArray) {
        this.insert(new TNode((BasicText)this, formulaArray.length, new FormulaItem(formulaArray)), this.getCursorPos());
    }

    public void insertExpr(String string, String string2, boolean bl) {
        TNode tNode = new TNode((BasicText)this, this.parser, string);
        if (string2 != null && string2.length() > 0) {
            tNode.setDecExpr(string2);
            tNode.setFixed(bl);
        }
        this.insert(tNode, this.getCursorPos());
    }

    public void insertRadical(String string, String string2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.getParser(), string, string2), 5), this.getCursorPos());
    }

    public void insertRadical(Formula formula, Formula formula2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2), 5), this.getCursorPos());
    }

    public void insertSqrt(Formula formula) {
        this.insert(new TNode((BasicText)this, new FormulaItem(new Formula(this.getParser()), formula), 5), this.getCursorPos());
    }

    public void insertFraction(String string, String string2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(this.parser, string, string2), 4), this.getCursorPos());
    }

    public void insertFraction(Formula formula, Formula formula2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2), 4), this.getCursorPos());
    }

    public void insertProduct(Formula formula, Formula formula2) {
        this.insert(new TNode((BasicText)this, new FormulaItem(formula, formula2), 14), this.getCursorPos());
    }

    public void insertFormula(Formula formula, boolean bl) {
        if (bl) {
            this.insert(new TNode((BasicText)this, formula, 13), this.getCursorPos());
        } else {
            for (int i = formula.begin(); i < formula.end(); ++i) {
                this.insert(formula.TNode(i), this.getCursorPos());
            }
        }
    }

    @Override
    public void removeMarkedSegment() {
        this.removeSegment(this.segMin(), this.segMax());
    }

    public void removeSegment(int n, int n2) {
        if (this.segMarked()) {
            TColors tColors = this.getColorsAtTNode(n2);
            TFont tFont = this.getTFontAtTNode(this.segMax());
            this.remove(n, n2);
            this.insertColors(tColors, false);
            this.insertTFont(tFont, false);
        }
        this.unmarkSegment();
    }

    int getAscent() {
        int n = this.getTFont().getAscent();
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar()) continue;
            n = Math.max(n, tNode.getAscent(this.getTFont()));
        }
        return n;
    }

    int getDescent() {
        int n = this.getTFont().getDescent();
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar()) continue;
            n = Math.max(n, tNode.getDescent(this.getTFont()));
        }
        return n;
    }

    public Formula getFormulaAt(int n, int n2) {
        if (this.contains(n, n2)) {
            Formula formula = null;
            for (int i = this.begin(); formula == null && i < this.end(); ++i) {
                TNode tNode = this.TNode(i);
                if (tNode.getFI() == null) continue;
                for (int j = 0; j < tNode.getFI().size() && (formula = tNode.getFI().getFormula(j).getFormulaAt(n, n2)) == null; ++j) {
                }
            }
            if (formula != null) {
                return formula;
            }
            return this;
        }
        return null;
    }

    int getHeight() {
        return this.getAscent() + this.getDescent();
    }

    @Override
    public int getIndexOfTNodeAtPixel(Component component, int n, int n2) {
        int n3 = this.getOffsetOfTNodeAtPixel(component, 0, n);
        return this.firstChar(n3);
    }

    public int getOffsetOfTNodeAtPixel(Component component, int n, int n2) {
        int n3;
        int n4 = n3 = this.begin();
        int n5 = this.x0;
        while (n4 < this.end() && !this.TNode(n4).isEndOfLine() && (double)n5 + 2.0 * (double)this.getCharWidthAtTNode(component, n4, true) / 3.0 < (double)n2) {
            n5 += this.getCharWidthAtTNode(component, n4++, true);
        }
        return n4 - n3;
    }

    public int getFormulaWidth(Component component) {
        TFont tFont = this.getTFont();
        int n = 0;
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar()) continue;
            n += tNode.getCharWidth(tFont, component, true);
        }
        return Math.max(n, tFont.getMjaFont().stringWidth(component, " "));
    }

    public int getStringWidth(Component component, String string) {
        TNode tNode = new TNode((BasicText)this, string);
        return tNode.getCharWidth(this.getTFont(), component, true);
    }

    @Override
    public int getX(Component component, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar()) continue;
            n2 += tNode.getCharWidth(this.getTFont(), component, true);
        }
        return this.x0 + n2;
    }

    public int getY() {
        return this.y0;
    }

    boolean contains(int n, int n2) {
        if (this.parent.isFraction()) {
            int n3 = this.parent.getFI().getFormula((int)0).W;
            int n4 = this.parent.getFI().getFormula((int)1).W;
            int n5 = Math.max(n3, n4);
            int n6 = (n5 - this.W) / 2;
            return this.posX - n6 <= n && n < this.posX - n6 + n5 && this.posY - this.A <= n2 && n2 < this.posY + this.D;
        }
        return this.posX <= n && n < this.posX + this.W && this.posY - this.A <= n2 && n2 < this.posY + this.D;
    }

    @Override
    public void calcValues(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            tNode.calcValues(n, bl, n2, bl2, bl3);
        }
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    void calcAndSetFonts(TFont tFont) {
        this.setFonts(tFont);
        if (useMinFont) {
            double d = 1.0;
            int n = 1;
            while (this.getMinFontSize() < 11) {
                TFont tFont2 = new TFont(tFont.getName(), tFont.getStyle(), tFont.getSize() + n++);
                this.setFonts(tFont2);
            }
        }
    }

    void draw(Graphics2D graphics2D, Container container, TFont tFont, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.locateToFindOrDraw(container, n, n2, true);
        graphics2D.setColor(this.getColors().getTextColor());
        this.doDraw(graphics2D, container, bl, bl2, bl3, bl4);
    }

    int getMinFontSize() {
        int n = this.getTFont().getSize();
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar() || tNode.getFI() == null) continue;
            FormulaItem formulaItem = tNode.getFI();
            for (int j = 0; j < formulaItem.size(); ++j) {
                n = Math.min(n, formulaItem.getFormula(j).getMinFontSize());
            }
        }
        return n;
    }

    @Override
    public boolean updateNodes(Component component, String string) {
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!(tNode.isChar() && tNode.getFI() != null ? tNode.getFI().updateNodes(component, string) : tNode.updateComponent(component, string))) continue;
            return true;
        }
        return false;
    }

    public void setFonts(TFont tFont) {
        this.setTFont(tFont);
        int n = this.begin();
        int n2 = this.end();
        for (int i = n; i < n2; ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar() || tNode.getFI() == null) continue;
            FormulaItem formulaItem = tNode.getFI();
            if (tNode.isSubIndex()) {
                formulaItem.getFormula(0).setFonts(tFont.scale(sixp));
                continue;
            }
            if (tNode.isSuperIndex()) {
                formulaItem.getFormula(0).setFonts(tFont.scale(sixp));
                continue;
            }
            if (tNode.isFormula()) {
                formulaItem.getFormula(0).setFonts(tFont);
                continue;
            }
            if (tNode.isFraction()) {
                formulaItem.getFormula(0).setFonts(tFont.scale(frp));
                formulaItem.getFormula(1).setFonts(tFont.scale(frp));
                continue;
            }
            if (tNode.isProduct()) {
                formulaItem.getFormula(0).setFonts(tFont.scale(frp));
                formulaItem.getFormula(1).setFonts(tFont.scale(frp));
                continue;
            }
            if (tNode.isRadical()) {
                formulaItem.getFormula(0).setFonts(tFont.scale(ixp));
                formulaItem.getFormula(1).setFonts(tFont);
                continue;
            }
            if (tNode.isSum() || tNode.isIntegral() || tNode.isLimit()) {
                formulaItem.getFormula(0).setFonts(tFont.scale(ixp));
                formulaItem.getFormula(1).setFonts(tFont.scale(ixp));
                formulaItem.getFormula(2).setFonts(tFont);
                continue;
            }
            for (int j = 0; j < formulaItem.size(); ++j) {
                formulaItem.getFormula(j).setFonts(tFont);
            }
        }
    }

    public void setColors(TColors tColors) {
        super.setColors(tColors.getBackColor(), tColors.getTextColor());
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            tNode.setColors(this.getColors());
        }
    }

    public void locate(Component component, int n, int n2) {
        this.locateToFindOrDraw(component, n, n2, false);
    }

    public Point getLocation() {
        return new Point(this.posX, this.posY);
    }

    private void locateToFindOrDraw(Component component, int n, int n2, boolean bl) {
        if (bl) {
            this.x0 = n;
            this.y0 = n2;
        } else {
            this.posX = n;
            this.posY = n2;
        }
        this.A = this.getAscent();
        this.D = this.getDescent();
        this.W = this.getFormulaWidth(component);
        TFont tFont = this.getTFont();
        int n3 = this.getTFont().getAscent();
        int n4 = this.getTFont().getDescent();
        int n5 = n3 + n4;
        int n6 = (n3 - n4) / 2;
        int n7 = this.begin();
        int n8 = this.end();
        int n9 = n;
        int n10 = n2;
        for (int i = n7; i < n8; ++i) {
            int n11;
            int n12;
            int n13;
            Formula formula;
            TNode tNode = this.TNode(i);
            if (!tNode.isChar()) continue;
            tNode.setLocation(n9, n10);
            int n14 = tNode.getCharWidth(tFont, component, true);
            Formula formula2 = null;
            if (tNode.getFI() != null) {
                formula2 = tNode.getFI().getFormula(0);
            }
            if (tNode.isSubIndex()) {
                formula2.locateToFindOrDraw(component, n9 + tNode.getdx2(), n10 - n6 + formula2.getAscent(), bl);
            } else if (tNode.isSuperIndex()) {
                formula2.locateToFindOrDraw(component, n9 + tNode.getdx2(), n10 - n6 - formula2.getDescent(), bl);
            } else if (tNode.isFormula()) {
                formula2.locateToFindOrDraw(component, n9 + tNode.getdx2(), n10, bl);
            } else if (tNode.isFraction()) {
                Formula formula3 = tNode.getFI().getFormula(0);
                formula = tNode.getFI().getFormula(1);
                n13 = formula3.getFormulaWidth(component);
                n12 = formula.getFormulaWidth(component);
                n11 = formula3.getDescent();
                int n15 = formula3.getHeight();
                int n16 = formula.getAscent();
                int n17 = formula.getHeight();
                formula3.locateToFindOrDraw(component, n9 + (n14 - n13) / 2, n10 - n6 - n11, bl);
                formula.locateToFindOrDraw(component, n9 + (n14 - n12) / 2, n10 - n6 + n16, bl);
            } else if (tNode.isProduct()) {
                Formula formula4 = tNode.getFI().getFormula(0);
                formula = tNode.getFI().getFormula(1);
                formula4.locateToFindOrDraw(component, n9, n10, bl);
                formula.locateToFindOrDraw(component, n9 + tNode.getdX1() + tNode.getdX2(), n10, bl);
            } else if (tNode.isRadical()) {
                Formula formula5 = tNode.getFI().getFormula(0);
                formula = tNode.getFI().getFormula(1);
                formula5.locateToFindOrDraw(component, n9, n10 - n6 - formula5.getDescent(), bl);
                formula.locateToFindOrDraw(component, n9 + tNode.getX1() + tNode.getdx2(), n10, bl);
            } else if (tNode.isSum()) {
                Formula formula6 = tNode.getFI().getFormula(0);
                formula = tNode.getFI().getFormula(1);
                Formula formula7 = tNode.getFI().getFormula(2);
                formula.locateToFindOrDraw(component, n9 + (tNode.getX1() - formula.getFormulaWidth(component)) / 2, n10 - n3 - formula.getDescent() + 1, bl);
                formula6.locateToFindOrDraw(component, n9 + (tNode.getX1() - formula6.getFormulaWidth(component)) / 2, n10 + n4 + formula6.getAscent() - 2, bl);
                formula7.locateToFindOrDraw(component, n9 + tNode.getX1(), n10, bl);
            } else if (tNode.isIntegral()) {
                Formula formula8 = tNode.getFI().getFormula(0);
                formula = tNode.getFI().getFormula(1);
                Formula formula9 = tNode.getFI().getFormula(2);
                n12 = tFont.isItalic() ? n5 / 2 : n5 / 6;
                n11 = tFont.isItalic() ? n5 / 6 : n5 / 12;
                formula.locateToFindOrDraw(component, n9 + tNode.getdX2() + 2 + n12, n10 - n3 - formula.getDescent() + 1, bl);
                formula8.locateToFindOrDraw(component, n9 + tNode.getdX2() + 3 - n11, n10 + n4 + formula8.getAscent() - 2, bl);
                formula9.locateToFindOrDraw(component, n9 + tNode.getX1() + 2, n10, bl);
            } else if (tNode.isLimit()) {
                Formula formula10 = tNode.getFI().getFormula(0);
                formula = tNode.getFI().getFormula(1);
                Formula formula11 = tNode.getFI().getFormula(2);
                n12 = Math.max(formula10.getAscent(), formula.getAscent());
                formula10.locateToFindOrDraw(component, n9, n10 + n4 + n12 - 2, bl);
                formula.locateToFindOrDraw(component, n9 + tNode.getdX2(), n10 + n4 + n12 - 2, bl);
                formula11.locateToFindOrDraw(component, n9 + tNode.getX1() + 3, n10, bl);
            } else if (tNode.isMatrix()) {
                for (int j = 0; j < tNode.getFI().size(); ++j) {
                    tNode.getFI().getFormula(j).locateToFindOrDraw(component, n9 + 4 * tNode.getdx2() + j % tNode.getColumns() * ((tNode.getW() - 2 * tNode.getdx2()) / tNode.getColumns()), n10 - n6 + tNode.getMaxA() - tNode.getMatrixHeight() / 2 + j / tNode.getColumns() * (tNode.getMatrixHeight() / tNode.getRows()), bl);
                }
            } else if (tNode.isDefParts()) {
                for (int j = 0; j < tNode.getFI().size(); ++j) {
                    int n18 = n9 + 4 * tNode.getdx2();
                    n13 = tNode.getDefPartsHeight() / tNode.getParts();
                    n12 = n10 - n6 + tNode.getMaxA() - tNode.getDefPartsHeight() / 2 + 5 + j * n13;
                    tNode.getFI().getFormula(j).locateToFindOrDraw(component, n18, n12, bl);
                }
            }
            n9 += n14;
        }
        if (this.segMarked()) {
            this.x1 = this.getX(component, Math.max(n7, this.segMin()));
            this.x2 = this.getX(component, Math.min(n8, this.segMax()));
            if (this.x1 == this.x0) {
                this.x1 -= 2;
            }
            this.x3 = this.getX(component, n8);
        } else {
            this.x1 = this.getX(component, n7);
            this.x2 = this.getX(component, n8);
            this.x3 = this.getX(component, n8);
        }
    }

    boolean hasChar() {
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            if (!tNode.isChar()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHoles(boolean bl) {
        if (bl && !this.hasChar()) {
            return true;
        }
        for (int i = this.begin(); i < this.end(); ++i) {
            TNode tNode = this.TNode(i);
            FormulaItem formulaItem = tNode.getFI();
            if (formulaItem == null) continue;
            if (!formulaItem.hasHoles(tNode.getType() == 5)) continue;
            return true;
        }
        return false;
    }

    protected void updateComponentLocation(Container container, int n) {
        TNode tNode = this.TNode(n);
        if (tNode.isComponent()) {
            int n2;
            TFont tFont = this.getTFont();
            int n3 = tNode.getX() + tNode.getdx2();
            int n4 = this.posY;
            int n5 = tFont.getAscent();
            int n6 = tFont.getDescent();
            int n7 = n5 + n6 - 2;
            Component component = tNode.getComponent();
            int n8 = n2 = component.getSize().width == component.getSize().height ? n7 : component.getSize().width;
            if (n3 != component.getLocation().x || n4 - n5 != component.getLocation().y || component.getSize().width != n2 || component.getSize().height != n7) {
                component.setBounds(n3, n4 - n5, n2, n7);
            }
            if (!(component.getFont() == null || component.getFont().getName().equals(tFont.getName()) && component.getFont().getStyle() == tFont.getStyle() % 4 && component.getFont().getSize() == tFont.getSize())) {
                component.setFont(new Font(tFont.getName(), tFont.getStyle() % 4, tFont.getSize()));
            }
            if (component.getParent() != container) {
                container.add(component);
                component.setVisible(true);
                if (component instanceof LiveOrDie) {
                    ((LiveOrDie)((Object)component)).start();
                }
            }
        }
    }

    void updateComponentLocations(Container container) {
        for (int i = 0; i < this.info.size(); ++i) {
            TNode tNode = this.TNode(i);
            if (tNode.isComponent()) {
                this.updateComponentLocation(container, i);
                continue;
            }
            if (tNode.getFI() == null) continue;
            FormulaItem formulaItem = tNode.getFI();
            for (int j = 0; j < formulaItem.size(); ++j) {
                Formula formula = formulaItem.getFormula(j);
                formula.updateComponentLocations(container);
            }
        }
    }

    public void doDraw(Graphics2D graphics2D, Container container) {
        this.doDraw(graphics2D, container, false, false, false, false);
    }

    void doDraw(Graphics2D graphics2D, Container container, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        int n;
        Color color = graphics2D.getColor();
        TColors tColors = this.getColors();
        color = tColors.getTextColor();
        if (this.segMarked()) {
            graphics2D.setColor(Formula.bestBG(Color.white));
            graphics2D.fillRect(this.x1, this.y0 - this.A, this.x2 - this.x1, this.A + this.D);
        }
        graphics2D.setColor(color);
        for (n = this.begin(); n < this.end(); ++n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            TNode tNode = this.TNode(n);
            if (tNode.isColors()) {
                tColors = tNode.getColors();
                if (tColors == null || tColors.getTextColor() == null) continue;
                color = tColors.getTextColor();
                graphics2D.setColor(color);
                continue;
            }
            if (tNode.isTFont() || !tNode.isChar()) continue;
            boolean bl5 = bl2 || this.segMarked() && this.segMin() <= n && n < this.segMax();
            Formula.fillBack(bl5, graphics2D, tColors, tNode, this.A, this.D);
            if (bl && tNode.isExpr()) {
                graphics2D.setColor(exprBC);
                graphics2D.fillRect(tNode.getX(), tNode.getY() - tNode.getA(), tNode.getW(), tNode.getA() + tNode.getD());
                graphics2D.setColor(color);
            }
            if (bl5) {
                graphics2D.setColor(Formula.bestFG(Color.white));
            } else {
                graphics2D.setColor(color);
            }
            FormulaItem formulaItem = tNode.getFI();
            if (tNode.isFormula() || tNode.isSubIndex() || tNode.isSuperIndex()) {
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                continue;
            }
            if (tNode.isFraction()) {
                Color color2 = graphics2D.getColor();
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                graphics2D.setColor(color2);
                int n7 = tNode.getX() + tNode.getdx2();
                int n8 = tNode.getY() - tNode.gethe();
                n6 = tNode.getX() + tNode.getW() - tNode.getdx2();
                TFont.setAntialias(graphics2D, false);
                graphics2D.drawLine(n7, n8, n6, n8);
                if (this.fm != null && (n5 = this.fm.getHeight()) > 32) {
                    graphics2D.drawLine(n7, n8 + 1, n6, n8 + 1);
                    if (n5 > 45) {
                        graphics2D.drawLine(n7, n8 - 1, n6, n8 - 1);
                        if (n5 > 60) {
                            graphics2D.drawLine(n7, n8 + 2, n6, n8 + 2);
                            if (n5 > 75) {
                                graphics2D.drawLine(n7, n8 - 2, n6, n8 - 2);
                                if (n5 > 90) {
                                    graphics2D.drawLine(n7, n8 + 3, n6, n8 + 3);
                                }
                            }
                        }
                    }
                }
                TFont.setAntialias(graphics2D, this.getTFont());
                continue;
            }
            if (tNode.isRadical()) {
                int n9;
                int n10 = tNode.getX();
                int n11 = tNode.getY();
                int n12 = n10;
                n6 = n10 + tNode.getX1();
                n5 = n6 - tNode.getdX2();
                n4 = (n5 + n6) / 2;
                int n13 = n10 + tNode.getW();
                n2 = n3 = n11 - tNode.gethe() + 1;
                int n14 = n11 + tNode.getD() - 2;
                int n15 = n9 = n11 - formulaItem.getFormula(1).getAscent() - 1;
                Color color3 = graphics2D.getColor();
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, true);
                TFont.setAntialias(graphics2D, true);
                graphics2D.setColor(color3);
                graphics2D.drawLine(n12 + 2, n3, n5 + 1, n2);
                graphics2D.drawLine(n5, n2, n4, n14);
                graphics2D.drawLine(n4, n14, n6, n9);
                graphics2D.drawLine(n6, n9, n13, n15);
                continue;
            }
            if (tNode.isSum()) {
                TFont.setAntialias(graphics2D, true);
                this.getTFont().getMjaFont().drawString(container, graphics2D, "\u2211", tNode.getX() + (tNode.getX1() - tNode.getdX2()) / 2, tNode.getY());
                TFont.setAntialias(graphics2D, this.getTFont());
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                continue;
            }
            if (tNode.isIntegral()) {
                TFont tFont = this.getTFont();
                graphics2D.setFont(tFont.getMjaFont().getAwtFont());
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                TFont.setAntialias(graphics2D, true);
                mjaFont mjaFont2 = tFont.scale(1.2).getMjaFont();
                mjaFont2.drawString(container, graphics2D, "\u222b", tNode.getX(), tNode.getY() + (int)Math.round(0.07 * (double)graphics2D.getFont().getSize()));
                TFont.setAntialias(graphics2D, tFont);
                continue;
            }
            if (tNode.isLimit()) {
                Formula formula = tNode.getFI().getFormula(0);
                Formula formula2 = tNode.getFI().getFormula(1);
                Formula formula3 = tNode.getFI().getFormula(2);
                n6 = formula.x0 + formula.getFormulaWidth(container);
                n5 = formula.y0;
                this.getTFont().getMjaFont().drawString(container, graphics2D, "l\u00edm", n6 + 2, tNode.getY());
                TFont.setAntialias(graphics2D, true);
                this.getTFont().getMjaFont().drawString(container, graphics2D, " \u2192", n6, n5);
                TFont.setAntialias(graphics2D, this.getTFont());
                graphics2D.setFont(this.getTFont().getMjaFont().getAwtFont());
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                continue;
            }
            if (tNode.isMatrix()) {
                int n16 = tNode.getX() + tNode.getdx2();
                int n17 = tNode.getY();
                int n18 = tNode.getW() - 2 * tNode.getdx2();
                n6 = n16;
                n5 = n16 + n18;
                n4 = n17 - tNode.getA() + 4;
                int n19 = n17 + tNode.getD() - 4;
                TFont.setAntialias(graphics2D, false);
                graphics2D.drawLine(n6, n4, n6, n19);
                graphics2D.drawLine(n6, n4, n6 + 2, n4 - 2);
                graphics2D.drawLine(n6, n19, n6 + 2, n19 + 2);
                graphics2D.drawLine(n5, n4, n5, n19);
                graphics2D.drawLine(n5, n4, n5 - 2, n4 - 2);
                graphics2D.drawLine(n5, n19, n5 - 2, n19 + 2);
                TFont.setAntialias(graphics2D, this.getTFont());
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                continue;
            }
            if (tNode.isDefParts()) {
                int n20 = tNode.getX();
                int n21 = tNode.getY();
                int n22 = 4;
                n6 = n20;
                n5 = n21 - tNode.getA() + 4;
                n4 = n21 + tNode.getD() - 4;
                int n23 = (n5 + n4) / 2;
                TFont.setAntialias(graphics2D, true);
                graphics2D.drawLine(n6 + 2 * n22, n5, n6 + n22, n5 + n22);
                graphics2D.drawLine(n6 + n22, n5 + n22, n6 + n22, n23 - n22);
                graphics2D.drawLine(n6 + n22, n23 - n22, n6, n23);
                graphics2D.drawLine(n6, n23, n6 + n22, n23 + n22);
                graphics2D.drawLine(n6 + n22, n23 + n22, n6 + n22, n4 - n22);
                graphics2D.drawLine(n6 + n22, n4 - n22, n6 + 2 * n22, n4);
                TFont.setAntialias(graphics2D, this.getTFont());
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                continue;
            }
            if (tNode.isProduct()) {
                Color color4 = graphics2D.getColor();
                formulaItem.doDraw(graphics2D, container, bl, bl5, bl4, false);
                graphics2D.setColor(color4);
                this.getTFont().getMjaFont().drawString(container, graphics2D, " \u00b7 ", tNode.getX() + tNode.getdX1(), tNode.getY());
                continue;
            }
            TFont.setAntialias(graphics2D, this.getTFont());
            int n24 = tNode.getX() + tNode.getdx2();
            int n25 = tNode.getY();
            int n26 = tNode.getW() - 2 * tNode.getdx2();
            n6 = 2;
            n5 = tNode.getA();
            n4 = tNode.getD();
            if (tNode.isComponent()) {
                Component component = tNode.getComponent();
                if (bl5) {
                    component.setForeground(Formula.bestFG(Color.white));
                    component.setBackground(Color.black);
                } else {
                    component.setForeground(tColors.getTextColor());
                    component.setBackground(null);
                }
                this.updateComponentLocation(container, n);
            } else if (tNode.isChar() && (tNode.getChar().equals("(") || tNode.getChar().equals(")"))) {
                int n27;
                if (tNode.getChar().equals("(")) {
                    n27 = 0;
                    n3 = 1;
                    for (n2 = n + 1; n2 <= this.end(); ++n2) {
                        TNode tNode2 = this.TNode(n2);
                        if (")".equals(tNode2.getChar())) {
                            if (--n3 == 0) {
                                n27 = 1;
                                break;
                            }
                        } else if ("(".equals(tNode2.getChar())) {
                            ++n3;
                        }
                        n5 = Math.max(n5, tNode2.getA());
                        n4 = Math.max(n4, tNode2.getD());
                    }
                } else {
                    n27 = 0;
                    n3 = -1;
                    for (n2 = n - 1; n2 >= this.begin(); --n2) {
                        TNode tNode3 = this.TNode(n2);
                        if ("(".equals(tNode3.getChar())) {
                            if (++n3 == 0) {
                                n27 = 1;
                                break;
                            }
                        } else if (")".equals(tNode3.getChar())) {
                            --n3;
                        }
                        n5 = Math.max(n5, tNode3.getA());
                        n4 = Math.max(n4, tNode3.getD());
                    }
                }
                n27 = n25 - (n5 - n4) / 2;
                n3 = (int)Math.round((double)(n26 * n26 + (n5 + n4) * (n5 + n4)) / (4.0 * (double)n26));
                n2 = (int)Math.round(135.0 * Math.asin((double)(n5 + n4) / (2.0 * (double)n3)) / Math.PI);
                if (tNode.getChar().equals("(")) {
                    graphics2D.drawArc(n24 + n26 / 3, n27 - n3, 2 * n3, 2 * n3, 180 - n2, 2 * n2);
                } else if (tNode.isChar() && tNode.getChar().equals(")")) {
                    graphics2D.drawArc(n24 + 2 * n26 / 3 - 2 * n3, n27 - n3, 2 * n3, 2 * n3, -n2, 2 * n2);
                }
            } else {
                this.getTFont().getMjaFont().drawString(container, graphics2D, tNode.getChar(), n24, n25);
            }
            if (this.getTFont().isUnderline()) {
                graphics2D.drawLine(n24, n25 + n6, n24 + n26 - 1, n25 + n6);
                if (this.getTFont().isBold()) {
                    graphics2D.drawLine(n24, n25 + n6 + 1, n24 + n26 - 1, n25 + n6 + 1);
                }
            }
            if (!this.getTFont().isOverline()) continue;
            graphics2D.drawLine(n24, n25 - n5, n24 + n26 - 1, n25 - n5);
            if (!this.getTFont().isBold()) continue;
            graphics2D.drawLine(n24, n25 - n5 + 1, n24 + n26 - 1, n25 - n5 + 1);
        }
        TFont.setAntialias(graphics2D, false);
        if (bl && drawBox && (this.active || this.getParent() != null && this.getParent().isFormula())) {
            n = 1;
            if (this.getParent().isFormula()) {
                n = 2;
            }
            if (this.getParent() != null) {
                n += this.getParent().getdX1();
            }
            graphics2D.setColor(lightLineColor);
            graphics2D.drawRect(this.x0 - n + 1, this.y0 - this.A + 1, this.W + 2 * n - 2, this.A + this.D - 2);
        }
        graphics2D.setColor(color);
    }

    private static void fillBack(boolean bl, Graphics graphics, TColors tColors, TNode tNode) {
        Formula.fillBack(bl, graphics, tColors, tNode, tNode.getA(), tNode.getD());
    }

    private static void fillBack(boolean bl, Graphics graphics, TColors tColors, TNode tNode, int n, int n2) {
        if (!bl && tColors != null && tColors.getBackColor() != null) {
            graphics.setColor(tColors.getBackColor());
            graphics.fillRect(tNode.getX(), tNode.getY() - n, tNode.getW(), n + n2);
            graphics.setColor(tColors.getTextColor());
        }
    }

    public Formula cloneFormula() {
        RTF rTF = new RTF(this);
        String string = rTF.toRTF(false);
        Formula formula = new Formula(this.getParser(), this.getTFont().cloneTFont(), this.getColors().getBackColor(), this.getColors().getTextColor());
        formula.parser = this.parser;
        RTF.parseRTF(string, formula);
        return formula;
    }

    public String toExpresion(boolean bl) {
        return this.toExpresion(this.begin(), this.end(), bl);
    }

    public String toExpresion(int n, int n2, boolean bl) {
        String string = "";
        boolean bl2 = false;
        boolean bl3 = false;
        String string2 = "";
        int n3 = 0;
        TNode tNode = null;
        for (int i = n; i < n2; ++i) {
            ++n3;
            TNode tNode2 = (TNode)this.info.elementAt(i);
            if (tNode2.isChar() && !tNode2.isWhiteSpace()) {
                String string3 = tNode2.getChar();
                if (tNode2.isAlgebraicToken()) {
                    if (!(!bl2 && (tNode == null || !tNode.isSuperIndex()) || bl3 && tNode2.isNumSymbol() || "(".equals(string2) || ")".equals(string3) || "[".equals(string2) || "]".equals(string3) || string3 != null && string3.startsWith("_"))) {
                        string = string + "*";
                    }
                    bl3 = tNode2.isNumSymbol();
                    bl2 = true;
                    string2 = string3;
                    if (string2 == null) {
                        string2 = "";
                    }
                } else {
                    bl2 = false;
                    bl3 = false;
                    string2 = "";
                }
                string = string + tNode2.toExpresion(bl);
            }
            tNode = tNode2;
        }
        return string;
    }

    private void cleanSigns() {
        TFont tFont = this.getTFont();
        TColors tColors = this.getColors();
        TNode tNode = null;
        for (int i = this.begin(); i < this.end(); ++i) {
            String string;
            TNode tNode2 = this.TNode(i);
            if (tNode != null && tNode.isPureChar() && tNode2.isPureChar() && (string = tNode2.getChar()).startsWith("-") && string.length() > 1) {
                if (tNode.getChar().equals("+")) {
                    tNode.setChar("-");
                    tNode2.setChar(string.substring(1));
                } else if (tNode.getChar().equals("-")) {
                    TNode tNode3 = null;
                    if (i >= this.begin() + 2) {
                        tNode3 = this.TNode(i - 2);
                    }
                    if (tNode3 != null && tNode3.isPureChar() && (tNode3.getChar().equals("=") || tNode3.getChar().equals("("))) {
                        if (!this.removeNode(--i)) {
                            System.out.println("Formula.couldNotRemoveNode " + this.TNode(i).toString());
                        }
                    } else {
                        tNode.setChar("+");
                    }
                    tNode2.setChar(string.substring(1));
                }
            }
            tNode = tNode2;
        }
    }
}

