/*
 * Decompiled with CFR 0.152.
 */
package com.mja.cmpedit;

import com.jla.calc.calcWin;
import com.mja.file.mjaFont;
import com.mja.util.BasicStr;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class mjaLineEditor
extends Canvas
implements Runnable,
KeyListener,
MouseListener,
MouseMotionListener,
FocusListener {
    private int align = 2;
    private int adjust = 1;
    private static String clipboardStr = "";
    private Thread thr;
    private volatile boolean isRunning;
    private volatile boolean pleaseStop;
    private volatile boolean hasTheFocus;
    private volatile boolean mustupdate;
    private volatile boolean mustmove;
    private volatile boolean editable;
    private int width;
    private int height;
    private int points;
    private Font font;
    private FontMetrics fm;
    private int X0 = 0;
    private int Y0 = 0;
    private int xl = 4;
    private int yl = 2;
    private int a;
    private int d;
    private int caret_pos = 0;
    private int decimales = -1;
    private String string = "";
    private int dx = 0;
    private int selection_0;
    private int selection_1;
    private volatile boolean caretOn = false;
    private boolean fijo = false;
    private int calcalfanum = 1;
    private Vector listeners = new Vector();
    private int x0;
    private int x1;
    private int l0;
    private int l1;
    private int mouse_x;
    private int mouse_y;
    private boolean moving;

    public mjaLineEditor(int n, int n2, int n3, boolean bl, int n4, boolean bl2, int n5) {
        this.width = n;
        this.height = n2;
        this.setFont("Serif", 0, n3);
        this.setEditable(bl);
        this.decimales = n4;
        this.fijo = bl2;
        this.calcalfanum = n5;
    }

    public void setDecimals(int n, boolean bl) {
        this.decimales = n;
        this.fijo = bl;
    }

    public void setInitialPoint(int n, int n2) {
        this.X0 = n;
        this.Y0 = n2;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    private void callListeners(String string) {
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    public String getText() {
        return this.string;
    }

    public void setText(String string) {
        this.string = string;
        if (this.decimales >= 0) {
            try {
                double d = Double.parseDouble(string);
                this.string = BasicStr.DoubleToString((double)d, (int)this.decimales, (boolean)this.fijo, (String)".");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.caret_pos = 0;
        this.dx = 0;
        this.selection_0 = 0;
        this.selection_1 = 0;
        this.paintAll(this.getGraphics());
    }

    public void setEditable(boolean bl) {
        if (this.editable) {
            this.removeKeyListener(this);
            this.removeFocusListener(this);
            this.removeMouseListener(this);
            this.removeMouseMotionListener(this);
        }
        this.editable = bl;
        if (this.editable) {
            this.addKeyListener(this);
            this.addFocusListener(this);
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        } else {
            this.hasTheFocus = false;
        }
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setFont(String string, int n, int n2) {
        this.points = n2;
        this.font = mjaFont.makeFont((String)string, (int)n, (int)n2);
        this.fm = this.getFontMetrics(this.font);
        this.a = this.fm.getMaxAscent();
        this.d = this.fm.getMaxDescent();
    }

    public void setFont(Font font) {
        this.setFont(font.getName(), font.getStyle(), font.getSize());
    }

    public void setAlignment(int n) {
        this.align = n;
    }

    public void setAdjust(int n) {
        this.adjust = n;
    }

    private void start() {
        this.stop();
        this.thr = new Thread(this);
        this.thr.start();
    }

    private boolean pleaseStop() {
        return this.pleaseStop;
    }

    private boolean isRunning() {
        return this.isRunning;
    }

    private void stop() {
        this.pleaseStop = true;
        if (this.thr != null) {
            try {
                while (this.isRunning()) {
                    Thread.sleep(10L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private boolean inZone(int n, int n2) {
        return 0 <= n && 0 <= n2 && n < this.width && n2 < this.height;
    }

    private boolean mustUpdate() {
        return this.mustupdate;
    }

    private boolean mustMove() {
        return this.mustmove;
    }

    private void setTheFocus(boolean bl) {
        this.mustupdate = true;
        this.hasTheFocus = bl;
        if (this.hasTheFocus) {
            this.start();
        } else {
            this.stop();
        }
    }

    boolean hasTheFocus() {
        return this.hasTheFocus;
    }

    void deleteSelection() {
        if (this.selection_0 != this.selection_1) {
            this.string = this.string.substring(0, this.selection_m()) + this.string.substring(this.selection_M());
            this.selection_0 = this.caret_pos = this.selection_m();
            this.selection_1 = this.caret_pos;
            this.mustupdate = true;
        }
    }

    void moveCaret(int n, boolean bl) {
        if (n != 0) {
            this.mustmove = true;
        }
        this.caret_pos += n;
        if (this.caret_pos < 0) {
            this.caret_pos = 0;
        }
        if (this.caret_pos > this.string.length()) {
            this.caret_pos = this.string.length();
        }
        while (2 * this.xl + this.dx + this.fm.stringWidth(this.string.substring(this.firstChar(), this.caret_pos)) >= this.width) {
            --this.dx;
            this.mustupdate = true;
        }
        while (this.dx + this.caret_x() < 0) {
            ++this.dx;
            this.mustupdate = true;
        }
        if (bl) {
            this.selection_1 = this.caret_pos;
            this.mustupdate = true;
        } else {
            this.mustupdate |= this.selection_0 != this.selection_1;
            this.selection_0 = this.caret_pos;
            this.selection_1 = this.caret_pos;
        }
    }

    int selection_m() {
        return Math.min(this.selection_0, this.selection_1);
    }

    int selection_M() {
        return Math.max(this.selection_0, this.selection_1);
    }

    int getCaretPos(int n, int n2, boolean bl) {
        this.mustmove = true;
        int n3 = 0;
        int n4 = this.string.length();
        this.caret_pos = 0;
        String[] stringArray = this.wrap();
        while (n3 + 1 < stringArray.length && this.y(n3) + this.d < n2) {
            this.caret_pos += stringArray[n3++].length();
        }
        n4 = this.caret_pos + stringArray[n3].length();
        while (this.caret_pos + 1 < n4 || this.caret_pos < n4 && n4 == this.string.length()) {
            char c = this.string.charAt(this.caret_pos);
            if (this.x(n3) + this.caret_x() + this.fm.charWidth(c) / 2 >= n) break;
            ++this.caret_pos;
        }
        this.selection_1 = this.caret_pos;
        if (bl) {
            this.mustupdate = true;
        } else {
            this.selection_0 = this.caret_pos;
        }
        return this.caret_pos;
    }

    private int firstChar() {
        String[] stringArray = this.wrap();
        int n = 0;
        int n2 = 0;
        while (n2 + 1 < stringArray.length && n + stringArray[n2].length() <= this.caret_pos) {
            n += stringArray[n2++].length();
        }
        return n;
    }

    private int lastChar() {
        String[] stringArray = this.wrap();
        int n = 0;
        int n2 = 0;
        while (n2 + 1 < stringArray.length && n + stringArray[n2].length() <= this.caret_pos) {
            n += stringArray[n2++].length();
        }
        n += stringArray[n2].length();
        if (n2 + 1 < stringArray.length) {
            --n;
        }
        return n;
    }

    private int lastCharOf(int n) {
        String[] stringArray = this.wrap();
        int n2 = 0;
        int n3 = 0;
        while (n3 + 1 < stringArray.length && n3 + 1 < n) {
            n2 += stringArray[n3++].length();
        }
        n2 += stringArray[n3].length();
        if (n3 + 1 < stringArray.length) {
            --n2;
        }
        return n2;
    }

    private int firstCharOf(int n) {
        String[] stringArray = this.wrap();
        int n2 = 0;
        int n3 = 0;
        while (n3 + 1 < stringArray.length && n3 + 1 < n) {
            n2 += stringArray[n3++].length();
        }
        return n2;
    }

    private int lineWidth(int n) {
        String[] stringArray = this.wrap();
        return this.fm.stringWidth(stringArray[n]);
    }

    private int x(int n) {
        String[] stringArray = this.wrap();
        switch (this.align) {
            case 1: {
                return this.xl + this.dx;
            }
            case 2: {
                return (this.width - this.fm.stringWidth(stringArray[n])) / 2;
            }
            case 3: {
                return this.width - this.xl - this.fm.stringWidth(stringArray[n]);
            }
        }
        return this.xl + this.dx;
    }

    private int xAt(int n) {
        int n2 = this.lnAt(n);
        return this.x(n2) + this.caret_x(n);
    }

    private int y(int n) {
        switch (this.align) {
            case 1: 
            case 2: 
            case 3: {
                return this.yl + this.a + (this.a + this.d) * n;
            }
        }
        return this.a + this.yl;
    }

    int ln() {
        return this.lnAt(this.caret_pos);
    }

    int NL() {
        return this.wrap().length;
    }

    int lnAt(int n) {
        int n2 = 0;
        String[] stringArray = this.wrap();
        int n3 = 0;
        while (n2 + 1 < stringArray.length && n >= n3 + stringArray[n2].length()) {
            n3 += stringArray[n2++].length();
        }
        return n2;
    }

    int caret_x() {
        return this.caret_x(this.caret_pos);
    }

    int caret_x(int n) {
        int n2 = 0;
        String[] stringArray = this.wrap();
        int n3 = this.lnAt(n);
        int n4 = 0;
        while (n4 < n3) {
            n2 += stringArray[n4++].length();
        }
        return this.fm.stringWidth(this.string.substring(n2, n));
    }

    String[] wrap() {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.string.length()) {
            int n5 = 0;
            if (this.adjust == 1) {
                while (n3 < this.string.length() && 2 * this.xl + this.fm.stringWidth(this.string.substring(n2, n3)) < this.width) {
                    if (this.string.charAt(n3) == ' ' || this.string.charAt(n3) == '\n') {
                        n5 = n3;
                    }
                    if (this.string.charAt(n3) != '\n') {
                        ++n3;
                        continue;
                    }
                    break;
                }
            } else {
                while (n3 < this.string.length()) {
                    if (this.string.charAt(n3) == '\n') {
                        n5 = n3++;
                        break;
                    }
                    ++n3;
                }
            }
            n = ++n3;
            if (this.adjust == 1 && n3 < this.string.length() && n5 > 0) {
                n = n5 + 1;
            }
            vector.addElement(this.string.substring(n2, n));
            ++n4;
            n3 = n2 = n;
        }
        if (n4 == 0 || this.string.length() > 0 && this.string.charAt(this.string.length() - 1) == '\n') {
            ++n4;
            vector.addElement("");
        }
        String[] stringArray = new String[n4];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    public void run() {
        this.mustupdate = false;
        this.pleaseStop = false;
        this.isRunning = true;
        Graphics graphics = this.getGraphics();
        try {
            while (!this.pleaseStop()) {
                if (this.hasTheFocus() && this.selection_0 == this.selection_1 && this.isEditable()) {
                    Color color = this.getBackground();
                    Color color2 = this.getForeground();
                    int n = this.ln();
                    int n2 = this.x(n) + this.caret_x() - 1;
                    int n3 = this.y(n);
                    int n4 = this.a;
                    int n5 = this.d;
                    graphics.setXORMode(color);
                    graphics.setColor(color2);
                    this.caretOn = true;
                    graphics.fillRect(n2, n3 - n4, 2, n4 + n5);
                    Thread.sleep(10L);
                    int n6 = 0;
                    while (!this.pleaseStop() && n6++ < 30 && this.hasTheFocus() && !this.mustUpdate() && !this.mustMove()) {
                        Thread.sleep(10L);
                    }
                    if (this.caretOn()) {
                        graphics.setXORMode(color);
                        graphics.setColor(color2);
                        graphics.fillRect(n2, n3 - n4, 2, n4 + n5);
                    }
                    this.caretOn = false;
                }
                if (this.mustUpdate()) {
                    this.paint(graphics);
                    this.mustupdate = false;
                }
                int n = 0;
                while (!(this.pleaseStop() || n++ >= 20 || this.mustMove() || this.mustUpdate())) {
                    Thread.sleep(10L);
                }
                this.mustmove = false;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.paint(graphics);
        this.thr = null;
        this.isRunning = false;
    }

    private boolean caretOn() {
        return this.caretOn;
    }

    public synchronized void paint(Graphics graphics) {
        super.paint(graphics);
        this.caretOn = false;
        if (graphics != null) {
            int n;
            graphics.setColor(this.getForeground());
            graphics.setPaintMode();
            graphics.setFont(this.font);
            String[] stringArray = this.wrap();
            for (n = 0; n < stringArray.length; ++n) {
                graphics.drawString(stringArray[n], this.X0 + this.x(n), this.Y0 + this.y(n));
            }
            if (this.selection_0 != this.selection_1) {
                n = this.xAt(this.selection_m());
                int n2 = this.lnAt(this.selection_m());
                int n3 = this.xAt(this.selection_M());
                int n4 = this.lnAt(this.selection_M());
                graphics.setXORMode(this.getBackground());
                if (n2 == n4) {
                    graphics.fillRect(n, this.y(n2) - this.a, n3 - n, this.a + this.d);
                } else {
                    graphics.fillRect(n, this.y(n2) - this.a, this.xAt(this.lastCharOf(n2)) - n, this.a + this.d);
                    ++n2;
                    while (n2 < n4) {
                        n = this.x(n2);
                        graphics.fillRect(n, this.y(n2) - this.a, this.lineWidth(n2), this.a + this.d);
                        ++n2;
                    }
                    n = this.x(n4);
                    graphics.fillRect(n, this.y(n4) - this.a, n3 - n, this.a + this.d);
                }
                graphics.setPaintMode();
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        boolean bl = keyEvent.isShiftDown();
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isAltDown();
        switch (keyEvent.getKeyCode()) {
            case 37: {
                if (bl2 || this.caret_pos == 0) {
                    this.callListeners("prev");
                    break;
                }
                this.moveCaret(-1, bl);
                this.mustmove = true;
                break;
            }
            case 39: {
                if (bl2 || this.caret_pos == this.string.length()) {
                    this.callListeners("next");
                    break;
                }
                this.moveCaret(1, bl);
                this.mustmove = true;
                break;
            }
            case 38: {
                if (bl2 || this.ln() == 0) {
                    this.callListeners("prevLine");
                    break;
                }
                this.getCaretPos(this.x(this.ln()) + this.caret_x(), this.y(this.ln()) - this.a - this.d, bl);
                this.mustmove = true;
                break;
            }
            case 40: {
                if (bl2 || this.ln() == this.NL() - 1) {
                    this.callListeners("nextLine");
                    break;
                }
                this.getCaretPos(this.x(this.ln()) + this.caret_x(), this.y(this.ln()) + this.a + this.d, bl);
                this.mustmove = true;
                break;
            }
            case 36: {
                if (bl2) {
                    this.moveCaret(-this.string.length(), bl);
                } else {
                    this.moveCaret(this.firstChar() - this.caret_pos, bl);
                }
                this.mustmove = true;
                break;
            }
            case 35: {
                if (bl2) {
                    this.moveCaret(this.string.length(), bl);
                } else {
                    this.moveCaret(this.lastChar() - this.caret_pos, bl);
                }
                this.mustmove = true;
                break;
            }
            case 67: {
                if (!bl2) break;
                clipboardStr = this.string.substring(this.selection_m(), this.selection_M());
                break;
            }
            case 88: {
                if (!bl2) break;
                clipboardStr = this.string.substring(this.selection_m(), this.selection_M());
                this.deleteSelection();
                break;
            }
            case 86: {
                if (!bl2) break;
                this.string = this.string.substring(0, this.caret_pos) + clipboardStr + this.string.substring(this.caret_pos);
                this.moveCaret(clipboardStr.length(), false);
                this.mustupdate = true;
            }
        }
        this.paintAll(this.getGraphics());
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        boolean bl = keyEvent.isShiftDown();
        int n = keyEvent.getKeyCode();
        if (n == 9) {
            if (bl) {
                this.callListeners("prev");
            } else {
                this.callListeners("next");
            }
            return;
        }
        boolean bl2 = keyEvent.isControlDown();
        boolean bl3 = keyEvent.isAltDown();
        if (!bl2) {
            char c = keyEvent.getKeyChar();
            switch (n) {
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: {
                    return;
                }
            }
            boolean bl4 = this.selection_0 != this.selection_1;
            this.deleteSelection();
            if (c == '\u007f') {
                if (this.caret_pos < this.string.length() && !bl4) {
                    this.string = this.string.substring(0, this.caret_pos) + this.string.substring(this.caret_pos + 1);
                    this.moveCaret(0, false);
                    this.mustupdate = true;
                }
            } else if (c == '\b') {
                if (this.caret_pos > 0 && !bl4) {
                    this.string = this.string.substring(0, this.caret_pos - 1) + this.string.substring(this.caret_pos);
                    this.moveCaret(-1, false);
                    this.mustupdate = true;
                }
            } else {
                if (c == '\n') {
                    c = '\n';
                }
                this.string = this.caret_pos == this.string.length() ? this.string + c : this.string.substring(0, this.caret_pos) + c + this.string.substring(this.caret_pos);
                this.moveCaret(1, false);
                this.mustupdate = true;
            }
        }
        this.paintAll(this.getGraphics());
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouse_x = mouseEvent.getX();
        this.mouse_y = mouseEvent.getY();
        if (this.selection_0 != this.selection_1) {
            this.moving = true;
        } else {
            this.x0 = this.xAt(this.getCaretPos(mouseEvent.getX(), mouseEvent.getY(), false));
            this.l0 = this.ln();
            this.x1 = this.x0;
            this.l1 = this.l0;
            this.selection_0 = this.caret_pos;
            this.selection_1 = this.caret_pos;
            this.mustupdate = true;
            this.paintAll(this.getGraphics());
            this.moving = false;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.moving) {
            if ((this.mouse_x != mouseEvent.getX() || this.mouse_y != mouseEvent.getY()) && this.inZone(mouseEvent.getX(), mouseEvent.getY())) {
                int n = this.selection_m();
                int n2 = this.selection_M();
                clipboardStr = this.string.substring(n, n2);
                int n3 = this.getCaretPos(mouseEvent.getX(), mouseEvent.getY(), false);
                this.selection_0 = n;
                this.selection_1 = n2;
                this.deleteSelection();
                if (n3 <= n) {
                    this.caret_pos = n3;
                } else if (n < n3 && n3 < n2) {
                    this.caret_pos = n;
                } else if (n2 <= n3) {
                    this.caret_pos = n + (n3 - n2);
                }
                this.string = this.string.substring(0, this.caret_pos) + clipboardStr + this.string.substring(this.caret_pos);
                this.moveCaret(clipboardStr.length(), false);
            }
            this.selection_0 = this.caret_pos;
            this.selection_1 = this.caret_pos;
            this.mustupdate = true;
        }
        this.moving = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == this && mouseEvent.getClickCount() == 2 && this.calcalfanum > 0) {
            calcWin calcWin2 = new calcWin(true, this.calcalfanum == 2);
            Point point = this.getLocationOnScreen();
            calcWin2.setLocation(point.x - (calcWin2.getSize().width - this.getSize().width) / 2, Math.max(0, point.y - calcWin2.getSize().height));
            calcWin2.show();
            if (calcWin2.getValue() != null) {
                this.setText(calcWin2.getValue());
            }
            calcWin2.dispose();
            this.paint(this.getGraphics());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (!this.moving) {
            int n = this.x1;
            int n2 = this.l1;
            this.x1 = this.xAt(this.getCaretPos(mouseEvent.getX(), mouseEvent.getY(), true));
            this.l1 = this.ln();
            if (n != this.x1 || n2 != this.l1) {
                this.selection_1 = this.caret_pos;
                this.mustupdate = true;
            }
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.setTheFocus(true);
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setTheFocus(false);
    }
}

