/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.persistence;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitChangeListener;
import edu.colorado.phet.circuitconstructionkit.model.Junction;
import edu.colorado.phet.circuitconstructionkit.model.SimpleObservableDebug;
import edu.colorado.phet.circuitconstructionkit.model.components.ACVoltageSource;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.model.grabbag.GrabBagResistor;
import java.io.IOException;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;

public class CircuitXML {
    public static Circuit parseXML(IXMLElement iXMLElement, CircuitChangeListener circuitChangeListener, CCKModule cCKModule) {
        Circuit circuit = new Circuit(circuitChangeListener);
        for (int i = 0; i < iXMLElement.getChildrenCount(); ++i) {
            IXMLElement iXMLElement2 = iXMLElement.getChildAtIndex(i);
            if (iXMLElement2.getName().equals("junction")) {
                String string = iXMLElement2.getAttribute("x", "0.0");
                String string2 = iXMLElement2.getAttribute("y", "0.0");
                double d = Double.parseDouble(string);
                double d2 = Double.parseDouble(string2);
                Junction junction = new Junction(d, d2);
                circuit.addJunction(junction);
                continue;
            }
            if (!iXMLElement2.getName().equals("branch")) continue;
            int n = iXMLElement2.getAttribute("startJunction", -1);
            int n2 = iXMLElement2.getAttribute("endJunction", -1);
            Junction junction = circuit.junctionAt(n);
            Junction junction2 = circuit.junctionAt(n2);
            Branch branch = CircuitXML.toBranch(cCKModule, circuitChangeListener, junction, junction2, iXMLElement2);
            circuit.addBranch(branch);
        }
        return circuit;
    }

    public static Branch toBranch(CCKModule cCKModule, CircuitChangeListener circuitChangeListener, Junction junction, Junction junction2, IXMLElement iXMLElement) {
        String string = iXMLElement.getAttribute("type", "null");
        if ((string = CircuitXML.updateToLatestVersion(string)).equals(Wire.class.getName())) {
            return new Wire(circuitChangeListener, junction, junction2);
        }
        double d = Double.parseDouble(iXMLElement.getAttribute("length", "-1"));
        double d2 = Double.parseDouble(iXMLElement.getAttribute("height", "-1"));
        if (string.equals(Resistor.class.getName())) {
            Resistor resistor = new Resistor(circuitChangeListener, junction, junction2, d, d2);
            String string2 = iXMLElement.getAttribute("resistance", "NaN");
            double d3 = Double.parseDouble(string2);
            resistor.setResistance(d3);
            return resistor;
        }
        if (string.equals(ACVoltageSource.class.getName())) {
            double d4 = Double.parseDouble(iXMLElement.getAttribute("amplitude", "NaN"));
            double d5 = Double.parseDouble(iXMLElement.getAttribute("frequency", "NaN"));
            double d6 = Double.parseDouble(iXMLElement.getAttribute("internalResistance", "NaN"));
            ACVoltageSource aCVoltageSource = new ACVoltageSource(circuitChangeListener, junction, junction2, d, d2, 1.0E-8, true);
            aCVoltageSource.setInternalResistance(d6);
            aCVoltageSource.setAmplitude(d4);
            aCVoltageSource.setFrequency(d5);
            return aCVoltageSource;
        }
        if (string.equals(Capacitor.class.getName())) {
            Capacitor capacitor = new Capacitor(circuitChangeListener, junction, junction2, d, d2);
            capacitor.setVoltageDrop(Double.parseDouble(iXMLElement.getAttribute("voltage", "NaN")));
            capacitor.setCurrent(Double.parseDouble(iXMLElement.getAttribute("current", "NaN")));
            capacitor.setCapacitance(Double.parseDouble(iXMLElement.getAttribute("capacitance", "NaN")));
            return capacitor;
        }
        if (string.equals(Battery.class.getName())) {
            double d7 = Double.parseDouble(iXMLElement.getAttribute("internalResistance", "NaN"));
            Battery battery = new Battery(circuitChangeListener, junction, junction2, d, d2, 1.0E-8, true);
            battery.setInternalResistance(d7);
            String string3 = iXMLElement.getAttribute("voltage", "NaN");
            double d8 = Double.parseDouble(string3);
            battery.setVoltageDrop(d8);
            return battery;
        }
        if (string.equals(Switch.class.getName())) {
            String string4 = iXMLElement.getAttribute("closed", "false");
            boolean bl = string4 != null && string4.equals(new Boolean(true).toString());
            return new Switch(circuitChangeListener, junction, junction2, bl, d, d2);
        }
        if (string.equals(Bulb.class.getName())) {
            String string5 = iXMLElement.getAttribute("width", "NaN");
            double d9 = Double.parseDouble(string5);
            boolean bl = !cCKModule.isLifelike();
            Bulb bulb = new Bulb(circuitChangeListener, junction, junction2, d9, d, d2, bl);
            String string6 = iXMLElement.getAttribute("resistance", "NaN");
            double d10 = Double.parseDouble(string6);
            bulb.setResistance(d10);
            String string7 = iXMLElement.getAttribute("connectAtLeft", "true");
            boolean bl2 = string7 != null && string7.equals(new Boolean(true).toString());
            bulb.setConnectAtLeftXML(bl2);
            return bulb;
        }
        if (string.equals(SeriesAmmeter.class.getName())) {
            return new SeriesAmmeter(circuitChangeListener, junction, junction2, d, d2);
        }
        if (string.equals(GrabBagResistor.class.getName())) {
            Resistor resistor = new Resistor(circuitChangeListener, junction, junction2, d, d2);
            String string8 = iXMLElement.getAttribute("resistance", "NaN");
            double d11 = Double.parseDouble(string8);
            resistor.setResistance(d11);
            return resistor;
        }
        if (string.equals(Inductor.class.getName())) {
            Inductor inductor = new Inductor(circuitChangeListener, junction, junction2, d, d2);
            inductor.setVoltageDrop(Double.parseDouble(iXMLElement.getAttribute("voltage", "NaN")));
            inductor.setCurrent(Double.parseDouble(iXMLElement.getAttribute("current", "NaN")));
            inductor.setInductance(Double.parseDouble(iXMLElement.getAttribute("inductance", "NaN")));
            return inductor;
        }
        if (string.equals(Wire.class.getName())) {
            Wire wire = new Wire(circuitChangeListener, junction, junction2);
            String string9 = iXMLElement.getAttribute("resistance", "NaN");
            double d12 = Double.parseDouble(string9);
            wire.setResistance(d12);
            return wire;
        }
        return null;
    }

    private static String updateToLatestVersion(String string) {
        if (string.equals("edu.colorado.phet.cck3.circuit.Branch")) {
            return "edu.colorado.phet.circuitconstructionkit.model.components.Wire";
        }
        string = string.replaceAll("edu.colorado.phet.cck.model.components.", "edu.colorado.phet.circuitconstructionkit.model.components.");
        string = string.replaceAll("edu.colorado.phet.cck3.circuit.components", "edu.colorado.phet.circuitconstructionkit.model.components.");
        return string;
    }

    public static XMLElement toXML(Circuit circuit) {
        XMLElement xMLElement;
        SimpleObservableDebug simpleObservableDebug;
        int n;
        XMLElement xMLElement2 = new XMLElement("circuit");
        for (n = 0; n < circuit.numJunctions(); ++n) {
            simpleObservableDebug = circuit.junctionAt(n);
            xMLElement = new XMLElement("junction");
            xMLElement.setAttribute("index", n + "");
            xMLElement.setAttribute("x", ((Junction)simpleObservableDebug).getPosition().getX() + "");
            xMLElement.setAttribute("y", ((Junction)simpleObservableDebug).getPosition().getY() + "");
            xMLElement2.addChild(xMLElement);
        }
        for (n = 0; n < circuit.numBranches(); ++n) {
            CircuitComponent circuitComponent;
            simpleObservableDebug = circuit.branchAt(n);
            xMLElement = new XMLElement("branch");
            Junction junction = ((Branch)simpleObservableDebug).getStartJunction();
            Junction junction2 = ((Branch)simpleObservableDebug).getEndJunction();
            int n2 = circuit.indexOf(junction);
            int n3 = circuit.indexOf(junction2);
            xMLElement.setAttribute("index", "" + n);
            xMLElement.setAttribute("type", simpleObservableDebug.getClass().getName());
            xMLElement.setAttribute("startJunction", n2 + "");
            xMLElement.setAttribute("endJunction", n3 + "");
            if (simpleObservableDebug instanceof CircuitComponent) {
                circuitComponent = (CircuitComponent)simpleObservableDebug;
                xMLElement.setAttribute("length", circuitComponent.getLength() + "");
                xMLElement.setAttribute("height", circuitComponent.getHeight() + "");
            }
            if (simpleObservableDebug instanceof ACVoltageSource) {
                circuitComponent = (ACVoltageSource)simpleObservableDebug;
                xMLElement.setAttribute("amplitude", ((ACVoltageSource)circuitComponent).getAmplitude() + "");
                xMLElement.setAttribute("frequency", ((ACVoltageSource)circuitComponent).getFrequency() + "");
                xMLElement.setAttribute("internalResistance", ((Battery)circuitComponent).getInteralResistance() + "");
            } else if (simpleObservableDebug instanceof Battery) {
                circuitComponent = (Battery)simpleObservableDebug;
                xMLElement.setAttribute("voltage", ((Branch)simpleObservableDebug).getVoltageDrop() + "");
                xMLElement.setAttribute("resistance", ((Branch)simpleObservableDebug).getResistance() + "");
                xMLElement.setAttribute("internalResistance", ((Battery)circuitComponent).getInteralResistance() + "");
            } else if (simpleObservableDebug instanceof Resistor) {
                xMLElement.setAttribute("resistance", ((Branch)simpleObservableDebug).getResistance() + "");
            } else if (simpleObservableDebug instanceof Bulb) {
                xMLElement.setAttribute("resistance", ((Branch)simpleObservableDebug).getResistance() + "");
                circuitComponent = (Bulb)simpleObservableDebug;
                xMLElement.setAttribute("width", ((Bulb)circuitComponent).getWidth() + "");
                xMLElement.setAttribute("length", ((Branch)simpleObservableDebug).getStartJunction().getDistance(((Branch)simpleObservableDebug).getEndJunction()) + "");
                xMLElement.setAttribute("schematic", ((Bulb)circuitComponent).isSchematic() + "");
                xMLElement.setAttribute("connectAtLeft", ((Bulb)circuitComponent).isConnectAtLeft() + "");
            } else if (simpleObservableDebug instanceof Switch) {
                circuitComponent = (Switch)simpleObservableDebug;
                xMLElement.setAttribute("closed", ((Switch)circuitComponent).isClosed() + "");
            } else if (!(simpleObservableDebug instanceof SeriesAmmeter)) {
                if (simpleObservableDebug instanceof Capacitor) {
                    circuitComponent = (Capacitor)simpleObservableDebug;
                    xMLElement.setAttribute("capacitance", ((Capacitor)circuitComponent).getCapacitance() + "");
                    xMLElement.setAttribute("voltage", circuitComponent.getVoltageDrop() + "");
                    xMLElement.setAttribute("current", circuitComponent.getCurrent() + "");
                } else if (simpleObservableDebug instanceof Inductor) {
                    circuitComponent = (Inductor)simpleObservableDebug;
                    xMLElement.setAttribute("inductance", ((Inductor)circuitComponent).getInductance() + "");
                    xMLElement.setAttribute("voltage", circuitComponent.getVoltageDrop() + "");
                    xMLElement.setAttribute("current", circuitComponent.getCurrent() + "");
                }
            }
            xMLElement2.addChild(xMLElement);
        }
        try {
            new XMLWriter(System.out).write(xMLElement2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return xMLElement2;
    }
}

