/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo.lifelike;

import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.PhetPPath;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class BulbNode
extends PhetPNode {
    private Bulb bulb;
    private double intensity = 0.0;
    private ArrayList brighties = new ArrayList();
    private BasicStroke brightyStroke;
    private Color brightyColor;
    private Ellipse2D.Double bulbShape;
    private Point2D pin;
    private Point2D.Double rad;
    private Rectangle2D.Double conductor;
    private Ellipse2D.Double insulator;
    private Rectangle2D.Double tip;
    private ArrayList spiralLines;
    private Stroke tipStroke = new BasicStroke(0.05f);
    private Color insulatorColor = Color.white;
    private Stroke baseStroke = new BasicStroke(0.025f);
    private Stroke linestroke = new BasicStroke(0.011111111f);
    private boolean showCoverOnly = false;
    private PhetPPath highlightNode = new PhetPPath(new BasicStroke(0.033333335f), (Paint)Color.yellow);
    private SimpleObserver bulbObserver = new SimpleObserver(){

        public void update() {
            BulbNode.this.update();
        }
    };

    public BulbNode(Bulb bulb) {
        this.bulb = bulb;
        Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, 1.0, 1.0);
        double d = 0.1;
        double d2 = 0.04;
        double d3 = 0.23504;
        double d4 = 1.0 - d - d2 - d3;
        double d5 = 0.5;
        double d6 = 0.08;
        double d7 = 0.06;
        double d8 = double_.getY();
        double d9 = double_.getHeight() * d4;
        double d10 = double_.getWidth();
        double d11 = double_.getX();
        double d12 = double_.getWidth() * d5;
        double d13 = double_.getX() + (double_.getWidth() - d12) / 2.0;
        double d14 = d9 + d8;
        double d15 = d3 * double_.getHeight();
        double d16 = d13;
        double d17 = d * double_.getHeight();
        double d18 = d14 + d15 - d17 / 2.0;
        double d19 = d12;
        double d20 = double_.getWidth() * d6;
        double d21 = double_.getHeight() * d2;
        double d22 = double_.getX() + (double_.getWidth() - d20) / 2.0;
        double d23 = d18 + d17;
        this.bulbShape = new Ellipse2D.Double(d11, d8, d10, d9 + d7 * double_.getHeight());
        this.pin = this.getPin(this.bulbShape);
        this.rad = new Point2D.Double(double_.getWidth() / 2.0, double_.getHeight() / 2.0);
        this.conductor = new Rectangle2D.Double(d13, d14, d12, d15);
        this.insulator = new Ellipse2D.Double(d16, d18, d19, d17);
        this.tip = new Rectangle2D.Double(d22, d23, d20, d21);
        int n = 4;
        double d24 = this.conductor.getHeight() / (double)n;
        this.spiralLines = new ArrayList();
        for (int i = 0; i < n; ++i) {
            double d25 = this.conductor.getX();
            double d26 = this.conductor.getY() + (double)i * d24;
            double d27 = this.conductor.getX() + this.conductor.getWidth();
            double d28 = d26 + d24 / 2.0;
            Line2D.Double double_2 = new Line2D.Double(d25, d26, d27, d28);
            this.spiralLines.add(double_2);
        }
        bulb.addObserver(this.bulbObserver);
        this.update();
    }

    protected void update() {
        this.removeAllChildren();
        if (this.showCoverOnly) {
            this.updateConductor();
            this.updateSpiralLines();
        } else {
            this.updateRays();
            this.addChild(this.createTipNode());
            this.addChild(this.createBulbShape());
            this.updateInsulator();
            this.updateConductor();
            this.updateSpiralLines();
            if (this.bulb.isSelected()) {
                Rectangle2D rectangle2D = this.bulbShape.getBounds2D().createUnion(this.tip);
                rectangle2D = RectangleUtils.expand(rectangle2D, 0.03333333333333333, 0.03333333333333333);
                this.highlightNode.setPathTo(rectangle2D);
                this.addChild(this.highlightNode);
            }
        }
    }

    private void updateSpiralLines() {
        for (int i = 0; i < this.spiralLines.size(); ++i) {
            Line2D.Double double_ = (Line2D.Double)this.spiralLines.get(i);
            PhetPPath phetPPath = new PhetPPath(double_, this.linestroke, (Paint)Color.black);
            this.addChild(phetPPath);
        }
    }

    private void updateConductor() {
        PhetPPath phetPPath = new PhetPPath(this.conductor, Color.lightGray, this.baseStroke, Color.black);
        this.addChild(phetPPath);
    }

    private void updateInsulator() {
        PhetPPath phetPPath = new PhetPPath((Shape)this.insulator, (Paint)this.insulatorColor);
        this.addChild(phetPPath);
    }

    private PPath createBulbShape() {
        PhetPPath phetPPath = new PhetPPath(this.bulbShape, (Stroke)new BasicStroke(0.025f), (Paint)Color.black);
        phetPPath.setPaint(this.createPaint());
        return phetPPath;
    }

    private Paint createPaint() {
        if (this.intensity > 0.01) {
            Color color = Color.yellow;
            Color color2 = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)this.intensity);
            Color color3 = new Color(1.0f, 1.0f, 1.0f, (float)this.intensity);
            return new RoundGradientPaint(this.pin.getX(), this.pin.getY(), color3, this.rad, color2);
        }
        return new Color(0, 0, 0, 0);
    }

    private PPath createTipNode() {
        PPath pPath = new PPath();
        pPath.setPaint(Color.black);
        pPath.setStroke(this.tipStroke);
        pPath.setPathTo(this.tip);
        return pPath;
    }

    private void updateRays() {
        for (int i = 0; i < this.brighties.size(); ++i) {
            PPath pPath = new PPath((Shape)this.brighties.get(i));
            pPath.setStrokePaint(this.brightyColor);
            pPath.setStroke(this.brightyStroke);
            pPath.setPickable(false);
            pPath.setChildrenPickable(false);
            this.addChild(pPath);
        }
    }

    private Point2D getPin(Ellipse2D.Double double_) {
        double d = 0.2;
        double d2 = 0.3;
        return new Point2D.Double(double_.getX() + double_.getWidth() * d, double_.getY() + double_.getHeight() * d2);
    }

    public void setIntensity(double d) {
        if (Double.isNaN(d)) {
            throw new RuntimeException("NaN intensity");
        }
        if (this.intensity == d) {
            return;
        }
        this.intensity = d;
        Color color = Color.yellow;
        Color color2 = new Color((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)d);
        int n = 40;
        int n2 = (int)(d * (double)n);
        double d2 = this.bulb.getWidth() * 3.0;
        double d3 = d * d2;
        double d4 = Math.max(this.bulb.getWidth() / 2.0, this.bulb.getHeight() / 2.0) * 1.05;
        this.brighties.clear();
        double d5 = 0.7853981633974483;
        double d6 = 1.5707963267948966 + d5;
        double d7 = d6 + Math.PI * 2 - d5 * 2.0;
        double d8 = Math.abs(d7 - d6) / (double)(n2 - 1);
        double d9 = d6;
        Point2D point2D = BulbNode.center(this.bulbShape);
        double d10 = 3.5;
        double d11 = 0.5;
        double d12 = d11 + d * d10;
        for (int i = 0; i < n2; ++i) {
            ImmutableVector2D immutableVector2D = ImmutableVector2D.parseAngleAndMagnitude(d4, d9);
            ImmutableVector2D immutableVector2D2 = ImmutableVector2D.parseAngleAndMagnitude(d3 + d4, d9);
            Point2D.Double double_ = immutableVector2D.getDestination(point2D);
            Point2D.Double double_2 = immutableVector2D2.getDestination(point2D);
            Line2D.Double double_3 = new Line2D.Double(double_, double_2);
            this.brighties.add(double_3);
            d9 += d8;
        }
        this.brightyStroke = new BasicStroke((float)d12 / 40.0f * 0.35f, 1, 1);
        this.brightyColor = color2;
        this.update();
    }

    static Point2D center(Ellipse2D ellipse2D) {
        return new Point2D.Double(ellipse2D.getX() + ellipse2D.getWidth() / 2.0, ellipse2D.getY() + ellipse2D.getHeight() / 2.0);
    }

    public Shape getCoverShape() {
        return this.conductor;
    }

    public Shape getCoverShapeOnFilamentSide() {
        return new Rectangle2D.Double(this.conductor.getX(), this.conductor.getY(), this.conductor.getWidth() * 0.85, this.conductor.getHeight());
    }

    public void delete() {
        this.bulb.removeObserver(this.bulbObserver);
    }
}

