/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.circuitconstructionkit.CCKModule;
import edu.colorado.phet.circuitconstructionkit.model.CCKModel;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.CircuitComponent;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.ComponentNode;
import edu.colorado.phet.circuitconstructionkit.view.piccolo.FlameNode;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public abstract class RectangularComponentNode
extends ComponentNode {
    private FlameNode flameNode;
    private PDimension dimension;
    private Branch.FlameListener flameListener = new Branch.FlameListener(){

        public void flameStarted() {
            RectangularComponentNode.this.update();
        }

        public void flameFinished() {
            RectangularComponentNode.this.update();
        }
    };

    public RectangularComponentNode(CCKModel cCKModel, CircuitComponent circuitComponent, double d, double d2, JComponent jComponent, CCKModule cCKModule) {
        super(cCKModel, circuitComponent, jComponent, cCKModule);
        this.dimension = new PDimension(d, d2);
        this.flameNode = new FlameNode(this.getBranch());
        this.addChild(this.flameNode);
        this.getBranch().addFlameListener(this.flameListener);
        this.update();
    }

    public void delete() {
        super.delete();
        this.getBranch().removeFlameListener(this.flameListener);
    }

    public PDimension getDimension() {
        return new PDimension(this.dimension);
    }

    protected void update() {
        super.update();
        Rectangle2D rectangle2D = new Rectangle2D.Double(0.0, 0.0, this.dimension.getWidth(), this.dimension.getHeight());
        rectangle2D = RectangleUtils.expand(rectangle2D, 2.0, 2.0);
        this.getHighlightNode().setPathTo(rectangle2D);
        this.getHighlightNode().setVisible(this.getBranch().isSelected());
        double d = this.getBranch().getStartPoint().distance(this.getBranch().getEndPoint());
        double d2 = this.dimension.getWidth();
        double d3 = d / d2;
        double d4 = this.getCircuitComponent().getHeight() / this.dimension.getHeight();
        double d5 = new Vector2D(this.getBranch().getStartPoint(), this.getBranch().getEndPoint()).getAngle();
        this.setTransform(new AffineTransform());
        if (Math.abs(d3) > 1.0E-4) {
            this.setScale(d3);
        }
        this.setOffset(this.getBranch().getStartPoint());
        this.rotate(d5);
        this.translate(0.0, -this.dimension.getHeight() / 2.0);
        this.flameNode.setOffset(0.0, -this.flameNode.getFullBounds().getHeight() + this.dimension.getHeight() / 2.0);
        if (this.getParent() != null && this.getParent().getChildrenReference().indexOf(this.flameNode) != this.getParent().getChildrenReference().size() - 1) {
            this.flameNode.moveToFront();
        }
    }
}

