/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model.mna;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.analysis.CircuitSolver;
import edu.colorado.phet.circuitconstructionkit.model.components.Battery;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Bulb;
import edu.colorado.phet.circuitconstructionkit.model.components.Capacitor;
import edu.colorado.phet.circuitconstructionkit.model.components.Filament;
import edu.colorado.phet.circuitconstructionkit.model.components.Inductor;
import edu.colorado.phet.circuitconstructionkit.model.components.Resistor;
import edu.colorado.phet.circuitconstructionkit.model.components.SeriesAmmeter;
import edu.colorado.phet.circuitconstructionkit.model.components.Switch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.circuitconstructionkit.model.mna.DynamicCircuit;
import edu.colorado.phet.circuitconstructionkit.model.mna.LinearCircuitSolver;
import edu.colorado.phet.circuitconstructionkit.model.mna.ObjectOrientedMNA;
import edu.colorado.phet.circuitconstructionkit.model.mna.ResultSet;
import edu.colorado.phet.circuitconstructionkit.model.mna.TimestepSubdivisions;
import java.util.ArrayList;

public class MNAAdapter
extends CircuitSolver {
    private double errorThreshold = 1.0E-5;
    private double minDT = 1.0E-5;

    public void apply(Circuit circuit, double d) {
        Object object;
        ArrayList<ResistiveBatteryAdapter> arrayList = new ArrayList<ResistiveBatteryAdapter>();
        ArrayList<ResistorAdapter> arrayList2 = new ArrayList<ResistorAdapter>();
        ArrayList<CapacitorAdapter> arrayList3 = new ArrayList<CapacitorAdapter>();
        ArrayList<InductorAdapter> arrayList4 = new ArrayList<InductorAdapter>();
        for (int i = 0; i < circuit.numBranches(); ++i) {
            object = circuit.getBranches()[i];
            if (object instanceof Battery) {
                arrayList.add(new ResistiveBatteryAdapter(circuit, (Battery)object));
                continue;
            }
            if (object instanceof Resistor) {
                arrayList2.add(new ResistorAdapter(circuit, (Branch)object));
                continue;
            }
            if (object instanceof Wire) {
                arrayList2.add(new ResistorAdapter(circuit, (Branch)object));
                continue;
            }
            if (object instanceof Filament) {
                arrayList2.add(new ResistorAdapter(circuit, (Branch)object));
                continue;
            }
            if (object instanceof Switch) {
                Switch switch_ = (Switch)object;
                if (!switch_.isClosed()) continue;
                arrayList2.add(new ResistorAdapter(circuit, switch_));
                continue;
            }
            if (object instanceof Bulb) {
                arrayList2.add(new ResistorAdapter(circuit, (Branch)object));
                continue;
            }
            if (object instanceof SeriesAmmeter) {
                arrayList2.add(new ResistorAdapter(circuit, (Branch)object));
                continue;
            }
            if (object instanceof Capacitor) {
                arrayList3.add(new CapacitorAdapter(circuit, (Capacitor)object));
                continue;
            }
            if (object instanceof Inductor) {
                arrayList4.add(new InductorAdapter(circuit, (Inductor)object));
                continue;
            }
            new RuntimeException("Type not found: " + object).printStackTrace();
        }
        DynamicCircuit dynamicCircuit = new DynamicCircuit(new ArrayList<LinearCircuitSolver.Battery>(), new ArrayList<LinearCircuitSolver.Resistor>(arrayList2), new ArrayList<LinearCircuitSolver.CurrentSource>(), new ArrayList<DynamicCircuit.ResistiveBattery>(arrayList), new ArrayList<DynamicCircuit.DynamicCapacitor>(arrayList3), new ArrayList<DynamicCircuit.DynamicInductor>(arrayList4), new ObjectOrientedMNA());
        object = dynamicCircuit.solveWithSudbivisions(new TimestepSubdivisions<DynamicCircuit.DynamicState>(this.errorThreshold, this.minDT), d);
        for (ResistiveBatteryAdapter object2 : arrayList) {
            object2.applySolution((CircuitResult)object);
        }
        for (ResistorAdapter resistorAdapter : arrayList2) {
            resistorAdapter.applySolution((CircuitResult)object);
        }
        for (CapacitorAdapter capacitorAdapter : arrayList3) {
            capacitorAdapter.applySolution((CircuitResult)object);
        }
        for (InductorAdapter inductorAdapter : arrayList4) {
            inductorAdapter.applySolution((CircuitResult)object);
        }
        for (int i = 0; i < circuit.numBranches(); ++i) {
            Switch switch_;
            if (!(circuit.getBranches()[i] instanceof Switch) || (switch_ = (Switch)circuit.getBranches()[i]).isClosed()) continue;
            switch_.setCurrent(0.0);
            switch_.setVoltageDrop(0.0);
        }
        circuit.setSolution((CircuitResult)object);
        this.fireCircuitSolved();
    }

    public double getErrorThreshold() {
        return this.errorThreshold;
    }

    public double getMinDT() {
        return this.minDT;
    }

    public void setErrorThreshold(double d) {
        this.errorThreshold = d;
    }

    public void setMinDT(double d) {
        this.minDT = d;
    }

    static class CapacitorAdapter
    extends DynamicCircuit.DynamicCapacitor {
        private Capacitor _capacitor;

        CapacitorAdapter(Circuit circuit, Capacitor capacitor) {
            super(new DynamicCircuit.Capacitor(circuit.indexOf(capacitor.getStartJunction()), circuit.indexOf(capacitor.getEndJunction()), capacitor.getCapacitance()), new DynamicCircuit.DynamicElementState(capacitor.getMNAVoltageDrop(), capacitor.getMNACurrent()));
            this._capacitor = capacitor;
        }

        void applySolution(CircuitResult circuitResult) {
            this._capacitor.setCurrent(circuitResult.getTimeAverageCurrent(this.capacitor));
            this._capacitor.setMNACurrent(circuitResult.getInstantaneousCurrent(this.capacitor));
            this._capacitor.setVoltageDrop(circuitResult.getTimeAverageVoltage(this.capacitor));
            this._capacitor.setMNAVoltageDrop(circuitResult.getInstantaneousVoltage(this.capacitor));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CircuitResult {
        private ResultSet<DynamicCircuit.DynamicState> resultSet;

        public CircuitResult(ResultSet<DynamicCircuit.DynamicState> resultSet) {
            this.resultSet = resultSet;
        }

        public double getTimeAverageCurrent(LinearCircuitSolver.Element element) {
            double d = 0.0;
            for (ResultSet.State<DynamicCircuit.DynamicState> state : this.resultSet) {
                d += ((DynamicCircuit.DynamicState)state.state).getSolution().getCurrent(element) * state.dt;
            }
            return d / this.resultSet.getTotalTime();
        }

        public double getInstantaneousCurrent(LinearCircuitSolver.Element element) {
            return this.getFinalState().getSolution().getCurrent(element);
        }

        public double getTimeAverageVoltage(LinearCircuitSolver.Element element) {
            double d = 0.0;
            for (ResultSet.State<DynamicCircuit.DynamicState> state : this.resultSet) {
                d += ((DynamicCircuit.DynamicState)state.state).getSolution().getVoltage(element) * state.dt;
            }
            return d / this.resultSet.getTotalTime();
        }

        public double getInstantaneousVoltage(LinearCircuitSolver.Element element) {
            return this.getFinalState().getSolution().getVoltage(element);
        }

        public DynamicCircuit.DynamicState getFinalState() {
            return this.resultSet.getFinalState();
        }

        public double getAverageNodeVoltage(int n) {
            double d = 0.0;
            for (ResultSet.State<DynamicCircuit.DynamicState> state : this.resultSet) {
                d += ((DynamicCircuit.DynamicState)state.state).getSolution().getNodeVoltage(n) * state.dt;
            }
            return d / this.resultSet.getTotalTime();
        }
    }

    static class InductorAdapter
    extends DynamicCircuit.DynamicInductor {
        Inductor inductor;

        InductorAdapter(Circuit circuit, Inductor inductor) {
            super(new DynamicCircuit.Inductor(circuit.indexOf(inductor.getStartJunction()), circuit.indexOf(inductor.getEndJunction()), inductor.getInductance()), new DynamicCircuit.DynamicElementState(inductor.getMNAVoltageDrop(), -inductor.getMNACurrent()));
            this.inductor = inductor;
        }

        void applySolution(CircuitResult circuitResult) {
            this.inductor.setCurrent(-circuitResult.getTimeAverageCurrent(this.getInductor()));
            this.inductor.setMNACurrent(-circuitResult.getInstantaneousCurrent(this.getInductor()));
            this.inductor.setVoltageDrop(circuitResult.getTimeAverageVoltage(this.getInductor()));
            this.inductor.setMNAVoltageDrop(circuitResult.getInstantaneousVoltage(this.getInductor()));
        }
    }

    static class ResistiveBatteryAdapter
    extends DynamicCircuit.ResistiveBattery {
        Battery battery;

        ResistiveBatteryAdapter(Circuit circuit, Battery battery) {
            super(circuit.indexOf(battery.getStartJunction()), circuit.indexOf(battery.getEndJunction()), battery.getVoltageDrop(), battery.getResistance());
            this.battery = battery;
        }

        void applySolution(CircuitResult circuitResult) {
            this.battery.setMNACurrent(circuitResult.getInstantaneousCurrent(this));
            this.battery.setCurrent(circuitResult.getTimeAverageCurrent(this));
        }
    }

    static class ResistorAdapter
    extends LinearCircuitSolver.Resistor {
        Branch resistor;

        ResistorAdapter(Circuit circuit, Branch branch) {
            super(circuit.indexOf(branch.getStartJunction()), circuit.indexOf(branch.getEndJunction()), branch.getResistance());
            this.resistor = branch;
        }

        void applySolution(CircuitResult circuitResult) {
            this.resistor.setCurrent(circuitResult.getTimeAverageCurrent(this));
            this.resistor.setVoltageDrop(circuitResult.getTimeAverageVoltage(this));
            this.resistor.setMNACurrent(circuitResult.getInstantaneousCurrent(this));
        }
    }
}

