/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.model;

import edu.colorado.phet.circuitconstructionkit.model.Circuit;
import edu.colorado.phet.circuitconstructionkit.model.CircuitListenerAdapter;
import edu.colorado.phet.circuitconstructionkit.model.components.Branch;
import edu.colorado.phet.circuitconstructionkit.model.components.Wire;
import edu.colorado.phet.common.phetcommon.model.property.Property;

public class ResistivityManager
extends CircuitListenerAdapter {
    private Circuit circuit;
    public Property<Double> resistivity = new Property<Double>(1.0E-4);
    private Property<Boolean> enabled = new Property<Boolean>(true);

    public ResistivityManager(Circuit circuit) {
        this.circuit = circuit;
    }

    public Circuit getCircuit() {
        return this.circuit;
    }

    public void junctionsMoved() {
        this.changed();
    }

    private void changed() {
        if (this.enabled.get().booleanValue()) {
            for (int i = 0; i < this.getCircuit().numBranches(); ++i) {
                Branch branch = this.getCircuit().branchAt(i);
                if (!(branch instanceof Wire)) continue;
                double d = this.getResistance(branch);
                branch.setResistance(d);
            }
        }
    }

    private double getResistance(Branch branch) {
        double d = branch.getLength();
        double d2 = d * this.resistivity.get();
        if (d2 < 1.0E-8) {
            return 1.0E-8;
        }
        return d2;
    }

    public void setResistivity(double d) {
        if (this.resistivity.get() != d) {
            this.resistivity.set(d);
            this.changed();
        }
    }

    public void reset() {
        this.enabled.reset();
        this.resistivity.reset();
        this.changed();
    }
}

