/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.dialogs;

import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColorChooserFactory {
    public static JDialog createDialog(String string, Component component, Color color, Listener listener) {
        return ColorChooserFactory.createDialog(string, component, color, listener, null);
    }

    public static JDialog createDialog(String string, Component component, final Color color, final Listener listener, String[] stringArray) {
        Object object;
        final JColorChooser jColorChooser = new JColorChooser(color);
        if (stringArray != null) {
            object = new AbstractColorChooserPanel[stringArray.length];
            for (int i = 0; i < ((AbstractColorChooserPanel[])object).length; ++i) {
                object[i] = ColorChooserFactory.findPanel(jColorChooser, stringArray[i]);
            }
            jColorChooser.setChooserPanels((AbstractColorChooserPanel[])object);
        }
        jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                listener.colorChanged(jColorChooser.getColor());
            }
        });
        object = JColorChooser.createDialog(component, string, false, jColorChooser, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                listener.ok(jColorChooser.getColor());
            }
        }, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                listener.cancelled(color);
            }
        });
        SwingUtils.centerDialogInParent((JDialog)object);
        if (component == null) {
            SwingUtils.centerWindowOnScreen((Window)object);
        }
        return object;
    }

    public static void showDialog(String string, Component component, Color color, Listener listener) {
        ColorChooserFactory.showDialog(string, component, color, listener, false);
    }

    public static void showDialog(String string, Component component, Color color, Listener listener, boolean bl) {
        JDialog jDialog = ColorChooserFactory.createDialog(string, component, color, listener, (String[])(bl ? ColorChooserFactory.getHSBFirstPanelOrder() : null));
        jDialog.show();
    }

    private static String[] getHSBFirstPanelOrder() {
        return new String[]{"javax.swing.colorchooser.DefaultHSBChooserPanel", "javax.swing.colorchooser.DefaultRGBChooserPanel", "javax.swing.colorchooser.DefaultSwatchChooserPanel"};
    }

    private static AbstractColorChooserPanel findPanel(JColorChooser jColorChooser, String string) {
        AbstractColorChooserPanel[] abstractColorChooserPanelArray = jColorChooser.getChooserPanels();
        for (int i = 0; i < abstractColorChooserPanelArray.length; ++i) {
            String string2 = abstractColorChooserPanelArray[i].getClass().getName();
            if (!string2.equals(string)) continue;
            return abstractColorChooserPanelArray[i];
        }
        return null;
    }

    public static interface Listener {
        public void colorChanged(Color var1);

        public void ok(Color var1);

        public void cancelled(Color var1);
    }
}

