/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.piccolo;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Capacitor3DShapeSet {
    private double tiltAngle;
    private double width;
    private double length;
    private Point2D inPt;
    private Point2D outPt;
    private double distBetweenPlates;
    private Shape plate1Path;
    private Shape plate2Path;
    private Shape plate2Wire;
    private Shape plate1Wire;

    public Capacitor3DShapeSet(double d, double d2, double d3, Point2D point2D, Point2D point2D2, double d4) {
        this.tiltAngle = d;
        this.width = d2;
        this.length = d3;
        this.inPt = point2D;
        this.outPt = point2D2;
        this.distBetweenPlates = d4;
        this.updateShape();
    }

    private void updateShape() {
        Point2D point2D = this.getPlate1Point();
        Point2D point2D2 = this.getPlate2Point();
        this.plate1Path = this.createPlatePath(point2D);
        this.plate2Path = this.createPlatePath(point2D2);
        this.plate1Wire = this.createWirePath(this.inPt, point2D);
        this.plate2Wire = this.createWirePath(this.outPt, point2D2);
    }

    private Shape createWirePath(Point2D point2D, Point2D point2D2) {
        return new Line2D.Double(point2D, point2D2);
    }

    private Shape createPlatePath(Point2D point2D) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(point2D);
        this.moveUV(doubleGeneralPath, -this.width / 2.0, 0.0);
        this.lineUV(doubleGeneralPath, 0.0, -this.length / 2.0);
        this.lineUV(doubleGeneralPath, this.width, 0.0);
        this.lineUV(doubleGeneralPath, 0.0, this.length);
        this.lineUV(doubleGeneralPath, -this.width, 0.0);
        this.lineUV(doubleGeneralPath, 0.0, -this.length / 2.0);
        return doubleGeneralPath.getGeneralPath();
    }

    private void moveUV(DoubleGeneralPath doubleGeneralPath, double d, double d2) {
        Vector2D vector2D = this.getVector(d, d2);
        doubleGeneralPath.moveToRelative(vector2D);
    }

    private Vector2D getVector(double d, double d2) {
        Vector2D vector2D = new Vector2D(d * Math.cos(this.tiltAngle), d * Math.sin(this.tiltAngle) + d2);
        vector2D.rotate(this.getSegmentAngle());
        return vector2D;
    }

    public Point2D getPlate1Location(double d, double d2) {
        Vector2D vector2D = this.getVector(d, d2);
        return vector2D.getDestination(this.getPlate1Point());
    }

    public Point2D getPlate2Location(double d, double d2) {
        Vector2D vector2D = this.getVector(d, d2);
        return vector2D.getDestination(this.getPlate2Point());
    }

    private double getSegmentAngle() {
        return new Vector2D(this.inPt, this.outPt).getAngle();
    }

    private void lineUV(DoubleGeneralPath doubleGeneralPath, double d, double d2) {
        Vector2D vector2D = this.getVector(d, d2);
        doubleGeneralPath.lineToRelative(vector2D);
    }

    public Point2D getPlate2Point() {
        Vector2D vector2D = new Vector2D(this.outPt, this.inPt);
        return vector2D.getInstanceOfMagnitude(this.getDistToPlate()).getDestination(this.outPt);
    }

    public Point2D getPlate1Point() {
        Vector2D vector2D = new Vector2D(this.inPt, this.outPt);
        return vector2D.getInstanceOfMagnitude(this.getDistToPlate()).getDestination(this.inPt);
    }

    private double getDistToPlate() {
        return (new Vector2D(this.inPt, this.outPt).getMagnitude() - this.distBetweenPlates) / 2.0;
    }

    public Shape getPlate1Shape() {
        return this.plate1Path;
    }

    public Shape getPlate2Shape() {
        return this.plate2Path;
    }

    public Shape getPlate2Wire() {
        return this.plate2Wire;
    }

    public Shape getPlate1Wire() {
        return this.plate1Wire;
    }

    public double getWidth() {
        return this.width;
    }

    public double getLength() {
        return this.length;
    }

    public Area getPlateArea() {
        Area area = new Area();
        area.add(new Area(this.getPlate1Shape()));
        area.add(new Area(this.getPlate2Shape()));
        return area;
    }
}

