/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.circuitconstructionkit.view.chart;

import edu.colorado.phet.circuitconstructionkit.view.chart.AbstractFloatingChart;
import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class CrosshairConnection
extends PhetPNode {
    private AbstractFloatingChart FloatingChart;
    private PNode destination;
    private PPath line;

    public CrosshairConnection(AbstractFloatingChart abstractFloatingChart, PNode pNode) {
        this.FloatingChart = abstractFloatingChart;
        this.destination = pNode;
        this.line = new PPath();
        this.line.setStroke(new BasicStroke(2.0f, 1, 1));
        this.addChild(this.line);
        this.getSource().addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CrosshairConnection.this.update();
            }
        });
        this.getDestination().addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                CrosshairConnection.this.update();
            }
        });
        this.update();
    }

    private PNode getDestination() {
        return this.destination;
    }

    private PNode getSource() {
        return this.FloatingChart.getStripChartJFCNode();
    }

    private void update() {
        Point2D.Double double_;
        Point2D.Double double_2 = new Point2D.Double(this.getSource().getFullBounds().getMaxX(), this.getSource().getFullBounds().getCenterY());
        double d = double_2.distance(double_ = new Point2D.Double(this.getDestination().getFullBounds().getMinX(), this.getDestination().getFullBounds().getCenterY()));
        if (d > 0.0) {
            DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(double_2);
            ImmutableVector2D immutableVector2D = new Vector2D(double_2, double_).getNormalizedInstance();
            ImmutableVector2D immutableVector2D2 = immutableVector2D.getRotatedInstance(1.5707963267948966).getNormalizedInstance();
            this.lineToDst(doubleGeneralPath, immutableVector2D, immutableVector2D2, d / 5.0);
            this.curveToDst(doubleGeneralPath, immutableVector2D, immutableVector2D2, d / 5.0);
            this.lineToDst(doubleGeneralPath, immutableVector2D, immutableVector2D2, d / 5.0);
            this.curveToDst(doubleGeneralPath, immutableVector2D, immutableVector2D2, d / 5.0);
            doubleGeneralPath.lineTo(double_);
            this.line.setPathTo(doubleGeneralPath.getGeneralPath());
        } else {
            this.line.setPathTo(new Rectangle());
        }
    }

    private void curveToDst(DoubleGeneralPath doubleGeneralPath, ImmutableVector2D immutableVector2D, ImmutableVector2D immutableVector2D2, double d) {
        double d2 = d;
        if (d2 < 7.0) {
            d2 = 7.0;
        }
        if (d2 > 20.0) {
            d2 = 20.0;
        }
        double d3 = 15.0;
        Point2D point2D = doubleGeneralPath.getCurrentPoint();
        Point2D.Double double_ = immutableVector2D.getInstanceOfMagnitude(d2).getDestination(point2D);
        Point2D.Double double_2 = immutableVector2D.getInstanceOfMagnitude(d2 / 2.0).getAddedInstance(immutableVector2D2.getInstanceOfMagnitude(d3)).getDestination(point2D);
        doubleGeneralPath.quadTo(((Point2D)double_).getX(), ((Point2D)double_).getY(), ((Point2D)double_2).getX(), ((Point2D)double_2).getY());
        doubleGeneralPath.quadTo(point2D.getX(), point2D.getY(), ((Point2D)double_).getX(), ((Point2D)double_).getY());
    }

    private void lineToDst(DoubleGeneralPath doubleGeneralPath, ImmutableVector2D immutableVector2D, ImmutableVector2D immutableVector2D2, double d) {
        doubleGeneralPath.lineToRelative(immutableVector2D.getInstanceOfMagnitude(d));
    }
}

