import { Sphere } from "./Figure.js";
import SolidColor from "../materials/SolidColor.js";
import GeometryPainter from "./GeometryPainter.js";
import M4 from "../modules/M4.js";
/**
 * Light.
 * Clase que dibuja la posición de una fuente de luz con una 
 * esfera de un color dado.
 * @author Melissa Méndez Servín.
 */
export default class Light{
    constructor(gl, WebGL, position, radio=.08, color=[1,1,1,1]){
        this.position = position;
        this.uniformColor = {u_color: color};

        let sphereFigure = new Sphere(radio, 15, 15);
        this.light = new GeometryPainter(gl, new SolidColor(gl, WebGL, sphereFigure, color));
        this.base = new GeometryPainter(gl, new SolidColor(gl, WebGL, sphereFigure, [0,0,0,1]), M4.scale(1.15,1.15,1.15));
   
    }
    draw(gl, viewMatrix, projectionMatrix, position, color){
        gl.enable(gl.DEPTH_TEST);
        gl.enable(gl.CULL_FACE);
        let lightPosition = position || this.position;
        if(color)
            this.uniformColor = {u_color: color};
        let modelViewLight = M4.multiply(viewMatrix, M4.translate(lightPosition[0],lightPosition[1],lightPosition[2]));
        gl.cullFace(gl.FRONT);
        this.base.draw(gl, modelViewLight, projectionMatrix);
        gl.cullFace(gl.BACK);
        this.light.draw(gl, modelViewLight, projectionMatrix, this.uniformColor);
    }
}