"use strict";

import {resize, Slider, addLabel, resizeAndCenterX, DarkMode} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import BadNormalMapping from "../../materials/BadNormalMapping.js";
import {Plane} from "../../geometry/Figure.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import Light from "../../geometry/Light.js";

/**
 * Normal mapping sin el espacio tangente.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    let planeFigure = new Plane();
    let srcTextures = [ "../../../images/capitulo_07/textures/Bricks071_1K_Color.jpg",
                        "../../../images/capitulo_07/textures/Bricks071_1K_Normal.jpg"];
    
    let lightPosition = [3.14, 2.4, -.03, 0];
    let uniforms = { u_material : {}, 
                     u_light: { position: lightPosition, la: [0.1,0.1,0.1], ld: [1, 1, 1],
                                ls: [0.8, 0.8, 0.8]}};

    let material =  new BadNormalMapping(gl, WebGL, planeFigure, srcTextures, setTextures, uniforms); 

    let plane = new GeometryPainter(gl, material, M4.translate(0,-.1,0));
    var pos = M4.multiply(M4.rotateX(70), [0,0,1,1]);
    let camera = new TrackballCamera(new V3(pos[0], pos[1], pos[2]));
    camera.setZoomConfig(2, 1);

    let bulb = new Light(gl, WebGL, lightPosition);
    let textures;
    var translation;
    var modelMatrix;
    var modelViewMatrix;
    
    let light_controls = document.getElementById("ui-container-up");
    addLabel(light_controls, "Posición de la luz");
    var light_pos_x = new Slider(light_controls, "x", -10, 10, upadeteLPos(0), lightPosition[0], 0.01, ["#4994D0"]);
    var light_pos_y = new Slider(light_controls, "y", -10, 10, upadeteLPos(1), lightPosition[1], 0.01, ["#4994D0"]);
    var light_pos_z = new Slider(light_controls, "z", -10, 10, upadeteLPos(2), lightPosition[2], 0.01, ["#4994D0"]);

    let darkMode = new DarkMode(draw, [light_controls]);
 
    gl.enable(gl.DEPTH_TEST);
    
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
    gl.clearColor(0, 0, 0, 0);

    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    
    function draw(){        
        resize(canvas);
        resizeAndCenterX(light_controls, {});
        darkMode.check(gl);
        
        var {width, height} = gl.canvas;
        
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        let aspect = width/height;
        var projectionMatrix = M4.perspective(85, aspect, .1, 100);
        var viewMatrix = camera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        
        bulb.draw(gl, M4.multiply(viewMatrix, M4.scale(.5, .5, .5)), projectionMatrix, lightPosition);

        uniforms.u_light.position = lightPos;
        if(textures)
            uniforms.u_material = { diffuse_map : { id: 0, texture: textures[0]},
                                    normal_map : { id: 1, texture: textures[1]},
                                    specular_map : { id: 2, texture: textures[2]},
                                    shininess: 0.09*128};

        plane.draw(gl, viewMatrix, projectionMatrix, uniforms);
    }
    function setTextures(loadedTextures){
        textures = loadedTextures;
        draw();
    }
    function upadeteLPos(index){
        return function(value){
            lightPosition[index] = value;
            draw();
        }
    }
} 