"use strict";

import {resize, Checkbox} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import AlphaMapping from "../../materials/AlphaMapping.js";
import {Plane} from "../../geometry/Figure.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import Light from "../../geometry/Light.js";
import PhongTexture from "../../materials/PhongTexture.js";

/**
 * Alpha mapping.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let planeFigure = new Plane(1.3,1.3, false);
    
    let height = -.5;
    let lightPosition = [.3, 2.4, -.03, 0];
                         
    let grassTextures = ["../../../images/capitulo_07/textures/Grass003_1K_Color.jpg",
                         "../../../images/capitulo_07/textures/grass.png"];
    //Piso 
    var floorTransform = M4.multiplyArray([M4.translate(0,height,-2), M4.rotateX(-90), M4.scale(5,5,1)]);
    let floorUniforms = { u_material : {}, 
                            u_light: { position: lightPosition, la: [0.2,0.2,0.2], ld: [1.1, 1.1, 1.1],
                                       ls: [0., 0., 0.]}};
       
                                       
    let alpha_mapping =  new AlphaMapping(gl, WebGL, planeFigure, grassTextures, setTextures, floorUniforms, {}); 
    let greenPlane = new GeometryPainter(gl, alpha_mapping);
    let phong_mapping =  new PhongTexture(gl, WebGL, planeFigure, grassTextures, setTextures, floorUniforms, {}); 
    let floor = new GeometryPainter(gl, phong_mapping, floorTransform); 
    
    let greenPosition = [0,.2,-1];
    let redPosition = [0,.5,1.5];
 
    var fov = 90;
    let zNear = .1;
    let zFar = 100;
    var pos = new V3(0,.3,.9);
    let camera = new TrackballCamera(pos);
    
    /*let controlPos = document.getElementById("ui-container-up");
    addLabel(controlPos, "Luz");
    var red_plane_x = new Slider(controlPos, "x", -15, 15, upadateRedPosition(0), redPosition[0], 0.1, ["#4994D0"]);
    var red_plane_y = new Slider(controlPos, "y",  -10, 15, upadateRedPosition(1), redPosition[1], 0.1, ["#4994D0"]);
    var red_plane_z = new Slider(controlPos, "z", -15, 15, upadateRedPosition(2), redPosition[2], 0.1, ["#4994D0"]);*/
   
    let right_controls = document.getElementById("right-options");
    let checkAlpha = new Checkbox(right_controls, "alpha", "Alpha Mapping", draw, "true");
    
    var modelViewMatrix;
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
    gl.clearColor(0, 0, 0, 0);
    
    let bulb = new Light(gl, WebGL, lightPosition, 0.1);
    let textures;
    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    

    function draw(){        
        resize(canvas);
        //resizeAndCenterX(controlPos, {top:0});
        var {width, height} = gl.canvas;

        gl.enable(gl.DEPTH_TEST);
        
        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

        let aspect = width/height;
        var projectionMatrix = M4.perspective(fov, aspect, zNear, zFar);

        let viewMatrix = camera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        
        bulb.draw(gl, viewMatrix, projectionMatrix, lightPosition);
        if(textures){
            floorUniforms.u_light.position = lightPos;
            floorUniforms.u_material = { diffuse_map : { id: 0, texture: textures[0]},
                                         shininess: 0.09*128};
            floor.draw(gl, viewMatrix, projectionMatrix, floorUniforms);
            //Transparecia
            let translate = M4.translate(greenPosition[0], greenPosition[1], greenPosition[2]);
            
            var uniforms = { u_texture : { id: 1, texture: textures[1]}};
            if(checkAlpha.checked())
                uniforms.u_active = 1;
            else
                uniforms.u_active = 0;
            for(var i = 0; i < 9; i++){
                if(i < 3)
                    modelViewMatrix = M4.multiply(viewMatrix, M4.translate(-i*2+1.5, .1, -4));
                else if (i < 6)
                    modelViewMatrix = M4.multiply(viewMatrix, M4.translate((3-i)*1.5+2, .1, -2));
                else
                    modelViewMatrix = M4.multiply(viewMatrix, M4.translate((6-i)*1.5 +2, .1, 0));
                
                greenPlane.draw(gl,modelViewMatrix, projectionMatrix, uniforms);
            }   
        }
    }
    function upadateRedPosition(index){
        return function(value){
            lightPosition[index] = value;
            draw();
        }
    }
    function setTextures(loadedTextures){
        textures = loadedTextures;
        draw();
    }
}