"use strict";

import {resize, Slider, Color, addLabel, resizeAndCenterX, DarkMode, TextBox, Select} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import PointLight from "../../materials/PointLight.js";
import {Sphere, Cube} from "../../geometry/Figure.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import {TrackballCamera, registerCameraEvents} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import Teapot from "../../geometry/Teapot.js";
import Bunny from "../../geometry/Bunny.js";
import Light from "../../geometry/Light.js";

/**
 * Fuente de luz puntual.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    
    let sphereFigure = new Sphere(1, 30,30);
    let cubeFigure = new Cube(1.35);
    let teapotFigure = new Teapot();
    let bunnyFigure = new Bunny();
    
    let lightPosition = [0, 2, -1, 1];
    let material = { ka: [0.105882, 0.058824, 0.113725], kd: [0.427451, 0.470588, 0.541176], ks: [0.333333, 0.333333, 0.521569], 
                     shininess: 20.84615*128};
    let light = { position: lightPosition, la: [.3, .3, .3], ld: [1,1,1], ls: [1.0, 1.0, 1.0],
                  quadratic : 0.01, linear: 0.22, constant: 0.03};
    let uniforms = { u_light: light, u_material: material};  
    let translate = M4.translate(0,.5,0);
    let figures = { 
        tetera: new GeometryPainter(gl, new PointLight(gl, WebGL, teapotFigure, uniforms), M4.multiply(M4.scale(.9,.9,.9), translate)),
        cubo: new GeometryPainter(gl, new PointLight(gl, WebGL, cubeFigure, uniforms), translate) ,
        esfera : new GeometryPainter(gl, new PointLight(gl, WebGL, sphereFigure, uniforms), translate),
        conejo: new GeometryPainter(gl, new PointLight(gl, WebGL, bunnyFigure, uniforms), translate)};

    let selectedFigure = figures.tetera;  
   
    var fov = 100;
    let zNear = .1;
    let zFar = 100;
    var pos = new V3(0,1.2,2.7);
    let camera = new TrackballCamera(pos);    
    camera.setZoomConfig(4,1.5);
    
    let light_controls = document.getElementById("ui-container-up");
    addLabel(light_controls, "Posición de la luz");
    var light_pos_x = new Slider(light_controls, "x", -10, 10, upadeteLPos(0), lightPosition[0], 0.01, ["#4994D0"]);
    var light_pos_y = new Slider(light_controls, "y", -10, 10, upadeteLPos(1), lightPosition[1], 0.01, ["#4994D0"]);
    var light_pos_z = new Slider(light_controls, "z", -10, 10, upadeteLPos(2), lightPosition[2], 0.01, ["#4994D0"]);

    let controls = document.getElementById("ui-container-center");
    var A_slider = new Slider(controls, "a", 0, 1, upadeteC(0), light.quadratic, 0.01, ["#4994D0"], "");
    var B_slider = new Slider(controls, "b", 0, 1, upadeteC(1), light.linear, 0.01, ["#4994D0"], "");
    var C_slider = new Slider(controls, "c", 0, 1, upadeteC(2), light.constant, 0.01, ["#4994D0"], "");

    let darkMode = new DarkMode(draw, [light_controls, controls]);

    let ccLabel = new TextBox(container, { left: 3, top: 11}, "", "author-small");

    /* Selects */
    let right_controls = document.getElementById("right-options");
    let selectFigure = new Select(right_controls, "figures", setFigure, figures);
    //Luz
    let bulb = new Light(gl, WebGL, lightPosition);

    let modelViewMatrix;

    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.CULL_FACE);

    window.addEventListener('resize', draw);
    registerCameraEvents(camera, canvas, draw);
    
    draw();

    function draw(){        
        resize(canvas);
        resizeAndCenterX(light_controls, {});
        resizeAndCenterX(controls, {bottom:6});
        var {width, height} = gl.canvas;
        
        darkMode.check(gl);

        gl.viewport(0, 0, width, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

        let aspect = width/height;
        var projectionMatrix = M4.perspective(fov, aspect, zNear, zFar);

        let viewMatrix = camera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        
        bulb.draw(gl, viewMatrix, projectionMatrix, lightPosition, [light.ld[0], light.ld[1], light.ld[2], 1]);

        uniforms = { u_light: light, u_material: material}; 
        uniforms.u_light.position = lightPos;
        
        for(var i = 0; i < 9; i++){
            if(i < 3)
                modelViewMatrix = M4.multiply(viewMatrix, M4.translate(-i*3 + 3, -1, -6));
            else if (i < 6)
                modelViewMatrix = M4.multiply(viewMatrix, M4.translate((3-i)*3 + 3, -1, -3));
            else
                modelViewMatrix = M4.multiply(viewMatrix, M4.translate((6-i)*3 + 3, -1, 0));

            selectedFigure.draw(gl, modelViewMatrix, projectionMatrix, uniforms);       
        }
        /*for(var i= 0; i < 2; i++){
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(-3, -2 + i*2, -6)]), projectionMatrix, uniforms);       
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(0, -2.5 + i*2, -6)]), projectionMatrix, uniforms);       
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(3, -2 + i*2, -6)]), projectionMatrix, uniforms);  
        
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(-3, -2. + i*3, -3)]), projectionMatrix, uniforms);       
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(0, -2.5 + i*3.5, -3)]), projectionMatrix, uniforms);       
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(3, -2. + i*3, -3)]), projectionMatrix, uniforms);  
        
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(-3, -2. + i*3.5, 0)]), projectionMatrix, uniforms);       
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(0, -2.5 + i*4, 0)]), projectionMatrix, uniforms);       
            selectedFigure.draw(gl, M4.multiplyArray([viewMatrix, M4.translate(3, -2. + i*3.5, 0)]), projectionMatrix, uniforms);  
  
        }*/ 
    }
    function setFigure(value){
        if(value == 'conejo'){
            ccLabel.setText( "<i>Bunny</i>. Modelo obtenido de <i>Stanford <br> University Computer Graphics Laboratory</i>.");
        }else
            ccLabel.setText("");
        selectedFigure = figures[value];
        draw();
    }
    function upadeteLPos(index){
        return function(value){
            lightPosition[index] = value;
            draw();
        }
    }
    function upadeteC(index){
        return function(value){
            switch(index){
                case 0:
                    light.quadratic = value;
                    break;
                case 1:
                    light.linear = value;
                    break;
                case 2:
                    light.constant = value;
                    break;
            }
            draw();
        }
    }
}