import Emitter from "./Emitter.js";

export default class Interactive {
  constructor(container) {
    this.container = container;
    this.canvas = container.querySelector("canvas");
    this.context = this.canvas.getContext("2d");

    this.emitter = new Emitter(this.canvas.width/2, this.canvas.height/2, 100, 400);
  }

  processInput() { }

  update(elapsed) {
    this.emitter.update();
  }

  render() {
    this.context.fillStyle = "#ffffff";
    this.context.fillRect(0, 0, this.canvas.width, this.canvas.height);

    this.emitter.draw(this.context);
  }
}