import {resizeContainerAndCanvas} from "../../../modules/HTMLUtils.js";
import CtxUtils from "../../../modules/Context2DUtils.js";
import V2 from "../../../modules/V2.js"; 

/**
 * Construcción de una curva de Bézier de grado 1.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);
function main(){
    document.body.style.backgroundColor = "#FFF";
    
    var canvas = document.getElementById("canvas");
    resizeContainerAndCanvas(canvas);
    let controls = document.getElementById("ui-container");
    controls.className = "bottom-box";
     
    let {width, height} = canvas;
    
    const p0 = new V2(.2*width, .75*height);
    const p1 = new V2(.78*width, .15*height);
    const textPos = new V2(.7*width, .92*height);
    const LINE_COLOR = "black";
    const LERP_COLOR = "red";
    const radius = 4;

    window.addEventListener('resize', draw);
    var time = 0; //Contador de tiempo para hacer la espera
    const wait_time = .5; //tiempo de espera
    var t = 0;
    var c = 0; //Contador auxiliar 
    
    requestAnimationFrame(draw);

    function draw(){
        resizeContainerAndCanvas(canvas);
        CtxUtils.clear();
        var currPoint = CtxUtils.lerp(p0, p1, t);
        
        CtxUtils.drawLine(p0, p1, 2.8, LINE_COLOR);
        CtxUtils.drawLine(p0, currPoint, 3.3, LERP_COLOR);
        CtxUtils.drawCircle( p0, radius, LERP_COLOR, 2, LERP_COLOR);
        
        let RIGHT_DOT_COLOR = (t >= 1) ? LERP_COLOR : LINE_COLOR;
        CtxUtils.drawCircle( p1, radius, RIGHT_DOT_COLOR, 2, RIGHT_DOT_COLOR);
        
        CtxUtils.putText("t = " + t.toFixed(2), 21, textPos.x, textPos.y, "black");
        
        if(t >= 1 && time <= wait_time){
            time += 0.01;
        }
        else{
            time = 0;
            //Actualizamos t 
            c = (c + 3) % 1006; // Cálculo con enteros para evitar problemas de precisión con decimales de js 
            t = c / 1000;
        }
        requestAnimationFrame(draw);
    }
}