import {resizeContainerAndCanvas, BigSlider, randomColor, Button, Checkbox} from "../../../modules/HTMLUtils.js";
import CtxUtils from "../../../modules/Context2DUtils.js";
import V2 from "../../../modules/V2.js"; 
import { MousePoint, registerMousePointsEvents } from "../../../modules/MouseEvents.js";
import {randomIntR} from "../../../modules/MathUtils.js";

/**
 * Construcción de curva de Bézier de grado [0,8] que permite la manipulación 
 * de sus puntos de control.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    
    var canvas = document.getElementById("canvas");
    resizeContainerAndCanvas(canvas);
    let controls = document.getElementById("ui-container");
    let buttons = document.getElementById("buttons");
    let checkbox = document.getElementById("checkbox");
    controls.className = "bottom-box";
    let {width, height} = canvas;
    
    if(window.innerWidth < window.innerHeight)
        controls.style.bottom = "0%";
    else 
        controls.style.bottom = "-7%";

    
    const P0 = new V2(.14*width, .65*height);
    const P1 = new V2(.3*width, .12*height);
    const P2 = new V2(.52*width, .53*height);
    const P3 = new V2(.62*width, .33*height);
    const P4 = new V2(.77*width, .35*height);
    const P5 = new V2(.82*width, .63*height);
    
    const P0_COLOR = "rgb(170, 224, 61)";
    const P1_COLOR = "rgb(255, 224, 0)";
    const P2_COLOR = "rgb(52, 181, 255)";
    const P3_COLOR = "rgb(197, 0, 255)";
    const P4_COLOR = "rgb(255, 153, 52)";
    
    const LINE_COLOR = "black";
    const DOT_COLOR = "rgb(135, 141, 144)";
    
    var control_points = [P0, P1, P2, P3, P4];
    var color_points = [P0_COLOR, P1_COLOR, P2_COLOR, P3_COLOR, P4_COLOR];
    const radius = 4;
    const radius_arc = 9;

    var t = 0;
    //HTML CONTROLS
    const colorsSlider = ["#708FDD", "#D1D1CA"];
    let sliderD = new BigSlider(controls, "t =", 0, 1, updateT, t, 0.01, colorsSlider);
    let addPointButton = new Button(buttons, addPoint, "+", "signed-bttn");
    let removePointButton = new Button(buttons, removePoint, "-", "signed-bttn");
    let hiddeLines = new Checkbox(checkbox, "Líneas", "Líneas de apoyo", draw, true);
    

    let mouse_points = [];
    for(var i = 0; i < control_points.length; i++){
        mouse_points.push(new MousePoint(control_points[i], radius_arc));
    }

    window.addEventListener('resize', draw);
    registerMousePointsEvents(canvas, mouse_points, draw);
    draw();

    function draw(){
        resizeContainerAndCanvas(canvas);
        CtxUtils.clear();

        updateControlPoints();
        CtxUtils.drawLines(control_points, LINE_COLOR, 2);
        
        //Puntos de control
        for(var i = 0; i < control_points.length; i++){
            CtxUtils.drawCircle(control_points[i], radius, color_points[i], 2, color_points[i]);
            CtxUtils.drawArc(control_points[i], radius_arc, 0, 2*Math.PI, color_points[i], 2);
        }
        CtxUtils.drawBezierCurve(control_points, t, 60, "red", 1.8);
        
        if(hiddeLines.checked() && control_points.length > 1 && t % 1 != 0){
            let sub_control_points = CtxUtils.drawSubBezierAndGetPoints(control_points, t, [], 3, 2, DOT_COLOR);
            CtxUtils.drawCircle(sub_control_points[sub_control_points.length-1], radius, "red", 3.8, "red");
        }else{
            let t_point = CtxUtils.bezierCurve(control_points, t);
            CtxUtils.drawCircle(t_point, radius, "red", 3.8, "red");
        }
    }
    function updateControlPoints(){
        control_points = [];
        mouse_points.forEach(function(ele) { control_points.push(ele.point)});
    }
    function updateMousePoints(){
        mouse_points = [];
        for(var i = 0; i < control_points.length; i++){
            mouse_points.push(new MousePoint(control_points[i], radius_arc));
        }
        registerMousePointsEvents(canvas, mouse_points, draw);
    }
    function updateT(value){
        t = value;
        draw();
    }
    function addPoint(){
        if(control_points.length >= 9)
            return;
        let randX = randomIntR(10,100)/100;
        let randY = randomIntR(10,100)/100;
        let new_point = new V2(randX*width, randY*height);
        control_points.push(new_point);
        if(color_points.length < 9)
            color_points.push(randomColor());
        updateMousePoints();
        draw();
    }
    function removePoint(){
        if(control_points.length == 1)
            return;
        control_points.pop();
        if(color_points.length > 4)
            color_points.pop();
        updateMousePoints();
        draw();
    }

}