import * as MU from "../../../modules/MathUtils.js";
import * as Utils from "../../../modules/HTMLUtils.js";
import WebGL from "../../../modules/WebGLUtils.js";
import M3 from "../../../modules/M3.js";
import V2 from "../../../modules/V2.js";
import Vector2D from "../../../geometry/Vector2D.js";
import Line2D from "../../../geometry/Line2D.js";
import Figure2D from "../../../geometry/Figure2D.js";
import { MouseVector, registerMouseEvents2DVec } from "../../../modules/MouseEvents.js";

/**
 * Vector 1D base.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;

    let container = document.getElementById("container");
    Utils.resize(canvas);
   
    const unit = 55;   
    
    //Colores
    const basisColor = [19, 41, 61, 255]; 
    const opaqueColor = [97, 100, 112, 200]; 
    const color2 = [122, 111, 140, 255];
    const lineColor = [100, 100, 100, 255];
    
    const {width, height} = gl.canvas;
    
    let sPoint  = new V2(0,0);
    //Vectores
    let basisVector  = new V2(Math.floor(width/unit/6), 0);
    var vector = basisVector.scale(1.5);
    let e = new Vector2D(gl, WebGL, sPoint, basisVector, unit, 2, basisColor);
    let vVector2D = new Vector2D(gl, WebGL, sPoint, basisVector, unit, 1.7, color2);
            
    //Punto céntrico
    var eparams = { center: sPoint, r: 0.1, numPoints: 10};
    let ePoint = new Figure2D(gl, WebGL, 'circle', unit, basisColor, eparams);
    
    //Line
    let line = new Line2D(gl, WebGL, new V2(-(width/unit) - 1, 0), basisVector, width, unit, .6);
    
    //Etiqueta vector
    let eLabel = Utils.createMathBox(container, {});
    let vLabel = Utils.createMathBox(container, {});
    
    //Constructor auxiliar para  el manejador de eventos con el ratón
    const radiusRegion = 0.3;
    let mouseVector = new MouseVector(gl, radiusRegion, unit, vector, null, true);
    let mouseVectors = [mouseVector];

    //Circunferencia para señalar el área para mover la flecha
    var cparams = { center: sPoint, r: radiusRegion, thickness: 0.1, numPoints: 10};
    let cRegion = new Figure2D(gl, WebGL, 'circumference', unit, opaqueColor, cparams);
    
    gl.clearColor(0, 0, 0, 0);
    //Transparecia
    gl.enable(gl.BLEND);
    gl.blendFunc(gl.SRC_ALPHA, gl.ONE_MINUS_SRC_ALPHA);
    
    draw();
    window.addEventListener('resize', draw);
    registerMouseEvents2DVec(canvas,mouseVectors, draw);
    
    function draw(){
        Utils.resize(canvas);
        const {width, height} = gl.canvas;
        gl.viewport(0, 0, width, height);
        
        gl.depthMask(true);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        var projectionMatrix = M3.projection(-width/2, width/2, height/2, -height/2);
        var v = mouseVector.vector;

        let diff = {t: 0, l: -25};
        let labelPosition = MU.getVectorLabelPosition(basisVector, projectionMatrix, width, height, unit, diff, .5);
        Utils.setElementPosition(eLabel, labelPosition);
        Utils.setMathBox(eLabel, "\\mathbf{e_1}");

        labelPosition = MU.getVectorLabelPosition(v, projectionMatrix, width, height, unit, null, .95);
        Utils.setElementPosition(vLabel, labelPosition);
        Utils.setMathBox(vLabel, "\\mathbf{v}");
        
        if(mouseVector.showRegion)
            cRegion.draw(gl, M3.translate(v.x, v.y), projectionMatrix);
        
        line.draw(gl, projectionMatrix);
        vVector2D.draw(gl, projectionMatrix, null, mouseVector.vector);
        e.draw(gl, projectionMatrix, null, basisVector);
        ePoint.draw(gl, M3.identity(), projectionMatrix); 
            
    }
}