import {Button, MathBox, resizeContainer2D, MatrixElement} from "../../../modules/HTMLUtils.js";

/**
 * Multiplicación de matrices.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    const generalForm = "ab_{ij} = \\sum_{k = 1}^{2}a_{ik} b_{kj} = a_{i1}b_{1j} + a_{i2}b_{2j}";
    resizeContainer2D();

    let container = document.getElementById("container2D");
    let controls = document.getElementById("ui-container");
    controls.className = "extra-right-bottom-bttns-box";
    let button = new Button(controls, reset, "Otro");

    let nameA = new MathBox(container, {top: 41, left: 88, type: "px"}, "\\mathbf{A}", "font-size");
    let nameB = new MathBox(container, {top: 76, left: 282, type: "px"}, "\\mathbf{B}", "font-size");
    let nameAB = new MathBox(container, {top: 41, left: 502, type: "px"}, "\\mathbf{AB}", "font-size");
    let times = new MathBox(container, {top: 163, left: 169, type: "px"}, "\\times", "symbol");
    let equals = new MathBox(container, {top: 163, left: 400, type: "px"}, "=", "symbol");
    let mult = new MathBox(container, {top: 360, left: 80, type: "px"}, generalForm, "font-size");
    
    let matrixA = document.getElementById("a-matrix");
    let matrixB = document.getElementById("b-matrix");
    let matrixAB = document.getElementById("ab-matrix");
    let mA = []; 
    let mB = [];
    for(var i = 0; i < 6; i++){
        mA.push(new MatrixElement(matrixA, "element"));
        mB.push(new MatrixElement(matrixB, "element"));
    }
    let mAB = [];
    let elementsAB = multiply();
    for(var i = 0; i < 9; i++)
        mAB.push(new MatrixElement(matrixAB, "element ab-ele", elementsAB[i].num));

    mAB.forEach(elementHandler);
    function elementHandler(item, index){
        var ele = elementsAB[index];
        item.ele.addEventListener("mouseover", function(evt){
            mult.setText(ele.s);
            for(var i= ele.ra; i < ele.ra + 2; i++) //Pintamos los elementos del renglón de A
                mA[i].ele.setAttribute("selectedA", "true");
            for(var j= ele.cb; j <= ele.cb + 3; j+=3) //Pintamos los elementos de la columna de B
                mB[j].ele.setAttribute("selectedB", "true");
    
        }, false),
        item.ele.addEventListener("mouseout", function(evt){
            mult.setText(generalForm);
            for(var i= ele.ra; i < ele.ra + 2; i++) //Despintamos los elementos del renglón de A
                mA[i].ele.setAttribute("selectedA", "false");
            for(var j= ele.cb; j <= ele.cb + 3; j+=3) //Pintamos los elementos de la columna de B
                mB[j].ele.setAttribute("selectedB", "false");
        }, false);
    }
    window.addEventListener('resize', resizeContainer2D());

    function reset(){
        for(var i = 0; i < 6; i++){
            mA[i].setNum();
            mB[i].setNum();
        }
        elementsAB = multiply();
        for(var i = 0; i < 9; i++)
            mAB[i].setNum(elementsAB[i].num);
        mAB.forEach(elementHandler);
    }
    /**
     * Multiplica las matrices A y B (compuestas de elementos HTML), 
     * conA de dimensión 3x2 y B de 2x3, donde
     * ab_ij = a_i0 b0j + ai1 b1j
     * Devuelve un arreglo de constructores con los atributos num 
     * (resultado asociado al elemento), s el string con la suma 
     * para obtener a dicho elemento, ra el renglón de la matriz A
     * y cb la columna de la matriz B por las que se multiplicaron.
     * @param {*} a 
     * @param {*} b 
     */
    function multiply(){
        var p = [];
        for(var i= 0; i < 3; i++) 
            for(var j= 0; j < 3; j++){
                var ab_ij = 0;
                var mathString = "ab_{" + (i+1) +  (j+1) + "} = ";
                for( var k = 0; k <2; k++){
                    ab_ij += mA[2* i + k].num * mB[3 * k + j].num;
                    mathString +="({\\color{#008B8B}" + mA[2* i + k].num + "})({\\color{#87CEEB}" + mB[3 * k + j].num + "})";
                    if(k == 0)
                        mathString += " + ";
                }
                mathString += "= " + ab_ij;
                p[3 * i + j] = { num: ab_ij, s: mathString, ra: 2*i, cb: j};
            }
        return p;
    }
}