"use strict";

import {resize} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import { Plane, Sphere} from "../../geometry/Figure.js";
import {TrackballCamera} from "../../modules/Trackballcamera.js";
import V3 from "../../modules/V3.js";
import GeometryPainter from "../../geometry/GeometryPainter.js";
import TexcoordGenerator from "../../materials/TexcoordGenerator.js";

/**
 * Ejemplo de mapeo de texturas.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
    let srcTextures = [ "../../../images/capitulo_07/textures/2k_mars.jpg"];
    
    let lightPosition = [0, 1.9, .3, 0];
    let uniforms = {u_material : {}, 
                    u_light: { position: lightPosition, la: [0.3,0.3,0.3], ld: [1, 1, 1],
                                                        ls: [0.2, 0.1, 0.1]}};
    
    let planeFigure = new Plane(4,2.3);
    let sphereFigure = new Sphere(1, 25, 25);
    
    let configMaterial = { filters: {min: gl.NEAREST, mag: gl.NEAREST, wrap_s: gl.REPEAT, wrap_t: gl.REPEAT}};
    
    let sphereMaterial = new TexcoordGenerator(gl, WebGL, sphereFigure, srcTextures, setTextures, uniforms, configMaterial); 
    let planeMaterial = new TexcoordGenerator(gl, WebGL, planeFigure, srcTextures, setTextures, uniforms, configMaterial, -1); 
    
    let sphere = new GeometryPainter(gl, sphereMaterial);
    let planeTexture = new GeometryPainter(gl, planeMaterial, M4.scale(.6,.6,.6));

    var pos = new V3(0,0,1.4);
    let camera = new TrackballCamera(pos);
    
    let textures;
    let angle = 0;

    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.SCISSOR_TEST);
    
    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
    gl.clearColor(0, 0, 0, 0);

    window.addEventListener('resize', draw);
    requestAnimationFrame(draw);
    
    function draw(){        
        resize(canvas);
        
        const {width, height} = gl.canvas;
        const leftWidth = width / 2 | 0;
        const rightWidth = width - leftWidth;
        
        //dibuja vista izquierda
        gl.viewport(0, 0, leftWidth, height);
        gl.scissor(0, 0, leftWidth, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        
        let aspect = leftWidth/height;
        var projectionMatrix = M4.perspective(85, aspect, .1, 100);
        var viewMatrix = camera.getMatrix();
        var lightPos = M4.multiplyVector(viewMatrix, lightPosition);
        uniforms.u_light.position = lightPos;
        if(textures){
            uniforms.u_material = { diffuse_map : { id: 0, texture: textures[0]},
                                    shininess: 0.088*128};
            planeTexture.draw(gl, viewMatrix, projectionMatrix, uniforms);
        }


        //dibuja vista derecha
        gl.viewport(leftWidth, 0, rightWidth, height);
        gl.scissor(leftWidth, 0, rightWidth, height);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);

        aspect =rightWidth/height;
        projectionMatrix = M4.perspective(85, aspect, .1, 100);
        angle = (angle + 0.1)% 360;
        var modelViewMatrix =  M4.multiply(viewMatrix, M4.multiply(M4.translate(0,0,-.5), M4.rotateY(-angle)));
        if(textures)
            sphere.draw(gl, modelViewMatrix, projectionMatrix, uniforms);   
        
        requestAnimationFrame(draw);
        
    }
    function setTextures(loadedTextures){
        textures = loadedTextures;
        draw();
    }
} 