/**
 * Modelo geométrico de un cubo con asignación de colores por vértice.
 * @author Melissa Méndez Servín.
 */
export default class Cube{
    constructor(size, color_num=[]){
        const u = size/2;
        this.numComponents = 3;
        this.numElements = 6 * 6; 
        this.vertices = [   // FRENTE
                            u, -u,  u, 
                            u,  u,  u, 
                            -u,  u,  u, 
                            -u,  u,  u, 
                            -u, -u,  u, 
                            u, -u,  u, 
                    
                            // DERECHA
                            u, -u, -u,
                            u,  u, -u,
                            u,  u,  u,
                            u,  u,  u,
                            u, -u,  u, 
                            u, -u, -u, 
                            
                            //ATRAS
                            -u,  -u,  -u,
                            -u,  u,  -u,
                            u,  u,  -u,
                            u,  u,  -u,
                            u,  -u,  -u,
                            -u,  -u,  -u,
                    
                            // IZQUIERDA
                            -u,  -u,  u,
                            -u,  u,  u,
                            -u,  u,  -u,
                            -u,  u,  -u,
                            -u,  -u,  -u,
                            -u,  -u,  u,
                    
                            // ARRIBA
                            u,  u,  u,
                            u,  u,  -u,
                            -u,  u,  -u,
                            -u,  u,  -u,
                            -u,  u,  u,
                            u,  u,  u,
                    
                            // ABAJO
                            u,  -u,  -u, 
                            u,  -u,  u, 
                            -u,  -u,  u, 
                            -u,  -u,  u, 
                            -u,  -u,  -u, 
                            u,  -u,  -u 
                        ];
            this.colors = this.getColors(color_num);
        }
        getVertices(){
            return this.vertices;
        }
        getColors(color_num){
            switch(color_num){
                case 0:
                    return blue_color;
                case 1: 
                    return color1;
                default:
                    return [];
            }
        }
        /**
         * Devuelve un arreglo con los colores correspondientes a 
         * los vértices que componen cada cara.
         */
        setColorsByFaces(faceColors){
            let colors = [];
            for(var i = 0; i < 6; i++)
                for(var j = 0; j < 6; j++)
                    colors = colors.concat(faceColors[i]);
            this.colors = colors;
        }
}
let blue_color = [
    100, 223, 223, 255,
    86, 207, 225, 255,
    100, 223, 223, 255,
    100, 223, 223, 255,
    86, 207, 225, 255,
    100, 223, 223, 255,

    128, 255, 219, 255,
    114, 239, 221, 255,
    128, 255, 219, 255,
    128, 255, 219, 255,
    114, 239, 221, 255,
    128, 255, 219, 255,

    86, 207, 225, 255,
    78, 168, 222, 255,
    86, 207, 225, 255,
    86, 207, 225, 255,
    78, 168, 222, 255,
    86, 207, 225, 255,

    83, 144, 217, 255,
    94, 96, 206, 255,
    83, 144, 217, 255,
    83, 144, 217, 255,
    94, 96, 206, 255,
    83, 144, 217, 255,

    94, 96, 206, 255,
    105, 48, 195, 255,
    94, 96, 206, 255,
    94, 96, 206, 255,
    105, 48, 195, 255,
    94, 96, 206, 255,

    105, 48, 195, 255,
    116, 0, 184, 255,
    105, 48, 195, 255,
    105, 48, 195, 255,
    116, 0, 184, 255,
    105, 48, 195, 255
];

let color1 = [
    255, 115, 101, 255,
    255, 65, 25, 255,
    255, 115, 101, 255,
    255, 115, 101, 255,
    255, 65, 25, 255,
    255, 115, 101, 255,

    100, 223, 223, 255,
    86, 207, 225, 255,
    100, 223, 223, 255,
    100, 223, 223, 255,
    86, 207, 225, 255,
    100, 223, 223, 255,

    255, 145, 255, 255,
    255, 0, 255, 255,
    255, 145, 255, 255,
    255, 145, 255, 255,
    255, 0, 255, 255,
    255, 145, 255, 255,

    50, 205, 50, 255,
    56, 176, 0, 255,
    50, 205, 50, 255,
    50, 205, 50, 255,
    56, 176, 0, 255,
    50, 205, 50, 255,

    255, 244, 134, 255,
    255, 244, 15, 255,
    255, 244, 134, 255,
    255, 244, 134, 255,
    255, 244, 15, 255,
    255, 244, 134, 255,

    105, 48, 195, 255,
    116, 0, 184, 255,
    105, 48, 195, 255,
    105, 48, 195, 255,
    116, 0, 184, 255,
    105, 48, 195, 255
];
/** Colores 
 purple = 116, 0, 184, 255,
 french -violet = 105, 48, 195, 255,
 slate -blue = 94, 96, 206, 255,
 tufts -blue = 83, 144, 217, 255,
 blue -jeans = 78, 168, 222, 255,
 vivid -sky -blue = 72, 191, 227, 255,
 sky -blue -crayola = 86, 207, 225, 255,
 medium -turquoise = 100, 223, 223, 255,
 turquoise = 114, 239, 221, 255,
 aquamarine = 128, 255, 219, 255,
 */