"use strict";

import {resize, TextBox} from "../../modules/HTMLUtils.js";
import WebGL from "../../modules/WebGLUtils.js";
import M4 from "../../modules/M4.js";
import Texture from "../../materials/Texture.js";
import {Plane} from "../../geometry/Figure.js";
import V3 from "../../modules/V3.js";
/**
 * Comparación entre los filtros de minificación:
 * Filtro de caja, filtro bilineal y mipmapping.
 * @author Melissa Méndez Servín.
 */
window.addEventListener("load", main);

function main(){
    var canvas = document.getElementById("gl_canvas");
    var gl = WebGL.init(canvas);
    if(!gl) return;
   
    let planeFigure = new Plane(2,2);   
    //planeFigure.setTexcoords( [-10,-10, 20,-10, 20,20, -10,20]);
    let srcTexture = "../../../images/capitulo_07/checkboard.png";

    let materials =  [new Texture(gl, WebGL, planeFigure, srcTexture, draw, false),  
                      new Texture(gl, WebGL, planeFigure, srcTexture, draw)]; 
    let projectionMatrix;
    let viewMatrix = M4.camera(new V3(0,.1,1), new V3(0,0,0), new V3(0,1,0))
    //Labels
    let container = document.getElementById("container");
    let nearestLabel = new TextBox(container, {}, "FILTRO DE CAJA");
    let linearLabel = new TextBox(container, {}, "FILTRO BILINEAL");
    let mipmapLabel = new TextBox(container, {}, "FILTRO MIPMAPPING");

    var rotationSpeed = .6;
    var rotationAngle = 0;

    gl.pixelStorei(gl.UNPACK_FLIP_Y_WEBGL, true);
    gl.enable(gl.DEPTH_TEST);
    gl.enable(gl.SCISSOR_TEST);
    gl.clearColor(0, 0, 0, 0);
    
    requestAnimationFrame(draw);
   // window.addEventListener('resize', draw);
    
    function draw(current){        
        // Convert to seconds
        current *= 0.01;
        rotationAngle = (current*rotationSpeed) %360;
        resize(canvas);
        
        var {width, height} = gl.canvas;
        const smallWidth = width/2 -10| 0;
        const smallHeight = height/2| 0; 

       
        nearestLabel.setPosition({top: 20, left: smallWidth * .3, type: "px"});
        linearLabel.setPosition({top: 20, left: smallWidth * 1.3, type: "px"});
        mipmapLabel.setPosition({top: smallHeight *1.1, left: smallWidth * .66, type: "px"});

        let aspect = smallWidth/smallHeight;
        projectionMatrix = M4.perspective(90, aspect, .1, 100);
       
        //left NEAREST NEIGHBOR
        gl.viewport(0, smallHeight, smallWidth, smallHeight);
        gl.scissor(0, smallHeight, smallWidth, smallHeight);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
             
        render(rotationAngle, gl.NEAREST,0)
        
        //right BILINEAR INTERPOLATION
        gl.viewport(smallWidth+10, smallHeight, smallWidth, smallHeight);
        gl.scissor(smallWidth+10, smallHeight, smallWidth, smallHeight);
        gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
        render(rotationAngle, gl.LINEAR,0);

         //right MIPMAP BILINEAR INTERPOLATION
         gl.viewport(smallWidth/2, 0, smallWidth, smallHeight);
         gl.scissor(smallWidth/2, 0, smallWidth, smallHeight);
         gl.clear(gl.COLOR_BUFFER_BIT | gl.DEPTH_BUFFER_BIT);
         render(rotationAngle, null, 1);

        requestAnimationFrame(draw);
    }
    function render(rotationYAngle, filter, index){
        gl.useProgram(materials[index].program);
        gl.bindVertexArray(materials[index].vao);

        let modelMatrix = M4.multiply(M4.translate(0,0,.7), M4.multiply(M4.rotateY(rotationYAngle), M4.rotateX(90)));
        let modelViewMatrix = M4.multiply(viewMatrix, modelMatrix);
        materials[index].uniforms.u_PVM_matrix = M4.multiply(projectionMatrix, modelViewMatrix);
          
        materials[index].uniforms.u_texture = { id:0, texture : materials[index].texture};
        materials[index].setUniforms(materials[index].uniforms);
        if(filter){
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MIN_FILTER, filter);
            gl.texParameteri(gl.TEXTURE_2D, gl.TEXTURE_MAG_FILTER, filter);
        }
           
        gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER, materials[index].indexBuffer);
        gl.drawElements( gl.TRIANGLES, materials[index].numIndices,  gl.UNSIGNED_SHORT, 0);
        gl.bindBuffer(gl.ARRAY_BUFFER, null);   
    }
} 
/**
    var c1 = new V3(102,102,102);
    var c2 = new V3(135,170,222);
    var c3 = new V3(239,198,231);
    var c4 = new V3(175,175,233);
    var c1s = c1.scale(.76*.82);
    var c2s = c2.scale(.24*.82);
    var c3s = c3.scale(.76*.18);
    var c4s = c4.scale(.24*.18);
    console.log(c1s.add(c2s.add(c3s.add(c4s)))); */